/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.app.injection.FuncFormal;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.app.injection.ValueNode;

class Symbol {
    String name;
    SymbolTable scope;
    Loc loc;
    private PlsqlType type;
    private Usage assigned;

    Symbol(SymbolTable scope, String name, PlsqlType type, Loc loc, Object label) {
        Usage u;
        this.scope = scope;
        this.name = name == null ? "" : name;
        this.type = type;
        this.loc = loc;
        this.assigned = u = new Usage(this, loc, label);
        if (scope != null && !name.equals("")) {
            scope.define(this, loc);
        }
    }

    PlsqlType getType() {
        return this.type;
    }

    Loc getLoc() {
        return this.loc;
    }

    public Usage getAssigned() {
        return this.assigned;
    }

    Usage read() {
        Usage ret = this.assigned;
        if (this.scope == null) {
            return ret;
        }
        ret = this.scope.readHook(ret);
        return ret;
    }

    void assign(Usage u) {
        if (this.scope != null) {
            this.scope.writeHook(u);
        }
        this.assigned = u;
    }

    public String toString() {
        return this.name + " " + this.type;
    }

    void setLoc(Loc loc) {
        this.loc = loc;
    }

    static class TypeSym
    extends Symbol {
        TypeSym(SymbolTable scope, String name, PlsqlType type, Loc loc, Object label) {
            super(scope, name, type, loc, label);
        }
    }

    static class ObjectSym
    extends Symbol {
        ObjectSym(SymbolTable scope, String name, PlsqlType type, Loc loc, Object label) {
            super(scope, name, type, loc, label);
        }
    }

    static class CollectionSym
    extends Symbol {
        CollectionSym(SymbolTable scope, String name, PlsqlType type, Loc loc, Object label) {
            super(scope, name, type, loc, label);
        }
    }

    static class RecordSym
    extends Symbol {
        RecordSym(SymbolTable scope, String name, List<ParmSpec> parms, Loc loc, Object label) {
            super(scope, name, PlsqlType.safeType(), loc, label);
        }
    }

    static class FunctionSym
    extends Symbol {
        FunctionSym(SymbolTable scope, String name, ArrayList<ParmSpec> parms, Loc loc, Object label) {
            super(scope, name, new PlsqlType.Function(new FuncFormal(name, parms, loc, label)), loc, label);
            this.name = name;
        }

        FuncFormal addSignature(FuncFormal formal) {
            return ((PlsqlType.Function)this.getType()).addSignature(formal);
        }

        PlsqlType.Function.FuncFormalResolved resolveArguments(ValueNode.MultiArgNode argsNode) {
            return ((PlsqlType.Function)this.getType()).resolveArguments(argsNode);
        }

        List<FuncFormal> getOverloads() {
            return ((PlsqlType.Function)this.getType()).getOverloads();
        }

        List<Loc> getAllLocs() {
            ArrayList<Loc> ret = new ArrayList<Loc>();
            for (FuncFormal formal : this.getOverloads()) {
                ret.add(formal.getLoc());
            }
            return ret;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    static class VariableSym
    extends Symbol {
        VariableSym(SymbolTable scope, String name, PlsqlType type, Loc loc, Object label) {
            super(scope, name, type, loc, label);
        }
    }
}

