/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import oracle.dbtools.app.injection.Call;
import oracle.dbtools.app.injection.DependencyLink;
import oracle.dbtools.app.injection.Dotted;
import oracle.dbtools.app.injection.FlowGraph;
import oracle.dbtools.app.injection.FuncFormal;
import oracle.dbtools.app.injection.LoadDbRefs;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.NodeLabel;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.PlsqlException;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.Predefined;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.app.injection.TypeConversion;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.app.injection.ValueNode;
import oracle.dbtools.app.injection.VerifyValueNodeTypes;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SqlInjectionGraph {
    static final boolean MASTER_DEBUG = false;
    static Function<Loc, Integer> linenumDebug;
    private SymbolTable topLevelSymbolsDebug;
    private static final int MAX_PARSING_FAILS = 10;
    private final DispatchInfo[] dispatch;
    private final HashMap<String, Integer> tokenInt;
    private final Earley parser;
    private final Parser.Tuple[] sortedRules;
    private final List<LexerToken> src;
    private final Parsed target;
    private final FlowGraph globalFlow;
    ArrayList<String> warnings = new ArrayList();
    List<SqlInjectionAnalysisFailure> parsingErrors = new ArrayList<SqlInjectionAnalysisFailure>();
    int[] newLines;
    ValueNode.ValueType[] foodle = new ValueNode.ValueType[0];

    public static boolean debugging() {
        return false;
    }

    int line(ParseNode pn) {
        int linenum = Arrays.binarySearch(this.newLines, this.target.getSrc().get((int)pn.from).begin);
        if (linenum >= 0) {
            return linenum + 1;
        }
        return -linenum;
    }

    public SqlInjectionGraph(String input, Connection connection) throws Exception {
        this(input, Lexer.parse(input), connection);
    }

    public SqlInjectionGraph(String input, List<LexerToken> src, Connection connection) throws Exception {
        SymbolTable toplevelSymbols;
        this.src = src;
        ArrayList<Integer> newLineList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < input.length(); ++i2) {
            if (input.charAt(i2) != '\n') continue;
            newLineList.add(i2);
        }
        this.newLines = newLineList.stream().mapToInt(i -> i).toArray();
        newLineList = null;
        this.globalFlow = new FlowGraph(new NodeLabel());
        this.parser = SqlEarley.getInstance();
        this.tokenInt = this.createTokenInt();
        this.sortedRules = this.createSortedRules();
        this.dispatch = new DispatchInfo[this.sortedRules.length];
        this.initializeDispatch();
        this.target = new Parsed(input, src, this.parser, new String[]{"parse with errors"});
        if (Debug.DUMP_EARLEY.debug) {
            this.target.getRoot().printTree();
            this.dumpParse(this.target.getRoot(), -1, 0);
        }
        if (Debug.DUMP_RULES.debug) {
            this.dumpParse(this.target.getRoot(), -1, 0);
        }
        linenumDebug = loc -> this.linenum((Loc)loc);
        this.topLevelSymbolsDebug = toplevelSymbols = new SymbolTable();
        long beforeLoadDbRefs = System.nanoTime();
        LoadDbRefs dbRefs = new LoadDbRefs(connection);
        if (Debug.TIMINGS.debug) {
            System.out.println("LoadDbRefs connect " + (double)(System.nanoTime() - beforeLoadDbRefs) / 1.0E9);
        }
        dbRefs.loadSymbols(toplevelSymbols);
        if (Debug.TIMINGS.debug) {
            System.out.println("LoadDbRefs load " + (double)(System.nanoTime() - beforeLoadDbRefs) / 1.0E9);
        }
        Predefined.hardCodedSafety(toplevelSymbols);
        try {
            ParseNode cur = this.target.getRoot();
            int[] rootSymbols = cur.content();
            if (rootSymbols.length < 1 || rootSymbols.length == 1 && rootSymbols[0] < 0) {
                this.parsingFailed(new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_SYNTAX_ERROR, new Object[0]), null);
                return;
            }
            this.parse(new ParseParm(cur, -1, toplevelSymbols, 0));
        }
        catch (SqlInjectionAnalysisFailure saf) {
            this.parsingFailed(saf, null);
        }
        catch (Exception e) {
            this.parsingFailed(new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_BAD_PARSE, e), null);
        }
    }

    void parsingFailed(SqlInjectionAnalysisFailure saf, ParseParm pp) {
        if (Debug.PARSING_ERRORS_FATAL.debug) {
            throw saf;
        }
        if (this.parsingErrors.size() == 10) {
            this.parsingErrors.add(new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_TOO_MANY_FAILS, new Object[0]));
        }
        if (this.parsingErrors.size() >= 10) {
            return;
        }
        this.parsingErrors.add(saf);
    }

    private HashMap<String, Integer> createTokenInt() {
        HashMap<String, Integer> tokInt = new HashMap<String, Integer>(this.parser.allSymbols.length * 4 / 3 + 3);
        for (int i = 0; i < this.parser.allSymbols.length; ++i) {
            tokInt.put(this.parser.allSymbols[i], i);
        }
        return tokInt;
    }

    private Parser.Tuple[] createSortedRules() {
        assert (!this.tokenInt.isEmpty());
        Object[] rulesAndTerms = Arrays.copyOf(this.parser.rules, this.parser.rules.length + this.parser.allSymbols.length);
        int len = this.parser.rules.length;
        for (int tok = 1; tok < this.parser.allSymbols.length; ++tok) {
            int n = len++;
            Earley earley = this.parser;
            earley.getClass();
            rulesAndTerms[n] = new Parser.Tuple(earley, tok, new int[0]);
        }
        Arrays.sort(rulesAndTerms, 0, len);
        int copyTo = 0;
        for (int idx = 0; idx < len; ++idx) {
            if (((Parser.Tuple)rulesAndTerms[idx]).rhs.length == 0 && idx + 1 < len && ((Parser.Tuple)rulesAndTerms[idx + 1]).head == ((Parser.Tuple)rulesAndTerms[idx]).head) continue;
            rulesAndTerms[copyTo++] = rulesAndTerms[idx];
        }
        rulesAndTerms = (Parser.Tuple[])Arrays.copyOf(rulesAndTerms, copyTo);
        return rulesAndTerms;
    }

    private void initializeDispatch() {
        HashMap<Integer, ValueNode.ValueType> tokenTypesDeclared = new HashMap<Integer, ValueNode.ValueType>();
        if (Debug.DUMP_GRAMMAR.debug) {
            System.out.println("Dumping grammar to " + Debug.DUMP_GRAMMAR.parms[0]);
            try (FileWriter writer = new FileWriter((String)Debug.DUMP_GRAMMAR.parms[0]);){
                for (String sym : this.parser.allSymbols) {
                    writer.write(sym + System.lineSeparator());
                }
                writer.write("----------------------------------------------------" + System.lineSeparator());
                for (Parser.Tuple rule : this.sortedRules) {
                    writer.write(this.tupleToString(rule) + System.lineSeparator());
                }
                writer.close();
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
            throw new InternalError("DUMP_GRAMMAR(true), exiting");
        }
        for (Object[] objectArray : new Object[][]{{"function", ValueNode.ValueType.EXPRNODE}, {"identifier", ValueNode.ValueType.DOTTEDNODE}, {"name", ValueNode.ValueType.DOTTEDNODE}, {"expr", ValueNode.ValueType.EXPRNODE}}) {
            Integer tokInt = this.tokenInt.get((String)objectArray[0]);
            if (tokInt == null) {
                throw new IllegalStateException("'" + objectArray[0] + "' not a recognized non-terminal");
            }
            tokenTypesDeclared.put(tokInt, (ValueNode.ValueType)((Object)objectArray[1]));
        }
        for (Object[] objectArray : SqlInjectionGraph.class.getDeclaredMethods()) {
            int ruleNum = -1;
            try {
                Returns annoRet;
                if (!objectArray.isAnnotationPresent(Reduction.class)) continue;
                Reduction anno = objectArray.getDeclaredAnnotation(Reduction.class);
                if (Debug.PARSE_DISPATCH.debug && anno.beforeChildren()) {
                    System.out.println("beforeChildren = true: " + anno.rules()[0] + " &etc");
                }
                if ((annoRet = objectArray.getDeclaredAnnotation(Returns.class)) == null) {
                    throw new IllegalArgumentException("Missing @Returns annotation");
                }
                Token[] headType = annoRet.type();
                PickTokens picks = objectArray.getDeclaredAnnotation(PickTokens.class);
                for (ruleNum = 0; ruleNum < anno.rules().length; ++ruleNum) {
                    Object ruleStrSplit;
                    int noColon;
                    int[] pickIdx;
                    if (picks == null) {
                        pickIdx = null;
                    } else {
                        pickIdx = new int[picks.tokens().length];
                        Arrays.fill(pickIdx, -1);
                    }
                    String ruleStr = anno.rules()[ruleNum];
                    String[] ruleColonSplit = ruleStr.split(":", 2);
                    String[] head = this.tokenInt.get(ruleColonSplit[0]);
                    if (head == null) {
                        throw new IllegalStateException("Internal Error: Token " + ruleColonSplit[0] + " not in parser.allSymbols list");
                    }
                    ArrayList<Integer> ruleIdxList = new ArrayList<Integer>();
                    int n = noColon = ruleColonSplit.length == 1 ? 1 : 0;
                    if (noColon != 0) {
                        Earley earley = this.parser;
                        earley.getClass();
                        int ruleIdx = Arrays.binarySearch(this.sortedRules, new Parser.Tuple(earley, head.intValue(), new int[0]));
                        int n2 = ruleIdx = ruleIdx >= 0 ? ruleIdx : -(ruleIdx + 1);
                        while (ruleIdx < this.sortedRules.length && this.sortedRules[ruleIdx].head == head.intValue()) {
                            ruleIdxList.add(ruleIdx);
                            ++ruleIdx;
                        }
                        if (ruleIdxList.size() == 0) {
                            throw new IllegalStateException(ruleStr + " has no rules");
                        }
                    } else {
                        int[] rhs;
                        ruleStrSplit = (" " + ruleColonSplit[1]).split(" +");
                        if (((String[])ruleStrSplit).length == 0) {
                            rhs = new int[]{};
                        } else {
                            rhs = new int[((String[])ruleStrSplit).length - 1];
                            block21: for (int j = 1; j < ((String[])ruleStrSplit).length; ++j) {
                                String token = ruleStrSplit[j];
                                Integer tok = this.tokenInt.get(token);
                                if (tok == null) {
                                    System.out.flush();
                                    throw new IllegalStateException("'" + token + "' not a token");
                                }
                                rhs[j - 1] = tok;
                                if (pickIdx == null) continue;
                                for (int k = 0; k < picks.tokens().length; ++k) {
                                    if (!picks.tokens()[k].equals(token)) continue;
                                    pickIdx[k] = j - 1;
                                    continue block21;
                                }
                            }
                        }
                        Earley earley = this.parser;
                        earley.getClass();
                        Parser.Tuple rule = new Parser.Tuple(earley, head.intValue(), rhs);
                        int ruleIdx = Arrays.binarySearch(this.sortedRules, rule);
                        if (ruleIdx < 0) {
                            throw new IllegalStateException("Internal error: " + this.tupleToString(rule) + " is not a grammar rule");
                        }
                        ruleIdxList.add(ruleIdx);
                    }
                    ruleStrSplit = ruleIdxList.iterator();
                    while (ruleStrSplit.hasNext()) {
                        int ruleIdx = (Integer)ruleStrSplit.next();
                        if (this.dispatch[ruleIdx] != null) {
                            if (noColon != 0) continue;
                            String msg = "Rule with multiple dispatches: " + this.tupleToString(this.sortedRules[ruleIdx]);
                            throw new IllegalStateException(msg);
                        }
                        int ruleNumF = ruleNum;
                        if (pickIdx == null) {
                            if (Debug.PARSE_DISPATCH.debug && anno.beforeChildren()) {
                                System.out.println("Dispatching with beforeChildren: " + this.tupleToString(this.sortedRules[ruleNum]));
                            }
                            this.dispatch[ruleIdx] = new DispatchInfo(anno, (arg_0, arg_1, arg_2) -> this.lambda$initializeDispatch$2((Method)objectArray, ruleNumF, ruleIdx, arg_0, arg_1, arg_2));
                        } else {
                            if (Debug.PARSE_DISPATCH.debug && anno.beforeChildren()) {
                                System.out.println("Dispatching with beforeChildren: " + this.tupleToString(this.sortedRules[ruleNum]));
                            }
                            this.dispatch[ruleIdx] = new DispatchInfo(anno, (arg_0, arg_1, arg_2) -> this.lambda$initializeDispatch$3((Method)objectArray, ruleNumF, pickIdx, ruleIdx, arg_0, arg_1, arg_2));
                        }
                        Parser.Tuple rule = this.sortedRules[ruleIdx];
                        ValueNode.ValueType oldType = tokenTypesDeclared.put(rule.head, (ValueNode.ValueType)headType);
                        if (oldType == null || oldType.equals(headType)) continue;
                        throw new IllegalStateException(rule + " LHS=" + headType + " != " + (Object)((Object)oldType));
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("While scanning " + objectArray.getName() + (ruleNum < 0 ? "" : " rule " + ruleNum) + System.lineSeparator() + e.toString() + System.lineSeparator() + e.getStackTrace()[0], e);
            }
        }
        if (Debug.RULE_TYPE_SYSTEM.debug) {
            ArrayList<String> allIllegalStateMessages = new ArrayList<String>();
            VerifyValueNodeTypes typeVerifier = new VerifyValueNodeTypes(this.parser, this.tokenInt, this.sortedRules, this.dispatch, tokenTypesDeclared);
            tokenTypesDeclared = typeVerifier.inferTypes();
            for (Method method : SqlInjectionGraph.class.getDeclaredMethods()) {
                try {
                    Reduction annoR;
                    Tokens annoTs = method.getDeclaredAnnotation(Tokens.class);
                    if (annoTs != null) {
                        for (Token annoT : annoTs.value()) {
                            ValueNode.ValueType reqdType = annoT.type();
                            for (String tok : annoT.token()) {
                                Integer tokInt = this.tokenInt.get(tok);
                                if (tokInt == null) {
                                    throw new IllegalStateException("'" + tok + "' not a recognized non-terminal");
                                }
                                ValueNode.ValueType actualType = tokenTypesDeclared.get(tokInt);
                                if (actualType == ValueNode.ValueType.CONFLICTED) {
                                    String err = method.getName() + " @Token(" + tok + " = " + (Object)((Object)reqdType) + ") but is actually " + (Object)((Object)actualType);
                                    System.out.println(err);
                                    continue;
                                }
                                if (actualType == reqdType) continue;
                                typeVerifier.printInferenceTree(tokInt, 1);
                                String msg = "@Token for '" + tok + "' says " + (Object)((Object)reqdType) + " but is actually " + (Object)((Object)actualType);
                                throw new IllegalStateException(msg);
                            }
                        }
                    }
                    if ((annoR = method.getDeclaredAnnotation(Reduction.class)) == null || annoR.genericChildren().length <= 0) continue;
                    List<ValueNode.ValueType> allowedTypes = Arrays.asList(annoR.genericChildren());
                    block27: for (String generic : annoR.rules()) {
                        if (generic.contains(":")) continue;
                        Integer tokInt = this.tokenInt.get(generic);
                        if (tokInt == null) {
                            throw new IllegalStateException("'" + generic + "' not a recognized non-terminal");
                        }
                        Earley earley = this.parser;
                        earley.getClass();
                        int ruleIdx = Arrays.binarySearch(this.sortedRules, new Parser.Tuple(earley, tokInt, new int[0]));
                        int n = ruleIdx = ruleIdx >= 0 ? ruleIdx : -(ruleIdx + 1);
                        while (ruleIdx < this.sortedRules.length) {
                            Parser.Tuple rule = this.sortedRules[ruleIdx];
                            if (rule.head != tokInt) continue block27;
                            for (int i = 0; i < rule.rhs.length; ++i) {
                                int rhsTok = rule.rhs[i];
                                ValueNode.ValueType actualType = tokenTypesDeclared.get(rhsTok);
                                if (actualType == ValueNode.ValueType.BOGUS_SYMBOL || actualType == ValueNode.ValueType.CONFLICTED) continue;
                                boolean compatible = false;
                                for (ValueNode.ValueType allowed : allowedTypes) {
                                    if (ValueNode.ValueType.inferCompatibleType(true, allowed, actualType) != allowed) continue;
                                    compatible = true;
                                    break;
                                }
                                if (compatible) continue;
                                throw new IllegalStateException("'" + generic + ":..." + this.parser.allSymbols[rhsTok] + "' type " + (Object)((Object)actualType) + " not in @VerifyChildren list");
                            }
                            ++ruleIdx;
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "Error while checking method " + method.getName();
                    if (Debug.GROUP_TYPE_SYSTEM_ERRORS.debug) {
                        allIllegalStateMessages.add(msg + ": " + e);
                        continue;
                    }
                    throw new IllegalStateException(msg, e);
                }
            }
            if (Debug.GROUP_TYPE_SYSTEM_ERRORS.debug && allIllegalStateMessages.size() > 0) {
                System.out.flush();
                for (String string : allIllegalStateMessages) {
                    System.err.println(string);
                }
                throw new IllegalStateException("Type system inconsitencies detected");
            }
            for (int ruleIdx = 0; ruleIdx < this.sortedRules.length; ++ruleIdx) {
                Parser.Tuple tuple = this.sortedRules[ruleIdx];
                for (int tok : tuple.rhs) {
                    if (tokenTypesDeclared.get(tok) != ValueNode.ValueType.CONFLICTED) continue;
                    this.dispatch[ruleIdx] = SqlInjectionGraph.conflictedDispatch(this.dispatch[ruleIdx], this.parser.allSymbols[tok] + " CONFLICTED in " + tuple);
                }
            }
        }
    }

    static DispatchInfo conflictedDispatch(DispatchInfo existingDispatch, String msg) {
        Reduction anno = null;
        if (existingDispatch != null) {
            anno = existingDispatch.annotation;
        }
        return new DispatchInfo(anno, (pp, unused, childValues) -> {
            throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_INTERNAL_ERROR, "CONFLICTED " + (msg.length() > 0 ? " " : "") + msg);
        });
    }

    private void dumpParse(ParseNode cur, int curtok, int depth) {
    }

    private void dumpChildren(String function, List<ValueNode> children) {
        System.out.print(function + "(");
        for (ValueNode child : children) {
            System.out.println(child + ", ");
        }
        System.out.println(")");
    }

    NodeReduction computeNodeReduction(ParseNode cur, List<ParseNode> childList, int token) throws SqlInjectionAnalysisFailure {
        Integer prevRule;
        int tok2;
        int[] parses = cur.content();
        HashMap<Integer, Integer> reverse121 = new HashMap<Integer, Integer>();
        if (Debug.PARSE_COMPUTERULE.debug) {
            System.out.print("computeNodeReduction (");
            for (int tok2 : parses) {
                System.out.print(" " + this.parser.allSymbols[tok2]);
            }
            System.out.println(", [" + childList.size() + "], " + (token < 0 ? "-1" : this.parser.allSymbols[token]) + ")");
        }
        ArrayDeque<Integer> possibleTokens = new ArrayDeque<Integer>();
        if (token < 0) {
            for (int i = 0; i < parses.length; ++i) {
                possibleTokens.addLast(parses[i]);
            }
        } else {
            possibleTokens.addLast(token);
        }
        NodeReduction ret = new NodeReduction();
        int matchingRulesCount = 0;
        if (childList.size() == 0) {
            assert (!possibleTokens.isEmpty());
            tok2 = -1;
            int lastTerminalIdx = -1;
            block2: while (!possibleTokens.isEmpty()) {
                tok2 = (Integer)possibleTokens.removeFirst();
                int parsesIdx = 0;
                Earley earley = this.parser;
                earley.getClass();
                int ruleIdx = Arrays.binarySearch(this.sortedRules, new Parser.Tuple(earley, tok2, new int[0]));
                int n = ruleIdx = ruleIdx >= 0 ? ruleIdx : -(ruleIdx + 1);
                while (ruleIdx < this.sortedRules.length) {
                    Parser.Tuple rule = this.sortedRules[ruleIdx];
                    if (rule.head != tok2) continue block2;
                    if (rule.rhs.length < 1) {
                        lastTerminalIdx = ruleIdx;
                    } else {
                        if (rule.rhs.length > 1) continue block2;
                        while (parsesIdx < parses.length && parses[parsesIdx] < rule.rhs[0]) {
                            ++parsesIdx;
                        }
                        if (parsesIdx < parses.length && parses[parsesIdx] == rule.rhs[0]) {
                            possibleTokens.add(rule.rhs[0]);
                            reverse121.put(rule.rhs[0], ruleIdx);
                        }
                    }
                    ++ruleIdx;
                }
            }
            ret.add(lastTerminalIdx);
        } else {
            block5: while (!possibleTokens.isEmpty()) {
                tok2 = (Integer)possibleTokens.removeFirst();
                int parsesIdx = 0;
                Earley earley = this.parser;
                earley.getClass();
                int ruleIdx = Arrays.binarySearch(this.sortedRules, new Parser.Tuple(earley, tok2, new int[0]));
                int n = ruleIdx = ruleIdx >= 0 ? ruleIdx : -(ruleIdx + 1);
                assert (ruleIdx >= 0);
                assert (ruleIdx < this.sortedRules.length);
                assert (ruleIdx == 0 || this.sortedRules[ruleIdx - 1].head < tok2);
                while (ruleIdx < this.sortedRules.length) {
                    Parser.Tuple rule = this.sortedRules[ruleIdx];
                    if (rule.head != tok2 || rule.rhs.length > childList.size()) continue block5;
                    if (rule.rhs.length == 1) {
                        while (parsesIdx < parses.length && parses[parsesIdx] < rule.rhs[0]) {
                            ++parsesIdx;
                        }
                        if (parsesIdx < parses.length && parses[parsesIdx] == rule.rhs[0]) {
                            possibleTokens.add(rule.rhs[0]);
                            reverse121.put(rule.rhs[0], ruleIdx);
                        }
                    }
                    if (rule.rhs.length == childList.size()) {
                        boolean childrenMatch = true;
                        block8: for (int childIdx = 0; childIdx < rule.rhs.length; ++childIdx) {
                            ParseNode child = childList.get(childIdx);
                            for (int childTok : child.content()) {
                                if (childTok == rule.rhs[childIdx]) continue block8;
                            }
                            childrenMatch = false;
                            break;
                        }
                        if (childrenMatch) {
                            ++matchingRulesCount;
                            ret.add(ruleIdx);
                            break block5;
                        }
                    }
                    ++ruleIdx;
                }
            }
        }
        if (ret.rules.size() == 0) {
            System.out.flush();
            throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_BAD_PARSE, "No rule for " + token + " " + (token < 0 || this.parser == null || this.parser.allSymbols == null || token >= this.parser.allSymbols.length ? "" : this.parser.allSymbols[token]));
        }
        assert (ret.rules.size() == 1);
        tok2 = ret.getHead(0);
        while (tok2 != token && (prevRule = (Integer)reverse121.get(tok2)) != null) {
            assert (prevRule >= 0);
            ret.add(prevRule);
            tok2 = ret.getLastRule().head;
        }
        if (Debug.PARSE_COMPUTERULE.debug) {
            System.out.println("computeRule: " + ret);
        }
        return ret;
    }

    final Parser.Tuple rule(int i) {
        return this.sortedRules[i];
    }

    public List<List<DependencyLink>> getInjections() {
        return this.globalFlow.getInjections(u -> new DependencyLink.LocationTuple("", this.linenum(u.getLoc())), this.topLevelSymbolsDebug, false);
    }

    public List<SqlInjectionAnalysisFailure> getParsingErrors() {
        return Collections.unmodifiableList(this.parsingErrors);
    }

    public static String getEditorWarningText(List<DependencyLink> injection, boolean skipFinal) {
        StringBuffer sb = new StringBuffer("SQL injection " + SqlInjectionGraph.getEditorWarningOneLink(injection, 0));
        for (int i = 1; i < injection.size() - (skipFinal ? 1 : 0); ++i) {
            if (injection.get(i).getLoc().isSynthetic()) continue;
            sb.append(" -> " + SqlInjectionGraph.getEditorWarningOneLink(injection, i));
        }
        return sb.toString();
    }

    public static String getEditorWarningText(List<DependencyLink> injection) {
        return SqlInjectionGraph.getEditorWarningText(injection, true);
    }

    private static String getEditorWarningOneLink(List<DependencyLink> injection, int i) {
        String name = "";
        name = injection.get(i).getVar() + " ";
        if (name.length() > 0 && name.startsWith("(")) {
            name = "(EXCEPTION) ";
        }
        return name + "line " + injection.get(i).getLoc();
    }

    private ValueNode parse(ParseParm pp) throws SqlInjectionAnalysisFailure {
        if (Debug.PARSE_SOURCE.debug) {
            System.out.print(this.printableLine(pp.cur, pp.reduces, pp.depth));
            System.out.flush();
            if (pp.reduces.getRule((int)0).rhs.length == 0) {
                System.out.print(" [" + this.src.get(pp.cur.from) + "]");
            }
            System.out.println();
        }
        try {
            List<ValueNode> childValues = null;
            boolean isRule0 = true;
            for (int ruleIdx : pp.reduces.getIdxs()) {
                DispatchInfo di = this.dispatch[ruleIdx];
                if (Debug.PARSE_DISPATCH.debug) {
                    System.out.println("Dispatching: " + this.tupleToString(this.sortedRules[ruleIdx]) + System.lineSeparator() + di);
                }
                if (!(di != null && di.annotation != null && di.annotation.beforeChildren() || childValues != null)) {
                    if (pp.childList.isEmpty()) {
                        assert (this.sortedRules[ruleIdx].rhs.length == 0);
                        childValues = Arrays.asList(new ValueNode.TokenNode(pp.cur, this.src.get(pp.cur.from)));
                    } else {
                        childValues = new ArrayList<ValueNode>(pp.childList.size());
                        for (int childIdx = 0; childIdx < pp.childList.size(); ++childIdx) {
                            childValues.add(this.parse(pp.createChildParm(childIdx)));
                        }
                    }
                }
                if (Debug.PARSE_DISPATCH.debug) {
                    Parser.Tuple rule = this.sortedRules[ruleIdx];
                    if (isRule0) {
                        if (rule.rhs.length == 0) {
                            System.out.print("=" + childValues.get(0) == null ? "[TOKEN]" : "[" + childValues.get(0) + "]");
                        } else {
                            System.out.print("{dispatching " + this.tupleToString(rule) + " ## " + this.correspondingSource(pp.cur) + "}");
                        }
                    }
                }
                boolean didReduction = false;
                if (di == null) {
                    if (childValues.size() > 1) {
                        childValues = Arrays.asList(this.parseMergeValueNodes(pp, -1, childValues));
                        didReduction = true;
                    }
                } else {
                    childValues = Arrays.asList(di.parser.parse(pp, -1, childValues));
                    didReduction = true;
                }
                if (Debug.PARSE_DISPATCH.debug && didReduction) {
                    System.out.println();
                    System.out.print("=" + childValues.get(0));
                }
                isRule0 = false;
            }
            if (Debug.PARSE_DISPATCH.debug) {
                System.out.println();
            }
            return (ValueNode)childValues.get(0);
        }
        catch (SqlInjectionAnalysisFailure e) {
            if (e.getWhileParsingSource() == null) {
                e.setWhileParsingSource(this.linenum(pp.cur) + ":" + this.correspondingSource(pp.cur));
            }
            throw e;
        }
        catch (Exception e) {
            SqlInjectionAnalysisFailure saf = new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_INTERNAL_ERROR, "While parsing", e);
            saf.setWhileParsingSource(this.linenum(pp.cur) + ":" + this.correspondingSource(pp.cur));
            throw saf;
        }
    }

    @Reduction(rules={"identifier"})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode parse_identifier(ParseParm pp, int ruleNum, List<ValueNode> ignored) {
        return new ValueNode.DottedNode(pp.cur, this.src.get((int)pp.cur.from).content);
    }

    @Reduction(rules={"interface_prm_spec: decl_id interface_constrained_type", "interface_prm_spec: decl_id interface_constrained_type interface_indicator_opt"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"decl_id"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"interface_constrained_type"})})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode parse_interface_prm_spec(ParseParm pp, int ruleNum, List<ValueNode> ignored) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"interface_constrained_type: unconstrained_type", "interface_constrained_type: unconstrained_type NOT_NULL_opt", "interface_constrained_type: unconstrained_type paren_expr_list", "interface_constrained_type: unconstrained_type paren_expr_list NOT_NULL_opt"})
    @Tokens(value={@Token(type=ValueNode.ValueType.MULTIARGNODE, token={"paren_expr_list"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"unconstrained_type"})})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_interface_constrained_type(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        ValueNode.TypeNode tnode = childValues.get(0).asTypeNode();
        ArrayList<Usage> uses = new ArrayList<Usage>();
        if (childValues.size() >= 2) {
            for (ValueNode.ArgNode expr : childValues.get(1).asMultiArgNode().getValues()) {
                uses.addAll(expr.getUsages());
            }
        }
        return new ValueNode.ExprNode(pp.cur, tnode.getType(), null);
    }

    @Reduction(rules={"json_object", "function_call: json_object '(' ')'", "function_call: json_object '(' json_flag_list ')'", "function_call: json_object '(' json_object_arg ')'", "function_call: json_object '(' json_object_arg json_flag_list ')'", "function_call: json_object '(' json_object_arg json_object_arg_list ')'", "function_call: json_object '(' json_object_arg json_object_arg_list json_flag_list ')'"})
    @Token(type=ValueNode.ValueType.MULTIEXPRNODE, token={"json_object_arg", "json_object_arg_list"})
    @PickTokens(tokens={"json_object_arg", "json_object_arg_list"})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_json_constructors(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ArrayList args = new ArrayList();
        for (int i = 0; i < 2; ++i) {
            if (pickIdx[i] < 0) continue;
            args.addAll(childValues.get(pickIdx[0]).asMultiArgNode().getValues());
        }
        if (args.size() > 0) {
            return this.parseMergeValueNodes(pp, -1, args).asExprNode(pp.symbols);
        }
        return new ValueNode.ExprNode(pp.cur, new PlsqlType.Scalar(PlsqlType.ScalarType.VARCHAR2), null);
    }

    @Reduction(rules={"basic_decl_item_list: basic_decl_item", "basic_decl_item_list: basic_decl_item_list basic_decl_item"})
    @Tokens(value={@Token(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION, token={"basic_decl_item"}), @Token(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION, token={"later_decl_item_list"})})
    @Returns(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION)
    private ValueNode.MultiIdentifierNodeDeclaration parse_basic_decl_item_list(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        ValueNode.MultiIdentifierNodeDeclaration ret = new ValueNode.MultiIdentifierNodeDeclaration(pp.cur);
        if (childValues.size() > 1) {
            ret.addAll(childValues.get(0).asMultiIdentifierNodeDeclaration().getValues());
        }
        ret.add(childValues.get(childValues.size() - 1).asIdentiferNodeDeclared());
        return ret;
    }

    @Reduction(rules={"decl_list: basic_decl_item_list", "decl_list: subprg_body", "decl_list: basic_decl_item_list subprg_body", "decl_list: subprg_body later_decl_item_list", "decl_list: basic_decl_item_list subprg_body later_decl_item_list"})
    @Tokens(value={@Token(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION, token={"basic_decl_item_list"}), @Token(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION, token={"later_decl_item_list"})})
    @PickTokens(tokens={"basic_decl_item_list", "later_decl_item_list"})
    @Returns(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION)
    private ValueNode.MultiIdentifierNodeDeclaration parse_decl_list(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ValueNode.MultiIdentifierNodeDeclaration ret = new ValueNode.MultiIdentifierNodeDeclaration(pp.cur);
        for (int i : pickIdx) {
            ValueNode vnode;
            if (i < 0 || (vnode = childValues.get(pickIdx[i])) == null) continue;
            ValueNode.MultiIdentifierNodeDeclaration node = vnode.asMultiIdentifierNodeDeclaration();
            ret.addAll(node.getValues());
        }
        return ret;
    }

    @Reduction(rules={"json_common_expr_flag: 'DEFAULT' pls_expr 'ON' 'CONVERSION' 'ERROR' ',' sim_expr ',' sim_expr", "json_common_expr_flag", "json_common_flag", "json_datetime_returning_flag"})
    @Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr", "sim_expr"})
    @PickTokens(tokens={"pls_expr", "sim_expr"})
    @Returns(type=ValueNode.ValueType.MULTIEXPRNODE)
    private ValueNode parse_json_flags(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ArrayList<ValueNode.MultiArgNode> args = new ArrayList<ValueNode.MultiArgNode>();
        for (int i = 0; i < 2; ++i) {
            if (pickIdx[i] < 0) continue;
            args.add(childValues.get(pickIdx[0]).asMultiArgNode());
        }
        if (args.size() > 0) {
            return this.parseMergeValueNodes(pp, -1, args);
        }
        return PlsqlType.safeExprNode(pp.cur);
    }

    @Reduction(rules={})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode.ExprNode parseMergeExprNode(ParseParm pp, int rulenum, List<? extends ValueNode> childValues) throws SqlInjectionAnalysisFailure {
        ValueNode.ExprNode expr = null;
        for (ValueNode valueNode : childValues) {
            if (!(valueNode instanceof ValueNode.ExprNode)) continue;
            if (expr != null) {
                throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_INTERNAL_ERROR, "Found > 1 ExprNode: " + expr + " : " + valueNode);
            }
            expr = (ValueNode.ExprNode)valueNode;
        }
        if (expr == null) {
            expr = new ValueNode.ExprNode(pp.cur, PlsqlType.safeType(), null);
        }
        return expr;
    }

    private ValueNode parseMergeValueNodes(ParseParm pp, int UNUSED, List<? extends ValueNode> childValues) {
        ValueNode single = null;
        Enum type = null;
        ValueNode.MultiNode multi = null;
        for (int i = 0; i < childValues.size(); ++i) {
            ValueNode childvalue = childValues.get(i);
            if (childvalue == null || childvalue instanceof ValueNode.TokenNode) continue;
            if (single == null) {
                single = childvalue;
                type = single.getValueType().asMulti();
                if (!(single instanceof ValueNode.MultiNode)) continue;
                multi = (ValueNode.MultiNode)single;
                continue;
            }
            if (multi == null) {
                switch (1.$SwitchMap$oracle$dbtools$app$injection$ValueNode$ValueType[type.ordinal()]) {
                    case 1: {
                        multi = new ValueNode.MultiArgNode(pp.cur);
                        break;
                    }
                    case 2: {
                        multi = new ValueNode.MultiExprNode(pp.cur);
                        break;
                    }
                    case 3: {
                        multi = new ValueNode.MultiIdentifierNodeDeclaration(pp.cur);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not a known multi type: " + type + " (from " + single.getClass() + ")" + System.lineSeparator() + pp.reduces);
                    }
                }
                multi.add(single);
            }
            if (childvalue instanceof ValueNode.MultiNode) {
                ValueNode.MultiNode multichild = (ValueNode.MultiNode)childvalue;
                multi.getValues().addAll(multichild.getValues());
                continue;
            }
            multi.add(childvalue);
        }
        if (multi != null) {
            return multi;
        }
        return single;
    }

    @Reduction(rules={"ext_tbl_string_literal[4,24)", "count[41,46)", "datetime_expression[13,58)", "datetime_expression[32,57)", "labeled_nonblock_stmt", "sim_stmt", "stmt_list_opt"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parseAsNull(ParseParm pp, int UNUSED, List<ValueNode> childValues) {
        return null;
    }

    private void print(ParseParm pp, NodeReduction rule) {
        if (Debug.PARSE_SOURCE.debug) {
            System.out.println(this.printableLine(pp.cur, rule, pp.depth));
        }
    }

    private String printableLine(ParseNode node, NodeReduction rule, int depth) {
        StringBuffer sb = new StringBuffer(this.linePrefix(node, depth));
        sb.append(rule);
        sb.append(" ## ");
        sb.append(this.correspondingSource(node));
        return sb.toString();
    }

    static String tupleToString(Parser.Tuple rule, Parser parser) {
        if (rule == null) {
            return "[null Tuple]";
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(rule.head < 0 || rule.head > parser.allSymbols.length ? rule + "(!)range" : parser.allSymbols[rule.head]);
            sb.append(rule.rhs.length == 0 ? " TERM" : ":");
            for (int childTok : rule.rhs) {
                sb.append(" " + (childTok < 0 || childTok >= parser.allSymbols.length ? childTok + "(!)range" : parser.allSymbols[childTok]));
            }
            return sb.toString();
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException ex) {
            sb.append(ex.getClass().toString());
            sb.append(" " + rule.head);
            if (rule.rhs == null) {
                return sb + " null RHS";
            }
            for (int childTok : rule.rhs) {
                sb.append(" " + childTok);
            }
            return sb.toString();
        }
    }

    String tupleToString(Parser.Tuple rule) {
        return SqlInjectionGraph.tupleToString(rule, this.parser);
    }

    private String correspondingSource(ParseNode node) {
        StringBuffer sb = new StringBuffer();
        String space = "";
        for (int i = node.from; i < node.to; ++i) {
            String s = space + this.src.get((int)i).content;
            space = " ";
            if (sb.length() + s.length() > 80 && i - node.from > 3) {
                sb.append("...");
                break;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private String linePrefix(ParseNode node, int depth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("| ");
        }
        String line = "" + this.linenum(node);
        String linePos = line + " $" + node.from;
        String lineRange = line + " $" + node.from + (node.to > node.from + 1 ? "-" + node.to : "");
        int space = sb.length() - 2;
        String prefix = "";
        if (space > lineRange.length()) {
            prefix = lineRange;
        } else if (space > linePos.length()) {
            prefix = linePos;
        } else if (space > line.length()) {
            prefix = line;
        }
        sb.replace(0, prefix.length(), prefix);
        return sb.toString();
    }

    private String getText(List<ParseNode> children, int childIdx, String token) {
        ParseNode child = children.get(childIdx);
        if (token == null || child.content(0).equals(token)) {
            LexerToken t = this.src.get(child.from);
            return t.content;
        }
        throw new IllegalArgumentException("Expected token '" + token + "' but got '" + child.content(0) + "'");
    }

    int linenum(Loc loc) {
        if (loc == null) {
            return 0;
        }
        if (loc.getLocType() == Loc.LocType.PARSENODE) {
            return this.linenum(loc.getParseNode());
        }
        return 0;
    }

    int linenum(ParseNode pos) {
        if (pos == null) {
            return 0;
        }
        try {
            int linenum = Service.charPos2LineNo(this.target.getInput(), this.target.getSrc().get((int)pos.from).begin);
            if (pos.to == Integer.MIN_VALUE) {
                linenum = -linenum;
            }
            return linenum;
        }
        catch (Exception e) {
            return Integer.MAX_VALUE;
        }
    }

    static ParseNode fakeParseNode(int token) {
        return new ParseNode(token, Integer.MIN_VALUE, -1, -1, null);
    }

    static boolean isFake(ParseNode node) {
        return node.to == Integer.MIN_VALUE;
    }

    static boolean isFake(Loc loc) {
        return loc == null || loc.isSynthetic();
    }

    @Reduction(beforeChildren=true, rules={"if_stmt: 'IF' pls_expr 'THEN' seq_of_stmts 'END' 'IF' ';'", "if_stmt: 'IF' pls_expr 'THEN' seq_of_stmts 'END' 'IF' identifier ';'", "if_stmt: 'IF' pls_expr 'THEN' seq_of_stmts else_clause_opt 'END' 'IF' ';'", "if_stmt: 'IF' pls_expr 'THEN' seq_of_stmts else_clause_opt 'END' 'IF' identifier ';'", "if_stmt: 'IF' pls_expr 'THEN' seq_of_stmts elsif_clause_opt 'END' 'IF' ';'", "if_stmt: 'IF' pls_expr 'THEN' seq_of_stmts elsif_clause_opt 'END' 'IF' identifier ';'", "if_stmt: 'IF' pls_expr 'THEN' seq_of_stmts elsif_clause_opt else_clause_opt 'END' 'IF' ';'", "if_stmt: 'IF' pls_expr 'THEN' seq_of_stmts elsif_clause_opt else_clause_opt 'END' 'IF' identifier ';'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"if_stmt"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"seq_of_stmts"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"else_clause_opt"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"elsif_clause_opt"})})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_if_stmt(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        pp.symbols.pushMetadata();
        ArrayList forkWritesList = new ArrayList();
        HashMap allUnmodReads = new HashMap();
        Function<Usage, Usage> oldReadHook = pp.symbols.getReadHook();
        pp.symbols.setReadHook(u -> {
            Usage forkU = (Usage)((HashMap)forkWritesList.get(forkWritesList.size() - 1)).get(u.getSymbol());
            Debug.IF_ENDIF.outln("Read forkWrite: " + forkU);
            if (forkU == null) {
                forkU = u;
                Debug.IF_ENDIF.outln("Unmod value read: " + u);
                allUnmodReads.put(u.getSymbol(), u);
            }
            return (Usage)oldReadHook.apply(forkU);
        });
        Consumer<Usage> oldWriteHook = pp.symbols.getWriteHook();
        pp.symbols.setWriteHook(u -> {
            if (allUnmodReads.get(u.getSymbol()) == null) {
                allUnmodReads.put(u.getSymbol(), u.getSymbol().getAssigned());
                Debug.IF_ENDIF.outln("Unmod value before write: " + u);
            }
            ((HashMap)forkWritesList.get(forkWritesList.size() - 1)).put(u.getSymbol(), u);
            oldWriteHook.accept((Usage)u);
        });
        forkWritesList.add(new HashMap());
        ValueNode.ExprNode pls_expr = this.parse(pp.createChildParm(1)).asExprNode(pp.symbols);
        this.parse(pp.createChildParm(3));
        if (ruleid >= 2) {
            forkWritesList.add(new HashMap());
            this.parse(pp.createChildParm(4));
        }
        if (ruleid >= 6) {
            forkWritesList.add(new HashMap());
            this.parse(pp.createChildParm(5));
        }
        pp.symbols.popMetadata();
        HashMap<Symbol, Usage> allForkWrites = new HashMap<Symbol, Usage>();
        for (HashMap hashMap : forkWritesList) {
            for (Map.Entry entry : hashMap.entrySet()) {
                Symbol symbol = (Symbol)entry.getKey();
                Usage forkU = (Usage)entry.getValue();
                Usage fakeU = (Usage)allForkWrites.get(symbol);
                if (fakeU == null) {
                    Loc loc = new Loc(SqlInjectionGraph.fakeParseNode(pp.cur.to - 1), "END IF");
                    fakeU = new Usage(symbol, loc, (Object)this.globalFlow.getNodeLabel());
                    allForkWrites.put(symbol, fakeU);
                }
                fakeU.from(forkU);
                symbol.assign(fakeU);
                Debug.IF_ENDIF.outln(forkU + " -> " + fakeU);
            }
        }
        ArrayList<Object> missed = new ArrayList<Object>();
        switch (ruleid) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                Debug.IF_ENDIF.outln("Null branch (ruleid=" + ruleid + "), all " + allForkWrites.size() + " vars miss");
                missed.addAll(allForkWrites.keySet());
                break;
            }
            default: {
                block5: for (Symbol symbol : allForkWrites.keySet()) {
                    for (Map map : forkWritesList) {
                        if (map.get(symbol) != null) continue;
                        missed.add(symbol);
                        Debug.IF_ENDIF.outln(symbol + " misses a branch");
                        continue block5;
                    }
                    Debug.IF_ENDIF.outln(symbol + " doesn't miss any branch");
                }
            }
        }
        for (Symbol symbol : missed) {
            Usage usage = (Usage)allForkWrites.get(symbol);
            usage.from((Usage)allUnmodReads.get(symbol));
            symbol.assign(usage);
        }
        return null;
    }

    @Reduction(beforeChildren=true, rules={"loop_stmt: 'LOOP' seq_of_stmts 'END' 'LOOP' ';'", "loop_stmt: 'LOOP' seq_of_stmts 'END' 'LOOP' identifier ';'", "loop_stmt: iteration_scheme 'LOOP' seq_of_stmts 'END' 'LOOP' ';'", "loop_stmt: iteration_scheme 'LOOP' seq_of_stmts 'END' 'LOOP' identifier ';'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"loop_stmt"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"iteration_scheme"})})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_loop_stmt(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        Usage u2;
        Symbol sym;
        pp.symbols.pushMetadata();
        ParseParm ppLocal = pp.createNestedScope(SymbolTable.ScopeType.BLOCK);
        Loc fakeContPos = new Loc(SqlInjectionGraph.fakeParseNode(ppLocal.cur.from), "CONTINUE");
        Loc fakeExitPos = new Loc(SqlInjectionGraph.fakeParseNode(ppLocal.cur.to - 1), "EXIT");
        HashMap varsRefed = new HashMap();
        HashMap varsAssigned = new HashMap();
        int[] exitCount = new int[]{0};
        Consumer<Usage> oldWrite = ppLocal.symbols.getWriteHook();
        ppLocal.symbols.setWriteHook(u -> {
            Symbol sym = u.getSymbol();
            if (varsAssigned.get(sym) == null) {
                Usage exitU = new Usage(sym, fakeExitPos, (Object)this.globalFlow.getNodeLabel());
                varsAssigned.put(sym, exitU);
                if (varsRefed.get(u.getSymbol()) == null) {
                    ppLocal.symbols.readHook((Usage)u);
                }
                if (exitCount[0] > 0) {
                    exitU.from((Usage)varsRefed.get(sym));
                }
            }
            oldWrite.accept((Usage)u);
        });
        Function<Usage, Usage> oldRead = pp.symbols.getReadHook();
        pp.symbols.setReadHook(u -> {
            Symbol sym = u.getSymbol();
            if (varsRefed.get(sym) == null) {
                Usage contU = new Usage(sym, fakeContPos, (Object)this.globalFlow.getNodeLabel());
                contU.from((Usage)u);
                varsRefed.put(sym, contU);
            }
            return (Usage)oldRead.apply((Usage)u);
        });
        pp.symbols.hookContinue(contScope -> {
            for (Map.Entry e : varsRefed.entrySet()) {
                Symbol sym = (Symbol)e.getKey();
                Usage u = (Usage)e.getValue();
                u.from(sym.getAssigned());
            }
        });
        pp.symbols.hookExit(exitScope -> {
            exitCount[0] = exitCount[0] + 1;
            for (Map.Entry e : varsAssigned.entrySet()) {
                Symbol sym = (Symbol)e.getKey();
                Usage u = (Usage)e.getValue();
                u.from(sym.getAssigned());
            }
        });
        if (ruleid < 2) {
            this.parse(pp.createChildParm(1));
        } else {
            this.parse(pp.createChildParm(0));
            this.parse(pp.createChildParm(2));
        }
        for (Map.Entry e : varsRefed.entrySet()) {
            sym = (Symbol)e.getKey();
            u2 = (Usage)e.getValue();
            u2.from(sym.getAssigned());
        }
        pp.symbols.popMetadata();
        for (Map.Entry e : varsAssigned.entrySet()) {
            sym = (Symbol)e.getKey();
            u2 = (Usage)e.getValue();
            sym.assign(u2);
        }
        return null;
    }

    @Reduction(rules={"seq_of_stmts: stmt", "seq_of_stmts: pragma_list_opt stmt", "seq_of_stmts: stmt stmt_list_opt", "seq_of_stmts: pragma_list_opt stmt stmt_list_opt"})
    @Token(type=ValueNode.ValueType.NULLNODE, token={"stmt"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_seq_of_stmts(ParseParm pp, int ruleid, List<ValueNode> children) {
        return null;
    }

    @Reduction(beforeChildren=true, rules={"block_stmt", "lock_table", "bulk_loop_stmt", "case_stmt", "if_stmt", "loop_stmt", "unlabeled_nonblock_stmt: exec_immediate_statement ';'", "unlabeled_nonblock_stmt: sql_stmt ';'", "unlabeled_nonblock_stmt: static_ddl_stmt ';'", "unlabeled_nonblock_stmt: static_dml_stmt ';'"})
    @Token(type=ValueNode.ValueType.NULLNODE, token={"block_stmt", "lock_table", "assignment_stmt", "bulk_loop_stmt", "case_stmt", "if_stmt", "loop_stmt"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_stmt(ParseParm pp, int ruleid, List<ValueNode> children) {
        try {
            for (int i = 0; i < pp.childList.size(); ++i) {
                this.parse(pp.createChildParm(i));
            }
        }
        catch (SqlInjectionAnalysisFailure saf) {
            if (saf.getWhileParsingSource() == null) {
                saf.setWhileParsingSource(this.linenum(pp.cur) + ":" + this.correspondingSource(pp.cur));
            }
            this.parsingFailed(saf, pp);
        }
        return null;
    }

    @Reduction(beforeChildren=true, rules={"subprg_body: ff_w_external ';'", "subprg_body: subprg_spec is_or_as 'BEGIN' seq_of_stmts 'END' ';'", "subprg_body: subprg_spec is_or_as 'BEGIN' seq_of_stmts 'END' designator ';'", "subprg_body: subprg_spec is_or_as 'BEGIN' seq_of_stmts exception_handlers_opt 'END' ';'", "subprg_body: subprg_spec is_or_as decl_list 'BEGIN' seq_of_stmts 'END' ';'", "subprg_body: subprg_spec is_or_as 'BEGIN' seq_of_stmts exception_handlers_opt 'END' designator ';'", "subprg_body: subprg_spec is_or_as decl_list 'BEGIN' seq_of_stmts 'END' designator ';'", "subprg_body: subprg_spec is_or_as decl_list 'BEGIN' seq_of_stmts exception_handlers_opt 'END' ';'", "subprg_body: subprg_spec is_or_as decl_list 'BEGIN' seq_of_stmts exception_handlers_opt 'END' designator ';'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"designator"}), @Token(type=ValueNode.ValueType.FUNCTIONNODEDECLARATION, token={"subprg_spec"}), @Token(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION, token={"decl_list"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"seq_of_stmts"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"exception_handlers_opt"})})
    @PickTokens(tokens={"decl_list", "seq_of_stmts", "designator", "exception_handlers_opt"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_subprg_body(ParseParm pp, int ruleid, List<ValueNode> children, int[] pickIdx) {
        if (ruleid == 0) {
            return null;
        }
        if (Debug.DUMP_USAGES.has(obj -> "parse_subprg_body".equals(obj))) {
            Usage.dumpSaveAll(null, "parse_subprg_body START", new List[0]);
        }
        ValueNode.FunctionNodeDeclaration spec = this.parse(pp.createChildParm(0)).asFunctionNodeDeclaration();
        Symbol.FunctionSym func = spec.func;
        FuncFormal formal = spec.formal;
        Call call = new Call(pp.loc(), formal);
        pp = pp.createNestedScope(SymbolTable.ScopeType.FUNCTION);
        this.globalFlow.pushNodeLabel(this.globalFlow.getNodeLabel().labelNewCall(call));
        for (Symbol symbol : formal.getInSymbols()) {
            pp.symbols.define(symbol, pp.loc());
            if (!symbol.getType().isInjectable()) continue;
            this.globalFlow.addSource(symbol.getAssigned());
        }
        if (pickIdx[0] >= 0) {
            ValueNode.MultiIdentifierNodeDeclaration declList = this.parse(pp.createChildParm(pickIdx[0])).asMultiIdentifierNodeDeclaration();
            for (ValueNode.IdentifierNodeDeclaration IdDecl : declList.getValues()) {
                String name = IdDecl.getName();
                PlsqlType type = IdDecl.getType();
                new Symbol(pp.symbols, name, type, new Loc(IdDecl.pos), this.globalFlow.getNodeLabel());
            }
        }
        if (pickIdx[3] >= 0) {
            this.parse(pp.createChildParm(pickIdx[3]));
        }
        this.parse(pp.createChildParm(pickIdx[1]));
        List<Usage> list = formal.getAfterCall();
        for (int i = 0; i < list.size(); ++i) {
            Symbol parmSym = formal.getInSymbols().get(i);
            Usage u = list.get(i);
            u.from(parmSym.getAssigned());
            u.setFunctionOutput(true);
        }
        this.globalFlow.popNodeLabel();
        if (Debug.DUMP_USAGES.has(obj -> "parse_subprg_body".equals(obj))) {
            Usage.dumpSaveAll(null, "parse_subprg_body END " + func, new List[0]);
        }
        return null;
    }

    @Reduction(beforeChildren=true, rules={"subprg_spec: 'FUNCTION' designator 'RETURN' func_return_prm_spec_unconstrained_type", "subprg_spec: 'FUNCTION' designator 'RETURN' func_return_prm_spec_unconstrained_type func_properties_opt", "subprg_spec: 'FUNCTION' designator 'RETURN' func_return_prm_spec_unconstrained_type subprg_properties", "subprg_spec: 'FUNCTION' designator 'RETURN' func_return_prm_spec_unconstrained_type subprg_properties func_properties_opt", "subprg_spec: 'FUNCTION' designator fml_part 'RETURN' func_return_prm_spec_unconstrained_type", "subprg_spec: 'FUNCTION' designator fml_part 'RETURN' func_return_prm_spec_unconstrained_type func_properties_opt", "subprg_spec: 'FUNCTION' designator fml_part 'RETURN' func_return_prm_spec_unconstrained_type subprg_properties", "subprg_spec: 'FUNCTION' designator fml_part 'RETURN' func_return_prm_spec_unconstrained_type subprg_properties func_properties_opt", "subprg_spec: 'PROCEDURE' decl_id", "subprg_spec: 'PROCEDURE' decl_id fml_part", "subprg_spec: 'PROCEDURE' decl_id fml_part proc_interface_opt", "subprg_spec: 'PROCEDURE' decl_id fml_part subprg_properties", "subprg_spec: 'PROCEDURE' decl_id fml_part subprg_properties proc_interface_opt", "subprg_spec: 'PROCEDURE' decl_id proc_interface_opt", "subprg_spec: 'PROCEDURE' decl_id subprg_properties", "subprg_spec: 'PROCEDURE' decl_id subprg_properties proc_interface_opt"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"decl_id", "designator"}), @Token(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION, token={"fml_part"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"func_return_prm_spec_unconstrained_type"})})
    @PickTokens(tokens={"decl_id", "designator", "fml_part", "func_return_prm_spec_unconstrained_type"})
    @Returns(type=ValueNode.ValueType.FUNCTIONNODEDECLARATION)
    private ValueNode parse_subprg_spec(ParseParm pp, int ruleid, List<ValueNode> children, int[] pickIdx) {
        Symbol.FunctionSym func;
        Symbol existingFunc;
        ValueNode.DottedNode dottedNode;
        if (pickIdx[0] >= 0) {
            dottedNode = this.parse(pp.createChildParm(pickIdx[0])).asDottedNode();
        } else {
            assert (pickIdx[1] >= 0);
            dottedNode = this.parse(pp.createChildParm(pickIdx[1])).asDottedNode();
        }
        ValueNode.MultiIdentifierNodeDeclaration fml_part = null;
        if (pickIdx[2] >= 0) {
            fml_part = this.parse(pp.createChildParm(pickIdx[2])).asMultiIdentifierNodeDeclaration();
        }
        ValueNode.TypeNode returnType = null;
        if (pickIdx[3] >= 0) {
            returnType = this.parse(pp.createChildParm(pickIdx[3])).asTypeNode();
        }
        ArrayList<ParmSpec> parms = new ArrayList<ParmSpec>();
        if (fml_part != null) {
            for (int i = 0; i < fml_part.getValues().size(); ++i) {
                ValueNode.IdentifierNodeDeclaration idDecl = (ValueNode.IdentifierNodeDeclaration)fml_part.getValues().get(i);
                parms.add(new ParmSpec(i + 1, idDecl.getName(), idDecl.getType(), idDecl.mode, idDecl.noCopy));
            }
        }
        if (returnType != null) {
            parms.add(new ParmSpec(0, null, returnType.getType(), ParameterMode.OUT, false));
        }
        FuncFormal formal = new FuncFormal(dottedNode.getName(), parms, pp.loc(), this.globalFlow.getNodeLabel());
        if (Debug.PARSE_FUNCTION_DEFINE.debug) {
            System.out.println("Dotted: " + dottedNode);
            System.out.println("fml_part: " + fml_part);
            System.out.println("returnType: " + returnType);
        }
        if ((existingFunc = pp.symbols.getLocalDeclaration(dottedNode.getName())) == null || !(existingFunc instanceof Symbol.FunctionSym)) {
            func = new Symbol.FunctionSym(pp.symbols, dottedNode.getName(), parms, pp.loc(), (Object)this.globalFlow.getNodeLabel());
            if (Debug.PARSE_FUNCTION_DEFINE.debug) {
                System.out.println("New: " + func);
            }
        } else {
            func = (Symbol.FunctionSym)existingFunc;
            formal = func.addSignature(formal);
            if (Debug.PARSE_FUNCTION_DEFINE.debug) {
                System.out.println("Add: " + func);
            }
        }
        return new ValueNode.FunctionNodeDeclaration(pp.cur, dottedNode.getDotted(), func, formal);
    }

    private ValueNode preparse_BEGIN_END(SubprgBodyState state, ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"assignment_stmt: name ':' '=' pls_expr ';'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"name"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"})})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_assignment_stmt(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        ValueNode.IdentifierNode name = childValues.get(0).asIdentifierNode(pp.symbols);
        ValueNode.ExprNode expr = (ValueNode.ExprNode)childValues.get(3);
        SymbolTable.ResolvedSymbol rSym = pp.symbols.resolveDotted(name.getDotted());
        Symbol symbol = rSym.symbol;
        Usage declaration = symbol.getAssigned();
        List<Usage> propagatesFrom = expr.getUsages();
        EnumSet<PlsqlException> exceptions = TypeConversion.conversionExceptions(expr.getType(), declaration.getType());
        if (!exceptions.isEmpty()) {
            pp.symbols.exceptions(exceptions, pp.cur);
        }
        Usage newUse = new Usage(symbol, pp.loc(), (Object)this.globalFlow.getNodeLabel());
        symbol.assign(newUse);
        if (declaration.getType().isInjectable()) {
            for (Usage use : propagatesFrom) {
                newUse.from(use);
            }
            Debug.ASSIGNMENT.out("Assignment: " + newUse + " [" + newUse.getType() + "] from: ");
            for (Usage use : propagatesFrom) {
                Debug.ASSIGNMENT.out(" " + use);
            }
            Debug.ASSIGNMENT.outln();
        } else {
            Debug.ASSIGNMENT.outln(name + " is safe: " + declaration.getType());
        }
        return null;
    }

    @Reduction(rules={"excptn_d", "subprg_i", "ty_d"})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode.IdentifierNodeDeclaration parse_VARIOUS_d(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        ValueNode node = childValues.get(0);
        if (node instanceof ValueNode.IdentifierNodeDeclaration) {
            return node.asIdentiferNodeDeclared();
        }
        if (node instanceof ValueNode.IdentifierNode) {
            ValueNode.IdentifierNode idNode = node.asIdentifierNode();
            return new ValueNode.IdentifierNodeDeclaration(pp.cur, idNode.getDotted(), idNode.getType(), null);
        }
        if (node instanceof ValueNode.DottedNode) {
            return new ValueNode.IdentifierNodeDeclaration(pp.cur, node.asDottedNode().getDotted(), PlsqlType.safeType(), null);
        }
        if (node instanceof ValueNode.TypeNode) {
            ValueNode.TypeNode tNode = node.asTypeNode();
            return new ValueNode.IdentifierNodeDeclaration(pp.cur, new Dotted(), tNode.getType(), null);
        }
        return new ValueNode.IdentifierNodeDeclaration(pp.cur, new Dotted(), PlsqlType.safeType(), null);
    }

    @Reduction(rules={"basic_d: cursor_d", "basic_d: excptn_d", "basic_d: object_d", "basic_d: subprg_i", "basic_d: subty_d", "basic_d: ty_d"})
    @Token(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION, token={"cursor_d", "excptn_d", "object_d", "subprg_i", "subty_d", "ty_d"})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode.IdentifierNodeDeclaration parse_basic_d(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        ValueNode.IdentifierNodeDeclaration id = childValues.get(0).asIdentiferNodeDeclared();
        return id;
    }

    @Reduction(rules={"continue_stmt: 'CONTINUE' 'WHEN' pls_expr ';'", "continue_stmt: 'CONTINUE' dotted_name ';'", "continue_stmt: 'CONTINUE' dotted_name 'WHEN' pls_expr ';'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"dotted_name"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"})})
    @PickTokens(tokens={"dotted_name"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_continue(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ValueNode.DottedNode dotted = null;
        if (pickIdx[0] >= 0) {
            dotted = childValues.get(pickIdx[0]).asDottedNode();
        }
        pp.symbols.cont();
        return null;
    }

    @Reduction(rules={"exit_stmt: 'EXIT' ';'", "exit_stmt: 'EXIT' WHEN_cond_opt ';'", "exit_stmt: 'EXIT' dotted_name ';'", "exit_stmt: 'EXIT' dotted_name WHEN_cond_opt ';'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"dotted_name"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"WHEN_cond_opt"})})
    @PickTokens(tokens={"dotted_name"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_exit_stmt(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ValueNode.DottedNode dotted = null;
        if (pickIdx[0] >= 0) {
            dotted = childValues.get(pickIdx[0]).asDottedNode();
        }
        pp.symbols.exit();
        return null;
    }

    @Reduction(rules={"goto_stmt: 'GOTO' dotted_name ';'"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"dotted_name"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_goto_stmt(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ValueNode.DottedNode dotted = childValues.get(0).asDottedNode();
        return null;
    }

    @Reduction(rules={"raise_stmt: 'RAISE' ';'", "raise_stmt: 'RAISE' dotted_name ';'"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"dotted_name"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_raise_stmt(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ValueNode.DottedNode dotted = childValues.get(0).asDottedNode();
        return null;
    }

    @Reduction(rules={"field: decl_id constrained_type", "field: decl_id constrained_type default_expr_opt", "field: decl_id constrained_type external_atr_opt", "field: decl_id constrained_type external_atr_opt default_expr_opt"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"decl_id"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"constrained_type"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"default_expr_opt"}), @Token(type=ValueNode.ValueType.LITERALNODE, token={"external_atr_opt"})})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode parse_field(ParseParm pp, int token, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    private ValueNode parse_fml_part(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"full_cursor_body: cursor_d 'IS' select ';'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION, token={"cursor_d"}), @Token(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION, token={"select"})})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode.IdentifierNodeDeclaration parse_full_cursor_body(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        ValueNode.IdentifierNodeDeclaration cursor_d = childValues.get(0).asIdentiferNodeDeclared();
        Dotted dotted = cursor_d.getDotted();
        ValueNode.MultiIdentifierNodeDeclaration decls = childValues.get(2).asMultiIdentifierNodeDeclaration();
        PlsqlType.Record rec = new PlsqlType.Record(new Symbol.RecordSym(pp.symbols, dotted.getFinal(), decls.getAsParms(), pp.loc(), (Object)this.globalFlow.getNodeLabel()));
        return new ValueNode.IdentifierNodeDeclaration(pp.cur, dotted, rec, cursor_d.getMode(), false);
    }

    @Reduction(rules={"pragma"})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode.IdentifierNodeDeclaration parse_pragma(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        return new ValueNode.IdentifierNodeDeclaration(pp.cur, new Dotted(), PlsqlType.safeType(), null);
    }

    @Reduction(rules={"arith_expr", "aggregate_function", "analytic_function", "case_expr", "conversion_function", "default_expr_opt", "expr", "pls_expr", "sim_expr", "single_row_function", "user_defined_function"}, genericChildren={ValueNode.ValueType.EXPRNODE, ValueNode.ValueType.MULTIEXPRNODE, ValueNode.ValueType.DOTTEDNODE, ValueNode.ValueType.IDENTIFIERNODEDECLARATION, ValueNode.ValueType.IDENTIFIERNODE, ValueNode.ValueType.NULLNODE, ValueNode.ValueType.TOKENNODE})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parseMergeExpressions(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        ValueNode.ExprNode expr = new ValueNode.ExprNode(pp.cur, null, null);
        block5: for (ValueNode child : childValues) {
            if (child == null || child.getValueType() == ValueNode.ValueType.TOKENNODE) continue;
            if (expr == null) {
                if (child instanceof ValueNode.ExprNode) {
                    expr = (ValueNode.ExprNode)child;
                    child.setPos(pp.cur);
                    continue;
                }
                expr = new ValueNode.ExprNode(pp.cur, null, null);
            }
            switch (child.getValueType()) {
                case EXPRNODE: 
                case LITERALNODE: {
                    ValueNode.ExprNode childExpr = (ValueNode.ExprNode)child;
                    expr.merge(childExpr);
                    break;
                }
                case MULTIEXPRNODE: {
                    ValueNode.MultiExprNode multi = (ValueNode.MultiExprNode)child;
                    for (ValueNode.ExprNode childExpr : multi.getValues()) {
                        expr.merge(childExpr);
                    }
                    continue block5;
                }
                case IDENTIFIERNODEDECLARATION: 
                case IDENTIFIERNODE: {
                    ValueNode.ExprNode childExpr = child.asExprNode(pp.symbols);
                    expr.merge(childExpr);
                    break;
                }
                default: {
                    throw new IllegalStateException("Can't convert " + child.getClass() + " to ExprNode");
                }
            }
        }
        if (expr == null || expr.getType() == null) {
            throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_BAD_TYPE, "" + expr);
        }
        return expr;
    }

    @Reduction(rules={"arg: assoc_arg", "arg: pls_expr"})
    @Tokens(value={@Token(type=ValueNode.ValueType.ARGNODE, token={"assoc_arg"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"})})
    @Returns(type=ValueNode.ValueType.ARGNODE)
    private ValueNode.ArgNode parse_arg(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        switch (ruleid) {
            case 0: {
                return childValues.get(0).asArgNode();
            }
        }
        ValueNode.ExprNode expr = childValues.get(0).asExprNode(pp.symbols);
        return new ValueNode.ArgNode(expr);
    }

    @Reduction(rules={"attribute: 'SQL' '%' attribute_designator", "attribute: name '%' attribute_designator"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"name"})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode parse_attribute(ParseParm pp, int token, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"bind_var: ':' digits", "bind_var: ':' identifier", "bind_var: ':' identifier '.' identifier", "bind_var: '?'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.TOKENNODE, token={"digits"}), @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier"})})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode.ExprNode parse_bind_var(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        return PlsqlType.safeExprNode(pp.cur);
    }

    @Reduction(rules={"call_arg: pls_expr json_format"})
    @Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"})
    @Returns(type=ValueNode.ValueType.ARGNODE)
    private ValueNode.ArgNode parse_call_arg(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        return new ValueNode.ArgNode(childValues.get(0).asExprNode(pp.symbols));
    }

    @Reduction(rules={"call_arg_list: ',' call_arg", "call_arg_list: call_arg_list ',' call_arg"})
    @Tokens(value={@Token(type=ValueNode.ValueType.ARGNODE, token={"call_arg"}), @Token(type=ValueNode.ValueType.MULTIARGNODE, token={"call_arg_list"})})
    @PickTokens(tokens={"call_arg_list", "call_arg"})
    @Returns(type=ValueNode.ValueType.MULTIARGNODE)
    private ValueNode.MultiArgNode parse_call_arg_list(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ValueNode.MultiArgNode marg = null;
        marg = pickIdx[0] >= 0 ? childValues.get(pickIdx[1]).asMultiArgNode() : new ValueNode.MultiArgNode(pp.cur);
        marg.add(childValues.get(pickIdx[0]).asArgNode());
        return marg;
    }

    @Reduction(rules={"charset_csname: bind_var", "charset_csname: identifier", "charset_csname: link_expanded_n '%' 'CHARSET'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.EXPRNODE, token={"bind_var"}), @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"link_expanded_n"})})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode parse_charset_csname(ParseParm pp, int token, List<ValueNode> childValues) {
        return new ValueNode.TypeNode(pp.cur, PlsqlType.safeType());
    }

    @Reduction(rules={"column: column[4,12) identifier", "column: identifier"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier", "column[4,12)"})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode.DottedNode parse_column(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        ValueNode.DottedNode dotted = (ValueNode.DottedNode)childValues.get(0);
        if (childValues.size() > 1) {
            dotted.dotted.addAll(((ValueNode.DottedNode)childValues.get(1)).getDotted());
        }
        return dotted;
    }

    @Reduction(rules={"constrained_datetime_type: datetime_link_expanded_n", "constrained_datetime_type: datetime_link_expanded_n 'WITH' 'LOCAL' 'TIME' 'ZONE'", "constrained_datetime_type: datetime_link_expanded_n 'WITH' 'TIME' 'ZONE'", "constrained_datetime_type: datetime_link_expanded_n constraint", "constrained_datetime_type: datetime_link_expanded_n constraint 'WITH' 'LOCAL' 'TIME' 'ZONE'", "constrained_datetime_type: datetime_link_expanded_n constraint 'WITH' 'TIME' 'ZONE'"})
    @Token(type=ValueNode.ValueType.NULLNODE, token={"datetime_link_expanded_n"})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode.TypeNode parse_constrained_datetime_type(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        return childValues.get(0).asTypeNode();
    }

    @Reduction(rules={"constrained_type: 'NATIONAL' constraint", "constrained_type: constrained_datetime_interval_type", "constrained_type: constrained_datetime_interval_type NOT_NULL_opt", "constrained_type: constrained_datetime_interval_type charset_spec_opt", "constrained_type: constrained_datetime_interval_type charset_spec_opt NOT_NULL_opt", "constrained_type: unconstrained_type_wo_datetime_wo_national NOT_NULL_opt", "constrained_type: unconstrained_type_wo_datetime_wo_national charset_spec_opt", "constrained_type: unconstrained_type_wo_datetime_wo_national charset_spec_opt NOT_NULL_opt", "constrained_type: unconstrained_type_wo_datetime_wo_national constraint", "constrained_type: unconstrained_type_wo_datetime_wo_national constraint NOT_NULL_opt", "constrained_type: unconstrained_type_wo_datetime_wo_national constraint charset_spec_opt", "constrained_type: unconstrained_type_wo_datetime_wo_national constraint charset_spec_opt NOT_NULL_opt"})
    @Token(type=ValueNode.ValueType.TYPENODE, token={"constrained_datetime_interval_type"})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode.TypeNode parse_constrained_type(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        if (rulenum < 1) {
            return new ValueNode.TypeNode(pp.cur, new PlsqlType.Scalar(PlsqlType.ScalarType.NCHAR, 32));
        }
        return childValues.get(0).asTypeNode();
    }

    @Reduction(rules={"constraint: '(' sim_expr 'BYTE' ')'", "constraint: '(' sim_expr 'CHAR' ')'", "constraint: 'RANGE' range", "constraint: id_or_qualid", "constraint: identifier '.' identifier '@' dblink", "constraint: inline_constraint", "constraint: inline_ref_constraint", "constraint: out_of_line_constraint", "constraint: out_of_line_ref_constraint", "constraint: paren_expr_list"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_constraint(ParseParm pp, int token, List<ValueNode> childValues) {
        return null;
    }

    @Reduction(rules={"cursor_d: 'CURSOR' identifier", "cursor_d: 'CURSOR' identifier fml_part", "cursor_d: 'CURSOR' identifier fml_part return_type_opt", "cursor_d: 'CURSOR' identifier return_type_opt"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier"})
    @PickTokens(tokens={"fml_part", "return_type_opt"})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode.IdentifierNodeDeclaration parse_cursor_d(ParseParm pp, int UNUSED, List<ValueNode> childValues, int[] pickIdx) {
        Dotted dotted = childValues.get(0).asExprNode(pp.symbols).asDottedNode().getDotted();
        ValueNode.MultiIdentifierNodeDeclaration fml_part = null;
        if (pickIdx[0] >= 0) {
            fml_part = this.parse(pp.createChildParm(pickIdx[0])).asMultiIdentifierNodeDeclaration();
        }
        ValueNode.TypeNode returnType = null;
        if (pickIdx[1] >= 0) {
            returnType = this.parse(pp.createChildParm(pickIdx[1])).asTypeNode();
        }
        ArrayList<ParmSpec> parms = new ArrayList<ParmSpec>();
        if (fml_part != null) {
            for (int i = 0; i < fml_part.getValues().size(); ++i) {
                ValueNode.IdentifierNodeDeclaration idDecl = (ValueNode.IdentifierNodeDeclaration)fml_part.getValues().get(i);
                parms.add(new ParmSpec(i + 1, idDecl.getName(), idDecl.getType(), idDecl.mode, idDecl.noCopy));
            }
        }
        if (returnType != null) {
            parms.add(new ParmSpec(0, null, returnType.getType(), ParameterMode.OUT, false));
        }
        Symbol.RecordSym rec = new Symbol.RecordSym(pp.symbols, dotted.getFinal(), parms, pp.loc(), (Object)this.globalFlow.getNodeLabel());
        return new ValueNode.IdentifierNodeDeclaration(pp.cur, dotted, new PlsqlType.Record(rec), null);
    }

    @Reduction(rules={"datetime_expression: expr 'AT' datetime_expression[13,58)"})
    @Token(type=ValueNode.ValueType.EXPRNODE, token={"expr"})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode.ExprNode parse_datetime_expression(ParseParm pp, int UNUSED, List<ValueNode> childValues) {
        return childValues.get(0).asExprNode(pp.symbols);
    }

    @Reduction(rules={"datetime_link_expanded_n: datetime_expanded_n", "datetime_link_expanded_n: datetime_expanded_n '@' dblink"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"datetime_expanded_n"})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode.DottedNode parse_datetime_link_expanded_n(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        return (ValueNode.DottedNode)childValues.get(0);
    }

    @Reduction(rules={"decl_id: identifier", "decl_id: identifier '.' identifier", "decl_id: 'CURRENT'", "decl_id: 'DELETE'", "decl_id: 'EXISTS'", "decl_id: 'PRIOR'"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier"})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode.DottedNode parse_decl_id(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        if (ruleid > 1) {
            return new ValueNode.DottedNode(pp.cur, new Dotted());
        }
        Dotted dotted = childValues.get((int)0).asDottedNode().dotted;
        if (ruleid == 1) {
            dotted.addAll(childValues.get((int)1).asDottedNode().dotted);
        }
        return new ValueNode.DottedNode(pp.cur, dotted);
    }

    @Reduction(rules={"designator: decl_id", "designator: string_literal"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"decl_id"}), @Token(type=ValueNode.ValueType.LITERALNODE, token={"string_literal"})})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode.DottedNode parse_designator(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        switch (ruleid) {
            case 0: {
                return (ValueNode.DottedNode)childValues.get(0);
            }
            case 1: {
                return new ValueNode.DottedNode(pp.cur, ((ValueNode.LiteralNode)childValues.get(0)).getVal());
            }
        }
        throw new IllegalStateException("Unexpected ruleid=" + ruleid);
    }

    @Reduction(rules={"dblink_alts: '!'", "dblink_alts: '@' identifier", "dblink_alts: dotted_name", "dblink_alts: dotted_name '@' identifier"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier", "dotted_name"})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode parse_dblink_alts(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"dotted_expr: name '.' decl_id"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"name", "decl_id"})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode parse_dotted_expr(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        ValueNode.DottedNode nn = childValues.get(0).asDottedNode();
        ValueNode.DottedNode dn = childValues.get(2).asDottedNode();
        Dotted dotted = nn.dotted;
        dotted.addAll(dn.dotted);
        return new ValueNode.DottedNode(pp.cur, dotted);
    }

    @Reduction(rules={"name: function_call", "name: name_wo_function_call"})
    @Tokens(value={@Token(type=ValueNode.ValueType.EXPRNODE, token={"function_call"}), @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"name_wo_function_call"})})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode parse_name(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        return childValues.get(0);
    }

    @Reduction(rules={"exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr BULK_COLLECT_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr into_list", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr returning_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr using_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr BULK_COLLECT_opt into_list", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr BULK_COLLECT_opt returning_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr BULK_COLLECT_opt using_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr into_list returning_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr into_list using_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr using_clause_opt returning_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr BULK_COLLECT_opt into_list returning_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr BULK_COLLECT_opt into_list using_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr BULK_COLLECT_opt using_clause_opt returning_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr into_list using_clause_opt returning_clause_opt", "exec_immediate_statement: 'EXECUTE' 'IMMEDIATE' pls_expr BULK_COLLECT_opt into_list using_clause_opt returning_clause_opt"})
    @Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_exec_immediate_statement(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        ValueNode.ExprNode expr = childValues.get(2).asExprNode(pp.symbols);
        for (Usage u : expr.getUsages()) {
            Usage exec = new Usage(u, pp.loc(), (Object)this.globalFlow.getNodeLabel());
            exec.from(u);
            this.globalFlow.addSink(exec);
        }
        return null;
    }

    @Reduction(rules={"func_return_prm_spec_unconstrained_type"})
    @Token(type=ValueNode.ValueType.TYPENODE, token={"prm_spec_unconstrained_type"})
    @PickTokens(tokens={"prm_spec_unconstrained_type"})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode.TypeNode func_return_prm_spec_unconstrained_type(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        if (pickIdx[0] >= 0) {
            return childValues.get(pickIdx[1]).asTypeNode();
        }
        return new ValueNode.TypeNode(pp.cur, new PlsqlType.Record());
    }

    @Reduction(beforeChildren=true, rules={"pkg_body: 'PACKAGE' 'BODY' identifier is_or_as 'END' ';'", "pkg_body: 'PACKAGE' 'BODY' identifier is_or_as 'END' identifier ';'", "pkg_body: 'PACKAGE' 'BODY' identifier is_or_as block_opt 'END' ';'", "pkg_body: 'PACKAGE' 'BODY' identifier is_or_as decl_list 'END' ';'", "pkg_body: 'PACKAGE' 'BODY' identifier '.' identifier is_or_as 'END' ';'", "pkg_body: 'PACKAGE' 'BODY' identifier is_or_as block_opt 'END' identifier ';'", "pkg_body: 'PACKAGE' 'BODY' identifier is_or_as decl_list 'END' identifier ';'", "pkg_body: 'PACKAGE' 'BODY' identifier is_or_as decl_list block_opt 'END' ';'", "pkg_body: 'PACKAGE' 'BODY' identifier '.' identifier is_or_as 'END' identifier ';'", "pkg_body: 'PACKAGE' 'BODY' identifier '.' identifier is_or_as block_opt 'END' ';'", "pkg_body: 'PACKAGE' 'BODY' identifier '.' identifier is_or_as decl_list 'END' ';'", "pkg_body: 'PACKAGE' 'BODY' identifier is_or_as decl_list block_opt 'END' identifier ';'", "pkg_body: 'PACKAGE' 'BODY' identifier '.' identifier is_or_as block_opt 'END' identifier ';'", "pkg_body: 'PACKAGE' 'BODY' identifier '.' identifier is_or_as decl_list 'END' identifier ';'", "pkg_body: 'PACKAGE' 'BODY' identifier '.' identifier is_or_as decl_list block_opt 'END' ';'", "pkg_body: 'PACKAGE' 'BODY' identifier '.' identifier is_or_as decl_list block_opt 'END' identifier ';'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier"}), @Token(type=ValueNode.ValueType.MULTIIDENTIFIERNODEDECLARATION, token={"decl_list"})})
    @PickTokens(tokens={"decl_list"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_pkg_body(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        BitSet parsed = new BitSet(pp.childList.size());
        ValueNode.DottedNode id1 = this.parse(pp.createChildParm(2)).asDottedNode();
        parsed.set(2);
        ValueNode.DottedNode id2 = null;
        switch (rulenum) {
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                id2 = this.parse(pp.createChildParm(4)).asDottedNode();
                parsed.set(4);
            }
        }
        Dotted dotted = new Dotted(id1.getDotted(), 0);
        if (id2 != null) {
            dotted.addAll(id2.getDotted());
        }
        SymbolTable scope = pp.symbols.getMakePackage(dotted);
        pp = pp.createReplaceScope(scope);
        int i = parsed.nextClearBit(0);
        while (i >= 0 && i < pp.childList.size()) {
            this.parse(pp.createChildParm(i));
            i = parsed.nextClearBit(i + 1);
        }
        return null;
    }

    @Reduction(rules={"function_call: 'MOD' paren_expr_list", "function_call: name '(' ')'", "function_call: name '(' '+' ')'", "function_call: name '(' cast_expression_arg 'AS' unconstrained_type ')'", "function_call: name '(' cast_expression_arg 'AS' unconstrained_type cast_conversion_error ')'", "function_call: name '(' cast_expression_arg 'AS' unconstrained_type cast_conversion_error cast_nls_params ')'", "function_call: name '(' cast_expression_arg 'AS' unconstrained_type cast_nls_params ')'", "function_call: name '(' datetime_field 'FROM' sim_expr ')'", "function_call: name '(' datetime_string_field 'FROM' sim_expr ')'", "function_call: name '(' pls_expr 'USING' charset_csname ')'", "function_call: name '(' trim_options_sim_expr 'FROM' sim_expr ')'", "function_call: name paren_expr_list", "function_call: name '(' call_arg json_flag_list ')'", "function_call: name '(' call_arg call_arg_list json_flag_list ')'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"name"}), @Token(type=ValueNode.ValueType.MULTIARGNODE, token={"paren_expr_list", "call_arg_list"}), @Token(type=ValueNode.ValueType.ARGNODE, token={"call_arg"}), @Token(type=ValueNode.ValueType.BOGUS_SYMBOL, token={"cast_expression_arg"})})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_function_call(ParseParm pp, int ruleid, List<ValueNode> children) {
        if (Debug.PARSE_CHILDREN.debug) {
            this.dumpChildren("parse_function_call", children);
        }
        switch (ruleid) {
            case 0: {
                return this.parse_function_call_helper(pp, new ValueNode.DottedNode(pp.cur, "MOD"), children.get(1).asMultiArgNode());
            }
            case 1: 
            case 2: {
                return this.parse_function_call_helper(pp, children.get(0).asDottedNode(), new ValueNode.MultiArgNode(pp.cur));
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                throw new NullPointerException();
            }
            case 7: {
                return this.parse_function_call_helper(pp, children.get(0).asDottedNode(), new ValueNode.ExprNode(pp.cur, new PlsqlType.Scalar(PlsqlType.ScalarType.PLS_INTEGER), Collections.emptyList()).asMultiArgNode());
            }
            case 8: {
                return this.parse_function_call_helper(pp, children.get(0).asDottedNode(), new ValueNode.ExprNode(pp.cur, new PlsqlType.Scalar(PlsqlType.ScalarType.VARCHAR2), Collections.emptyList()).asMultiArgNode());
            }
            case 11: {
                return this.parse_function_call_helper(pp, children.get(0).asDottedNode(), children.get(1).asMultiArgNode());
            }
            case 12: {
                ValueNode.MultiArgNode parms = new ValueNode.MultiArgNode(pp.cur);
                parms.add(children.get(2).asArgNode());
                return this.parse_function_call_helper(pp, children.get(0).asDottedNode(), parms);
            }
            case 13: {
                ValueNode.MultiArgNode parms = new ValueNode.MultiArgNode(pp.cur);
                parms.add(children.get(2).asArgNode());
                parms.addAll(children.get(3).asMultiArgNode().getValues());
                return this.parse_function_call_helper(pp, children.get(0).asDottedNode(), parms);
            }
        }
        throw new NullPointerException();
    }

    private ValueNode.ExprNode parse_function_call_helper(ParseParm pp, ValueNode.DottedNode name, ValueNode.MultiArgNode argNode) {
        if (Debug.DUMP_USAGES.has(obj -> "parse_function_call_helper".equals(obj))) {
            Usage.dumpSaveAll(null, "parse_function_call_helper START " + name, new List[0]);
        }
        List args = argNode.getValues();
        Symbol.FunctionSym func = pp.symbols.resolveFunction(name.getDotted());
        if (Debug.FUNCRESOLVE.debug) {
            System.out.println("Function: " + func);
        }
        PlsqlType.Function.FuncFormalResolved resolved = func.resolveArguments(argNode);
        int[] argsToParms = resolved.argsToParms;
        ValueNode.ArgNode[] argsInParmOrder = new ValueNode.ArgNode[resolved.formal.getParms().size()];
        for (int argIdx = 0; argIdx < args.size(); ++argIdx) {
            argsInParmOrder[argsToParms[argIdx]] = (ValueNode.ArgNode)args.get(argIdx);
        }
        List<ValueNode.ArgNode> argsIPO = Arrays.asList(argsInParmOrder);
        Call call = new Call(pp.loc(), resolved.formal);
        Usage result = resolved.formal.doCallLink(pp, call, argsIPO, this.globalFlow.getNodeLabel());
        ParmSpec resultSpec = resolved.getResultParm();
        assert (result == null == (resultSpec == null));
        if (resultSpec == null) {
            return null;
        }
        ValueNode.ExprNode funcResult = new ValueNode.ExprNode(pp.cur, resultSpec.getType(), Collections.singletonList(result));
        if (Debug.DUMP_USAGES.has(obj -> "parse_function_call_helper".equals(obj))) {
            Usage.dumpSaveAll(null, "parse_function_call_helper END " + name, new List[0]);
        }
        return funcResult;
    }

    @Reduction(rules={"function_expression: function", "function_expression: function_call", "function_expression: function_expression '.' function_call", "function_expression: function_expression '.' identifier"})
    @Token(type=ValueNode.ValueType.EXPRNODE, token={"function", "function_call", "function_expression"})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_function_expression(ParseParm pp, int ruleid, List<ValueNode> children) {
        switch (ruleid) {
            case 0: 
            case 1: {
                return children.get(0).asExprNode(pp.symbols);
            }
            case 2: 
            case 3: {
                throw new NullPointerException();
            }
        }
        throw new NullPointerException();
    }

    @Reduction(rules={"gen_call: '(' pls_expr 'AS' unconstrained_type ')' '.' procedure_call"})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_gen_call(ParseParm pp, int token, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"paren_aggr", "paren_expr_list", "arg_list"})
    @Tokens(value={@Token(type=ValueNode.ValueType.ARGNODE, token={"arg"}), @Token(type=ValueNode.ValueType.MULTIARGNODE, token={"arg_list"}), @Token(type=ValueNode.ValueType.ARGNODE, token={"assoc_arg"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"})})
    @Returns(type=ValueNode.ValueType.MULTIARGNODE)
    private ValueNode parse_paren_expr(ParseParm pp, int token, List<ValueNode> childValues) {
        ValueNode.MultiArgNode multi = new ValueNode.MultiArgNode(pp.cur);
        for (ValueNode child : childValues) {
            if (child == null) continue;
            if (child instanceof ValueNode.ArgNode) {
                multi.add((ValueNode.ArgNode)child);
                continue;
            }
            if (child instanceof ValueNode.MultiArgNode) {
                ValueNode.MultiArgNode man = (ValueNode.MultiArgNode)child;
                multi.addAll(man.getValues());
                continue;
            }
            if (child instanceof ValueNode.ExprNode) {
                multi.add(new ValueNode.ArgNode((ValueNode.ExprNode)child));
                continue;
            }
            if (!(child instanceof ValueNode.MultiExprNode)) continue;
            for (ValueNode.ExprNode expr : ((ValueNode.MultiExprNode)child).getValues()) {
                multi.add(new ValueNode.ArgNode(expr));
            }
        }
        return multi;
    }

    @Reduction(rules={"simple_expression: 'CONNECT_BY_ISCYCLE'", "simple_expression: 'CONNECT_BY_ISLEAF'", "simple_expression: 'CONNECT_BY_ROOT' expr", "simple_expression: 'NULL'", "simple_expression: 'ROWID'", "simple_expression: 'ROWNUM'", "simple_expression: col_oj", "simple_expression: column", "simple_expression: identifier '.' simple_expression[59,78)", "simple_expression: literal", "simple_expression[59,78): 'CURRVAL'", "simple_expression[59,78): 'NEXTVAL'"})
    @Token(type=ValueNode.ValueType.EXPRNODE, token={"col_oj", "column", "identifier", "simple_expression[59,78)", "literal"})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_simple_expression(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"alternatively_quoted_nonnative_string_literal", "alternatively_quoted_string_literal", "COMMENT_literal_opt", "datetime_literal", "ext_tbl_string_literal", "interval_literal", "interval_literal_qualifier", "level_member_literal", "literal", "literal_list", "nonnative_string_literal", "static_or_string_literal", "string_literal"})
    @Returns(type=ValueNode.ValueType.LITERALNODE)
    private ValueNode parse_string_literals(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        assert (childValues.size() == 1);
        assert (childValues.get(0).getClass() == ValueNode.TokenNode.class);
        assert (pp.cur.to == pp.cur.from + 1);
        int size = this.src.get((int)pp.cur.from).content.length();
        PlsqlType.Scalar type = new PlsqlType.Scalar(PlsqlType.ScalarType.CHAR, size);
        return new ValueNode.LiteralNode(pp.cur, (PlsqlType)type, this.src.get((int)pp.cur.from).content);
    }

    @Reduction(rules={"subquery_restriction_clause: 'WITH' subquery_restriction_clause[11,32)", "subquery_restriction_clause: 'WITH' subquery_restriction_clause[11,32) 'CONSTRAINT' constraint", "subquery_restriction_clause[11,32): 'CHECK' 'OPTION'", "subquery_restriction_clause[11,32): 'READ' 'ONLY'"})
    @Returns(type=ValueNode.ValueType.MULTIARGNODE)
    private ValueNode parse_subquery_restriction_clause(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"subty_d: 'SUBTYPE' identifier 'IS' constrained_type"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"constrained_type"})})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode.IdentifierNodeDeclaration parse_subty_d(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        return new ValueNode.IdentifierNodeDeclaration(pp.cur, childValues.get(1).asDottedNode().getDotted(), childValues.get(3).asTypeNode().getType(), null);
    }

    @Reduction(rules={"link_expanded_n"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode.DottedNode parse_link_expanded_n(ParseParm pp, int ruleid, List<ValueNode> childValues) {
        return null;
    }

    @Reduction(rules={"mode: 'IN'", "mode: 'IN' 'OUT'", "mode: 'OUT'"})
    @Returns(type=ValueNode.ValueType.MODENODE)
    private ValueNode parse_mode(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        switch (rulenum) {
            case 0: {
                return new ValueNode.ModeNode(pp.cur, ParameterMode.IN, false);
            }
            case 1: {
                return new ValueNode.ModeNode(pp.cur, ParameterMode.INOUT, false);
            }
            case 2: {
                return new ValueNode.ModeNode(pp.cur, ParameterMode.OUT, false);
            }
        }
        throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_BAD_PARSE, "Unable to parse mode: " + pp.cur);
    }

    @Reduction(rules={"number_literal", "numeric_literal"})
    @Returns(type=ValueNode.ValueType.LITERALNODE)
    private ValueNode parse_numeric_literals(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        assert (childValues.size() == 1);
        assert (childValues.get(0) instanceof ValueNode.TokenNode);
        assert (pp.cur.to == pp.cur.from + 1);
        int size = this.src.get((int)pp.cur.from).content.length();
        PlsqlType.Scalar type = new PlsqlType.Scalar(PlsqlType.ScalarType.NUMBER, size);
        return new ValueNode.LiteralNode(pp.cur, (PlsqlType)type, this.src.get((int)pp.cur.from).content);
    }

    @Reduction(rules={"assoc_arg"})
    @Returns(type=ValueNode.ValueType.ARGNODE)
    private ValueNode parse_assoc_arg(ParseParm pp, int token, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"pri: '(' pls_expr 'AS' unconstrained_type ')'", "pri: 'NEW' procedure_call", "pri: 'NULL'", "pri: alternatively_quoted_nonnative_string_literal", "pri: alternatively_quoted_string_literal", "pri: case_expr", "pri: conversion_function", "pri: datetime_literal", "pri: gen_call", "pri: nonnative_string_literal", "pri: numeric_literal", "pri: paren_aggr", "pri: procedure_call", "pri: string_literal"})
    @Tokens(value={@Token(type=ValueNode.ValueType.EXPRNODE, token={"case_expr", "conversion_function", "gen_call", "pls_expr"}), @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"procedure_call"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"unconstrained_type"}), @Token(type=ValueNode.ValueType.LITERALNODE, token={"alternatively_quoted_nonnative_string_literal", "alternatively_quoted_string_literal", "datetime_literal", "nonnative_string_literal", "numeric_literal", "string_literal"}), @Token(type=ValueNode.ValueType.MULTIARGNODE, token={"paren_aggr"})})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_pri(ParseParm pp, int token, List<ValueNode> childValues) {
        ValueNode.ExprNode ret;
        if (childValues.size() > 2) {
            ValueNode.ExprNode ret2 = childValues.get(1).asExprNode(pp.symbols);
            ret2.setType(childValues.get(3).asExprNode(pp.symbols).getType());
            return ret2;
        }
        if (childValues.size() == 2) {
            ret = childValues.get(1).asExprNode(pp.symbols);
        } else {
            assert (childValues.size() == 1);
            ValueNode child = childValues.get(0);
            ret = child.asExprNode(pp.symbols);
        }
        return ret;
    }

    @Reduction(rules={"unconstrained_type_wo_national: alldatetime_d", "unconstrained_type_wo_national: unconstrained_type_wo_datetime_wo_national"})
    @Tokens(value={@Token(type=ValueNode.ValueType.TYPENODE, token={"pls_number_datatypes"}), @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"datetime_link_expanded_n"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"link_expanded_n"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"attribute_designator"})})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode.TypeNode parse_unconstrained_type_wo_national(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        switch (rulenum) {
            case 0: {
                return new ValueNode.TypeNode(pp.cur, new PlsqlType.Scalar(PlsqlType.ScalarType.DATE));
            }
        }
        return childValues.get(0).asTypeNode();
    }

    @Reduction(rules={"unconstrained_type_wo_datetime_wo_national: datetime_link_expanded_n '%' attribute_designator", "unconstrained_type_wo_datetime_wo_national: link_expanded_n", "unconstrained_type_wo_datetime_wo_national: link_expanded_n '%' attribute_designator", "unconstrained_type_wo_datetime_wo_national: pls_number_datatypes", "unconstrained_type_wo_datetime_wo_national: 'REF' link_expanded_n", "unconstrained_type_wo_datetime_wo_national: 'BFILE'", "unconstrained_type_wo_datetime_wo_national: 'BINARY'", "unconstrained_type_wo_datetime_wo_national: 'BINARY' 'LARGE' 'OBJECT'", "unconstrained_type_wo_datetime_wo_national: 'BLOB'", "unconstrained_type_wo_datetime_wo_national: 'CHAR'", "unconstrained_type_wo_datetime_wo_national: 'CHAR' 'LARGE' 'OBJECT'", "unconstrained_type_wo_datetime_wo_national: 'CHAR' 'VARYING'", "unconstrained_type_wo_datetime_wo_national: 'CHARACTER'", "unconstrained_type_wo_datetime_wo_national: 'CHARACTER' 'LARGE' 'OBJECT'", "unconstrained_type_wo_datetime_wo_national: 'CHARACTER' 'VARYING'", "unconstrained_type_wo_datetime_wo_national: 'CLOB'", "unconstrained_type_wo_datetime_wo_national: 'COLUMNS'", "unconstrained_type_wo_datetime_wo_national: 'COLUMNS' 'WITH' 'TYPE'", "unconstrained_type_wo_datetime_wo_national: 'DOUBLE' 'PRECISION'", "unconstrained_type_wo_datetime_wo_national: 'LONG'", "unconstrained_type_wo_datetime_wo_national: 'LONG' 'RAW'", "unconstrained_type_wo_datetime_wo_national: 'MLSLABEL'", "unconstrained_type_wo_datetime_wo_national: 'NATIONAL' 'CHAR'", "unconstrained_type_wo_datetime_wo_national: 'NATIONAL' 'CHAR' 'VARYING'", "unconstrained_type_wo_datetime_wo_national: 'NATIONAL' 'CHARACTER'", "unconstrained_type_wo_datetime_wo_national: 'NATIONAL' 'CHARACTER' 'LARGE' 'OBJECT'", "unconstrained_type_wo_datetime_wo_national: 'NATIONAL' 'CHARACTER' 'VARYING'", "unconstrained_type_wo_datetime_wo_national: 'NCHAR'", "unconstrained_type_wo_datetime_wo_national: 'NCHAR' 'LARGE' 'OBJECT'", "unconstrained_type_wo_datetime_wo_national: 'NCHAR' 'VARYING'", "unconstrained_type_wo_datetime_wo_national: 'NCLOB'", "unconstrained_type_wo_datetime_wo_national: 'NVARCHAR2'", "unconstrained_type_wo_datetime_wo_national: 'RAW'", "unconstrained_type_wo_datetime_wo_national: 'REF' 'XMLTYPE'", "unconstrained_type_wo_datetime_wo_national: 'ROWID'", "unconstrained_type_wo_datetime_wo_national: 'STRING'", "unconstrained_type_wo_datetime_wo_national: 'SYS_REFCURSOR'", "unconstrained_type_wo_datetime_wo_national: 'TABLE'", "unconstrained_type_wo_datetime_wo_national: 'UROWID'", "unconstrained_type_wo_datetime_wo_national: 'VARCHAR'", "unconstrained_type_wo_datetime_wo_national: 'VARCHAR2'", "unconstrained_type_wo_datetime_wo_national: 'XMLTYPE'"})
    @Tokens(value={@Token(type=ValueNode.ValueType.TYPENODE, token={"pls_number_datatypes"}), @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"datetime_link_expanded_n"}), @Token(type=ValueNode.ValueType.NULLNODE, token={"link_expanded_n"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"attribute_designator"})})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode.TypeNode parse_unconstrained_type_wo_datetime(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        switch (rulenum) {
            case 0: 
            case 2: {
                return childValues.get(3).asTypeNode();
            }
            case 1: {
                return new ValueNode.TypeNode(pp.cur, new PlsqlType.Scalar(PlsqlType.ScalarType.DATE));
            }
            case 3: {
                return childValues.get(0).asTypeNode();
            }
            case 4: {
                return new ValueNode.TypeNode(pp.cur, new PlsqlType.Scalar(PlsqlType.ScalarType.fromString("'SYS_REFCURSOR'")));
            }
        }
        String typeString = "";
        String sep = "";
        for (ValueNode tokenNode : childValues) {
            typeString = typeString + sep + tokenNode.asTokenNode().getName();
            sep = " ";
        }
        PlsqlType.ScalarType type = PlsqlType.ScalarType.fromString(typeString);
        if (type == null) {
            this.warn(pp.cur, "unconstrained_type_wo_datetime unrecognized type " + typeString);
            type = PlsqlType.ScalarType.VARCHAR2;
        }
        return new ValueNode.TypeNode(pp.cur, new PlsqlType.Scalar(type));
    }

    @Reduction(rules={"pls_number_datatypes"})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode.TypeNode parse_pls_number_datatypes(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        String typeString = "";
        String sep = "";
        for (ValueNode tokenNode : childValues) {
            typeString = typeString + sep + tokenNode.asTokenNode().getName();
            sep = " ";
        }
        PlsqlType.ScalarType type = PlsqlType.ScalarType.fromString(typeString);
        if (type == null) {
            this.warn(pp.cur, "pls_number_datatypes unrecognized type " + typeString);
            type = PlsqlType.ScalarType.VARCHAR2;
        }
        return new ValueNode.TypeNode(pp.cur, new PlsqlType.Scalar(type));
    }

    @Reduction(rules={"attribute_designator: 'TYPE'", "attribute_designator: identifier"})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode.TypeNode parse_attribute_designator(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"object_d_rhs: constrained_type", "object_d_rhs: tbl_ty_def", "object_d_rhs: 'CONSTANT' constrained_type", "object_d_rhs: constrained_type default_expr_opt", "object_d_rhs: 'CONSTANT' constrained_type default_expr_opt"})
    @Tokens(value={@Token(type=ValueNode.ValueType.TYPENODE, token={"constrained_type"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"default_expr_opt"}), @Token(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION, token={"tbl_ty_def"})})
    @PickTokens(tokens={"constrained_type", "default_expr_opt", "tbl_ty_def"})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode.ExprNode parse_object_d_rhs(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        PlsqlType type = pickIdx[0] < 0 ? childValues.get(pickIdx[2]).asIdentiferNodeDeclared().getType() : childValues.get(pickIdx[0]).asTypeNode().getType();
        List<Usage> uses = null;
        if (pickIdx[1] >= 0) {
            uses = ((ValueNode.ExprNode)childValues.get(pickIdx[1])).getUsages();
        }
        return new ValueNode.ExprNode(pp.cur, type, uses);
    }

    @Reduction(rules={"object_d: decl_id object_d_rhs"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"decl_id"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"object_d_rhs"})})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode.IdentifierNodeDeclaration parse_object_d(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        ValueNode.DottedNode dotted = childValues.get(0).asDottedNode();
        ValueNode.ExprNode expr = childValues.get(1).asExprNode(pp.symbols);
        return new ValueNode.IdentifierNodeDeclaration(pp.cur, dotted.getDotted(), expr.getType(), null);
    }

    @Reduction(rules={"prm_spec: decl_id 'ELLIPSIS'", "prm_spec: decl_id 'IN' 'OUT' 'NOCOPY'", "prm_spec: decl_id 'IN' 'OUT' 'NOCOPY' charset_spec_opt", "prm_spec: decl_id 'IN' 'OUT' 'NOCOPY' charset_spec_opt default_expr_opt", "prm_spec: decl_id 'IN' 'OUT' 'NOCOPY' default_expr_opt", "prm_spec: decl_id 'IN' 'OUT' 'NOCOPY' prm_spec_unconstrained_type", "prm_spec: decl_id 'IN' 'OUT' 'NOCOPY' prm_spec_unconstrained_type default_expr_opt", "prm_spec: decl_id 'OUT' 'NOCOPY'", "prm_spec: decl_id 'OUT' 'NOCOPY' charset_spec_opt", "prm_spec: decl_id 'OUT' 'NOCOPY' charset_spec_opt default_expr_opt", "prm_spec: decl_id 'OUT' 'NOCOPY' default_expr_opt", "prm_spec: decl_id 'OUT' 'NOCOPY' prm_spec_unconstrained_type", "prm_spec: decl_id 'OUT' 'NOCOPY' prm_spec_unconstrained_type default_expr_opt", "prm_spec: decl_id mode prm_spec_unconstrained_type", "prm_spec: decl_id mode prm_spec_unconstrained_type default_expr_opt", "prm_spec: decl_id prm_spec_unconstrained_type", "prm_spec: decl_id prm_spec_unconstrained_type default_expr_opt"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"decl_id"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"charset_spec_opt"}), @Token(type=ValueNode.ValueType.EXPRNODE, token={"default_expr_opt"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"prm_spec_unconstrained_type"}), @Token(type=ValueNode.ValueType.MODENODE, token={"mode"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"prm_spec_unconstrained_type"})})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    @PickTokens(tokens={"decl_id", "mode", "unconstrained_type", "prm_spec_unconstrained_type", "default_expr_opt"})
    private ValueNode.IdentifierNodeDeclaration parse_prm_spec(ParseParm pp, int rulenum, List<ValueNode> childValues, int[] pickIdx) {
        ValueNode.DottedNode decl_id = childValues.get(pickIdx[0]).asDottedNode();
        ValueNode.ModeNode mode = null;
        if (pickIdx[1] >= 0) {
            mode = childValues.get(pickIdx[1]).asModeNode();
        }
        ValueNode.TypeNode type = null;
        if (pickIdx[2] >= 0) {
            type = childValues.get(pickIdx[2]).asTypeNode();
            assert (pickIdx[3] < 0);
        } else if (pickIdx[3] >= 0) {
            type = childValues.get(pickIdx[3]).asTypeNode();
        }
        ValueNode.ExprNode default_expr_opt = null;
        if (pickIdx[4] >= 0) {
            default_expr_opt = childValues.get(pickIdx[4]).asExprNode(pp.symbols);
        }
        switch (rulenum) {
            case 0: {
                type = new ValueNode.TypeNode(pp.cur, new PlsqlType.Ellipsis());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                mode = new ValueNode.ModeNode(pp.cur, ParameterMode.INOUT, true);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                mode = new ValueNode.ModeNode(pp.cur, ParameterMode.OUT, true);
                break;
            }
        }
        ValueNode.IdentifierNodeDeclaration id = new ValueNode.IdentifierNodeDeclaration(pp.cur, decl_id.getDotted(), type.getType(), mode);
        return id;
    }

    @Reduction(rules={"prm_spec_unconstrained_type: unconstrained_type_wo_national", "prm_spec_unconstrained_type: unconstrained_type_wo_national charset_spec_opt"})
    @Token(type=ValueNode.ValueType.TYPENODE, token={"unconstrained_type"})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode parse_prm_spec_unconstrained_type(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        return childValues.get(0).asTypeNode();
    }

    @Reduction(rules={"return_stmt: 'RETURN' ';'", "return_stmt: 'RETURN' pls_expr ';'"})
    @Token(type=ValueNode.ValueType.EXPRNODE, token={"pls_expr"})
    @Returns(type=ValueNode.ValueType.NULLNODE)
    private ValueNode parse_return(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        if (childValues.size() > 1) {
            ValueNode.ExprNode expr = childValues.get(1).asExprNode(pp.symbols);
            SymbolTable scope = pp.symbols;
            while (scope.getScopeType() != SymbolTable.ScopeType.FUNCTION) {
                scope = scope.getEnclosingScope();
            }
            Symbol ret = scope.getLocalDeclaration("RETURN");
            if (expr.getUsages().size() == 1) {
                ret.assign(expr.getUsages().get(0));
            } else {
                Usage retU = new Usage(ret, pp.loc(), (Object)this.globalFlow.getNodeLabel());
                for (Usage u : expr.getUsages()) {
                    retU.from(u);
                }
                ret.assign(retU);
            }
            pp.symbols.retrn(expr);
        }
        return null;
    }

    @Reduction(rules={"pkg_spec: 'PACKAGE' identifier '.' identifier is_or_as 'END'", "pkg_spec: 'PACKAGE' identifier '.' identifier is_or_as 'END' identifier", "pkg_spec: 'PACKAGE' identifier '.' identifier is_or_as basic_decl_item_list 'END'", "pkg_spec: 'PACKAGE' identifier '.' identifier is_or_as basic_decl_item_list 'END' identifier", "pkg_spec: 'PACKAGE' identifier '.' identifier package_properties_opt is_or_as 'END'", "pkg_spec: 'PACKAGE' identifier '.' identifier package_properties_opt is_or_as 'END' identifier", "pkg_spec: 'PACKAGE' identifier '.' identifier package_properties_opt is_or_as basic_decl_item_list 'END'", "pkg_spec: 'PACKAGE' identifier '.' identifier package_properties_opt is_or_as basic_decl_item_list 'END' identifier", "pkg_spec: 'PACKAGE' identifier is_or_as 'END'", "pkg_spec: 'PACKAGE' identifier is_or_as 'END' identifier", "pkg_spec: 'PACKAGE' identifier is_or_as basic_decl_item_list 'END'", "pkg_spec: 'PACKAGE' identifier is_or_as basic_decl_item_list 'END' identifier", "pkg_spec: 'PACKAGE' identifier package_properties_opt is_or_as 'END'", "pkg_spec: 'PACKAGE' identifier package_properties_opt is_or_as 'END' identifier", "pkg_spec: 'PACKAGE' identifier package_properties_opt is_or_as basic_decl_item_list 'END'", "pkg_spec: 'PACKAGE' identifier package_properties_opt is_or_as basic_decl_item_list 'END' identifier"})
    @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier"})
    @Returns(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION)
    private ValueNode parse_pkg_spec(ParseParm pp, int ruleid, List<ValueNode> children) {
        throw new IllegalStateException();
    }

    @Reduction(rules={"procedure_call: name", "procedure_call: name_wo_function_call '@' dblink", "procedure_call: name_wo_function_call '@' dblink empty_parens_opt", "procedure_call: name_wo_function_call '@' dblink paren_expr_list"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"name"}), @Token(type=ValueNode.ValueType.DOTTEDNODE, token={"name_wo_function_call"})})
    @Returns(type=ValueNode.ValueType.DOTTEDNODE)
    private ValueNode parse_procedure_call(ParseParm pp, int ruleid, List<ValueNode> children) {
        return children.get(0);
    }

    @Reduction(rules={"query_table_expression: '(' query_table_expression ')'", "query_table_expression: '(' subquery ')'", "query_table_expression: '(' subquery subquery_restriction_clause ')'", "query_table_expression: 'LATERAL' '(' subquery ')'", "query_table_expression: 'LATERAL' '(' subquery subquery_restriction_clause ')'", "query_table_expression: identifier", "query_table_expression: identifier '.' query_table_expression[11,58)", "query_table_expression: identifier '.' query_table_expression[11,58) sample_clause", "query_table_expression: query_table_expression[11,58)", "query_table_expression: query_table_expression[11,58) sample_clause", "query_table_expression: table_collection_expression", "query_table_expression: xmltable"})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_query_table_expression(ParseParm pp, int token, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"type_constructor_expression: 'NEW' identifier '.' type_name paren_expr_list", "type_constructor_expression: 'NEW' type_name paren_expr_list", "type_constructor_expression: identifier '.' type_name paren_expr_list", "type_constructor_expression: type_name paren_expr_list"})
    @Tokens(value={@Token(type=ValueNode.ValueType.DOTTEDNODE, token={"identifier"}), @Token(type=ValueNode.ValueType.TYPENODE, token={"type_name"}), @Token(type=ValueNode.ValueType.MULTIARGNODE, token={"paren_expr_list"})})
    @Returns(type=ValueNode.ValueType.EXPRNODE)
    private ValueNode parse_type_constructor_expression(ParseParm pp, int token, List<ValueNode> childValues) {
        throw new IllegalStateException("Unimplemented dispatch method");
    }

    @Reduction(rules={"type_name: identifier", "type_name: 'BINARY_DOUBLE'", "type_name: 'BINARY_FLOAT'", "type_name: 'DATE'", "type_name: 'INTERVAL' 'DAY' 'TO' 'SECOND'", "type_name: 'INTERVAL' 'YEAR' 'TO' 'MONTH'", "type_name: 'NUMBER'", "type_name: 'TIMESTAMP'", "type_name: 'TIMESTAMP' 'WITH' 'LOCAL' 'TIME' 'ZONE'", "type_name: 'TIMESTAMP' 'WITH' 'TIME' 'ZONE'"})
    @Token(type=ValueNode.ValueType.IDENTIFIERNODEDECLARATION, token={"identifier"})
    @Returns(type=ValueNode.ValueType.TYPENODE)
    private ValueNode.TypeNode parse_type_name(ParseParm pp, int rulenum, List<ValueNode> childValues) {
        if (rulenum < 1) {
            ValueNode.IdentifierNode idn = childValues.get(0).asIdentifierNode();
            return new ValueNode.TypeNode(idn.pos, idn.getType());
        }
        String typeString = "";
        String sep = "";
        for (ValueNode tokenNode : childValues) {
            typeString = typeString + sep + tokenNode.asTokenNode().getName();
            sep = " ";
        }
        PlsqlType.ScalarType type = PlsqlType.ScalarType.fromString(typeString);
        if (type == null) {
            this.warn(pp.cur, "unconstrained_type_name unrecognized type " + typeString);
            type = PlsqlType.ScalarType.VARCHAR2;
        }
        return new ValueNode.TypeNode(pp.cur, new PlsqlType.Scalar(type));
    }

    private void warn(ParseNode pos, String msg) {
        this.warnings.add(msg + " line " + this.linenum(pos) + " " + this.correspondingSource(pos));
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    private /* synthetic */ ValueNode lambda$initializeDispatch$3(Method method, int ruleNumF, int[] pickIdx, int ruleIdx, ParseParm pp, int unused, List childValues) {
        try {
            return (ValueNode)method.invoke((Object)this, pp, ruleNumF, childValues, pickIdx);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            if (e.getCause() instanceof SqlInjectionAnalysisFailure) {
                SqlInjectionAnalysisFailure saf = (SqlInjectionAnalysisFailure)e.getCause();
                if (saf.getWhileParsingSource() == null) {
                    saf.setWhileParsingSource(this.linenum(pp.cur) + ":" + this.correspondingSource(pp.cur));
                }
                throw saf;
            }
            SqlInjectionAnalysisFailure saf = new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_BAD_PARSE, method.getName() + "(rule " + this.tupleToString(this.sortedRules[ruleIdx]) + ")", e);
            throw saf;
        }
    }

    private /* synthetic */ ValueNode lambda$initializeDispatch$2(Method method, int ruleNumF, int ruleIdx, ParseParm pp, int unused, List childValues) {
        try {
            return (ValueNode)method.invoke((Object)this, pp, ruleNumF, childValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            if (e.getCause() instanceof SqlInjectionAnalysisFailure) {
                SqlInjectionAnalysisFailure saf = (SqlInjectionAnalysisFailure)e.getCause();
                if (saf.getWhileParsingSource() == null) {
                    saf.setWhileParsingSource(this.linenum(pp.cur) + ":" + this.correspondingSource(pp.cur));
                }
                throw saf;
            }
            SqlInjectionAnalysisFailure saf = new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_BAD_PARSE, method.getName() + "(rule " + this.tupleToString(this.sortedRules[ruleIdx]) + ")", e);
            throw saf;
        }
    }

    static class DispatchInfo {
        Reduction annotation;
        NodeParser parser;

        public DispatchInfo(Reduction annotation, NodeParser parser) {
            this.annotation = annotation;
            this.parser = parser;
        }

        public String toString() {
            return "DispatchInfo [annotation=" + this.annotation + ", parser=" + this.parser + "]";
        }
    }

    private static enum SubprgBodyState {
        SEEKING_SUBPRG_SPEC,
        SEEKING_BEGIN,
        SEEKING_EXCEPTION_HANDLERS,
        SKIP_TO_END;

    }

    class ParseParm {
        final ParseNode cur;
        final int curTok;
        ValueNode value;
        final List<ParseNode> childList;
        final NodeReduction reduces;
        final SymbolTable symbols;
        Loc locLazy;
        final int depth;

        ParseParm(ParseNode cur, int curTok, SymbolTable symbols, int depth) {
            this.cur = cur;
            this.curTok = curTok;
            this.value = null;
            this.childList = cur.childList();
            this.reduces = SqlInjectionGraph.this.computeNodeReduction(cur, this.childList, curTok);
            this.symbols = symbols;
            this.depth = depth;
        }

        ParseParm createChildParm(int childIdx) {
            return new ParseParm(this.childList.get(childIdx), this.reduces.getRule((int)0).rhs[childIdx], this.symbols, this.depth + 1);
        }

        ParseParm createNestedScope(SymbolTable.ScopeType scopeType) {
            SymbolTable scope = new SymbolTable("", this.symbols, scopeType, this.loc());
            return new ParseParm(this.cur, this.curTok, scope, this.depth);
        }

        ParseParm createReplaceScope(SymbolTable scope) {
            return new ParseParm(this.cur, this.curTok, scope, this.depth);
        }

        Loc loc() {
            if (this.locLazy == null) {
                this.locLazy = new Loc(this.cur);
                this.locLazy.setLinenum(SqlInjectionGraph.this.line(this.cur));
            }
            return this.locLazy;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("<");
            String sep = "";
            for (int tok : this.cur.content()) {
                sb.append(sep + ((SqlInjectionGraph)SqlInjectionGraph.this).parser.allSymbols[tok]);
                sep = "|";
            }
            sb.append("> " + this.reduces);
            sb.append(" depth " + this.depth);
            return sb.toString();
        }
    }

    private class NodeReduction {
        ArrayList<Integer> rules = new ArrayList();

        private NodeReduction() {
        }

        void add(int ruleIdx) {
            this.rules.add(ruleIdx);
        }

        List<Integer> getIdxs() {
            return this.rules;
        }

        Parser.Tuple getRule(int i) {
            int idx = this.rules.get(i);
            return SqlInjectionGraph.this.sortedRules[idx];
        }

        int getHead(int i) {
            int idx = this.rules.get(i);
            return ((SqlInjectionGraph)SqlInjectionGraph.this).sortedRules[idx].head;
        }

        int getIdx(int i) {
            return this.rules.get(i);
        }

        Parser.Tuple getLastRule() {
            return this.getRule(this.rules.size() - 1);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String sep = "";
            boolean problem = false;
            for (int i = this.rules.size() - 1; i >= 0; --i) {
                sb.append(sep);
                sep = "<=";
                int ruleIdx = this.rules.get(i);
                if (ruleIdx < 0 || ruleIdx >= SqlInjectionGraph.this.sortedRules.length) {
                    sb.append("[NOT 0<=" + ruleIdx + "<" + SqlInjectionGraph.this.sortedRules.length + "]");
                    problem = true;
                    continue;
                }
                Parser.Tuple rule = SqlInjectionGraph.this.sortedRules[ruleIdx];
                sb.append(((SqlInjectionGraph)SqlInjectionGraph.this).parser.allSymbols[rule.head]);
                if (i == 0) {
                    String childSep = ": ";
                    for (int child : rule.rhs) {
                        sb.append(childSep + ((SqlInjectionGraph)SqlInjectionGraph.this).parser.allSymbols[child]);
                        childSep = " ";
                    }
                    continue;
                }
                assert (rule.rhs.length == 1);
            }
            if (!problem) {
                int prevHead = -1;
                for (int i = 0; i < this.rules.size(); ++i) {
                    if (i > 0) assert (this.getRule((int)i).rhs[0] == prevHead);
                    prevHead = this.getHead(i);
                }
            }
            return (problem ? "PROBLEM: " : "") + sb.toString();
        }
    }

    static enum ParameterMode {
        INOUT,
        IN,
        OUT;


        static ParameterMode parse(String mode) {
            switch (mode) {
                case "IN": {
                    return IN;
                }
                case "OUT": {
                    return OUT;
                }
                case "IN/OUT": 
                case "INOUT": {
                    return INOUT;
                }
            }
            return ParameterMode.valueOf(mode);
        }

        boolean isIn() {
            return this == IN || this == INOUT;
        }

        boolean isOut() {
            return this == OUT || this == INOUT;
        }
    }

    @FunctionalInterface
    private static interface NodeParser {
        public ValueNode parse(ParseParm var1, int var2, List<ValueNode> var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Tokens {
        public Token[] value();
    }

    @Repeatable(value=Tokens.class)
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Token {
        public String[] token();

        public ValueNode.ValueType type();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PickTokens {
        public String[] tokens();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Returns {
        public ValueNode.ValueType type();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Reduction {
        public String[] rules();

        public boolean beforeChildren() default false;

        public ValueNode.ValueType[] genericChildren() default {};
    }

    static enum Debug {
        TIMINGS(true),
        RULE_TYPE_SYSTEM(false),
        PARSING_ERRORS_FATAL(true),
        DUMP_GRAMMAR(false, "/tmp/dumped-grammar.txt"),
        DUMP_EARLEY(false),
        DUMP_RULES(false),
        GROUP_TYPE_SYSTEM_ERRORS(true),
        PARSE_SOURCE(false),
        PARSE_COMPUTERULE(false),
        PARSE_NODEVALUE(false),
        PARSE_DISPATCH(false),
        PARSE_CHILDREN(false),
        PARSE_FUNCTION_DEFINE(false),
        ASSIGNMENT(true),
        DATAFLOW(false),
        EXCEPTION(false),
        FUNCRESOLVE(false),
        IF_ENDIF(true),
        LOOP_AND_BLOCK(false),
        WARNING(false),
        MISC(false),
        SYM_DEFINE(false),
        SYM_WRITE(false),
        SYM_READ(false),
        PLSQL(false),
        DUMP_USAGES(false, "/tmp/dumpUsage", "parse_subprg_body", "parse_function_call_helper", "getInjections"),
        DB_FUNCS(false);

        static final boolean DEBUG = false;
        boolean debug = false;
        Object[] parms;

        private Debug(boolean debug) {
        }

        private Debug(boolean debug, Object ... parms) {
            this.parms = parms;
        }

        void out(String string) {
            if (this.debug) {
                System.out.print(string);
            }
        }

        void outln(String line) {
            if (this.debug) {
                System.out.println(line + "[" + this.toString() + "]");
            }
        }

        void outln() {
            this.outln("");
        }

        boolean has(Predicate<Object> p) {
            return Arrays.asList(this.parms).stream().anyMatch(p);
        }
    }
}

