/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.dbtools.app.injection.Dotted;
import oracle.dbtools.app.injection.FuncFormal;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.SymbolTable;

public class LoadDbRefs {
    private Connection m_conn = null;

    LoadDbRefs(Connection connection) {
        this.m_conn = connection;
    }

    void loadCollectionTypes(SymbolTable symbols) {
        throw new IllegalStateException();
    }

    void loadSymbols(SymbolTable symbols) throws SQLException {
        if (this.m_conn == null) {
            throw new SQLRecoverableException("No connection");
        }
        Statement stmt = this.m_conn.createStatement();
        ResultSet rslt = stmt.executeQuery("select user from dual");
        while (rslt.next()) {
            symbols.setCurrentUser(rslt.getString("USER"));
        }
        rslt = stmt.executeQuery("select distinct aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.argument_name, aa.position, aa.data_type, aa.data_length, aa.in_out, aa.type_name, aa.type_subname, aa.type_link, aa.type_object_type, aa.pls_type, aa.char_length, aa.char_used from all_procedures ap, all_arguments aa where aa.object_id = ap.object_id and ap.subprogram_id = aa.subprogram_id and aa.package_name = ap.object_name and (aa.owner = 'SYS' and (aa.package_name = 'DBMS_ASSERT' or aa.package_name = 'DBMS_RANDOM' or aa.package_name = 'STANDARD')or aa.OWNER = '" + symbols.getCurrentUser() + "') order by aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.position ");
        int count = 0;
        String curOwner = null;
        String curPackage = null;
        SymbolTable curSymbolTable = null;
        String curFuncUnique = null;
        String curFuncName = null;
        int curOverload = Integer.MIN_VALUE;
        ArrayList<ParmSpec> curArgs = new ArrayList<ParmSpec>();
        String prevFunc = "";
        while (rslt.next()) {
            ParmSpec arg;
            ++count;
            String owner = rslt.getString("OWNER");
            String packageName = rslt.getString("PACKAGE_NAME");
            String objectName = rslt.getString("OBJECT_NAME");
            int subprogram = rslt.getInt("SUBPROGRAM_ID");
            int overload = rslt.getInt("OVERLOAD");
            String argName = rslt.getString("ARGUMENT_NAME");
            int argPos = rslt.getInt("POSITION");
            String dataType = rslt.getString("DATA_TYPE");
            String dataLength = rslt.getString("DATA_LENGTH");
            String inOut = rslt.getString("IN_OUT");
            String typeName = rslt.getString("TYPE_NAME");
            String typeSubname = rslt.getString("TYPE_SUBNAME");
            String typeLink = rslt.getString("TYPE_LINK");
            String typeObjectType = rslt.getString("TYPE_OBJECT_TYPE");
            String plsType = rslt.getString("PLS_TYPE");
            int charLength = rslt.getInt("CHAR_LENGTH");
            String charUsed = rslt.getString("CHAR_USED");
            String funcUnique = owner + "." + packageName + "." + objectName + ":" + subprogram + "/" + overload;
            boolean newFunc = false;
            if (!owner.equals(curOwner) || !packageName.equals(curPackage)) {
                newFunc = true;
                this.storeFunction(curSymbolTable, curFuncName, curArgs);
                curOwner = owner;
                curPackage = packageName;
                curSymbolTable = symbols.getMakeSchemaPackage(owner, packageName);
            } else if (!funcUnique.equals(curFuncUnique)) {
                newFunc = true;
                this.storeFunction(curSymbolTable, curFuncName, curArgs);
            }
            if (newFunc) {
                curFuncUnique = funcUnique;
                curFuncName = objectName;
                curArgs = new ArrayList();
            }
            String param = argPos + ":" + argName + " " + dataType + "(" + dataLength + " " + charUsed + "/" + charLength + ") " + inOut + " " + typeName + "-" + typeSubname + "-" + typeLink + "-" + typeObjectType + "-" + plsType;
            SqlInjectionGraph.ParameterMode mode = SqlInjectionGraph.ParameterMode.parse(inOut);
            if (plsType == null) {
                arg = new ParmSpec(argPos, argName, dataType, mode);
            } else {
                PlsqlType.Scalar type = new PlsqlType.Scalar(PlsqlType.ScalarType.fromString(plsType));
                arg = new ParmSpec(argPos, argName, type, mode);
            }
            if (SqlInjectionGraph.Debug.DB_FUNCS.debug) {
                if (!funcUnique.equals(prevFunc)) {
                    System.out.println(funcUnique);
                    prevFunc = funcUnique;
                }
                System.out.println("    " + arg + " <=== " + param);
            }
            curArgs.add(arg);
        }
        this.storeFunction(curSymbolTable, curFuncName, curArgs);
        if (SqlInjectionGraph.Debug.DB_FUNCS.debug) {
            System.out.println("Total rows " + count);
            System.out.flush();
        }
    }

    private void storeFunction(SymbolTable curSymbolTable, String curFuncName, ArrayList<ParmSpec> curArgs) {
        if (curFuncName == null) {
            return;
        }
        Symbol symbol = curSymbolTable.getLocalDeclaration(curFuncName);
        if (symbol != null && !(symbol instanceof Symbol.FunctionSym)) {
            throw new SqlInjectionAnalysisFailure("Database appears to have overloaded " + symbol + " with a function " + curFuncName);
        }
        Symbol.FunctionSym func = (Symbol.FunctionSym)symbol;
        Dotted dotted = curSymbolTable.getDotted();
        Loc loc = new Loc(dotted);
        if (func == null) {
            dotted.add(curFuncName);
            func = new Symbol.FunctionSym(curSymbolTable, curFuncName, curArgs, loc, (Object)loc);
        } else {
            func.addSignature(new FuncFormal(curFuncName, curArgs, loc, loc));
        }
        if (SqlInjectionGraph.Debug.DB_FUNCS.debug) {
            System.out.println("DB: " + func);
        }
        if (curArgs.get(0).getPos() != 0) {
            func.toString();
        }
    }
}

