/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.app.injection.Call;
import oracle.dbtools.app.injection.CallLink;
import oracle.dbtools.app.injection.FlowFunc;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.NodeLabel;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.app.injection.ValueNode;

public class FuncFormal {
    private final String RETURN_PARM_NAME = "[return]";
    private String funcName;
    private boolean bodyDefined;
    private Object bodyLabel;
    private ArrayList<ParmSpec> parms;
    private ArrayList<Symbol> inSymbols;
    private ArrayList<Symbol> outSymbols;
    private ArrayList<Usage> afterCall;
    private int resultIdx;
    private Loc loc;
    private boolean safe;
    private boolean dangerous;
    private HashMap<Loc, FlowFunc> specificFlows;

    FuncFormal(String funcName, ArrayList<ParmSpec> parms, Loc loc, Object label) {
        int i;
        assert (loc != null);
        this.funcName = funcName;
        this.bodyDefined = false;
        this.bodyLabel = null;
        this.parms = parms;
        this.inSymbols = new ArrayList(parms.size());
        this.outSymbols = new ArrayList(parms.size());
        this.afterCall = new ArrayList(parms.size());
        this.loc = loc;
        this.safe = false;
        this.specificFlows = new HashMap();
        this.resultIdx = -1;
        for (i = 0; i < parms.size(); ++i) {
            String name = parms.get(i).getName();
            if (name != null && !name.equals("")) continue;
            assert (this.resultIdx < 0);
            this.resultIdx = i;
            name = "[return]";
        }
        if (this.resultIdx > 0) {
            ArrayList<ParmSpec> reorderedParms = new ArrayList<ParmSpec>(parms);
            ParmSpec retParm = reorderedParms.get(this.resultIdx);
            for (int i2 = this.resultIdx; i2 > 0; --i2) {
                reorderedParms.set(i2, reorderedParms.get(i2 - 1));
            }
            reorderedParms.set(0, retParm);
            this.parms = reorderedParms;
            this.resultIdx = 0;
        }
        for (i = 0; i < this.parms.size(); ++i) {
            ParmSpec parm = this.parms.get(i);
            String name = parm.getName();
            PlsqlType type = parm.getType();
            this.inSymbols.add(new Symbol(null, this.resultIdx == i ? "RETURN" : name, type, loc, label));
            Symbol parmSym = new Symbol(null, this.resultIdx == i ? "RETURN" : name, type, loc, label);
            this.outSymbols.add(parmSym);
            this.afterCall.add(new Usage(parmSym, loc, label));
        }
    }

    void defineBody(SymbolTable scope, Object bodyLabel) {
        this.bodyDefined = true;
    }

    boolean getBodyDefined() {
        return this.bodyDefined;
    }

    Object getBodyLabel() {
        return this.bodyLabel;
    }

    String getFuncName() {
        return this.funcName;
    }

    ArrayList<ParmSpec> getParms() {
        return this.parms;
    }

    List<Symbol> getInSymbols() {
        return this.inSymbols;
    }

    List<Usage> getAfterCall() {
        return this.afterCall;
    }

    Loc getLoc() {
        return this.loc;
    }

    int getResultIdx() {
        return this.resultIdx;
    }

    void markAsSafe() {
        this.safe = true;
    }

    public Usage doSafeCallLink(List<ValueNode.ArgNode> argsInParmOrder, Loc callLoc, NodeLabel label) {
        int n = argsInParmOrder.size();
        assert (!this.dangerous);
        Symbol[] outSym = new Symbol[n];
        for (int out = 0; out < n; ++out) {
            Symbol sym;
            if (!this.getParms().get(out).getMode().isOut()) continue;
            outSym[out] = sym = this.outSymbols.get(out);
            Usage newOutU = new Usage(new Symbol(null, "", PlsqlType.safeType(), callLoc, label), callLoc, (Object)label);
            sym.assign(newOutU);
        }
        return new Usage(new Symbol(null, "", PlsqlType.safeType(), callLoc, label), callLoc, (Object)label);
    }

    public Usage doDangerousCallLink(List<ValueNode.ArgNode> argsInParmOrder, Loc callLoc, NodeLabel label) {
        int n = argsInParmOrder.size();
        assert (!this.safe);
        Symbol[] outSym = new Symbol[n];
        for (int out = 0; out < n; ++out) {
            Symbol sym;
            ValueNode.ArgNode outArg = argsInParmOrder.get(out);
            if (!this.getParms().get(out).getMode().isOut()) continue;
            outSym[out] = sym = this.outSymbols.get(out);
            Usage newOutU = new Usage(sym, callLoc, (Object)label);
            sym.assign(newOutU);
            for (int in = 0; in < n; ++in) {
                if (!this.getParms().get(in).getMode().isIn()) continue;
                ValueNode.ArgNode inArg = argsInParmOrder.get(in);
                for (Usage inU : inArg.getUsages()) {
                    outSym[out].getAssigned().from(inU);
                }
            }
        }
        if (this.getResultIdx() < 0) {
            return null;
        }
        return outSym[this.getResultIdx()].getAssigned();
    }

    public Usage doCallLink(SqlInjectionGraph.ParseParm pp, Call call, List<ValueNode.ArgNode> argsInParmOrder, NodeLabel label) {
        int n = argsInParmOrder.size();
        if (this.safe) {
            return this.doSafeCallLink(argsInParmOrder, call.loc(), label);
        }
        if (this.dangerous) {
            return this.doDangerousCallLink(argsInParmOrder, call.loc(), label);
        }
        CallLink callLink = new CallLink(this, call);
        for (int in = 0; in < n; ++in) {
            ValueNode.ArgNode inArg;
            if (!this.getParms().get(in).getMode().isIn() || (inArg = argsInParmOrder.get(in)) == null) continue;
            for (Usage u : inArg.getUsages()) {
                FlowFunc.FlowFuncLink ffl = new FlowFunc.FlowFuncLink(u, in, callLink);
                u.getFuncLinks().add(ffl);
            }
        }
        Usage[] outParms = new Usage[n];
        Usage[] outActual = new Usage[n];
        for (int out = 0; out < n; ++out) {
            if (!this.getParms().get(out).getMode().isOut()) continue;
            outParms[out] = this.afterCall.get(out);
            outParms[out].setFunctionOutput(true);
            Loc loc = new Loc(call.loc());
            if (out == this.resultIdx) {
                loc.setSyntheticMsg("RETURN");
            } else {
                loc.setSyntheticMsg("[" + this.inSymbols.get((int)out).name + "]");
            }
            outActual[out] = new Usage(this.inSymbols.get(out), loc, (Object)label);
            ValueNode.ArgNode outArg = argsInParmOrder.get(out);
            if (outArg == null) continue;
            Symbol sym = outArg.getUsages().get(0).getSymbol();
            sym.assign(outActual[out]);
            SqlInjectionGraph.Debug.ASSIGNMENT.out("OUT: " + sym + " := " + outActual[out]);
            SqlInjectionGraph.Debug.ASSIGNMENT.outln();
        }
        callLink.setOutParms(Arrays.asList(outParms));
        callLink.setOutActual(Arrays.asList(outActual));
        if (this.getResultIdx() < 0) {
            return null;
        }
        return outActual[this.getResultIdx()];
    }

    public Usage connectFlows(List<ValueNode.ArgNode> argsInParmOrder, Loc callLoc, Object label) {
        assert (callLoc != null);
        FlowFunc flowFunc = this.specificFlows.get(callLoc);
        if (flowFunc == null) {
            flowFunc = new FlowFunc(this, this.loc, callLoc);
            this.specificFlows.put(callLoc, flowFunc);
        }
        return flowFunc.connect(argsInParmOrder);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.funcName + "(");
        String sep = "";
        for (ParmSpec pspec : this.parms) {
            sb.append(sep + pspec);
            sep = ",";
        }
        sb.append(")");
        return sb.toString();
    }
}

