/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import oracle.dbtools.app.injection.CallLink;
import oracle.dbtools.app.injection.DependencyLink;
import oracle.dbtools.app.injection.FlowFunc;
import oracle.dbtools.app.injection.NodeLabel;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.app.injection.Tuple;
import oracle.dbtools.app.injection.Usage;

class FlowGraph {
    ArrayList<Node> sources = new ArrayList();
    Set<Usage> sinks = new HashSet<Usage>();
    Deque<NodeLabel> nodeLabelStack = new ArrayDeque<NodeLabel>();

    FlowGraph(NodeLabel label) {
        this.nodeLabelStack.addLast(label);
    }

    void addSource(Usage source) {
        this.sources.add(new Node(this.getNodeLabel(), source));
    }

    void addSink(Usage sink) {
        this.sinks.add(sink);
    }

    List<List<DependencyLink>> getInjections(Function<Usage, ? extends DependencyLink.LocationTuple> linenum, SymbolTable debugScope, boolean keepDuplicates) {
        ArrayDeque<Path> todo = new ArrayDeque<Path>();
        HashMap<Node, Path> paths = new HashMap<Node, Path>();
        HashMap<NodeLabel, CallLink> labelsAndLinks = new HashMap<NodeLabel, CallLink>();
        for (Node node : this.sources) {
            if (node.usage.isSafe()) continue;
            Path p = new Path(node);
            paths.put(node, p);
            todo.addLast(p);
        }
        while (!todo.isEmpty()) {
            Path cur = (Path)todo.removeFirst();
            for (Usage u : cur.usage().getFlows()) {
                Node nu = new Node(((Path)cur).node().label, u);
                Path path = this.reached(cur, nu, paths, todo, labelsAndLinks);
            }
            for (FlowFunc.FlowFuncLink link : cur.usage().getFuncLinks()) {
                CallLink callLink = link.getCallLink();
                NodeLabel callLabel = cur.node.label.labelNewCall(callLink.call());
                CallLink oldCallLink = labelsAndLinks.put(callLabel, callLink);
                assert (oldCallLink == null || oldCallLink == callLink);
                Usage formalU = link.getDestinationUsage();
                formalU.from(link.u);
                Node nu = new Node(callLabel, formalU);
                Path path = this.reached(cur, nu, paths, todo, labelsAndLinks);
            }
        }
        ArrayList<List<DependencyLink>> allInjections = new ArrayList<List<DependencyLink>>();
        HashSet<Tuple<Usage, Usage>> hashSet = new HashSet<Tuple<Usage, Usage>>();
        for (Map.Entry reached : paths.entrySet()) {
            if (!this.sinks.contains(((Node)reached.getKey()).usage) || hashSet.contains(((Node)reached.getKey()).usage)) continue;
            Path p = (Path)reached.getValue();
            ArrayList<DependencyLink> injection = new ArrayList<DependencyLink>();
            Debug.DUMP_INJECTION_LINKS.outln("INJECTION #" + allInjections.size());
            Usage u = null;
            for (Node n : p.getPath()) {
                NodeLabel nl;
                u = n.usage;
                Debug.DUMP_INJECTION_LINKS.outln(" Dependency link ... " + n.label.call() + "+" + n.label.size + " at " + u.getLoc() + ":" + linenum.apply(u));
                DependencyLink.LocationTuple lt = linenum.apply(n.usage);
                DependencyLink link = new DependencyLink(u.getName(), u.getLoc(), lt);
                String proposedLabel = u.getName();
                if (u.getLoc().isSynthetic()) {
                    proposedLabel = proposedLabel + " [" + u.getLoc().getSyntheticMsg() + "]";
                }
                if (u.getLabel() instanceof NodeLabel && (nl = (NodeLabel)u.getLabel()).call() != null && nl.call().formal() != null) {
                    proposedLabel = proposedLabel + " in " + nl.call().formal().getFuncName();
                }
                Debug.DUMP_INJECTION_LINKS.outln("Proposed: " + proposedLabel);
                if (keepDuplicates || injection.isEmpty() || !link.equals(injection.get(injection.size() - 1))) {
                    injection.add(new DependencyLink(u.getName(), u.getLoc(), lt));
                }
                Debug.DUMP_INJECTION_LINKS.outln(" " + u + "-" + linenum.apply(u));
            }
            assert (u != null);
            Tuple<Usage, Usage> pair = new Tuple<Usage, Usage>(u, ((Node)reached.getKey()).usage);
            if (hashSet.add(pair)) {
                allInjections.add(injection);
            } else {
                Debug.DUMP_INJECTION_LINKS.out(" DUPLICATE");
            }
            Debug.DUMP_INJECTION_LINKS.outln();
        }
        if (Debug.DUMP_PATHS.debug) {
            Debug.DUMP_PATHS.outln("====================== Dumping paths");
            this.dumpPaths(paths);
        }
        return allInjections;
    }

    private void dumpPaths(HashMap<Node, Path> paths) {
        HashMap<Path, Node> inverted = new HashMap<Path, Node>();
        HashSet<Path> notFinal = new HashSet<Path>();
        for (Map.Entry<Node, Path> e : paths.entrySet()) {
            Path p = e.getValue();
            inverted.put(p, e.getKey());
            if (p.prev == null) continue;
            notFinal.add(p.prev);
        }
        for (Path p : paths.values()) {
            if (notFinal.contains(p)) continue;
            while (p != null) {
                Usage u = ((Node)inverted.get((Object)p)).usage;
                System.out.print(u.string() + "<=");
                p = p.prev;
            }
            System.out.println();
        }
        System.out.println("------ Sources:");
        for (Node n : this.sources) {
            System.out.println(n.label + " " + n.usage);
        }
        System.out.println("------ Sinks:");
        for (Usage u : this.sinks) {
            System.out.println(u);
        }
    }

    Path reached(Path cur, Node nu, Map<Node, Path> paths, Deque<Path> todo, Map<NodeLabel, CallLink> labelsAndLinks) {
        Path p = paths.get(nu);
        if (p != null) {
            return p;
        }
        p = new Path(nu, cur);
        paths.put(nu, p);
        todo.addLast(p);
        if (!nu.usage.functionOutput()) {
            return p;
        }
        for (NodeLabel nuLabel = nu.label; nuLabel != null; nuLabel = nuLabel.parent()) {
            CallLink callLink = labelsAndLinks.get(nuLabel);
            if (callLink == null) continue;
            for (int i = 0; i < callLink.outParms().size(); ++i) {
                Usage actualU;
                Usage parmU = callLink.outParms().get(i);
                if (parmU == null || parmU != nu.usage || (actualU = callLink.outActual().get(i)) == null) continue;
                this.reached(p, new Node(nuLabel, actualU), paths, todo, labelsAndLinks);
            }
        }
        return p;
    }

    public NodeLabel getNodeLabel() {
        return this.nodeLabelStack.getLast();
    }

    public void pushNodeLabel(NodeLabel nodeLabel) {
        this.nodeLabelStack.addLast(nodeLabel);
    }

    public void popNodeLabel() {
        if (this.nodeLabelStack.isEmpty()) {
            throw new NullPointerException();
        }
        this.nodeLabelStack.pollLast();
    }

    private static class Path {
        Node node;
        Path prev;

        private Path(Node node, Path reachedFrom) {
            this.node = node;
            this.prev = reachedFrom;
        }

        private Path(Node node) {
            this(node, (Path)null);
        }

        private Node node() {
            return this.node;
        }

        private Usage usage() {
            return this.node.usage;
        }

        private Path prev() {
            return this.prev;
        }

        private List<Node> getPath() {
            List<Object> ret = this.prev == null ? new ArrayList() : this.prev.getPath();
            ret.add(this.node);
            return ret;
        }

        private String toString(Function<Node, ? extends DependencyLink.LocationTuple> linenum) {
            StringBuffer sb = new StringBuffer(this.node.toString() + ":" + linenum.apply(this.node) + " |");
            for (Node u : this.getPath()) {
                sb.append(" " + u + ":" + linenum.apply(u));
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.node.toString() + " |");
            for (Node u : this.getPath()) {
                sb.append(" " + u);
            }
            return sb.toString();
        }
    }

    private static class Node {
        final NodeLabel label;
        final Usage usage;

        Node(NodeLabel label, Usage usage) {
            this.label = label;
            this.usage = usage;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.usage == null ? 0 : this.usage.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            return !(this.usage == null ? other.usage != null : !this.usage.equals(other.usage));
        }

        public String toString() {
            return this.usage + "(" + this.label + ")";
        }
    }

    static enum Debug {
        DUMP_PATHS(true),
        DUMP_GRAPH(false),
        DUMP_INJECTION_LINKS(true);

        boolean debug = false;
        Object[] parms;

        private Debug(boolean debug) {
        }

        private Debug(boolean debug, Object ... parms) {
            this.parms = parms;
        }

        void out(String string) {
            if (this.debug) {
                System.out.print(string);
            }
        }

        void outln(String line) {
            if (this.debug) {
                System.out.println(line);
            }
        }

        void outln() {
            this.outln("");
        }
    }
}

