/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import oracle.dbtools.lsp.Jsonable;
import oracle.dbtools.parser.json.Util;

public class CompletionItem
implements Jsonable {
    public String entry;
    public Type type;

    public CompletionItem(String entry, Type type) {
        this.entry = entry;
        this.type = type;
    }

    public String toString() {
        return this.entry + " " + (Object)((Object)this.type);
    }

    public boolean equals(Object obj) {
        CompletionItem cmp = (CompletionItem)obj;
        if (!cmp.entry.equals(this.entry)) {
            return false;
        }
        return cmp.type.equals((Object)this.type);
    }

    public int lspCode() {
        switch (this.type) {
            case TABLE: {
                return 6;
            }
            case VIEW: {
                return 6;
            }
            case COLUMN: {
                return 5;
            }
            case USER: {
                return 1;
            }
            case KEYWORD: {
                return 14;
            }
            case SYNONYM: {
                return 1;
            }
            case PROCEDURE: {
                return 3;
            }
            case FUNCTION: {
                return 3;
            }
            case PACKAGE: {
                return 9;
            }
            case PACKAGE_BODY: {
                return 9;
            }
            case CONDITION: {
                return 10;
            }
        }
        return 1;
    }

    @Override
    public String toJson() {
        return "{\"label\":\"" + Util.sugarcoatText(this.entry) + "\",\"kind\":" + this.lspCode() + "}";
    }

    public static enum Type {
        TABLE,
        VIEW,
        COLUMN,
        USER,
        KEYWORD,
        TURLNET,
        SYNONYM,
        SEQUENCE,
        PROCEDURE,
        FUNCTION,
        PACKAGE,
        PACKAGE_BODY,
        CONDITION,
        ARGUMENT;

    }
}

