/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import oracle.dbtools.jdbc.CLOB;

public class RestJdbcOutputStream
extends ByteArrayOutputStream {
    private CLOB clob = null;
    long pos;
    private boolean isFlushed = false;

    public RestJdbcOutputStream(CLOB clob, long pos) {
        this.clob = clob;
        this.pos = pos;
    }

    public RestJdbcOutputStream(int size) {
        super(size);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.clob.setString(this.pos - 1L, this.toString());
            this.isFlushed = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isFlushed) {
            this.flush();
        }
    }
}

