/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsString;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import oracle.dbtools.jdbc.util.Accessor;
import oracle.dbtools.jdbc.util.OracleTypesSize;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.SQLStateMapping;

public class ResultSetMetadata
implements ResultSetMetaData {
    private TreeNode rsMetadataTree = null;
    Logger LOGGER = Logger.getLogger(ResultSetMetadata.class.getName());

    protected ResultSetMetadata(TreeNode rsMetadataTree2) {
        this.rsMetadataTree = rsMetadataTree2;
    }

    protected TreeNode getMetadataHelper(int column, String metadata_info) throws SQLException {
        try {
            return this.rsMetadataTree.get("metadata").get(column - 1).get(metadata_info);
        }
        catch (NullPointerException ne) {
            int errorCode = 17003;
            throw new SQLException(RestjdbcResources.getString("ORA_17003"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.rsMetadataTree.get("metadata").size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type == 1 || type == 12 || type == -1 || type == -15 || type == -9 || type == 2005 || type == 2011 || type == 2009 || this.getColumnTypeName(column).contains("XMLTYPE");
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type != -4 && type != -1 && type != 2004 && type != 2005 && type != -13 && type != 2011 && type != 2002 && type != 2008 && type != 2007 && type != 2003 && type != 2006 && type != -10;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        String column_type_name = this.getColumnTypeName(column);
        return column_type_name.equals("NUMBER") || column_type_name.equals("FLOAT");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        JrsNumber n = (JrsNumber)this.getMetadataHelper(column, "isNullable");
        return n.getValue().intValue();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int type = this.getColumnType(column);
        if (type == -6 || type == 5 || type == 4 || type == -5 || type == 2 || type == 6 || type == 8 || type == 2 || type == 3 || type == 7) {
            int precision = this.getPrecision(column);
            int scale = this.getScale(column);
            if (precision != 0 && scale == -127) {
                precision = (int)((double)precision / 3.32193);
                scale = 1;
            } else {
                if (precision == 0) {
                    precision = 38;
                }
                if (scale == -127) {
                    scale = 0;
                }
            }
            int width = precision + (scale != 0 ? 1 : 0) + 1;
            return width;
        }
        if (type == 1 || type == 12 || type == -1) {
            return this.getPrecision(column);
        }
        return OracleTypesSize.getMaxSize(type);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        JrsString s = (JrsString)this.getMetadataHelper(column, "columnName");
        return s.getValue();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        JrsNumber n = (JrsNumber)this.getMetadataHelper(column, "precision");
        return n.getValue().intValue();
    }

    @Override
    public int getScale(int column) throws SQLException {
        JrsNumber n = (JrsNumber)this.getMetadataHelper(column, "scale");
        return n.getValue().intValue();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return Accessor.getConstant(this.getColumnTypeName(column));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        JrsString s = (JrsString)this.getMetadataHelper(column, "columnTypeName");
        return s.getValue();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int type = this.getColumnType(column);
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return String.class.getName();
            }
            case 2: {
                if (this.getPrecision(column) != 0 && this.getScale(column) == -127) {
                    return Double.class.getName();
                }
                return BigDecimal.class.getName();
            }
            case -4: 
            case -2: {
                return byte[].class.getName();
            }
            case 91: 
            case 93: {
                return Timestamp.class.getName();
            }
            case 101: {
                return Double.class.getName();
            }
            case 100: {
                return Float.class.getName();
            }
        }
        return null;
    }

    public TreeNode getRsMetadataTree() {
        return this.rsMetadataTree;
    }

    public void setRsMetadataTree(TreeNode rsMetadataTree) {
        this.rsMetadataTree = rsMetadataTree;
    }
}

