/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;
import oracle.dbtools.jdbc.util.RestJdbcOutputStream;
import oracle.dbtools.jdbc.util.RestJdbcWriter;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.SQLStateMapping;

public class CLOB
implements Clob {
    private long len;
    StringWriter clob = new StringWriter();

    public CLOB() {
    }

    protected CLOB(String x) {
        if (x != null) {
            this.clob.write(x);
            this.len = this.clob.getBuffer().length();
        } else {
            this.clob = null;
        }
    }

    @Override
    public long length() throws SQLException {
        return this.len;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.length() == 0L) {
            return "";
        }
        if (pos < 1L || pos > this.length()) {
            int error_code = 17068;
            throw new SQLException(RestjdbcResources.getString("ORA_17068"), SQLStateMapping.getSQLState(error_code), error_code);
        }
        if ((long)length > this.length() || pos - 1L + (long)length > this.length()) {
            length = (int)this.length();
        }
        try {
            int start = (int)pos - 1;
            int end = start + length;
            return this.clob.getBuffer().substring(start, end);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SQLException("StringIndexOutOfBoundsException: " + e.getMessage());
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, this.clob.getBuffer().length());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        ByteArrayInputStream stream = new ByteArrayInputStream(String.valueOf(this.clob.getBuffer()).getBytes(StandardCharsets.UTF_8));
        return stream;
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (start < 1L || start > this.len) {
            return -1L;
        }
        return this.clob.getBuffer().indexOf(searchstr, (int)start - 1) + 1;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int length) throws SQLException {
        if (offset < 0 || offset > str.length()) {
            throw new SQLException("Invalid offset in byte array set");
        }
        if (pos < 1L || pos > this.length() + 1L) {
            throw new SQLException("Invalid position in CLOB object set");
        }
        if (offset + length > str.length()) {
            throw new SQLException("Invalid OffSet. Cannot have combined offset  and length that is greater that the Clob buffer");
        }
        String toWrite = str.substring(offset, offset + length);
        int start = (int)pos - 1;
        int end = start + toWrite.length();
        this.clob.getBuffer().replace(start, end, toWrite);
        this.len = this.clob.getBuffer().length();
        return start - end;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return new RestJdbcOutputStream(this, pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return new RestJdbcWriter(this, pos);
    }

    @Override
    public void truncate(long length) throws SQLException {
        if (length > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        this.len = length;
        if (this.len == 0L) {
            this.clob.getBuffer().setLength(0);
        } else {
            this.clob.getBuffer().setLength((int)length);
        }
    }

    @Override
    public void free() throws SQLException {
        this.truncate(0L);
        this.len = 0L;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        int start = (int)pos - 1;
        int end = start + (int)length;
        return new StringReader(this.clob.getBuffer().substring(start, end));
    }
}

