/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.liquibase;

import java.io.OutputStream;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import liquibase.exception.DatabaseException;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.exceptions.PropertyNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.tokenizer.ArgumentTokenizer;
import oracle.dbtools.raptor.liquibase.utils.LbExceptionHandler;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExport;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExportV1;
import oracle.dbtools.raptor.newscriptrunner.apex.AppNotInstalledException;
import oracle.dbtools.raptor.newscriptrunner.apex.DoNothingException;
import oracle.dbtools.raptor.newscriptrunner.apex.InvalidParameterException;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LiquibaseActions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class liquibaseCommand
extends CommandListener
implements IHelp,
SQLCLService {
    final String NAME = "Liquibase Command";
    private static final List<String> commands = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("genobject");
            this.add("genschema");
            this.add("gencontrolfile");
            this.add("update");
            this.add("updatesql");
            this.add("rollback");
            this.add("rollbacksql");
            this.add("diff");
            this.add("dbdoc");
            this.add("status");
            this.add("validate");
            this.add("changelogsync");
            this.add("listlocks");
            this.add("releaselocks");
            this.add("clearchecksums");
            this.add("help");
            this.add("version");
            this.add("data");
        }
    };

    public void beginEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public void endEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public String getCommand() {
        return "LIQUIBASE";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return "Liquibase change management commands";
    }

    public String getExtensionName() {
        return "Liquibase Command";
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public String getHelp() {
        return Messages.getString("LB_HELP_OVERVIEW");
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedSQL().startsWith("lb") && !cmd.getLoweredTrimmedSQL().startsWith("liquibase")) {
            return false;
        }
        ctx.write("\n");
        try {
            this.processArgs(cmd.getSql(), ctx);
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                Exception e1 = ((ProcessFailedException)e).getOriginalException();
                if (LiquibaseActions.getBoolenParameter("debug")) {
                    ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR2"), "Location \n" + e.getMessage(), "Message \n" + e1.getMessage()));
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e1.getMessage()));
                }
            } else if (e instanceof DoNothingException) {
                ctx.write(this.getHelp());
            } else {
                ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e.getMessage()));
                ctx.write(this.getHelp());
            }
            return true;
        }
        try {
            if (conn == null || !conn.isValid(10)) {
                ctx.write(Messages.getString("LB_NO_CONNECTION"));
                return true;
            }
        }
        catch (SQLException e) {
            ctx.write(Messages.getString("LB_NO_CONNECTION"));
            return true;
        }
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "true");
        }
        catch (PropertyNotFoundException e) {
            // empty catch block
        }
        String _command = LiquibaseActions.getLbParameter("command");
        boolean _help = LiquibaseActions.getBoolenParameter("help");
        try {
            if (_help) {
                this.showHelp(conn);
            } else if (_command.equalsIgnoreCase("genobject")) {
                if (LiquibaseActions.getLbParameter("type").equalsIgnoreCase("ords")) {
                    LiquibaseActions.genOrdsObjectChangelogWork(conn);
                } else if (LiquibaseActions.getLbParameter("type").equalsIgnoreCase("apex")) {
                    LiquibaseActions.genApexObjectChangelogsWork(conn);
                } else {
                    LiquibaseActions.genDbObjectChangelogWork(conn);
                }
            } else if (_command.equalsIgnoreCase("genschema")) {
                LiquibaseActions.genDbSchemaWork(conn);
            } else if (_command.equalsIgnoreCase("gencontrolfile")) {
                LiquibaseActions.genControlFileWork(conn);
            } else if (_command.equalsIgnoreCase("update")) {
                LiquibaseActions.doUpdateWork(conn, null);
            } else if (_command.equalsIgnoreCase("updatesql")) {
                LiquibaseActions.doUpdateWork(conn, new StringWriter());
            } else if (_command.equalsIgnoreCase("rollback")) {
                LiquibaseActions.doRollbackWork(conn, null);
            } else if (_command.equalsIgnoreCase("rollbacksql")) {
                LiquibaseActions.doRollbackWork(conn, new StringWriter());
            } else if (_command.equalsIgnoreCase("diff")) {
                LiquibaseActions.genDiffWork(conn);
            } else if (_command.equalsIgnoreCase("dbdoc")) {
                LiquibaseActions.genDbDocWork(conn);
            } else if (_command.equalsIgnoreCase("status")) {
                LiquibaseActions.lbStatusWork(conn);
            } else if (_command.equalsIgnoreCase("validate")) {
                LiquibaseActions.lbValidateWork(conn);
            } else if (_command.equalsIgnoreCase("changelogsync")) {
                LiquibaseActions.lbChangeLogSyncWork(conn);
            } else if (_command.equalsIgnoreCase("listlocks")) {
                LiquibaseActions.lbListLocksWork(conn);
            } else if (_command.equalsIgnoreCase("releaselocks")) {
                LiquibaseActions.lbReleaseLocksWork(conn);
            } else if (_command.equalsIgnoreCase("clearchecksums")) {
                LiquibaseActions.lbClearCheckSumsWork(conn);
            } else if (_command.equalsIgnoreCase("data")) {
                LiquibaseActions.genTableDataWork(conn);
            } else if (_command.equalsIgnoreCase("version")) {
                ctx.write(LiquibaseActions.getLbVersion());
            } else {
                ctx.write(this.getHelp());
            }
            ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).resetAllParms();
            return true;
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, Messages.getString("LB_GENERIC_ERROR2"), false);
            if (e instanceof ProcessFailedException) {
                Exception e1 = ((ProcessFailedException)e).getOriginalException();
                ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e1.getMessage()));
                if (e1 instanceof DatabaseException) {
                    ctx.write(e1.getCause().getMessage());
                }
            } else {
                ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e.getMessage()));
            }
            return true;
        }
    }

    public boolean isSqlPlus() {
        return false;
    }

    private String checkArg(String parm) throws ProcessFailedException {
        if (parm == null || parm.startsWith("-")) {
            throw new ProcessFailedException((Exception)new InvalidParameterException("Bad Arguemnt value " + parm), "checkArg");
        }
        return parm;
    }

    private void printArgs(ScriptRunnerContext ctx) {
        System.out.println(Collections.singletonList(LiquibaseActions.getAllLbParameters()));
    }

    private void processArgs(String cmd, ScriptRunnerContext ctx) throws ProcessFailedException {
        SqlclConfig cfg = ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).setContext(ctx);
        cfg.resetAllParms();
        List<String> rawArgs = ArgumentTokenizer.tokenize(cmd, false);
        String[] _args = rawArgs.toArray(new String[0]);
        for (int i = 1; i < _args.length; ++i) {
            try {
                if (!_args[i].startsWith("-")) {
                    if (!commands.contains(_args[i].toLowerCase())) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Unknown command supplied please check your arguments. - " + _args[i]), "processArgs");
                    }
                    if (_args[i].equalsIgnoreCase("help")) {
                        cfg.setLbParameter("help", "true");
                        if (i == 1) {
                            cfg.setLbParameter("command", "help");
                        }
                        continue;
                    }
                    cfg.setLbParameter("command", _args[i].toLowerCase());
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-changelog")) {
                    cfg.setLbParameter("changelog", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-sql")) {
                    cfg.setLbParameter("sql", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-filter")) {
                    cfg.setLbParameter("filter", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-object")) {
                    cfg.setLbParameter("object", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-type")) {
                    cfg.setLbParameter("type", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-name")) {
                    cfg.setLbParameter("name", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-emit_schema")) {
                    cfg.setLbParameter("emit_schema", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-label")) {
                    cfg.setLbParameter("label", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-context")) {
                    cfg.setLbParameter("context", this.checkArg(this.checkArg(_args[++i])));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-count")) {
                    cfg.setLbParameter("count", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-url")) {
                    cfg.setLbParameter("url", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-user")) {
                    cfg.setLbParameter("user", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-password")) {
                    cfg.setLbParameter("password", this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-silent")) {
                    cfg.setLbParameter("silent", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-noreport")) {
                    cfg.setLbParameter("report", "false");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-debug")) {
                    cfg.setLbParameter("debug", "true");
                    cfg.addApexParameter("-debug");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-noenable")) {
                    cfg.setLbParameter("enable", "false");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-noprivs")) {
                    cfg.setLbParameter("privs", "false");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-synonyms")) {
                    cfg.setLbParameter("synonyms", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-grants")) {
                    cfg.setLbParameter("grants", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-log")) {
                    cfg.setLbParameter("log", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-fail")) {
                    cfg.setLbParameter("fail", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-replace")) {
                    cfg.setLbParameter("replace", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-runonchange")) {
                    cfg.setLbParameter("runonchange", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-runalways")) {
                    cfg.setLbParameter("runalways", "true");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-h")) {
                    cfg.addApexParameter("-h");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-db")) {
                    cfg.addApexParameter("-db");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-user")) {
                    cfg.addApexParameter("-user");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-password")) {
                    cfg.addApexParameter("-password");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-workspaceid")) {
                    cfg.addApexParameter("-workspaceid");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-applicationid")) {
                    cfg.addApexParameter("-applicationid");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-skipExportDate")) {
                    cfg.addApexParameter("-skipExportDate");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expPubReports")) {
                    cfg.addApexParameter("-expPubReports");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expSavedReports")) {
                    cfg.addApexParameter("-expSavedReports");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expIRNotif")) {
                    cfg.addApexParameter("-expIRNotif");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expTranslations")) {
                    cfg.addApexParameter("-expTranslations");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-instance")) {
                    cfg.addApexParameter("-instance");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expWorkspace")) {
                    cfg.addApexParameter("-expWorkspace");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expMinimal")) {
                    cfg.addApexParameter("-expMinimal");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expFiles")) {
                    cfg.addApexParameter("-expFiles");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expFeedback")) {
                    cfg.addApexParameter("-expFeedback");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expTeamdevdata")) {
                    cfg.addApexParameter("-expTeamdevdata");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-deploymentSystem")) {
                    cfg.addApexParameter("-deploymentSystem");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expFeedbackSince")) {
                    SimpleDateFormat dtFmt = new SimpleDateFormat("yyyyMMdd");
                    String mydate = "";
                    try {
                        mydate = this.checkArg(_args[++i]);
                        dtFmt.parse(mydate);
                        cfg.addApexParameter("-expFeedbackSince");
                        cfg.addApexParameter(mydate);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad expFeedbackSince " + mydate), "process_args");
                    }
                }
                if (_args[i].equalsIgnoreCase("-expOriginalIds")) {
                    cfg.addApexParameter("-expOriginalIds");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-split")) {
                    cfg.setLbParameter("split", "true");
                    cfg.addApexParameter("-split");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expNoSubscriptions")) {
                    cfg.addApexParameter("-expNoSubscriptions");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expComments")) {
                    cfg.addApexParameter("-expComments");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expSupportingObjects")) {
                    String _expSupportingObjects = this.checkArg(_args[++i]);
                    if (!Arrays.asList("Y", "I", "N").contains(_expSupportingObjects)) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad expSupportingObjects " + this.checkArg(_args[++i])), "process_args");
                    }
                    cfg.addApexParameter("-expSupportingObjects");
                    cfg.addApexParameter(_expSupportingObjects);
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expACLAssignments")) {
                    cfg.addApexParameter("-expACLAssignments");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expLocked")) {
                    cfg.addApexParameter("-expLocked");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-nochecksum")) {
                    cfg.addApexParameter("-nochecksum");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-dir")) {
                    if (i == _args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -dir "), "process_args");
                    }
                    String dir = _args[++i];
                    cfg.addApexParameter("-dir");
                    cfg.addApexParameter(this.checkArg(dir));
                    cfg.setLbParameter("dir", dir);
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-list")) {
                    cfg.addApexParameter("-list");
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-changesSince")) {
                    if (i == _args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -changesSince "), "process_args");
                    }
                    cfg.addApexParameter("-changesSince");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-changesBy")) {
                    if (i == _args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -changesBy "), "process_args");
                    }
                    cfg.addApexParameter("-changesBy");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if (_args[i].equalsIgnoreCase("-expComponents")) {
                    StringBuilder _components = null;
                    while (++i < _args.length) {
                        _components = (_components == null ? new StringBuilder("null") : _components).append("#").append(_args[i]);
                    }
                    cfg.addApexParameter("-expComponents");
                    cfg.addApexParameter(_components == null ? null : _components.toString());
                    continue;
                }
                throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Unknown parameter or bad value supplied " + _args[i]), "process_args");
            }
            catch (Exception e) {
                LbExceptionHandler.handleError(e, null, false);
                if (e instanceof ProcessFailedException) {
                    throw (ProcessFailedException)e;
                }
                throw new ProcessFailedException(e, "process_args");
            }
        }
        String _command = LiquibaseActions.getLbParameter("command");
        if (!(_args.length != 2 || _command.equalsIgnoreCase("genschema") || _command.equalsIgnoreCase("version") || _command.equalsIgnoreCase("data") || _command.equalsIgnoreCase("gencontrolfile") || _command.equalsIgnoreCase("help"))) {
            throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Invalid number or parameters supplied unable to do anything. "), "processArgs");
        }
        if (LiquibaseActions.getBoolenParameter("debug")) {
            this.printArgs(ctx);
        }
    }

    private void showHelp(Connection conn) {
        ScriptRunnerContext ctx = ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getContext();
        String _command = LiquibaseActions.getLbParameter("command");
        String _type = LiquibaseActions.getLbParameter("type");
        if (_command.equalsIgnoreCase("genobject")) {
            if (_type.equalsIgnoreCase("APEX")) {
                ctx.write(Messages.getString("LB_HELP_GENOBJECT_APEX"));
            } else if (_type.equalsIgnoreCase("ORDS")) {
                ctx.write(Messages.getString("LB_HELP_GENOBJECT_ORDS"));
            } else if (!_type.equalsIgnoreCase("")) {
                ctx.write(Messages.getString("LB_HELP_GENOBJECT"));
                ctx.write(Messages.getString("LB_OBJECT_TYPES"));
            } else {
                this.showObjectHelp(ctx, conn);
            }
        } else if (_command.equalsIgnoreCase("genschema")) {
            ctx.write(Messages.getString("LB_HELP_GENSCHEMA"));
        } else if (_command.equalsIgnoreCase("gencontrolfile")) {
            ctx.write(Messages.getString("LB_HELP_GENCONTROLFILE"));
        } else if (_command.equalsIgnoreCase("update")) {
            ctx.write(Messages.getString("LB_HELP_UPDATE"));
        } else if (_command.equalsIgnoreCase("updatesql")) {
            ctx.write(Messages.getString("LB_HELP_UPDATESQL"));
        } else if (_command.equalsIgnoreCase("rollback")) {
            ctx.write(Messages.getString("LB_HELP_ROLLBACK"));
        } else if (_command.equalsIgnoreCase("rollbacksql")) {
            ctx.write(Messages.getString("LB_HELP_ROLLBACKSQL"));
        } else if (_command.equalsIgnoreCase("diff")) {
            ctx.write(Messages.getString("LB_HELP_DIFF"));
        } else if (_command.equalsIgnoreCase("dbdoc")) {
            ctx.write(Messages.getString("LB_HELP_DBDOC"));
        } else if (_command.equalsIgnoreCase("status")) {
            ctx.write(Messages.getString("LB_HELP_STATUS"));
        } else if (_command.equalsIgnoreCase("version")) {
            ctx.write(Messages.getString("LB_HELP_VERSION"));
        } else if (_command.equalsIgnoreCase("validate")) {
            ctx.write(Messages.getString("LB_HELP_VALIDATE"));
        } else if (_command.equalsIgnoreCase("changelogsync")) {
            ctx.write(Messages.getString("LB_HELP_CHANGELOGSYNC"));
        } else if (_command.equalsIgnoreCase("listlocks")) {
            ctx.write(Messages.getString("LB_HELP_LISTLOCKS"));
        } else if (_command.equalsIgnoreCase("releaselocks")) {
            ctx.write(Messages.getString("LB_HELP_RELEASELOCKS"));
        } else if (_command.equalsIgnoreCase("clearchecksums")) {
            ctx.write(Messages.getString("LB_HELP_CLEARCHECKSUMS"));
        } else if (_command.equalsIgnoreCase("data")) {
            ctx.write(Messages.getString("LB_HELP_DATA"));
        } else {
            ctx.write(this.getHelp());
        }
    }

    private void showObjectHelp(ScriptRunnerContext ctx, Connection conn) {
        ctx.write(Messages.getString("LB_HELP_GENOBJECT"));
        ctx.write(Messages.getString("LB_OBJECT_TYPES"));
        ctx.write("==================================================================\n\n");
        ctx.write(Messages.getString("LB_HELP_GENOBJECT_ORDS"));
        ctx.write("==================================================================\n\n");
        ctx.write(Messages.getString("LB_HELP_GENOBJECT_APEX"));
        try {
            if (SchemaGenerator.newApexVersion(conn)) {
                APEXExport.usage((OutputStream)ctx.getOutputStream());
            } else {
                APEXExportV1.usage((OutputStream)ctx.getOutputStream());
            }
        }
        catch (AppNotInstalledException appNotInstalledException) {
            // empty catch block
        }
    }
}

