/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.logging;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.List;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.ext.ora.createoraclesxml.CreateOracleSxmlChange;
import liquibase.ext.ora.createoracletrigger.CreateTriggerChange;
import liquibase.ext.ora.runoraclescript.RunOracleScriptChange;
import liquibase.ext.ora.runoraclescript.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.utils.LbExceptionHandler;
import oracle.dbtools.raptor.liquibase.utils.LbStringUtils;
import oracle.dbtools.raptor.liquibase.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LiquibaseActions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class LogTableManager {
    private static final String LogTriggerSource = "--create log table trigger\nCREATE OR REPLACE TRIGGER databasechangelog_actions_trg BEFORE\r\n    INSERT ON databasechangelog_actions\r\n    FOR EACH ROW\r\nDECLARE\r\n    new_seq  NUMBER;\r\nBEGIN\r\n    SELECT\r\n        nvl(MAX(sequence + 1), 0)\r\n    INTO new_seq\r\n    FROM\r\n        databasechangelog_actions\r\n    WHERE\r\n            id = :new.id\r\n        AND author = :new.author\r\n        AND filename = :new.filename;\r\n\r\n    :new.sequence := new_seq;\r\nEND;\n/\n-- end trigger\n";
    private static final String LogViewsource = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><VIEW xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n   <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>DATABASECHANGELOG_DETAILS</NAME>\r\n   <COL_LIST>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DEPLOYMENT_ID</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>ID</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>AUTHOR</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>FILENAME</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>SQL</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>SXML</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DATEEXECUTED</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>EXECTYPE</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>MD5SUM</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DESCRIPTION</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>COMMENTS</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>LIQUIBASE</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>CONTEXTS</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>LABELS</NAME>\r\n      </COL_LIST_ITEM>\r\n   </COL_LIST>\r\n   <SUBQUERY>SELECT  da.deployment_id,    da.id,    da.author,    da.filename,  da.sql,     da.sxml,    d.dateexecuted,    d.exectype,    d.md5sum,  d.description,    d.comments,    d.liquibase,    d.contexts,    d.labels \r\nFROM databasechangelog d  LEFT JOIN databasechangelog_actions da ON d.id = da.id AND d.author = da.author AND d.filename = da.filename ORDER BY   1,7</SUBQUERY>\r\n</VIEW>";
    private static final String MergeSql = "MERGE INTO databasechangelog_actions tt\r\nUSING databasechangelog st ON ( tt.id = st.id )\r\nWHEN MATCHED THEN UPDATE SET tt.author = st.author,\r\n    tt.filename = st.filename;";
    private static final String LogTableSource = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><TABLE xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>DATABASECHANGELOG_ACTIONS</NAME>\r\n   <RELATIONAL_TABLE>\r\n      <COL_LIST>\r\n         <COL_LIST_ITEM>\r\n            <NAME>ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SEQUENCE</NAME>\r\n            <DATATYPE>NUMBER</DATATYPE>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SQL</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SXML</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>AUTHOR</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>FILENAME</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>DEPLOYMENT_ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>10</LENGTH>\r\n         </COL_LIST_ITEM>\r\n      </COL_LIST>\r\n      <PHYSICAL_PROPERTIES>\r\n         <HEAP_TABLE/>\r\n      </PHYSICAL_PROPERTIES>\r\n   </RELATIONAL_TABLE>\r\n</TABLE>";
    private static final String PkSql = "ALTER TABLE databasechangelog_actions ADD PRIMARY KEY (id,author,filename,sequence);";
    private static final CreateOracleSxmlChange CreateorUpdateLogTableChange = new CreateOracleSxmlChange();
    private static final CreateTriggerChange CreateorUpdateLogTableTriggerChange = new CreateTriggerChange();
    private static final RunOracleScriptChange UpdateLogDataChange = new RunOracleScriptChange();
    private static final RunOracleScriptChange CreatePkChange = new RunOracleScriptChange();
    private static final CreateOracleSxmlChange CreateorUpdateLogViewChange = new CreateOracleSxmlChange();

    public static void createLogView(Connection con, Database db, ScriptRunnerContext ctx) {
        Sql[] sql = null;
        String sqlToRun = null;
        try {
            sql = SqlGeneratorFactory.getInstance().generateSql((Change)CreateorUpdateLogViewChange, db);
            sqlToRun = sql[0].toSql();
            QueryUtils.runSqlReturnResult(sqlToRun, con);
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            ctx.write(MessageFormat.format(Messages.getString("BAD_VIEW_PERMISSION"), e.getMessage()));
        }
    }

    public static void createUpdateLogTable(Database db) throws DatabaseException, ProcessFailedException {
        block16: {
            Connection con = ((JdbcConnection)db.getConnection()).getUnderlyingConnection();
            Sql[] sql = null;
            boolean create = false;
            String sqlToRun = null;
            try {
                if (!LiquibaseActions.getConfig().getCreateActionTable()) break block16;
                DBUtil dbUtil = DBUtil.getInstance((Connection)con);
                String cols = dbUtil.executeReturnOneCol("select count(*) from user_tab_columns where table_name='DATABASECHANGELOG_ACTIONS' ");
                if (cols != null && Integer.parseInt(cols) == 7) {
                    LiquibaseActions.getConfig().setCreateActionTable(false);
                    return;
                }
                create = Integer.parseInt(cols) == 0;
                Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", db);
                if (exec instanceof LoggingExecutor) {
                    exec.execute((Change)CreateorUpdateLogTableChange);
                    if (!create) {
                        exec.execute((Change)UpdateLogDataChange);
                    }
                    exec.execute((Change)CreatePkChange);
                    exec.execute((Change)CreateorUpdateLogTableTriggerChange);
                    exec.execute((Change)CreateorUpdateLogViewChange);
                } else {
                    sql = SqlGeneratorFactory.getInstance().generateSql((Change)CreateorUpdateLogTableChange, db);
                    if (sql.length == 0) {
                        throw new DatabaseException(Messages.getString("BAD_PERMISSION"));
                    }
                    sqlToRun = sql[0].toSql();
                    QueryUtils.runSqlReturnResult(sqlToRun, con);
                    if (!create) {
                        sql = SqlGeneratorFactory.getInstance().generateSql((Change)UpdateLogDataChange, db);
                        sqlToRun = sql[0].toSql();
                        QueryUtils.runSqlReturnResult(sqlToRun, con);
                    }
                    try {
                        sql = SqlGeneratorFactory.getInstance().generateSql((Change)CreatePkChange, db);
                        sqlToRun = sql[0].toSql();
                        QueryUtils.runSqlReturnResult(sqlToRun, con);
                    }
                    catch (Exception e) {
                        try {
                            QueryUtils.runSqlReturnResult("drop table DATABASECHANGELOG_ACTIONS", con);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw e;
                    }
                    try {
                        sql = SqlGeneratorFactory.getInstance().generateSql((Change)CreateorUpdateLogTableTriggerChange, db);
                        sqlToRun = sql[0].toSql();
                        QueryUtils.runSqlReturnResult(sqlToRun, con);
                    }
                    catch (Exception e) {
                        try {
                            QueryUtils.runSqlReturnResult("drop table DATABASECHANGELOG_ACTIONS", con);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
                    }
                }
                LiquibaseActions.getConfig().setCreateActionTable(false);
            }
            catch (DatabaseException e) {
                LbExceptionHandler.handleError((Exception)((Object)e), e.getStackTrace()[1].getMethodName(), true);
                throw e;
            }
        }
    }

    public static String getActionFromActionLog(Database db, String changeId, String author, String filename) throws ProcessFailedException {
        Connection conn = ((JdbcConnection)db.getConnection()).getUnderlyingConnection();
        String actionLogSxmlQuery = QueryUtils.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql();
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            LogTableManager.createUpdateLogTable(db);
            stmt = conn.prepareStatement(actionLogSxmlQuery);
            stmt.setString(1, changeId);
            stmt.setString(2, author);
            stmt.setString(3, filename);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Clob sxml = rs.getClob(1);
                if (sxml == null) {
                    String string = null;
                    return string;
                }
                sb.append(LbStringUtils.clobToString(sxml));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
            }
        }
    }

    public static SqlStatement logAction(String id, String author, String filename, String actions, String sxml, Database database) throws DatabaseException {
        try {
            StringBuffer sb = new StringBuffer();
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            String rawAction = "";
            String rawSxml = "";
            if (actions != null) {
                rawAction = new String(Base64.getEncoder().encode(actions.getBytes()));
            }
            if (sxml != null) {
                rawSxml = new String(Base64.getEncoder().encode(sxml.getBytes()));
            }
            sb.append("-- Logging Oracle Liquibase extension actions to the Database. ");
            sb.append("-- This is a halting action - if we can not log our action all actions ");
            sb.append("-- must stop or we will be unaware of what has occured and unable to undo it. ");
            sb.append("-- You must correct whatever is causing this issue to continue. ");
            sb.append("\n DECLARE ");
            sb.append("\n id varchar2(200) := '" + id + "';");
            sb.append("\n rawAction clob;");
            sb.append("\n rawSxml clob;");
            sb.append("\n myrow varchar2(2000);");
            sb.append("\n action clob := '';");
            sb.append("\n sxml clob := '';");
            sb.append("\n dep varchar2(200) := '" + ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getDeploymentId() + "';");
            sb.append("\n author varchar2(200) := '" + author + "';");
            sb.append("\n filename varchar2(200) := '" + filename + "';");
            sb.append("\n insertlog varchar2(200) := 'insert into DATABASECHANGELOG_ACTIONS (id,author,filename,sql,sxml,deployment_id) values (:id,:author,:filename,:action,:sxml,:dep) returning rowid into :out';");
            sb.append("\n updateaction varchar2(200) := 'update DATABASECHANGELOG_ACTIONS set sql = sql ||:action where rowid = :myrow ';");
            sb.append("\n updatesxml varchar2(200) := 'update DATABASECHANGELOG_ACTIONS set sxml = sxml ||:sxml where rowid = :myrow ';");
            sb.append("\n begin ");
            if (actions == null) {
                sb.append("\n action := '';");
            } else if (rawAction.length() < 32000 && rawSxml.length() < 32000) {
                if (rawAction.length() > 0) {
                    sb.append("\naction := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{" + rawAction + "}')));");
                }
                if (rawSxml.length() > 0) {
                    sb.append("\nsxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{" + rawSxml + "}')));");
                }
                sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep returning into myrow;");
            } else {
                List<String> actionchunks = LbStringUtils.splitString(rawAction, 32000);
                List<String> sxmlchunks = LbStringUtils.splitString(rawSxml, 32000);
                boolean first = true;
                for (String piece : actionchunks) {
                    sb.append("\n rawAction := '" + piece + "';");
                    sb.append("\n action := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawAction)));");
                    if (first) {
                        sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep returning into myrow;");
                        first = false;
                        continue;
                    }
                    sb.append("\n execute immediate updateaction using action,myrow;");
                }
                for (String piece : sxmlchunks) {
                    sb.append("\n rawSxml := '" + piece + "';");
                    sb.append("\n sxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawSxml)));");
                    sb.append("\n execute immediate updatesxml using sxml,myrow;\n");
                }
            }
            sb.append("\nend;");
            if (exec instanceof LoggingExecutor) {
                sb.append("\n/        --\n");
            }
            RunOracleScriptStatement stmt = new RunOracleScriptStatement();
            stmt.setObjectName("logAction");
            stmt.setObjectOwner(author);
            stmt.setUseScriptRunner(true);
            stmt.setSource(sb.toString());
            stmt.setSourceType("STRING");
            stmt.setContinueOnError(false);
            return stmt;
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            throw e;
        }
    }

    static {
        CreateorUpdateLogTableChange.setSource(LogTableSource);
        CreateorUpdateLogTableChange.setObjectName("DATABASECHANGELOG_ACTIONS");
        CreateorUpdateLogTableChange.setObjectType("TABLE");
        CreateorUpdateLogTableTriggerChange.setSource(LogTriggerSource);
        CreateorUpdateLogTableTriggerChange.setObjectType("TRIGGER");
        CreateorUpdateLogTableTriggerChange.setObjectName("DATABASECHANGELOG_ACTIONS_TRG");
        CreateorUpdateLogViewChange.setSource(LogViewsource);
        CreateorUpdateLogViewChange.setObjectName("DATABASECHANGELOG_DETAILS");
        CreateorUpdateLogViewChange.setObjectType("VIEW");
        UpdateLogDataChange.setSource(MergeSql);
        UpdateLogDataChange.setSourceType("STRING");
        CreatePkChange.setSource(PkSql);
        CreatePkChange.setSourceType("STRING");
    }
}

