/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporaclepublicsynonym;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporaclepublicsynonym.DropPublicSynonymStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOraclePublicSynonym", description="Drop oracle public synonym", priority=1)
public class DropPublicSynonymChange
extends AbstractCommonPlSqlChange {
    public DropPublicSynonymChange() {
        this.setObjectType("PUBLIC_SYNONYM");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Public Synonym {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropPublicSynonymStatement statement = new DropPublicSynonymStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

