/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporaclepackagespec;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporaclepackagespec.DropPackageSpecStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOraclePackageSpec", description="Drop oracle package", priority=1)
public class DropPackageSpecChange
extends AbstractCommonPlSqlChange {
    public DropPackageSpecChange() {
        this.setObjectType("PACKAGE_SPEC");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Package {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropPackageSpecStatement statement = new DropPackageSpecStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setReplaceIfExists(this.getReplaceIfExists());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

