/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporacledirectory;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporacledirectory.DropDirectoryStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOracleDirectory", description="Drop oracle directory", priority=1)
public class DropDirectoryChange
extends AbstractCommonPlSqlChange {
    public DropDirectoryChange() {
        this.setObjectType("DIRECTORY");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Directory {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropDirectoryStatement statement = new DropDirectoryStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

