/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporacledblink;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporacledblink.DropDbLinkStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOracleSynonym", description="Drop oracle synonym", priority=1)
public class DropDbLinkChange
extends AbstractCommonPlSqlChange {
    public DropDbLinkChange() {
        this.setObjectType("DB_LINK");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Database Link {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropDbLinkStatement statement = new DropDbLinkStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

