/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporacleconstraint;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporacleconstraint.DropConstraintStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOracleConstraint", description="Drop oracle Constraint", priority=1)
public class DropConstraintChange
extends AbstractCommonPlSqlChange {
    public DropConstraintChange() {
        this.setObjectType("CONSTRAINT");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Constraint {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropConstraintStatement statement = new DropConstraintStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

