/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoracletypespec;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoracletypespec.CreateTypeSpecStatement;
import liquibase.ext.ora.droporacletypespec.DropTypeSpecChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleTypeSpec", description="Create oracle Type", priority=1)
public class CreateTypeSpecChange
extends AbstractCommonPlSqlChange {
    public CreateTypeSpecChange() {
        this.setObjectType("TYPE_SPEC");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Type {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateTypeSpecStatement stmt = new CreateTypeSpecStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropTypeSpecChange inverse = new DropTypeSpecChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

