/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoracletrigger;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoracletrigger.CreateTriggerStatement;
import liquibase.ext.ora.droporacletrigger.DropTriggerChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleTrigger", description="CREATE ORACLE TRIGGER", priority=1)
public class CreateTriggerChange
extends AbstractCommonPlSqlChange {
    public CreateTriggerChange() {
        this.setObjectType("TRIGGER");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Trigger {0} Created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateTriggerStatement stmt = new CreateTriggerStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(this.getReplaceIfExists());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropTriggerChange inverse = new DropTriggerChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

