/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclesynonym;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoraclesynonym.CreateSynonymStatement;
import liquibase.ext.ora.droporacleynonym.DropSynonymChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleSynonym", description="Create oracle synonym", priority=1)
public class CreateSynonymChange
extends AbstractCommonPlSqlChange {
    public CreateSynonymChange() {
        this.setObjectType("SYNONYM");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Synonym {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateSynonymStatement stmt = new CreateSynonymStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(this.getReplaceIfExists());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropSynonymChange inverse = new DropSynonymChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

