/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclepublicsynonym;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoraclepublicsynonym.CreatePublicSynonymStatement;
import liquibase.ext.ora.droporaclepublicsynonym.DropPublicSynonymChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOraclePublicSynonym", description="Create oracle Publicsynonym", priority=1)
public class CreatePublicSynonymChange
extends AbstractCommonPlSqlChange {
    public CreatePublicSynonymChange() {
        this.setObjectType("SYNONYM");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Public Synonym {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreatePublicSynonymStatement stmt = new CreatePublicSynonymStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropPublicSynonymChange inverse = new DropPublicSynonymChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

