/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoracleprocedure;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoracleprocedure.CreateProcedureStatement;
import liquibase.ext.ora.droporacleprocedure.DropProcedureChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleProcedure", description="Create oracle procedure", priority=1)
public class CreateProcedureChange
extends AbstractCommonPlSqlChange {
    public CreateProcedureChange() {
        this.setObjectType("PROCEDURE");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Procedure {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateProcedureStatement stmt = new CreateProcedureStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropProcedureChange inverse = new DropProcedureChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

