/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclepackagespec;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoraclepackagespec.CreatePackageSpecStatement;
import liquibase.ext.ora.droporaclepackagespec.DropPackageSpecChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOraclePackageSpec", description="Create oracle Package Spec", priority=1)
public class CreatePackageSpecChange
extends AbstractCommonPlSqlChange {
    public CreatePackageSpecChange() {
        this.setObjectType("PACKAGE_SPEC");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Package Spec {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreatePackageSpecStatement stmt = new CreatePackageSpecStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setObjectType(this.getObjectType());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropPackageSpecChange inverse = new DropPackageSpecChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setObjectType(this.getObjectType());
        inverse.setReplaceIfExists(this.getReplaceIfExists());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

