/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclejob;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoraclejob.CreateJobStatement;
import liquibase.ext.ora.droporaclejob.DropJobChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleJob", description="CREATE ORACLE JOB", priority=1)
public class CreateJobChange
extends AbstractCommonPlSqlChange {
    public CreateJobChange() {
        this.setObjectType("JOB");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Job {0} Created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateJobStatement stmt = new CreateJobStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropJobChange inverse = new DropJobChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

