/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclefunction;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoraclefunction.CreateFunctionStatement;
import liquibase.ext.ora.droporaclefunction.DropFunctionChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleFunction", description="Create oracle function", priority=1)
public class CreateFunctionChange
extends AbstractCommonPlSqlChange {
    public CreateFunctionChange() {
        this.setObjectType("FUNCTION");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Function {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateFunctionStatement stmt = new CreateFunctionStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropFunctionChange inverse = new DropFunctionChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

