/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoracledirectory;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoracledirectory.CreateDirectoryStatement;
import liquibase.ext.ora.droporacledirectory.DropDirectoryChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleDirectory", description="Create oracle diretory", priority=1)
public class CreateDirectoryChange
extends AbstractCommonPlSqlChange {
    public CreateDirectoryChange() {
        this.setObjectType("DIRECTORY");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Directory {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateDirectoryStatement stmt = new CreateDirectoryStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropDirectoryChange inverse = new DropDirectoryChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

