/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.abstractplsqlobject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import liquibase.database.Database;
import liquibase.database.ext.OracleDatabaseV2;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.runoraclescript.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.utils.LbMetaUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LiquibaseActions;

public abstract class AbstractCommonPlSqlGenerator<StatementType extends SqlStatement>
extends AbstractSqlGenerator<AbstractCommonPlSqlStatement> {
    public abstract ACTIONS createOrDrop();

    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        if (statement.getObjectType() != null && (statement.getObjectType().equalsIgnoreCase("COMMENT") || statement.getObjectType().equalsIgnoreCase("REF_CONSTRAINT"))) {
            return new Sql[]{new UnparsedSql("REM no rollback on this object currently available --", new DatabaseObject[0])};
        }
        if (this.createOrDrop().equals((Object)ACTIONS.CREATE)) {
            return this.createSql(statement, database);
        }
        try {
            return this.dropSql(statement, database);
        }
        catch (Exception e) {
            return null;
        }
    }

    public abstract boolean supports(AbstractCommonPlSqlStatement var1, Database var2);

    public ValidationErrors validate(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("ownerName", (Object)statement.getOwnerName());
        if (statement instanceof AbstractCommonPlSqlStatement && ((Object)((Object)statement)).getClass().getSimpleName().startsWith("Create")) {
            validationErrors.checkRequiredField("source", (Object)statement.getSource());
        }
        if (statement instanceof RunOracleScriptStatement) {
            if (statement.getSourceType() != null && statement.getSourceType().toUpperCase().equals("STRING")) {
                validationErrors.checkRequiredField("source", (Object)statement.getSource());
            } else if (statement.getSourceType() != null && statement.getSourceType().toUpperCase().equals("FILE")) {
                Path cwd = null;
                Path path = null;
                try {
                    cwd = Paths.get(FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext()), new String[0]).toAbsolutePath();
                    path = cwd.resolve(statement.getSource());
                    new String(Files.readAllBytes(path));
                }
                catch (Exception e) {
                    if (LiquibaseActions.getBoolenParameter("debug")) {
                        LiquibaseActions.getContext().write("cwd      - " + cwd.toString() + "\n");
                        LiquibaseActions.getContext().write("relative - " + path.toString() + "\n");
                        e.printStackTrace();
                    }
                    validationErrors.addError("generateSql unable to find and load file, check paths");
                }
            } else if (statement.getSourceType() != null && statement.getSourceType().toUpperCase().equals("URL")) {
                URL url = null;
                URI uri = null;
                URL fileURL = null;
                try {
                    url = new URL(statement.getSource());
                    uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                    fileURL = uri.toURL();
                    BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                    in.close();
                }
                catch (Exception e) {
                    validationErrors.addError("generateSql unable to find and load file, check urls");
                }
            } else {
                validationErrors.addError("Invalid source type :" + statement.getSourceType());
            }
        }
        return validationErrors;
    }

    private Sql[] createSql(AbstractCommonPlSqlStatement statement, Database database) {
        if (database instanceof OracleDatabaseV2) {
            return LbMetaUtils.getCreateSqlPlSql(statement, database);
        }
        return null;
    }

    private Sql[] dropSql(AbstractCommonPlSqlStatement statement, Database database) throws ProcessFailedException {
        if (database instanceof OracleDatabaseV2) {
            return LbMetaUtils.getDropSqlPlSql(statement, database);
        }
        return null;
    }

    protected static enum ACTIONS {
        CREATE,
        DROP;

    }
}

