/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.oci;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.dbtools.oci.OCIRESTClient;

public class OCIProfiles {
    private static final String PKCS_1_PEM_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String PKCS_1_PEM_FOOTER = "-----END RSA PRIVATE KEY-----";
    private static final String PKCS_8_PEM_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PKCS_8_PEM_FOOTER = "-----END PRIVATE KEY-----";
    private ArrayList<String> _sections = new ArrayList();
    private Properties profiles = null;

    public ArrayList<String> getProfiles() throws IOException {
        this._sections.clear();
        this.load();
        return this._sections;
    }

    public OCIRESTClient getOciClient(String section) throws IOException {
        this.getProfiles();
        OCIRESTClient client = new OCIRESTClient.Builder().authUserId(this.profiles.getProperty(section + "/user")).keyFingerprint(this.profiles.getProperty(section + "/fingerprint")).tenancyId(this.profiles.getProperty(section + "/tenancy")).privateKeyPath(this.profiles.getProperty(section + "/key_file")).build();
        return client;
    }

    private File findOciConfig() {
        File ociConfig = null;
        if (null == ociConfig) {
            ociConfig = this.getReadable(this.getVar("OCI_SQLCL_CONFIG_FILE"));
        }
        if (null == ociConfig) {
            Path path = FileSystems.getDefault().getPath(System.getProperty("user.home"), ".oci", "config");
            String candidate = path.toString();
            ociConfig = this.getReadable(candidate);
        }
        if (null == ociConfig) {
            ociConfig = this.getReadable(this.getVar("OCI_CLI_CONFIG_FILE"));
        }
        if (null == ociConfig) {
            ociConfig = this.getReadable(this.getVar("OCI_CONFIG_FILE"));
        }
        return ociConfig;
    }

    private String getVar(String var) {
        String value = System.getProperty(var);
        if (null == value) {
            value = System.getenv(var);
        }
        return value;
    }

    private File getReadable(String path) {
        try {
            File file = new File(path);
            if (file.canRead()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void load() throws IOException {
        File ociConfig = this.findOciConfig();
        if (null == ociConfig) {
            throw new IOException("Cannot find oci config in OCI_SQLCL_CONFIG_FILE, ~/.oci/config, OCI_CLI_CONFIG_FILE, OCI_CONFIG_FILE");
        }
        FileReader reader = new FileReader(ociConfig);
        this.profiles = new Properties(){
            private String section = "ROOT";

            @Override
            public Object put(Object key, Object value) {
                String header = ((String)key + " " + value).trim();
                if (header.startsWith("[") && header.endsWith("]")) {
                    OCIProfiles.this._sections.add(header.substring(1, header.length() - 1));
                    this.section = header.substring(1, header.length() - 1);
                    return this.section;
                }
                return super.put(this.section + "/" + key, value);
            }
        };
        this.profiles.load(reader);
    }

    public Properties getProperties() throws IOException {
        this.getProfiles();
        return this.profiles;
    }

    public String getPrivateKey(String keyFilePath) throws GeneralSecurityException, IOException {
        return this.loadKeyFile(keyFilePath);
    }

    public String loadKeyFile(String keyFilePath) throws GeneralSecurityException, IOException {
        byte[] keyDataBytes = Files.readAllBytes(Paths.get(keyFilePath, new String[0]));
        return this.loadKey(new String(keyDataBytes, StandardCharsets.UTF_8));
    }

    public String loadKey(String keyDataString) throws GeneralSecurityException, IOException {
        if ((keyDataString = keyDataString.replaceAll("\n", "")).contains(PKCS_1_PEM_HEADER)) {
            keyDataString = keyDataString.replace(PKCS_1_PEM_HEADER, "");
            keyDataString = keyDataString.replace(PKCS_1_PEM_FOOTER, "");
        }
        if (keyDataString.contains(PKCS_8_PEM_HEADER)) {
            keyDataString = keyDataString.replace(PKCS_8_PEM_HEADER, "");
            keyDataString = keyDataString.replace(PKCS_8_PEM_FOOTER, "");
        }
        return keyDataString;
    }
}

