/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http.auth.basic;

import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.HttpResources;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.http.auth.Authentication;
import oracle.dbtools.http.auth.AuthenticationEngine;
import oracle.dbtools.http.auth.AuthenticationFailedException;
import oracle.dbtools.http.auth.basic.BasicAuthenticationHandler;
import oracle.dbtools.util.Logger;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.RequestLine;

public abstract class BasicAuthenticationEngine
implements AuthenticationEngine {
    private static final String GRANT_TYPE = "grant_type";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final Charset ENCODING_UTF8 = Charset.forName("UTF-8");
    private Client m_client;

    protected BasicAuthenticationEngine() {
    }

    @Override
    public final void init(Client client) {
        this.m_client = client;
    }

    @Override
    public Authentication authenticate(SessionInfo conn) throws AuthenticationFailedException {
        HttpPost post = this.createPost(conn);
        HttpEntity content = this.promptForAuthentication(conn);
        post.setEntity(content);
        return this.doPost(post);
    }

    private HttpPost createPost(SessionInfo conn) throws AuthenticationFailedException {
        SessionType type = this.m_client.getConnectionType();
        URI path = type.getAuthenticationURI(conn);
        HttpPost post = new HttpPost(path);
        this.signRequest((HttpRequest)post);
        return post;
    }

    @Override
    public Authentication reauthenticate(Authentication auth, SessionInfo conn) throws AuthenticationFailedException {
        HttpPost post = this.createPost(conn);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(GRANT_TYPE, "refresh_token"));
        params.add(new BasicNameValuePair("refresh_token", auth.getRefreshToken()));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, ENCODING_UTF8));
        return this.doPost(post);
    }

    protected abstract HttpEntity promptForAuthentication(SessionInfo var1) throws AuthenticationFailedException;

    private void signRequest(HttpRequest request) throws AuthenticationFailedException {
        SessionType type = this.m_client.getConnectionType();
        type.signRequest(request);
    }

    private Authentication doPost(HttpPost post) throws AuthenticationFailedException {
        StringBuilder sb = new StringBuilder(new RequestLine((HttpRequest)post).toString());
        this.log(sb.toString());
        try {
            return this.m_client.executeRequest((HttpUriRequest)post, new BasicAuthenticationHandler());
        }
        catch (AuthenticationFailedException e) {
            throw e;
        }
        catch (ClientProtocolException e) {
            throw new AuthenticationFailedException(e);
        }
        catch (UnknownHostException e) {
            throw new AuthenticationFailedException(HttpResources.format("MESSAGE_UNKNOWN_HOST", e.getMessage()));
        }
        catch (IOException e) {
            throw new AuthenticationFailedException(e);
        }
    }

    private void log(String s) {
        Logger.fine(AuthenticationEngine.class, (String)s);
    }

    protected final HttpEntity createEntity(String username, String pwdString) throws AuthenticationFailedException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(GRANT_TYPE, PASSWORD));
        params.add(new BasicNameValuePair(USERNAME, username));
        params.add(new BasicNameValuePair(PASSWORD, pwdString));
        return new UrlEncodedFormEntity(params, ENCODING_UTF8);
    }

    protected final Client getClient() {
        return this.m_client;
    }

    protected HttpEntity authenticateHeadless(SessionInfo conn) throws AuthenticationFailedException {
        String connName = conn.getName();
        String username = conn.getUsername();
        if (username == null) {
            throw new AuthenticationFailedException(HttpResources.format("ERROR_NO_USERNAME", connName));
        }
        char[] pwd = conn.getPassword();
        if (pwd == null || pwd.length == 0) {
            throw new AuthenticationFailedException(HttpResources.format("ERROR_NO_PWD", connName));
        }
        return this.createEntity(username, new String(pwd));
    }
}

