/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.utility;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.dbtools.util.Logger;

public class RunnableTimer {
    private static DecimalFormat df = new DecimalFormat("#00.0000");
    protected String name;
    protected Runnable runnable;
    protected Level logLevel = Level.INFO;
    protected boolean elapsedOnly;

    private RunnableTimer() {
    }

    public static void time(String name, Runnable runnable) {
        RunnableTimer timer = new RunnableTimer(name, runnable);
        timer.setLogLevel(Level.INFO);
        timer.setElapsedOnly(false);
        timer.timeIt();
    }

    public void setLogLevel(Level level) {
        this.logLevel = level;
    }

    public void setElapsedOnly(boolean flag) {
        this.elapsedOnly = flag;
    }

    public RunnableTimer(String aName, Runnable aRunnable) {
        this();
        this.name = aName;
        this.runnable = aRunnable;
    }

    public void timeIt() {
        long start = System.nanoTime();
        if (!this.elapsedOnly) {
            this.out(this.name + " [");
        }
        this.runnable.run();
        long now = System.nanoTime();
        long duration = now - start;
        double elapsed = (double)duration / 1.0E9;
        this.out((this.elapsedOnly ? "" : "] ") + this.name + " elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n");
    }

    protected void out(String msg) {
        Logger.log(RunnableTimer.class, (Level)this.logLevel, (String)msg, null);
    }

    public static String asHMSS(long nanos) {
        String hms = String.format("%02d:%02d:%02d.%03d", TimeUnit.NANOSECONDS.toHours(nanos), TimeUnit.NANOSECONDS.toMinutes(nanos) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.NANOSECONDS.toSeconds(nanos) % TimeUnit.MINUTES.toSeconds(1L), TimeUnit.NANOSECONDS.toMillis(nanos) % TimeUnit.SECONDS.toMillis(1L));
        return hms;
    }
}

