/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ProxySelector;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.LocationTestInfo;
import oracle.dbtools.transfer.location.OracleSwiftObjectStorageFactory;
import oracle.dbtools.transfer.location.OracleSwiftObjectStorageInfo;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTask;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.InputStreamProgressWrapper;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.RunnableTimer;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.utility.SimpleByteProgressMonitor;
import oracle.dbtools.transfer.utility.URIEncoder;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.encoding.EncodingException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.util.Timeout;

public class OracleSwiftObjectStorage
extends Location {
    private static final Class<?> clazz = OracleSwiftObjectStorage.class;
    private static final String USER_AGENT = clazz.getCanonicalName() + "/19.1";
    private String namespaceUrl;
    private String user;
    private byte[] userData;
    private CloseableHttpClient client;
    private static OracleSwiftObjectStorageFactory FACTORY = null;
    private static boolean DUMMY;
    private static String BUCKET_NAME;
    private static String filePath2;
    private boolean taskDone = false;
    private static DecimalFormat df;

    public OracleSwiftObjectStorage(String namespaceUrl, String user) {
        assert (namespaceUrl != null);
        assert (user != null);
        this.namespaceUrl = namespaceUrl;
        if (!this.namespaceUrl.endsWith("/")) {
            this.namespaceUrl = this.namespaceUrl + "/";
        }
        this.user = user;
    }

    public void setPassword(String userData) throws IOException {
        assert (userData != null);
        this.userData = (this.user + ":" + userData).getBytes();
    }

    @Override
    public Location clone() {
        OracleSwiftObjectStorage clone = new OracleSwiftObjectStorage(this.namespaceUrl, this.user);
        clone.userData = this.userData;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectImpl() throws IOException {
        if (null == this.userData) {
            throw new UnsupportedOperationException("Password must be set before calling connect");
        }
        if (!this.namespaceUrl.substring(0, 8).equalsIgnoreCase("https://")) {
            throw new UnsupportedOperationException("Protocol MUST be https");
        }
        try {
            if (null == this.client) {
                this.init();
            }
        }
        catch (Throwable t) {
            String msg = "Unable to create client";
            Logger.severe(this.getClass(), (String)msg, (Throwable)t);
            throw new IOException(msg, t);
        }
        try {
            HttpGet httpget = this.signMessage(new HttpGet(URIEncoder.toASCIIString(this.namespaceUrl)));
            try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)httpget);){
                if (200 != response.getCode()) {
                    String msg = response.getReasonPhrase();
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        msg = msg + " - " + EntityUtils.toString((HttpEntity)entity);
                    }
                    throw new IOException(msg);
                }
            }
            Logger.info(this.getClass(), (String)this.namespaceUrl);
        }
        catch (Throwable t) {
            throw OracleSwiftObjectStorage.asIOException(t);
        }
    }

    private void init() {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)60000L)).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        connMgr.setDefaultSocketConfig(socketConfig);
        connMgr.setDefaultMaxPerRoute(10);
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)connMgr);
        builder.setUserAgent(USER_AGENT);
        this.initProxy();
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        this.client = builder.build();
    }

    protected void initProxy() {
    }

    @Override
    public void disconnect() {
        this.userData = null;
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                Logger.warn(this.getClass(), (Throwable)e);
            }
        }
        Logger.info(this.getClass(), (String)this.namespaceUrl);
    }

    @Override
    public InputStream asInputStream(Path path, long position, long size) throws IOException {
        return this.asInputStream(path, position, size, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream asInputStream(Path path, long position, long size, TransferTaskProgressMonitor progressMonitor) throws IOException {
        InputStream in = null;
        try {
            String name = path.getFileName().toString();
            String bucket = path.getParent().getFileName().toString();
            HttpGet httpget = this.signMessage(new HttpGet(URIEncoder.toASCIIString(this.namespaceUrl + bucket + '/' + name)));
            boolean rangedRequest = false;
            if (size > 0L) {
                String range = "bytes=" + position + '-' + (position + size - 1L);
                httpget.addHeader("Range", (Object)range);
                rangedRequest = true;
            }
            final CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)httpget);
            try {
                if (200 != response.getCode()) {
                    throw new IOException(String.valueOf(response.getReasonPhrase()));
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    MessageDigest md5MessageDigest;
                    String md5Promised;
                    Header objectManifestHeader;
                    in = entity.getContent();
                    if (progressMonitor != null) {
                        String length = response.getFirstHeader("Content-Length").getValue();
                        long len = null == length ? -1L : Long.parseLong(length);
                        in = new InputStreamProgressWrapper(in, progressMonitor, len);
                    }
                    if ((objectManifestHeader = response.getFirstHeader("x-object-meta-X-Object-Manifest")) != null) {
                        rangedRequest = true;
                    }
                    String string = md5Promised = rangedRequest ? null : response.getFirstHeader("ETag").getValue();
                    if (md5Promised != null && !md5Promised.startsWith("\"")) {
                        md5MessageDigest = MD5.getMessageDigest();
                        in = new DigestInputStream(in, md5MessageDigest);
                    } else {
                        md5MessageDigest = null;
                    }
                    in = new FilterInputStream(in){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            response.close();
                            if (md5Promised != null && !md5Promised.startsWith("\"")) {
                                String md5Received = MD5.convertByteArrayToHexString(md5MessageDigest.digest());
                                if (!md5Promised.equals(md5Received)) {
                                    throw new IOException(String.format("\n\tMD5 %s\n\t!=  %s", md5Promised, md5Received));
                                }
                                Logger.info(this.getClass(), (String)String.format("MD5 %s == %s", md5Promised, md5Received));
                            }
                        }
                    };
                }
            }
            finally {
                if (null == in) {
                    response.close();
                }
            }
        }
        catch (Throwable t) {
            throw OracleSwiftObjectStorage.asIOException(t);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copy(InputStream in, String target, TransferTaskProgressMonitor progressMonitor, CopyOption ... options) throws IOException {
        long len = in.available();
        double size = (double)len / 1048576.0;
        Logger.info(this.getClass(), (String)(in + ", " + target + ", " + Arrays.toString(options) + ", len=" + size + " MiB"));
        try {
            CloseableHttpResponse response;
            MessageDigest md5MessageDigest;
            block6: {
                FilterInputStream inw = new InputStreamProgressWrapper(in, progressMonitor, len);
                md5MessageDigest = MD5.getMessageDigest();
                inw = new DigestInputStream(inw, md5MessageDigest);
                InputStreamEntity entity = new InputStreamEntity((InputStream)inw, len, ContentType.APPLICATION_OCTET_STREAM);
                HttpPut httpput = this.signMessage(new HttpPut(URIEncoder.toASCIIString(this.namespaceUrl + target)));
                httpput.setEntity((HttpEntity)entity);
                response = this.client.execute((ClassicHttpRequest)httpput);
                try {
                    if (201 == response.getCode()) break block6;
                    throw new IOException(String.valueOf(response.getReasonPhrase()));
                }
                catch (Throwable throwable) {
                    String md5Promised = MD5.convertByteArrayToHexString(md5MessageDigest.digest());
                    String md5Received = response.getFirstHeader("ETag").getValue();
                    response.close();
                    if (!md5Promised.equals(md5Received)) {
                        throw new IOException(String.format("\n\tMD5 %s\n\t!=  %s", md5Promised, md5Received));
                    }
                    Logger.info(this.getClass(), (String)String.format("MD5 %s == %s", md5Promised, md5Received));
                    throw throwable;
                }
            }
            String md5Promised = MD5.convertByteArrayToHexString(md5MessageDigest.digest());
            String md5Received = response.getFirstHeader("ETag").getValue();
            response.close();
            if (!md5Promised.equals(md5Received)) {
                throw new IOException(String.format("\n\tMD5 %s\n\t!=  %s", md5Promised, md5Received));
            }
            Logger.info(this.getClass(), (String)String.format("MD5 %s == %s", md5Promised, md5Received));
        }
        catch (Throwable t) {
            throw OracleSwiftObjectStorage.asIOException(t);
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String target) throws IOException {
        Logger.info(this.getClass(), (String)target);
        try {
            HttpDelete httpdelete = this.signMessage(new HttpDelete(URIEncoder.toASCIIString(this.namespaceUrl + target)));
            try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)httpdelete);){
                if (204 != response.getCode()) {
                    throw new IOException(String.valueOf(response.getReasonPhrase()));
                }
            }
        }
        catch (Throwable t) {
            throw OracleSwiftObjectStorage.asIOException(t);
        }
    }

    @Override
    public ScriptOutput logExecuteScript(String tagName, String executeScriptStr, String scriptName, String targetDir) {
        return super.logExecuteScript(tagName, executeScriptStr, scriptName, targetDir);
    }

    @Override
    public ScriptOutput executeScript(String executeScriptStr, String scriptName, String targetDir) {
        return super.executeScript(executeScriptStr, scriptName, targetDir);
    }

    @Override
    public MD5 getMd5(Path path, long offset, long size) {
        return super.getMd5(path, offset, size);
    }

    @Override
    public String toString() {
        return this.user + '@' + this.namespaceUrl + ' ' + super.toString();
    }

    @Override
    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        return super.doPreProcessing(transferId, fileInfos, targetDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPostProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException, TransferRestartRequest {
        CloseableHttpResponse response = null;
        boolean restartRequired = false;
        try {
            String container = targetDir;
            if (!container.endsWith("/")) {
                container = container + '/';
            }
            for (FileInfo fileInfo : fileInfos) {
                HashMap<String, FileChunk> chunkMap = new HashMap<String, FileChunk>();
                for (FileChunk chunk : fileInfo.getFileChunks()) {
                    chunkMap.put(chunk.getName(), chunk);
                }
                for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                    HttpHead httphead = this.signMessage(new HttpHead(URIEncoder.toASCIIString(this.namespaceUrl + container + fileChunk.getName())));
                    response = this.client.execute((ClassicHttpRequest)httphead);
                    try {
                        if (200 != response.getCode()) continue;
                        String rmd5 = response.getFirstHeader("ETag").getValue();
                        fileChunk.calculateMd5();
                        String fmd5 = fileChunk.getMd5();
                        if (!ModelUtil.areEqual((Object)rmd5, (Object)fmd5)) continue;
                        fileChunk.setTransferred(true);
                        chunkMap.remove(fileChunk.getName());
                    }
                    finally {
                        response.close();
                    }
                }
                if (chunkMap.isEmpty()) {
                    if (fileInfo.getFileChunks().size() <= 1) continue;
                    String name = fileInfo.getPath().getFileName().toString();
                    String manifestValue = container + name + '-';
                    MD5 md5 = new MD5();
                    StringBuilder sb = new StringBuilder();
                    for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                        sb.append(fileChunk.getMd5());
                    }
                    String manifestETag = md5.calculate(sb.toString().getBytes(StandardCharsets.UTF_8));
                    Logger.info(this.getClass(), (String)("manifestETag = " + manifestETag));
                    String fileETag = fileInfo.getMd5();
                    Logger.info(this.getClass(), (String)("fileETag = " + fileETag));
                    HttpPut httpput = this.signMessage(new HttpPut(URIEncoder.toASCIIString(this.namespaceUrl + container + name)));
                    httpput.addHeader("X-Object-Manifest", (Object)manifestValue);
                    httpput.setEntity((HttpEntity)new StringEntity(""));
                    response = this.client.execute((ClassicHttpRequest)httpput);
                    try {
                        if (201 != response.getCode()) {
                            restartRequired = true;
                            String msg = response.getReasonPhrase();
                            HttpEntity entity = response.getEntity();
                            if (entity != null) {
                                msg = msg + " - " + EntityUtils.toString((HttpEntity)entity);
                            }
                            throw new IOException(msg);
                        }
                        String md5Received = response.getFirstHeader("ETag").getValue();
                        Logger.info(this.getClass(), (String)("md5Received = " + md5Received));
                    }
                    finally {
                        response.close();
                    }
                    fileInfo.setTransferred(true);
                    continue;
                }
                restartRequired = true;
            }
        }
        catch (Throwable t) {
            throw OracleSwiftObjectStorage.asIOException(t);
        }
        if (restartRequired) {
            throw new TransferRestartRequest();
        }
    }

    private <T extends BasicClassicHttpRequest> T signMessage(T message) throws IOException, EncodingException {
        message.addHeader("Authorization", (Object)String.format("Basic %s", Base64.getEncoder().encodeToString(this.userData)));
        return message;
    }

    public static void registerFactory(OracleSwiftObjectStorageFactory factory) {
        FACTORY = factory;
    }

    public static String getNamespaceUrl(String swiftUrl) {
        return OracleSwiftObjectStorage.getPartialUrl(swiftUrl, 2);
    }

    public static String getBucketUrl(String swiftUrl) {
        return OracleSwiftObjectStorage.getPartialUrl(swiftUrl, 3);
    }

    private static String getPartialUrl(String swiftUrl, int pathSegments) {
        int count = pathSegments + 2;
        if (count == OracleSwiftObjectStorage.countStringInString("/", swiftUrl)) {
            return swiftUrl;
        }
        int index = OracleSwiftObjectStorage.nthIndexOfStringInString(count + 1, "/", swiftUrl);
        if (index > -1) {
            return swiftUrl.substring(0, index);
        }
        return null;
    }

    private static int countStringInString(String search, String target) {
        int index = 0;
        int count = 0;
        while (index > -1) {
            if ((index = target.indexOf(search, index + 1)) <= 0) continue;
            ++count;
        }
        return count;
    }

    private static int nthIndexOfStringInString(int n, String search, String target) {
        int index = -1;
        while (n > 0 && (index = target.indexOf(search, index + 1)) >= 0) {
            --n;
        }
        return index;
    }

    public static OracleSwiftObjectStorage find(String swiftUrl) {
        if (null == FACTORY) {
            return null;
        }
        return FACTORY.find(OracleSwiftObjectStorage.getNamespaceUrl(swiftUrl));
    }

    public static LocationTestInfo testBucketUrl(String swiftBucketUrl) {
        return OracleSwiftObjectStorage.testBucketUrl(swiftBucketUrl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationTestInfo testBucketUrl(String swiftBucketUrlIn, boolean promptUserForAdd) {
        Logger.info(clazz, (String)(swiftBucketUrlIn + ' ' + String.valueOf(promptUserForAdd)));
        String swiftBucketUrl = OracleSwiftObjectStorage.getBucketUrl(swiftBucketUrlIn);
        LocationTestInfo result = new LocationTestInfo();
        try {
            if (null == FACTORY) {
                result.setResult(LocationTestInfo.Result.NO_FACTORY);
                return result;
            }
            OracleSwiftObjectStorageInfo info = FACTORY.getInfo(swiftBucketUrl);
            if (!info.isEnabled()) {
                result.setResult(LocationTestInfo.Result.NOT_ENABLED);
                return result;
            }
            OracleSwiftObjectStorage storage = info.getStorage();
            if (null == storage) {
                if (promptUserForAdd) {
                    if (FACTORY.canPromptUserForAdd()) {
                        if (FACTORY.promptUserForAdd(swiftBucketUrl)) {
                            return OracleSwiftObjectStorage.testBucketUrl(swiftBucketUrl, false);
                        }
                        result.setResult(LocationTestInfo.Result.USER_CANCELLED);
                        return result;
                    }
                    result.setResult(LocationTestInfo.Result.NOT_FOUND_NO_PROMPT);
                    return result;
                }
                result.setResult(LocationTestInfo.Result.NOT_FOUND);
                return result;
            }
            String target = swiftBucketUrl;
            if (target.endsWith("/")) {
                target = target.substring(0, target.length() - 1);
            }
            target = target.substring(target.lastIndexOf("/") + 1);
            storage.connect();
            try {
                storage.testRoundTripIO(target);
                result.setResult(LocationTestInfo.Result.PASS);
            }
            finally {
                storage.disconnect();
            }
        }
        catch (Throwable t) {
            result.setResult(LocationTestInfo.Result.FAIL);
            result.setThrowable(t);
        }
        Throwable t = result.getThrowable();
        if (null == t) {
            Logger.info(clazz, (String)String.valueOf((Object)result.getResult()));
        } else {
            Logger.info(clazz, (String)String.valueOf((Object)result.getResult()), (Throwable)t);
        }
        return result;
    }

    public static void main(String[] args) {
        TransferManager.INSTANCE.setPackageLogStream(System.out, false);
        TransferManager.INSTANCE.setPackageLogLevel(Level.INFO);
        if (DUMMY) {
            OracleSwiftObjectStorage storage = new OracleSwiftObjectStorage("", "");
            storage.test();
        }
    }

    private void test() {
        Logger.info(clazz, (String)OracleSwiftObjectStorage.getNamespaceUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET/FILE"));
        Logger.info(clazz, (String)OracleSwiftObjectStorage.getBucketUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET/FILE"));
        assert ("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE".equals(OracleSwiftObjectStorage.getNamespaceUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET/FILE")));
        assert ("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE".equals(OracleSwiftObjectStorage.getNamespaceUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET")));
        assert ("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE".equals(OracleSwiftObjectStorage.getNamespaceUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/")));
        assert ("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE".equals(OracleSwiftObjectStorage.getNamespaceUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE")));
        assert (null == OracleSwiftObjectStorage.getNamespaceUrl("https://swiftobjectstorage.*.oraclecloud.com/v1"));
        assert ("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET".equals(OracleSwiftObjectStorage.getBucketUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET/FILE")));
        assert ("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET".equals(OracleSwiftObjectStorage.getBucketUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET/")));
        assert ("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET".equals(OracleSwiftObjectStorage.getBucketUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/NAMESPACE/BUCKET")));
        assert (null == OracleSwiftObjectStorage.getBucketUrl("https://swiftobjectstorage.*.oraclecloud.com/v1/"));
        try {
            RunnableTimer.time("testRoundTripIO", () -> {
                try {
                    this.testRoundTripIO(BUCKET_NAME);
                }
                catch (Throwable t) {
                    Logger.warn(this.getClass(), (Throwable)t);
                }
            });
            RunnableTimer.time("testFileRoundTripIO", () -> this.testFileRoundTripIO(filePath2));
            RunnableTimer.time("testManagedFileRoundTripIO", () -> this.testManagedFileRoundTripIO(filePath2));
        }
        catch (Throwable t) {
            Logger.warn(this.getClass(), (Throwable)t);
        }
    }

    private void testRoundTripIO(String bucketName) throws IOException {
        Logger.info(this.getClass(), (String)"testRoundTripIO");
        try {
            File file = File.createTempFile("testRoundTripIO", ".pangram");
            String objectName = file.getName();
            file.delete();
            String out = "The wizard quickly jinxed the gnomes before they vaporized";
            ByteArrayInputStream source = new ByteArrayInputStream(out.getBytes(StandardCharsets.UTF_8));
            String target = bucketName + '/' + objectName;
            this.copy(source, target, new SimpleByteProgressMonitor(), StandardCopyOption.REPLACE_EXISTING);
            InputStream in = this.asInputStream(Paths.get(bucketName, objectName), 0L, 0L, new SimpleByteProgressMonitor());
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    sb.append((char)c);
                }
            }
            this.delete(target);
            if (out.equals(sb.toString())) {
                Logger.info(this.getClass(), (String)"testRoundTripIO - PASSED");
            } else {
                Logger.warn(this.getClass(), (String)"testRoundTripIO - FAILED");
            }
        }
        catch (Throwable t) {
            throw OracleSwiftObjectStorage.asIOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFileRoundTripIO(String filePath) {
        String tag = "testFileRoundTripIO(" + filePath + ")";
        Logger.info(this.getClass(), (String)tag);
        try {
            String bucketName = BUCKET_NAME;
            File file = new File(filePath);
            URL fileURL = file.toURI().toURL();
            String objectName = this.getClass().getSimpleName() + "-" + file.getName();
            InputStream source = fileURL.openStream();
            String target = bucketName + '/' + objectName;
            long start = System.nanoTime();
            this.copy(source, target, new SimpleByteProgressMonitor(), StandardCopyOption.REPLACE_EXISTING);
            long now = System.nanoTime();
            long duration = now - start;
            double elapsed = (double)duration / 1.0E9;
            Logger.info(this.getClass(), (String)(file.getName() + " Upload Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
            start = System.nanoTime();
            try (InputStream in = this.asInputStream(Paths.get(bucketName, objectName), 0L, 0L, new SimpleByteProgressMonitor());
                 FileOutputStream os = new FileOutputStream(filePath + "-" + this.getClass().getSimpleName());){
                int l;
                byte[] buffer = new byte[4096];
                while ((l = in.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, l);
                }
                os.flush();
            }
            now = System.nanoTime();
            duration = now - start;
            elapsed = (double)duration / 1.0E9;
            Logger.info(this.getClass(), (String)(file.getName() + " Download Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
        }
        catch (Throwable t) {
            Logger.warn(this.getClass(), (Throwable)t);
        }
    }

    private void testManagedFileRoundTripIO(final String filePath) {
        String tag = "testManagedFileRoundTripIO(" + filePath + ")";
        Logger.info(this.getClass(), (String)tag);
        try {
            final String bucketName = BUCKET_NAME;
            FileSet fileSet = new FileSet(Location.getLocal(), Collections.emptySet());
            fileSet.add(filePath);
            TransferTask transferTask = TransferManager.INSTANCE.createTransferTask(tag, IRaptorTaskRunMode.NO_GUI, fileSet, this, bucketName);
            final long start = System.nanoTime();
            final File file = new File(filePath);
            MD5 md5 = new MD5();
            final String md5Promised = md5.calculate(filePath);
            this.taskDone = false;
            transferTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(RaptorTaskEvent event) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)event.getThrowable());
                    OracleSwiftObjectStorage.this.taskDone = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(RaptorTaskEvent event) {
                    try {
                        long now = System.nanoTime();
                        long duration = now - start;
                        double elapsed = (double)duration / 1.0E9;
                        Logger.info(((Object)((Object)this)).getClass(), (String)(file.getName() + " Upload Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
                        InputStream in = OracleSwiftObjectStorage.this.asInputStream(Paths.get(bucketName, file.getName()), 0L, 0L, new SimpleByteProgressMonitor());
                        MessageDigest md5MessageDigest = MD5.getMessageDigest();
                        in = new DigestInputStream(in, md5MessageDigest);
                        try (FileOutputStream os = new FileOutputStream(filePath + "-" + clazz.getSimpleName());){
                            int l;
                            byte[] buffer = new byte[4096];
                            while ((l = in.read(buffer)) != -1) {
                                ((OutputStream)os).write(buffer, 0, l);
                            }
                            os.flush();
                        }
                        finally {
                            in.close();
                        }
                        String md5Received = MD5.convertByteArrayToHexString(md5MessageDigest.digest());
                        if (!md5Promised.equals(md5Received)) {
                            Logger.severe((Class)clazz, (String)String.format("\n\tMD5 %s\n\t!=  %s", md5Promised, md5Received));
                        } else {
                            Logger.info((Class)clazz, (String)String.format("MD5 %s == %s", md5Promised, md5Received));
                        }
                        now = System.nanoTime();
                        duration = now - start;
                        elapsed = (double)duration / 1.0E9;
                        Logger.info(((Object)((Object)this)).getClass(), (String)(file.getName() + " Download Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
                    }
                    catch (Throwable t) {
                        Logger.severe(((Object)((Object)this)).getClass(), (Throwable)t);
                    }
                    finally {
                        OracleSwiftObjectStorage.this.taskDone = true;
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)transferTask);
            try {
                while (!this.taskDone) {
                    Thread.sleep(250L);
                }
            }
            catch (Throwable t) {
                Logger.severe(this.getClass(), (String)tag, (Throwable)t);
            }
        }
        catch (Throwable t) {
            Logger.warn(this.getClass(), (Throwable)t);
        }
    }

    static {
        BUCKET_NAME = "brian";
        filePath2 = "/Users/bjeffrie/SHARED/test/Bank_Account_or_Service_Complaints.csv";
        df = new DecimalFormat("#00.0000");
    }
}

