/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.parser.AndORTree;
import oracle.json.parser.ContainsClause;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.Predicate;
import oracle.json.parser.ProjectionSpec;
import oracle.json.parser.QueryException;
import oracle.json.parser.SpatialClause;
import oracle.json.parser.SqlJsonClause;
import oracle.json.parser.ValueTypePair;
import oracle.json.util.ComponentTime;
import oracle.json.util.JsonByteArray;
import oracle.json.util.Pair;
import oracle.soda.OracleCursor;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.OracleOperationBuilder;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.Operation;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleCursorImpl;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.TableCollectionImpl;
import oracle.soda.rdbms.impl.WriteResult;
import oracle.soda.rdbms.impl.WriteResultImpl;

public class OracleOperationBuilderImpl
implements OracleOperationBuilder {
    private static final int MAX_NUM_OF_KEYS = 1000;
    private static final Logger log = Logger.getLogger(OracleOperationBuilderImpl.class.getName());
    private String key;
    private String likePattern;
    private String likeEscape;
    private boolean isStartKey;
    private boolean ascending;
    private boolean startKeyInclusive;
    Set<String> keys;
    private String since;
    private String until;
    private boolean timeRangeInclusive;
    private OracleDocument filterSpec;
    private AndORTree tree;
    private String version;
    private String lastModified;
    private boolean lockRows;
    private int limit;
    private long skip;
    private Long asOfScn = null;
    private String asOfTimestamp = null;
    private List<SpatialClause> spatialClauses = null;
    private List<ContainsClause> containsClauses = null;
    private List<SqlJsonClause> sqlJsonClauses = null;
    boolean headerOnly;
    private int firstRows;
    private ProjectionSpec proj = null;
    private String projString = null;
    private boolean skipProjErrors = true;
    private final OracleCollectionImpl collection;
    private final MetricsCollector metrics;
    private final Connection connection;
    private final CollectionDescriptor options;
    private final JsonFactoryProvider jProvider;
    private String computedVersion;
    private static final String NULL = "null";
    private static final boolean PAGINATION_WORKAROUND = Boolean.valueOf(System.getProperty("oracle.soda.rdbms.paginationWorkaround", "true"));
    private boolean selectPatchedDoc = false;
    private boolean selectMergedDoc = false;
    private boolean patchSpecExceptionOnly = false;
    private OracleDocument patchSpec = null;
    private String hints = null;
    private boolean return_query = false;
    private JsonByteArray return_sql_json = null;

    OracleOperationBuilderImpl(OracleCollectionImpl oracleCollectionImpl, Connection connection) {
        this.collection = oracleCollectionImpl;
        this.jProvider = oracleCollectionImpl.getDatabase().getJsonFactoryProvider();
        this.options = oracleCollectionImpl.getOptions();
        this.connection = connection;
        this.ascending = true;
        this.startKeyInclusive = true;
        this.timeRangeInclusive = true;
        this.firstRows = -1;
        this.metrics = oracleCollectionImpl.getMetrics();
    }

    public void returnQuery(boolean bl) {
        this.return_query = bl;
        this.return_sql_json = bl ? new JsonByteArray(1000) : null;
    }

    private void beginQueryRecord(String string) {
        this.return_sql_json.appendOpenBrace();
        this.return_sql_json.appendValue("sql");
        this.return_sql_json.appendColon();
        this.return_sql_json.appendValue(string);
    }

    private void recordNamedBind(String string, String string2) {
        this.return_sql_json.appendComma();
        this.return_sql_json.appendValue(string);
        this.return_sql_json.appendColon();
        this.return_sql_json.appendValue(string2);
    }

    private void recordQueryBind(int n, ValueTypePair valueTypePair) {
        this.return_sql_json.appendComma();
        this.return_sql_json.appendValue("B" + Integer.toString(n));
        this.return_sql_json.appendColon();
        switch (valueTypePair.getType()) {
            case 1: {
                this.return_sql_json.append(valueTypePair.getNumberValue().toString());
                break;
            }
            case 2: {
                this.return_sql_json.appendValue(valueTypePair.getStringValue());
                break;
            }
            case 3: {
                this.return_sql_json.append(valueTypePair.getBooleanValue() ? "true" : "false");
                break;
            }
            default: {
                this.return_sql_json.append(NULL);
            }
        }
    }

    private void recordJsonValueBind(int n, ValueTypePair valueTypePair) {
        this.return_sql_json.appendComma();
        this.return_sql_json.appendValue("JV" + Integer.toString(n));
        this.return_sql_json.appendColon();
        switch (valueTypePair.getType()) {
            case 1: {
                this.return_sql_json.append(valueTypePair.getNumberValue().toString());
                break;
            }
            case 2: {
                this.return_sql_json.appendValue(valueTypePair.getStringValue());
                break;
            }
            default: {
                this.return_sql_json.append(NULL);
            }
        }
    }

    private void recordQueryKey(int n, String string) {
        this.return_sql_json.appendComma();
        this.return_sql_json.appendValue("key_" + Integer.toString(n));
        this.return_sql_json.appendColon();
        if (string == null) {
            this.return_sql_json.append(NULL);
        } else {
            this.return_sql_json.appendValue(string);
        }
    }

    @Override
    public OracleOperationBuilder keyLike(String string, String string2) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "pattern");
        }
        if (this.options.keyAssignmentMethod != 1 || this.options.keyDataType != 1 && this.options.keyDataType != 2) {
            throw SODAUtils.makeException(SODAMessage.EX_KEY_LIKE_CANNOT_BE_USED, new Object[0]);
        }
        this.likePattern = string;
        this.likeEscape = string2;
        this.key = null;
        this.keys = null;
        this.isStartKey = false;
        this.ascending = true;
        this.startKeyInclusive = true;
        return this;
    }

    @Override
    public OracleOperationBuilder key(String string) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "key");
        }
        this.key = this.collection.canonicalKey(string);
        this.maxNumberOfKeysCheck();
        this.likePattern = null;
        this.likeEscape = null;
        this.keys = null;
        this.isStartKey = false;
        this.ascending = true;
        this.startKeyInclusive = true;
        return this;
    }

    @Override
    public OracleOperationBuilder keys(Set<String> set) throws OracleException {
        if (set == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "keys");
        }
        if (set.isEmpty()) {
            throw SODAUtils.makeException(SODAMessage.EX_SET_IS_EMPTY, "keys");
        }
        if (set.contains(null)) {
            throw SODAUtils.makeException(SODAMessage.EX_SET_CONTAINS_NULL, "keys");
        }
        this.keys = new HashSet<String>();
        for (String string : set) {
            this.keys.add(this.collection.canonicalKey(string));
        }
        this.maxNumberOfKeysCheck();
        this.likePattern = null;
        this.likeEscape = null;
        this.key = null;
        this.isStartKey = false;
        this.ascending = true;
        this.startKeyInclusive = true;
        return this;
    }

    @Override
    public OracleOperationBuilder startKey(String string, Boolean bl, Boolean bl2) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "startKey");
        }
        this.isStartKey = true;
        this.key = this.collection.canonicalKey(string);
        this.ascending = bl != null ? bl : true;
        this.startKeyInclusive = bl2 != null ? bl2 : true;
        this.keys = null;
        return this;
    }

    public OracleOperationBuilder timeRange(String string, String string2, Boolean bl) throws OracleException {
        if (this.options.timestampColumnName == null) {
            throw SODAUtils.makeException(SODAMessage.EX_NO_TIMESTAMP, this.options.uriName);
        }
        if (string == null && string2 == null) {
            throw SODAUtils.makeException(SODAMessage.EX_SINCE_AND_UNTIL_CANNOT_BE_NULL, new Object[0]);
        }
        if (string != null && string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2 != null && string2.endsWith("Z")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.since = string;
        this.until = string2;
        this.timeRangeInclusive = bl != null ? bl : true;
        this.lastModified = null;
        return this;
    }

    public OracleOperationBuilder asOfScn(long l) {
        this.asOfScn = new Long(l);
        this.asOfTimestamp = null;
        return this;
    }

    public OracleOperationBuilder asOfTimestamp(String string) {
        long l = ComponentTime.stringToStamp(string);
        this.asOfTimestamp = ComponentTime.stampToString(l);
        this.asOfScn = null;
        return this;
    }

    @Override
    public OracleOperationBuilder filter(String string) throws OracleException {
        return this.filter(new OracleDocumentImpl(string));
    }

    @Override
    public OracleOperationBuilder filter(OracleDocument oracleDocument) throws OracleException {
        this.specChecks(oracleDocument, "filterSpec");
        if (this.collection.admin().isHeterogeneous()) {
            throw SODAUtils.makeException(SODAMessage.EX_NO_QBE_ON_HETERO_COLLECTIONS, new Object[0]);
        }
        try {
            this.tree = AndORTree.createTree(this.jProvider, ((OracleDocumentImpl)oracleDocument).getContentAsStream());
            this.tree.generateJsonExists();
        }
        catch (QueryException queryException) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning(queryException.toString());
            }
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, queryException, new Object[0]);
        }
        this.filterSpec = oracleDocument;
        this.maxNumberOfKeysCheck();
        return this;
    }

    public OracleOperationBuilder project(OracleDocument oracleDocument, boolean bl) throws OracleException {
        this.specChecks(oracleDocument, "projectionSpec");
        this.proj = new ProjectionSpec(this.jProvider, ((OracleDocumentImpl)oracleDocument).getContentAsStream());
        try {
            this.projString = this.proj.getAsString();
            boolean bl2 = this.proj.validate(true);
            if (!bl2) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_PROJ_SPEC, "validation");
            }
            if (this.proj.hasIncludeRules() && this.proj.hasExcludeRules()) {
                throw SODAUtils.makeException(SODAMessage.EX_PROJ_SPEC_MIXED, new Object[0]);
            }
            if (this.proj.hasArraySteps()) {
                throw SODAUtils.makeException(SODAMessage.EX_ARRAY_STEPS_NOT_ALLOWED_IN_PROJ, new Object[0]);
            }
            if (this.proj.hasOverlappingPaths()) {
                throw SODAUtils.makeException(SODAMessage.EX_OVERLAPPING_PATHS_NOT_ALLOWED_IN_PROJ, new Object[0]);
            }
        }
        catch (QueryException queryException) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_PROJ_SPEC, queryException, new Object[0]);
        }
        this.skipProjErrors = bl;
        this.headerOnly = false;
        return this;
    }

    public OracleOperationBuilder project(OracleDocument oracleDocument) throws OracleException {
        return this.project(oracleDocument, true);
    }

    @Override
    public OracleOperationBuilder lock() throws OracleException {
        if (this.skip > 0L) {
            throw SODAUtils.makeException(SODAMessage.EX_INCOMPATIBLE_METHODS, "lock()", "skip()");
        }
        if (this.limit > 0) {
            throw SODAUtils.makeException(SODAMessage.EX_INCOMPATIBLE_METHODS, "lock()", "limit()");
        }
        this.lockRows = true;
        return this;
    }

    @Override
    public OracleOperationBuilder hint(String string) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, string);
        }
        if (string.indexOf("/*") >= 0 || string.indexOf("*/") >= 0) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_HINT, string);
        }
        this.hints = string == "" ? null : string;
        return this;
    }

    private void maxNumberOfKeysCheck() throws OracleException {
        int n = 0;
        if (this.filterSpec != null) {
            n += this.tree.getKeys().size();
        }
        if (this.keys != null) {
            n += this.keys.size();
        } else if (this.key != null && !this.isStartKey) {
            ++n;
        }
        if (n > 1000) {
            throw SODAUtils.makeException(SODAMessage.EX_MAX_NUM_OF_KEYS_EXCEEDED, n, 1000);
        }
    }

    @Override
    public OracleOperationBuilder version(String string) throws OracleException {
        if (this.options.versionColumnName == null) {
            throw SODAUtils.makeException(SODAMessage.EX_NO_VERSION, this.options.uriName);
        }
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "version");
        }
        this.version = string;
        return this;
    }

    public OracleOperationBuilder lastModified(String string) throws OracleException {
        if (this.options.timestampColumnName == null) {
            throw SODAUtils.makeException(SODAMessage.EX_NO_TIMESTAMP, this.options.uriName);
        }
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "lastModified");
        }
        if (string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1);
        }
        this.lastModified = string;
        this.since = null;
        this.until = null;
        this.timeRangeInclusive = true;
        return this;
    }

    private ResultSet getResultSet(Operation operation) throws OracleException {
        return this.getResultSet(operation, false);
    }

    private ResultSet getResultSet(Operation operation, boolean bl) throws OracleException {
        PreparedStatement preparedStatement = operation.getPreparedStatement();
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            if (bl) {
                resultSet.close();
                resultSet = null;
                preparedStatement.close();
            }
            preparedStatement = null;
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString() + "\n" + operation.getSqlText());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
            }
            catch (Throwable throwable) {
                for (String string : SODAUtils.closeCursor(preparedStatement, bl ? resultSet : null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string);
                }
                throw throwable;
            }
        }
        for (String string : SODAUtils.closeCursor(preparedStatement, bl ? resultSet : null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string);
        }
        return resultSet;
    }

    @Override
    public OracleCursor getCursor() throws OracleException {
        boolean bl;
        Operation operation = this.generateOperation(Terminal.GET_CURSOR);
        ResultSet resultSet = this.getResultSet(operation);
        long l = this.metrics.endTiming();
        boolean bl2 = bl = this.selectPatchedDoc || this.selectMergedDoc;
        OracleCursorImpl oracleCursorImpl = new OracleCursorImpl(this.options, this.metrics, operation, resultSet, bl ? false : this.proj != null, bl);
        oracleCursorImpl.setElapsedTime(l);
        if (this.return_query) {
            this.return_sql_json.appendCloseBrace();
            oracleCursorImpl.setQuery(this.return_sql_json.toArray());
        }
        return oracleCursorImpl;
    }

    private void specChecks(OracleDocument oracleDocument, String string) throws OracleException {
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, string);
        }
        if (string.equals("patchSpec")) {
            this.collection.writeCheck("patch");
        } else if (string.equals("mergeSpec")) {
            this.collection.writeCheck("merge");
            return;
        }
        String string2 = oracleDocument.getContentAsString();
        if (string2 == null || string2.isEmpty()) {
            if (string.equals("patchSpec")) {
                throw SODAUtils.makeException(SODAMessage.EX_SPEC_HAS_NO_CONTENT, "Patch");
            }
            if (string.equals("projectionSpec")) {
                throw SODAUtils.makeException(SODAMessage.EX_SPEC_HAS_NO_CONTENT, "Projection");
            }
            throw SODAUtils.makeException(SODAMessage.EX_SPEC_HAS_NO_CONTENT, "Filter");
        }
    }

    private Pair<List<OracleDocument>, Long> getModifiedDocs(OracleDocument oracleDocument, boolean bl) throws OracleException {
        this.patchSpec = oracleDocument;
        this.selectPatchedDoc = !bl;
        this.selectMergedDoc = bl;
        OracleCursor oracleCursor = null;
        ArrayList<OracleDocument> arrayList = new ArrayList<OracleDocument>();
        Long l = 0L;
        try {
            oracleCursor = this.getCursor();
            if (oracleCursor != null) {
                while (oracleCursor.hasNext()) {
                    OracleDocument oracleDocument2 = oracleCursor.next();
                    if (oracleDocument2 != null) {
                        arrayList.add(oracleDocument2);
                    }
                    l = l + 1L;
                }
            }
        }
        catch (OracleException oracleException) {
            try {
                if (oracleCursor != null) {
                    oracleCursor.close();
                }
            }
            catch (IOException iOException) {
                OracleException oracleException2 = new OracleException(iOException);
                oracleException.setNextException(oracleException2);
            }
            throw oracleException;
        }
        catch (RuntimeException runtimeException) {
            block23: {
                try {
                    if (oracleCursor != null) {
                        oracleCursor.close();
                    }
                }
                catch (IOException iOException) {
                    if (!OracleLog.isLoggingEnabled()) break block23;
                    log.fine(iOException.getMessage());
                }
            }
            throw runtimeException;
        }
        catch (Error error) {
            block24: {
                try {
                    if (oracleCursor != null) {
                        oracleCursor.close();
                    }
                }
                catch (IOException iOException) {
                    if (!OracleLog.isLoggingEnabled()) break block24;
                    log.fine(iOException.getMessage());
                }
            }
            throw error;
        }
        finally {
            this.selectMergedDoc = false;
            this.selectPatchedDoc = false;
            oracleDocument = null;
        }
        try {
            if (oracleCursor != null) {
                oracleCursor.close();
            }
        }
        catch (IOException iOException) {
            throw new OracleException(iOException);
        }
        return new Pair<List<OracleDocument>, Long>(arrayList, l);
    }

    private boolean disableAutoCommit() throws OracleException {
        try {
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
                return true;
            }
        }
        catch (SQLException sQLException) {
            throw SODAUtils.makeException(SODAMessage.EX_CANT_DISABLE_AUTOCOMMIT, sQLException, new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OracleDocument> modifyAndGet(OracleDocument oracleDocument, boolean bl, boolean bl2) throws OracleException {
        Object object;
        boolean bl3;
        block25: {
            if (this.key != null && !this.isStartKey) {
                OracleDocument oracleDocument2 = bl2 ? this.mergeOneAndGet(oracleDocument) : this.patchOneAndGet(oracleDocument);
                ArrayList<OracleDocument> arrayList = new ArrayList<OracleDocument>();
                if (oracleDocument2 != null) {
                    arrayList.add(oracleDocument2);
                }
                return arrayList;
            }
            this.specChecks(oracleDocument, "patchSpec");
            bl3 = this.disableAutoCommit();
            try {
                Object object2;
                Object object3;
                if (bl) {
                    this.patchSpecExceptionOnly = true;
                }
                object = this.getModifiedDocs(oracleDocument, bl2).getFirst();
                this.patchSpecExceptionOnly = false;
                if (object.isEmpty()) break block25;
                ArrayList<OracleDocument> arrayList = new ArrayList<OracleDocument>();
                HashSet<String> hashSet = null;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                if (this.keys != null && !this.keys.isEmpty()) {
                    hashSet = new HashSet<String>();
                    hashSet.addAll(this.keys);
                } else if (this.isStartKey) {
                    bl4 = true;
                    bl5 = this.ascending;
                    bl6 = this.startKeyInclusive;
                }
                try {
                    object3 = object.iterator();
                    while (object3.hasNext()) {
                        object2 = (OracleDocument)object3.next();
                        if (object2.getContentAsByteArray() == null) continue;
                        this.key(object2.getKey());
                        OracleDocument oracleDocument3 = this.replaceOneAndGet((OracleDocument)object2);
                        if (oracleDocument3 == null) continue;
                        ((OracleDocumentImpl)oracleDocument3).setContent(object2.getContentAsByteArray());
                        arrayList.add(oracleDocument3);
                    }
                }
                finally {
                    if (hashSet != null) {
                        this.keys = new HashSet<String>();
                        this.keys.addAll(hashSet);
                    } else if (bl4) {
                        this.isStartKey = bl4;
                        this.ascending = bl5;
                        this.startKeyInclusive = bl6;
                    }
                }
                object3 = TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, true);
                if (object3 != null) {
                    throw object3;
                }
                object2 = arrayList;
                return object2;
            }
            catch (OracleException oracleException) {
                OracleException oracleException2 = TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, false);
                oracleException.setNextException(oracleException2);
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(oracleException.toString());
                }
                throw oracleException;
            }
            catch (RuntimeException runtimeException) {
                TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, false);
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(runtimeException.toString());
                }
                throw runtimeException;
            }
            catch (Error error) {
                TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, false);
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(error.toString());
                }
                throw error;
            }
            finally {
                this.patchSpecExceptionOnly = false;
            }
        }
        object = TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, true);
        if (object != null) {
            throw object;
        }
        return new ArrayList<OracleDocument>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteResult modify(OracleDocument oracleDocument, boolean bl, boolean bl2) throws OracleException {
        Object object;
        boolean bl3;
        block25: {
            if (this.key != null && !this.isStartKey) {
                boolean bl4 = bl2 ? this.mergeOne(oracleDocument) : this.patchOne(oracleDocument);
                if (bl4) {
                    return new WriteResultImpl(1L, 1L);
                }
                return new WriteResultImpl(1L, 0L);
            }
            this.specChecks(oracleDocument, bl2 ? "mergeSpec" : "patchSpec");
            bl3 = this.disableAutoCommit();
            if (bl) {
                this.patchSpecExceptionOnly = true;
            }
            try {
                object = this.getModifiedDocs(oracleDocument, bl2);
                List<OracleDocument> list = ((Pair)object).getFirst();
                this.patchSpecExceptionOnly = false;
                if (list.isEmpty()) break block25;
                long l = 0L;
                HashSet<String> hashSet = null;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                if (this.keys != null && !this.keys.isEmpty()) {
                    hashSet = new HashSet<String>();
                    hashSet.addAll(this.keys);
                } else if (this.isStartKey) {
                    bl5 = true;
                    bl6 = this.ascending;
                    bl7 = this.startKeyInclusive;
                }
                try {
                    for (OracleDocument object22 : list) {
                        if (((OracleDocumentImpl)object22).isBinary() ? ((OracleDocumentImpl)object22).getBinaryContentAsByteArray() == null : object22.getContentAsByteArray() == null) continue;
                        this.key(object22.getKey());
                        if (!this.replaceOne(object22)) continue;
                        ++l;
                    }
                }
                finally {
                    if (hashSet != null) {
                        this.keys = new HashSet<String>();
                        this.keys.addAll(hashSet);
                    } else if (bl5) {
                        this.isStartKey = bl5;
                        this.ascending = bl6;
                        this.startKeyInclusive = bl7;
                    }
                }
                OracleException oracleException = TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, true);
                if (oracleException != null) {
                    throw oracleException;
                }
                WriteResultImpl writeResultImpl = new WriteResultImpl((Long)((Pair)object).getSecond(), l);
                return writeResultImpl;
            }
            catch (OracleException oracleException) {
                OracleException oracleException2 = TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, false);
                oracleException.setNextException(oracleException2);
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(oracleException.toString());
                }
                throw oracleException;
            }
            catch (RuntimeException runtimeException) {
                TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, false);
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(runtimeException.toString());
                }
                throw runtimeException;
            }
            catch (Error error) {
                TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, false);
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(error.toString());
                }
                throw error;
            }
            finally {
                this.patchSpecExceptionOnly = false;
            }
        }
        object = TableCollectionImpl.completeTxnAndRestoreAutoCommit(this.connection, bl3, true);
        if (object != null) {
            throw object;
        }
        return new WriteResultImpl(0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleDocument getModifiedDoc(OracleDocument oracleDocument, boolean bl) throws OracleException {
        if (this.key == null || this.isStartKey) {
            throw SODAUtils.makeException(SODAMessage.EX_KEY_MUST_BE_SPECIFIED, new Object[0]);
        }
        this.patchSpec = oracleDocument;
        this.selectPatchedDoc = !bl;
        this.selectMergedDoc = bl;
        OracleDocument oracleDocument2 = null;
        try {
            oracleDocument2 = this.getOne();
        }
        finally {
            this.selectMergedDoc = false;
            this.selectPatchedDoc = false;
            oracleDocument = null;
        }
        return oracleDocument2;
    }

    private boolean modifyOne(OracleDocument oracleDocument, boolean bl) throws OracleException {
        this.specChecks(oracleDocument, bl ? "mergeSpec" : "patchSpec");
        if (bl && (this.options.versionColumnName == null || !this.collection.payloadBasedVersioning())) {
            this.patchSpec = oracleDocument;
            return this.replaceOneWithOptionalMerge(oracleDocument, Terminal.MERGE_ONE);
        }
        OracleDocument oracleDocument2 = this.getModifiedDoc(oracleDocument, bl);
        if (oracleDocument2 != null) {
            return this.replaceOneWithOptionalMerge(oracleDocument2, Terminal.REPLACE_ONE);
        }
        return false;
    }

    private OracleDocument modifyOneAndGet(OracleDocument oracleDocument, boolean bl) throws OracleException {
        OracleDocument oracleDocument2;
        this.specChecks(oracleDocument, bl ? "mergeSpec" : "patchSpec");
        OracleDocument oracleDocument3 = this.getModifiedDoc(oracleDocument, bl);
        if (oracleDocument3 != null && (oracleDocument2 = this.replaceOneAndGet(oracleDocument3)) != null) {
            OracleDocumentImpl oracleDocumentImpl = new OracleDocumentImpl(oracleDocument2.getKey(), oracleDocument2.getVersion(), oracleDocument2.getLastModified(), oracleDocument3.getContentAsByteArray());
            oracleDocumentImpl.setCreatedOn(oracleDocument2.getCreatedOn());
            oracleDocumentImpl.setContentType(oracleDocument2.getMediaType());
            return oracleDocumentImpl;
        }
        return null;
    }

    public WriteResult patch(OracleDocument oracleDocument) throws OracleException {
        return this.modify(oracleDocument, true, false);
    }

    public boolean patchOne(OracleDocument oracleDocument) throws OracleException {
        return this.modifyOne(oracleDocument, false);
    }

    public OracleDocument patchOneAndGet(OracleDocument oracleDocument) throws OracleException {
        return this.modifyOneAndGet(oracleDocument, false);
    }

    public List<OracleDocument> patchAndGet(OracleDocument oracleDocument) throws OracleException {
        return this.modifyAndGet(oracleDocument, true, false);
    }

    public WriteResult merge(OracleDocument oracleDocument) throws OracleException {
        return this.modify(oracleDocument, true, true);
    }

    @Override
    public boolean mergeOne(OracleDocument oracleDocument) throws OracleException {
        return this.modifyOne(oracleDocument, true);
    }

    @Override
    public OracleDocument mergeOneAndGet(OracleDocument oracleDocument) throws OracleException {
        return this.modifyOneAndGet(oracleDocument, true);
    }

    public List<OracleDocument> mergeAndGet(OracleDocument oracleDocument) throws OracleException {
        return this.modifyAndGet(oracleDocument, true, true);
    }

    private Operation generateOperation(Terminal terminal) throws OracleException {
        return this.generateOperation(terminal, null);
    }

    private Operation generateOperation(Terminal terminal, OracleDocument oracleDocument) throws OracleException {
        Operation operation;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.returningClause(terminal) && this.collection.useCallableReturns) {
            stringBuilder.append("begin\n");
        }
        if (terminal == Terminal.REMOVE) {
            this.return_query = false;
            this.generateRemove(stringBuilder);
        } else if (this.isReplaceOrMerge(terminal)) {
            this.return_query = false;
            this.generateUpdate(stringBuilder, terminal);
        } else {
            if (terminal != Terminal.GET_CURSOR || this.selectStageOfPatch()) {
                this.return_query = false;
            }
            if (this.paginationWorkaround(terminal)) {
                this.generatePaginationWorkaround(stringBuilder, terminal);
            } else {
                this.generateSelect(stringBuilder, terminal);
            }
        }
        if (this.flashback(terminal)) {
            this.generateFlashback(stringBuilder);
        }
        int n = 0;
        if (this.filterSpec != null) {
            if (this.tree == null) {
                throw new IllegalStateException();
            }
            n = this.getNumberOfFilterSpecKeys();
        }
        this.generateWhere(stringBuilder);
        if (!this.countOrWrite(terminal) && !this.selectStageOfPatch()) {
            boolean bl = false;
            if (this.hasFilterSpecOrderBy()) {
                this.generateFilterSpecOrderBy(stringBuilder, this.tree);
                bl = true;
            }
            if (!this.paginationWorkaround(terminal)) {
                this.generateOrderBy(stringBuilder, bl);
                this.generateOffsetAndFetchNext(stringBuilder);
            }
            if (this.lockRows) {
                stringBuilder.append(" for update");
            }
        }
        if (this.returningClause(terminal)) {
            this.generateReturning(stringBuilder);
        }
        if (this.returningClause(terminal) && this.collection.useCallableReturns) {
            stringBuilder.append(";\nend;\n");
        }
        PreparedStatement preparedStatement = null;
        CallableStatement callableStatement = null;
        String string = stringBuilder.toString();
        try {
            String string2;
            int n2;
            Object object4;
            if (this.return_query) {
                this.beginQueryRecord(string);
            }
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Query:\n" + string);
            }
            this.metrics.startTiming();
            if (this.returningClause(terminal) && this.collection.useCallableReturns) {
                callableStatement = this.connection.prepareCall(string);
                preparedStatement = callableStatement;
            } else {
                preparedStatement = this.connection.prepareStatement(string);
            }
            int n3 = 0;
            if (this.isReplaceOrMerge(terminal)) {
                n3 = this.bindUpdate(preparedStatement, oracleDocument, terminal);
            }
            if (this.selectPatchedDoc) {
                preparedStatement.setString(++n3, this.patchSpec.getContentAsString());
            } else if (this.selectMergedDoc) {
                n3 = this.bindMergePatch(preparedStatement, n3);
            } else if (this.projection(terminal)) {
                preparedStatement.setString(++n3, this.projString);
            }
            if (this.flashback(terminal)) {
                n3 = this.bindFlashback(preparedStatement, n3);
            }
            Iterator<String> iterator = null;
            if (this.key != null) {
                object4 = this.collection.canonicalKey(this.key);
                ((TableCollectionImpl)this.collection).bindKeyColumn(preparedStatement, ++n3, (String)object4);
                if (this.return_query) {
                    this.recordNamedBind("key", (String)object4);
                }
            } else if (this.likePattern != null) {
                ((TableCollectionImpl)this.collection).bindKeyColumn(preparedStatement, ++n3, this.likePattern);
                if (this.likeEscape != null) {
                    ((TableCollectionImpl)this.collection).bindKeyColumn(preparedStatement, ++n3, this.likeEscape);
                }
            } else if (this.keys != null) {
                iterator = this.keys.iterator();
                this.bindKeys(iterator, preparedStatement, this.keys.size(), n3);
                n3 += this.keys.size();
            }
            if (n > 0) {
                object4 = this.tree.getKeys();
                n2 = ((HashSet)object4).size();
                HashSet<String> object32 = new HashSet<String>(n2);
                Iterator iterator2 = ((HashSet)object4).iterator();
                while (iterator2.hasNext()) {
                    string2 = (String)iterator2.next();
                    object32.add(this.collection.canonicalKey(string2));
                }
                this.bindKeys(object32.iterator(), preparedStatement, n2, n3);
                n3 += n2;
            }
            n3 = this.setStartAndEndTime(preparedStatement, n3);
            n3 = this.setVersionAndLastModified(preparedStatement, n3);
            if (this.filterSpec != null) {
                n3 = this.bindJsonExists(preparedStatement, this.tree, n3);
            }
            if (this.spatialClauses != null) {
                int n4 = 0;
                for (SpatialClause spatialClause : this.spatialClauses) {
                    string2 = spatialClause.getReference();
                    String string3 = spatialClause.getDistance();
                    if (string2 == null) continue;
                    if (this.return_query) {
                        String string4 = "GEO" + Integer.toString(++n4);
                        this.recordNamedBind(string4, string2);
                    }
                    preparedStatement.setString(++n3, string2);
                    if (string3 == null) continue;
                    if (this.return_query) {
                        String string5 = "GEO" + Integer.toString(++n4);
                        this.recordNamedBind(string5, string3);
                    }
                    preparedStatement.setString(++n3, string3);
                }
            }
            if (this.containsClauses != null) {
                int n5 = 0;
                for (ContainsClause containsClause : this.containsClauses) {
                    string2 = containsClause.getSearchString();
                    if (string2 == null) continue;
                    if (this.return_query) {
                        String string6 = "TXT" + Integer.toString(++n5);
                        this.recordNamedBind(string6, string2);
                    }
                    preparedStatement.setString(++n3, string2);
                }
            }
            if (this.sqlJsonClauses != null) {
                int n6 = 0;
                for (SqlJsonClause sqlJsonClause : this.sqlJsonClauses) {
                    int n4;
                    int n5 = 0;
                    for (n4 = 0; n4 < sqlJsonClause.getArgCount(); ++n4) {
                        ValueTypePair valueTypePair = sqlJsonClause.getValue(n5++);
                        if (this.return_query) {
                            this.recordJsonValueBind(++n6, valueTypePair);
                        }
                        this.bindTypedParam(preparedStatement, valueTypePair, ++n3);
                    }
                    for (n4 = 0; n4 < sqlJsonClause.getBindCount(); ++n4) {
                        ValueTypePair valueTypePair = sqlJsonClause.getValue(n5++);
                        if (this.return_query) {
                            this.recordJsonValueBind(++n6, valueTypePair);
                        }
                        this.bindTypedParam(preparedStatement, valueTypePair, ++n3);
                    }
                }
            }
            int n9 = -1;
            if (this.returningClause(terminal)) {
                if (this.collection.useCallableReturns) {
                    n9 = n3;
                    n3 = this.bindReturning(callableStatement, n3);
                } else {
                    n3 = this.bindReturning(preparedStatement, n3);
                }
            }
            int n6 = n2 = this.key != null && !this.isStartKey ? 1 : 0;
            if (!this.countOrWrite(terminal)) {
                if (n2 == 0) {
                    preparedStatement.setFetchSize(1000);
                }
                this.collection.db.setLobPrefetchSize(preparedStatement);
            }
            Object var12_29 = null;
            boolean bl = this.filterSpec != null;
            Operation operation2 = new Operation(preparedStatement, string, this.headerOnly, bl, n2 != 0, n9, this.collection);
            preparedStatement = null;
            operation = operation2;
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString() + "\n" + string);
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string4 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string4);
                }
                throw throwable;
            }
        }
        for (String string5 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string5);
        }
        return operation;
    }

    private int bindMergePatch(PreparedStatement preparedStatement, int n) throws SQLException, OracleException {
        ++n;
        if (this.options.hasBinaryFormat() && !this.options.hasJsonType()) {
            ((TableCollectionImpl)this.collection).bindPayloadColumn(preparedStatement, n, this.patchSpec.getContentAsByteArray());
        } else {
            ((TableCollectionImpl)this.collection).bindPayloadColumn(preparedStatement, n, this.patchSpec);
        }
        return n;
    }

    private void bindTypedParam(PreparedStatement preparedStatement, ValueTypePair valueTypePair, int n) throws SQLException {
        switch (valueTypePair.getType()) {
            case 1: {
                preparedStatement.setBigDecimal(n, valueTypePair.getNumberValue());
                break;
            }
            case 2: {
                preparedStatement.setString(n, valueTypePair.getStringValue());
                break;
            }
            case 3: {
                preparedStatement.setString(n, String.valueOf(valueTypePair.getBooleanValue()));
                break;
            }
            case 4: {
                preparedStatement.setString(n, NULL);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private int bindJsonExists(PreparedStatement preparedStatement, AndORTree andORTree, int n) throws SQLException {
        int n2 = 0;
        for (ValueTypePair valueTypePair : andORTree.getValueArray()) {
            ++n;
            if (this.return_query) {
                this.recordQueryBind(n2++, valueTypePair);
            }
            this.bindTypedParam(preparedStatement, valueTypePair, n);
        }
        return n;
    }

    private int setVersionAndLastModified(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.version != null) {
            if (this.return_query) {
                this.recordNamedBind("version", this.version);
            }
            preparedStatement.setString(++n, this.version);
        }
        if (this.lastModified != null) {
            if (this.return_query) {
                this.recordNamedBind("lastModified", this.lastModified);
            }
            preparedStatement.setString(++n, this.lastModified);
        }
        return n;
    }

    private int setStartAndEndTime(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.since != null) {
            if (this.return_query) {
                this.recordNamedBind("since", this.since);
            }
            preparedStatement.setString(++n, this.since);
        }
        if (this.until != null) {
            if (this.return_query) {
                this.recordNamedBind("until", this.until);
            }
            preparedStatement.setString(++n, this.until);
        }
        return n;
    }

    int bindUpdate(PreparedStatement preparedStatement, OracleDocument oracleDocument, Terminal terminal) throws SQLException, OracleException {
        int n = 0;
        byte[] byArray = OracleCollectionImpl.EMPTY_DATA;
        boolean bl = true;
        if (!this.collection.payloadBasedVersioning() && this.collection.admin().isHeterogeneous() && ((OracleDocumentImpl)oracleDocument).hasStreamContent() && !OracleDocumentImpl.isBinary(oracleDocument)) {
            ((TableCollectionImpl)this.collection).setStreamBind(preparedStatement, oracleDocument, ++n);
            bl = false;
        } else if (terminal == Terminal.MERGE_ONE && this.options.hasBinaryFormat() && !this.options.hasJsonType()) {
            ((TableCollectionImpl)this.collection).bindPayloadColumn(preparedStatement, ++n, oracleDocument.getContentAsByteArray());
        } else {
            byArray = ((TableCollectionImpl)this.collection).bindPayloadColumn(preparedStatement, ++n, oracleDocument);
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            switch (this.options.versioningMethod) {
                case 2: {
                    break;
                }
                case 1: {
                    OracleDatabaseImpl oracleDatabaseImpl = this.collection.getDatabase();
                    long l = oracleDatabaseImpl.getDatabaseTime();
                    preparedStatement.setLong(++n, l);
                    this.computedVersion = Long.toString(l);
                    break;
                }
                case 3: {
                    this.computedVersion = this.collection.getDatabase().generateKey();
                    preparedStatement.setString(++n, this.computedVersion);
                    break;
                }
                default: {
                    if (!bl || terminal == Terminal.MERGE_ONE) {
                        throw SODAUtils.makeException(SODAMessage.EX_NO_HASH_VERSION, this.options.uriName, this.options.getVersioningMethod());
                    }
                    this.computedVersion = this.collection.computeVersion(byArray);
                    preparedStatement.setString(++n, this.computedVersion);
                }
            }
        }
        n = ((TableCollectionImpl)this.collection).bindMediaTypeColumn(preparedStatement, n, oracleDocument);
        return n;
    }

    int bindReturning(CallableStatement callableStatement, int n) throws SQLException {
        if (this.options.timestampColumnName != null) {
            callableStatement.registerOutParameter(++n, 12);
        }
        if (this.options.versionColumnName != null && (this.options.versioningMethod == 0 || this.options.versioningMethod == 2)) {
            callableStatement.registerOutParameter(++n, 12);
        }
        if (this.options.creationColumnName != null) {
            callableStatement.registerOutParameter(++n, 12);
        }
        callableStatement.registerOutParameter(++n, 12);
        return n;
    }

    int bindReturning(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.options.timestampColumnName != null) {
            this.collection.db.registerReturnTimestamp(preparedStatement, ++n);
        }
        if (this.options.versionColumnName != null && (this.options.versioningMethod == 0 || this.options.versioningMethod == 2)) {
            this.collection.db.registerReturnString(preparedStatement, ++n);
        }
        if (this.options.creationColumnName != null) {
            this.collection.db.registerReturnTimestamp(preparedStatement, ++n);
        }
        return n;
    }

    int bindFlashback(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.asOfScn != null) {
            preparedStatement.setLong(++n, this.asOfScn);
        } else if (this.asOfTimestamp != null) {
            preparedStatement.setString(++n, this.asOfTimestamp);
        }
        return n;
    }

    void bindKeys(Iterator<String> iterator, PreparedStatement preparedStatement, int n, int n2) throws SQLException, OracleException {
        String string = null;
        int n3 = n2;
        int n4 = 0;
        while (iterator.hasNext()) {
            string = iterator.next();
            if (this.return_query) {
                this.recordQueryKey(n4++, string);
            }
            ((TableCollectionImpl)this.collection).bindKeyColumn(preparedStatement, ++n3, string);
        }
    }

    private Operation createReplaceStatement(Terminal terminal, OracleDocument oracleDocument) throws OracleException {
        if (this.key == null || this.isStartKey) {
            throw SODAUtils.makeException(SODAMessage.EX_KEY_MUST_BE_SPECIFIED, new Object[0]);
        }
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "document");
        }
        this.computedVersion = null;
        return this.generateOperation(terminal, oracleDocument);
    }

    @Override
    public OracleDocument replaceOneAndGet(OracleDocument oracleDocument) throws OracleException {
        this.collection.writeCheck("replaceOneAndGet");
        Operation operation = this.createReplaceStatement(Terminal.REPLACE_ONE_AND_GET, oracleDocument);
        PreparedStatement preparedStatement = operation.getPreparedStatement();
        CallableStatement callableStatement = operation.getCallableStatement();
        String string = null;
        String string2 = null;
        int n = 0;
        OracleDocumentImpl oracleDocumentImpl = null;
        try {
            n = preparedStatement.executeUpdate();
            if (n == 0) {
                OracleDocument oracleDocument2 = null;
                return oracleDocument2;
            }
            if (this.returningClause(Terminal.REPLACE_ONE_AND_GET) && (this.options.timestampColumnName != null || ((TableCollectionImpl)this.collection).returnVersion() || this.options.creationColumnName != null)) {
                Object object;
                int n2 = 0;
                if (callableStatement == null) {
                    object = this.collection.db.getReturnResultSet(preparedStatement);
                    if (object == null) {
                        OracleDocument oracleDocument3 = null;
                        return oracleDocument3;
                    }
                    if (!object.next()) {
                        object.close();
                        OracleDocument oracleDocument4 = null;
                        return oracleDocument4;
                    }
                    if (this.options.timestampColumnName != null) {
                        string = OracleDatabaseImpl.getTimestamp((ResultSet)object, ++n2);
                    }
                    if (((TableCollectionImpl)this.collection).returnVersion()) {
                        this.computedVersion = object.getString(++n2);
                    }
                    if (this.options.creationColumnName != null) {
                        string2 = OracleDatabaseImpl.getTimestamp((ResultSet)object, ++n2);
                    }
                    object.close();
                    object = null;
                } else {
                    n2 = operation.getReturnParameterIndex();
                    if (n2 >= 0) {
                        if (this.options.timestampColumnName != null) {
                            string = OracleDatabaseImpl.getTimestamp(callableStatement, ++n2);
                        }
                        if (((TableCollectionImpl)this.collection).returnVersion()) {
                            this.computedVersion = callableStatement.getString(++n2);
                        }
                        if (this.options.creationColumnName != null) {
                            string2 = OracleDatabaseImpl.getTimestamp(callableStatement, ++n2);
                        }
                        if ((object = callableStatement.getString(++n2)) == null || !((String)object).equals("1")) {
                            OracleDocument oracleDocument5 = null;
                            return oracleDocument5;
                        }
                    }
                }
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
            if (n == 1) {
                oracleDocumentImpl = new OracleDocumentImpl(this.collection.canonicalKey(this.key), this.computedVersion, string);
                oracleDocumentImpl.setCreatedOn(string2);
                String string3 = oracleDocument.getMediaType();
                ((TableCollectionImpl)this.collection).setContentType(string3, oracleDocumentImpl);
            }
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString() + "\n" + operation.getSqlText());
            }
            throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
        }
        finally {
            for (String string4 : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string4);
            }
        }
        return oracleDocumentImpl;
    }

    @Override
    public boolean replaceOne(OracleDocument oracleDocument) throws OracleException {
        return this.replaceOneWithOptionalMerge(oracleDocument, Terminal.REPLACE_ONE);
    }

    private boolean replaceOneWithOptionalMerge(OracleDocument oracleDocument, Terminal terminal) throws OracleException {
        this.collection.writeCheck("replaceOne");
        Operation operation = this.createReplaceStatement(terminal, oracleDocument);
        PreparedStatement preparedStatement = operation.getPreparedStatement();
        boolean bl = false;
        try {
            int n = preparedStatement.executeUpdate();
            if (n == 1) {
                bl = true;
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString() + "\n" + operation.getSqlText());
            }
            throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
        }
        finally {
            for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string);
            }
        }
        return bl;
    }

    @Override
    public int remove() throws OracleException {
        this.collection.writeCheck("remove");
        Operation operation = this.generateOperation(Terminal.REMOVE);
        PreparedStatement preparedStatement = operation.getPreparedStatement();
        int n = 0;
        try {
            n = preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString() + "\n" + operation.getSqlText());
            }
            throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
        }
        finally {
            for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string);
            }
        }
        return n;
    }

    @Override
    public OracleOperationBuilder limit(int n) throws OracleException {
        this.firstRowsHint(n);
        if (n < 1) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_POSITIVE, "limit");
        }
        if (this.lockRows) {
            throw SODAUtils.makeException(SODAMessage.EX_INCOMPATIBLE_METHODS, "lock()", "limit()");
        }
        this.limit = n;
        return this;
    }

    @Override
    public OracleOperationBuilder skip(long l) throws OracleException {
        if (l < 0L) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_NON_NEGATIVE, "skip");
        }
        if (this.lockRows) {
            throw SODAUtils.makeException(SODAMessage.EX_INCOMPATIBLE_METHODS, "lock()", "skip()");
        }
        this.skip = l;
        return this;
    }

    @Override
    public OracleOperationBuilder headerOnly() {
        this.proj = null;
        this.skipProjErrors = true;
        this.headerOnly = true;
        return this;
    }

    public OracleOperationBuilder firstRowsHint(int n) {
        if (n >= 0) {
            this.firstRows = n;
        }
        return this;
    }

    public String explainPlan(String string) throws OracleException {
        String string2;
        Operation operation = this.generateOperation(Terminal.EXPLAIN_PLAN);
        this.getResultSet(operation, true);
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            string = string.equalsIgnoreCase("all") ? "all" : (string.equalsIgnoreCase("typical") ? "typical" : "basic");
            String string3 = "select plan_table_output from table(dbms_xplan.display('plan_table', null, '" + string + "'))";
            preparedStatement = this.connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                stringBuilder.append(resultSet.getString(1));
                stringBuilder.append("\n");
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            string2 = stringBuilder.toString();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString() + "\n" + operation.getSqlText());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
            }
            catch (Throwable throwable) {
                for (String string4 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string4);
                }
                throw throwable;
            }
        }
        for (String string5 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string5);
        }
        return string2;
    }

    @Override
    public long count() throws OracleException {
        if (this.skip > 0L || this.limit > 0) {
            throw SODAUtils.makeException(SODAMessage.EX_SKIP_AND_LIMIT_WITH_COUNT, new Object[0]);
        }
        if (this.lockRows) {
            throw SODAUtils.makeException(SODAMessage.EX_INCOMPATIBLE_METHODS, "lock()", "count()");
        }
        Operation operation = this.generateOperation(Terminal.COUNT);
        long l = 0L;
        PreparedStatement preparedStatement = null;
        try {
            this.metrics.startTiming();
            preparedStatement = operation.getPreparedStatement();
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordReads(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString() + "\n" + operation.getSqlText());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
            }
            catch (Throwable throwable) {
                for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string);
                }
                throw throwable;
            }
        }
        for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string);
        }
        return l;
    }

    @Override
    public OracleDocument getOne() throws OracleException {
        Operation operation = this.generateOperation(Terminal.GET_ONE);
        ResultSet resultSet = this.getResultSet(operation);
        long l = this.metrics.endTiming();
        OracleCursorImpl oracleCursorImpl = new OracleCursorImpl(this.options, this.metrics, operation, resultSet, this.selectPatchedDoc ? false : this.proj != null, this.selectPatchedDoc || this.selectMergedDoc);
        oracleCursorImpl.setElapsedTime(l);
        OracleDocument oracleDocument = null;
        if (oracleCursorImpl.hasNext()) {
            oracleDocument = oracleCursorImpl.next();
        }
        try {
            oracleCursorImpl.close();
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.getCause();
            if (throwable instanceof SQLException) {
                throw SODAUtils.makeExceptionWithSQLText((SQLException)throwable, operation.getSqlText());
            }
            throw new IllegalStateException();
        }
        return oracleDocument;
    }

    private void appendColumn(StringBuilder stringBuilder, String string) {
        this.appendAliasedColumn(stringBuilder, string, null);
    }

    private void appendAliasedColumn(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(".");
        }
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
    }

    private boolean generateSpatialClauses(StringBuilder stringBuilder, AndORTree andORTree, boolean bl) {
        if (!andORTree.hasSpatialClause()) {
            return bl;
        }
        this.spatialClauses = andORTree.getSpatialOperators();
        if (this.spatialClauses.size() == 0) {
            return bl;
        }
        for (SpatialClause spatialClause : this.spatialClauses) {
            this.addAnd(stringBuilder, bl);
            bl = true;
            stringBuilder.append("(");
            stringBuilder.append(spatialClause.getOperator());
            stringBuilder.append("(");
            stringBuilder.append("JSON_VALUE(");
            this.appendColumn(stringBuilder, this.options.contentColumnName);
            stringBuilder.append(", '");
            spatialClause.getPath().toSingletonString(stringBuilder);
            stringBuilder.append("' returning SDO_GEOMETRY");
            String string = spatialClause.getErrorClause();
            if (string != null && !string.equals("null on error")) {
                stringBuilder.append(" ");
                stringBuilder.append(string);
            }
            stringBuilder.append("),");
            stringBuilder.append("JSON_VALUE(?, '$' returning SDO_GEOMETRY error on error)");
            if (spatialClause.getDistance() != null) {
                stringBuilder.append(", ?");
            }
            if (spatialClause.isNot()) {
                stringBuilder.append(") <> 'TRUE')");
                continue;
            }
            stringBuilder.append(") = 'TRUE')");
        }
        return bl;
    }

    private boolean generateFullTextClauses(StringBuilder stringBuilder, AndORTree andORTree, boolean bl) {
        if (!andORTree.hasContainsClause()) {
            return bl;
        }
        this.containsClauses = andORTree.getContainsOperators();
        if (this.containsClauses.size() == 0) {
            return bl;
        }
        for (ContainsClause containsClause : this.containsClauses) {
            this.addAnd(stringBuilder, bl);
            bl = true;
            if (containsClause.isNot()) {
                stringBuilder.append("not(");
            }
            stringBuilder.append("JSON_TextContains(");
            this.appendColumn(stringBuilder, this.options.contentColumnName);
            stringBuilder.append(", '");
            containsClause.getPath().toLaxString(stringBuilder);
            stringBuilder.append("', ?)");
            if (!containsClause.isNot()) continue;
            stringBuilder.append(")");
        }
        return bl;
    }

    private boolean generateSqlJsonClauses(StringBuilder stringBuilder, AndORTree andORTree, boolean bl) {
        if (!andORTree.hasSqlJsonClause()) {
            return bl;
        }
        this.sqlJsonClauses = andORTree.getSqlJsonOperators();
        if (this.sqlJsonClauses.size() == 0) {
            return bl;
        }
        for (SqlJsonClause sqlJsonClause : this.sqlJsonClauses) {
            int n;
            String string;
            ValueTypePair valueTypePair;
            String string2;
            this.addAnd(stringBuilder, bl);
            bl = true;
            stringBuilder.append(sqlJsonClause.isNot() ? "not(" : "(");
            String string3 = sqlJsonClause.getCompareFunction();
            if (string3 != null) {
                stringBuilder.append(string3);
                stringBuilder.append("(");
            }
            if ((string2 = sqlJsonClause.getConversionFunction()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append("(");
            }
            if (sqlJsonClause.isExists()) {
                stringBuilder.append("JSON_QUERY(");
            } else {
                stringBuilder.append("JSON_VALUE(");
            }
            this.appendColumn(stringBuilder, this.options.contentColumnName);
            stringBuilder.append(", '");
            sqlJsonClause.getPath().toSingletonString(stringBuilder);
            stringBuilder.append("'");
            String string4 = sqlJsonClause.getReturningType();
            if (sqlJsonClause.isExists()) {
                stringBuilder.append(" with array wrapper)");
            } else {
                if (string4 != null) {
                    stringBuilder.append(" returning ");
                    stringBuilder.append(string4);
                }
                stringBuilder.append(")");
            }
            if (string2 != null) {
                stringBuilder.append(")");
            }
            int n2 = 0;
            for (int i = 0; i < sqlJsonClause.getArgCount(); ++i) {
                stringBuilder.append(",");
                valueTypePair = sqlJsonClause.getValue(n2++);
                andORTree.appendFormattedBind(stringBuilder, valueTypePair, sqlJsonClause);
            }
            if (string3 != null) {
                stringBuilder.append(")");
            }
            if ((string = sqlJsonClause.getComparator()) != null) {
                stringBuilder.append(" ");
                stringBuilder.append(string);
            }
            if ((n = sqlJsonClause.getBindCount()) == 1) {
                stringBuilder.append(" ");
                valueTypePair = sqlJsonClause.getValue(n2++);
                andORTree.appendFormattedBind(stringBuilder, valueTypePair, sqlJsonClause);
            } else if (n > 1) {
                stringBuilder.append(" (");
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append(",");
                    }
                    valueTypePair = sqlJsonClause.getValue(n2++);
                    andORTree.appendFormattedBind(stringBuilder, valueTypePair, sqlJsonClause);
                }
                stringBuilder.append(")");
            }
            stringBuilder.append(")");
        }
        return bl;
    }

    private void generateFilterSpecJsonExists(StringBuilder stringBuilder, AndORTree andORTree) {
        stringBuilder.append("JSON_EXISTS(");
        this.appendColumn(stringBuilder, this.options.contentColumnName);
        this.collection.addFormat(stringBuilder);
        stringBuilder.append(",");
        andORTree.appendJsonExists(stringBuilder);
        stringBuilder.append(")");
    }

    private int getNumberOfFilterSpecKeys() {
        int n = 0;
        if (this.filterSpec != null) {
            if (this.tree == null) {
                throw new IllegalStateException();
            }
            HashSet<String> hashSet = this.tree.getKeys();
            if (hashSet != null) {
                n = hashSet.size();
            }
        }
        return n;
    }

    private void generateWhere(StringBuilder stringBuilder) {
        int n;
        boolean bl = false;
        int n2 = this.getNumberOfFilterSpecKeys();
        if (!this.whereClauseRequired()) {
            return;
        }
        stringBuilder.append(" where ");
        if (this.key != null) {
            stringBuilder.append("(");
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            if (!this.isStartKey) {
                stringBuilder.append(" = ");
            } else {
                stringBuilder.append(this.ascending ? " >" : " <");
                stringBuilder.append(this.startKeyInclusive ? "= " : " ");
            }
            ((TableCollectionImpl)this.collection).addKey(stringBuilder);
            bl = true;
        } else if (this.likePattern != null) {
            stringBuilder.append("(");
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            stringBuilder.append(" LIKE ?");
            if (this.likeEscape != null) {
                stringBuilder.append(" ESCAPE ?");
            }
            bl = true;
        } else if (this.keys != null) {
            stringBuilder.append(" (");
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            stringBuilder.append(" in (");
            n = 0;
            while (n < this.keys.size()) {
                if (++n == this.keys.size()) {
                    stringBuilder.append("?)");
                    continue;
                }
                stringBuilder.append("?,");
            }
            bl = true;
        }
        if (n2 > 0) {
            if (bl) {
                if (this.isStartKey) {
                    stringBuilder.append(" ) and ( ");
                } else {
                    stringBuilder.append(" or ");
                }
            } else {
                stringBuilder.append("( ");
            }
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            stringBuilder.append(" in (");
            n = 0;
            while (n < n2) {
                if (++n == n2) {
                    stringBuilder.append("?)");
                    continue;
                }
                stringBuilder.append("?,");
            }
            this.addCloseParenthesis(stringBuilder);
            bl = true;
        } else if (bl) {
            this.addCloseParenthesis(stringBuilder);
        }
        if (this.since != null || this.until != null) {
            this.addAnd(stringBuilder, bl);
            stringBuilder.append(" ( ");
            this.appendColumn(stringBuilder, this.options.timestampColumnName);
            if (this.since != null) {
                stringBuilder.append(" >");
                if (this.timeRangeInclusive) {
                    stringBuilder.append("=");
                }
                OracleDatabaseImpl.addToTimestamp(" ", stringBuilder);
            }
            if (this.until != null) {
                if (this.since != null) {
                    stringBuilder.append(" and ");
                    this.appendColumn(stringBuilder, this.options.timestampColumnName);
                }
                OracleDatabaseImpl.addToTimestamp(" <= ", stringBuilder);
            }
            this.addCloseParenthesis(stringBuilder);
            bl = true;
        }
        if (this.version != null) {
            this.addAnd(stringBuilder, bl);
            stringBuilder.append(" ( ");
            this.appendColumn(stringBuilder, this.options.versionColumnName);
            stringBuilder.append(" = ");
            switch (this.options.versioningMethod) {
                case 1: 
                case 2: {
                    stringBuilder.append("to_number(?)");
                    break;
                }
                default: {
                    stringBuilder.append("?");
                }
            }
            this.addCloseParenthesis(stringBuilder);
            bl = true;
        }
        if (this.lastModified != null) {
            this.addAnd(stringBuilder, bl);
            stringBuilder.append(" ( ");
            this.appendColumn(stringBuilder, this.options.timestampColumnName);
            OracleDatabaseImpl.addToTimestamp(" = ", stringBuilder);
            this.addCloseParenthesis(stringBuilder);
            bl = true;
        }
        if (this.filterSpec != null) {
            if (this.tree.hasJsonExists()) {
                this.addAnd(stringBuilder, bl);
                this.generateFilterSpecJsonExists(stringBuilder, this.tree);
                bl = true;
            }
            if (this.tree.hasSpatialClause()) {
                bl = this.generateSpatialClauses(stringBuilder, this.tree, bl);
            }
            if (this.tree.hasContainsClause()) {
                bl = this.generateFullTextClauses(stringBuilder, this.tree, bl);
            }
            if (this.tree.hasSqlJsonClause()) {
                bl = this.generateSqlJsonClauses(stringBuilder, this.tree, bl);
            }
        }
    }

    private boolean whereClauseRequired() {
        return this.key != null || this.keys != null || this.likePattern != null || this.since != null || this.until != null || this.version != null || this.lastModified != null || this.filterSpec != null && (this.tree.hasJsonExists() || this.tree.hasSpatialClause() || this.tree.hasContainsClause() || this.tree.hasSqlJsonClause() || this.tree.hasKeys());
    }

    private boolean hasFilterSpecOrderBy() {
        return this.filterSpec != null && this.tree.hasOrderBy();
    }

    private boolean projection(Terminal terminal) {
        return this.proj != null && !this.countOrWrite(terminal) && !this.selectStageOfPatch();
    }

    private boolean countOrWrite(Terminal terminal) {
        return terminal == Terminal.COUNT || this.write(terminal);
    }

    private boolean write(Terminal terminal) {
        return terminal == Terminal.REMOVE || this.isReplaceOrMerge(terminal);
    }

    private boolean selectStageOfPatch() {
        return this.selectPatchedDoc || this.selectMergedDoc;
    }

    private boolean returningClause(Terminal terminal) {
        boolean bl = this.collection.internalDriver;
        if (!this.collection.oracleDriver && !this.collection.useCallableReturns) {
            bl = true;
        }
        if (terminal == Terminal.REPLACE_ONE_AND_GET && !bl) {
            return this.options.timestampColumnName != null || this.options.creationColumnName != null || ((TableCollectionImpl)this.collection).returnVersion();
        }
        return false;
    }

    private boolean isReplaceOrMerge(Terminal terminal) {
        return terminal == Terminal.REPLACE_ONE_AND_GET || terminal == Terminal.REPLACE_ONE || terminal == Terminal.MERGE_ONE;
    }

    private boolean flashback(Terminal terminal) {
        return !this.selectStageOfPatch() && !this.paginationWorkaround(terminal) && (terminal == Terminal.COUNT || terminal == Terminal.GET_ONE || terminal == Terminal.GET_CURSOR);
    }

    private boolean paginationWorkaround(Terminal terminal) {
        return !(!PAGINATION_WORKAROUND || this.asOfTimestamp != null || this.asOfScn != null || this.skip <= 0L && this.limit <= 0 || terminal != Terminal.GET_CURSOR && terminal != Terminal.GET_ONE && terminal != Terminal.EXPLAIN_PLAN || this.projection(terminal) || this.whereClauseRequired() || this.hasFilterSpecOrderBy() || this.selectPatchedDoc || this.selectMergedDoc);
    }

    private void addAnd(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(" and ");
        }
    }

    private void addCloseParenthesis(StringBuilder stringBuilder) {
        stringBuilder.append(" ) ");
    }

    private void generateFilterSpecOrderBy(StringBuilder stringBuilder, AndORTree andORTree) throws OracleException {
        ArrayList<Predicate> arrayList = andORTree.getOrderByArray();
        Predicate predicate = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            predicate = arrayList.get(i);
            if (i == 0) {
                stringBuilder.append(" order by");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(" JSON_VALUE(");
            this.appendColumn(stringBuilder, this.options.contentColumnName);
            this.collection.addFormat(stringBuilder);
            JsonQueryPath jsonQueryPath = predicate.getQueryPath();
            if (jsonQueryPath.hasArraySteps()) {
                throw SODAUtils.makeException(SODAMessage.EX_ARRAY_STEPS_IN_PATH, new Object[0]);
            }
            stringBuilder.append(", '");
            jsonQueryPath.toSingletonString(stringBuilder);
            stringBuilder.append("'");
            String string2 = predicate.getReturnType();
            if (string2 != null) {
                stringBuilder.append(" returning ");
                stringBuilder.append(string2);
            }
            if ((string = predicate.getErrorClause()) != null && !string.equals("null on error")) {
                stringBuilder.append(" ");
                stringBuilder.append(string);
            }
            stringBuilder.append(")");
            if (predicate.getValue().equals("1")) {
                stringBuilder.append(" asc");
                continue;
            }
            stringBuilder.append(" desc");
        }
    }

    private void generateOrderBy(StringBuilder stringBuilder, boolean bl) {
        if (this.isStartKey && !bl) {
            stringBuilder.append(" order by ");
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            if (!this.ascending) {
                stringBuilder.append(" desc ");
            }
        } else if (!(this.since == null && this.until == null || bl)) {
            stringBuilder.append(" order by ");
            if (this.since != null || this.until != null) {
                this.appendColumn(stringBuilder, this.options.timestampColumnName);
                stringBuilder.append(",");
            }
            this.appendColumn(stringBuilder, this.options.keyColumnName);
        } else if (this.skip > 0L || this.limit > 0) {
            if (!bl) {
                stringBuilder.append(" order by ");
            } else {
                stringBuilder.append(", ");
            }
            this.appendColumn(stringBuilder, this.options.keyColumnName);
        }
    }

    private void generateOffsetAndFetchNext(StringBuilder stringBuilder) {
        if (this.skip > 0L) {
            stringBuilder.append(" offset " + Long.toString(this.skip) + " rows");
        }
        if (this.limit > 0) {
            stringBuilder.append(" fetch next " + Integer.toString(this.limit) + " rows only");
        }
    }

    private void generateFlashback(StringBuilder stringBuilder) {
        if (this.asOfScn != null) {
            stringBuilder.append(" as of scn ?");
        } else if (this.asOfTimestamp != null) {
            stringBuilder.append(" as of timestamp ");
            stringBuilder.append("to_timestamp_tz(?,'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM')");
            stringBuilder.append(" at local");
        }
    }

    private void appendTable(StringBuilder stringBuilder) {
        stringBuilder.append("\"");
        if (this.options.dbSchema != null) {
            stringBuilder.append(this.options.dbSchema);
            stringBuilder.append("\".\"");
        }
        stringBuilder.append(this.options.dbObjectName);
        stringBuilder.append("\"");
    }

    private void generatePaginationWorkaround(StringBuilder stringBuilder, Terminal terminal) {
        stringBuilder.setLength(0);
        String string = "TAB_";
        String string2 = "TAB1_";
        String string3 = "TAB2_";
        if (terminal == Terminal.EXPLAIN_PLAN) {
            stringBuilder.append("explain plan for ");
        }
        boolean bl = this.projection(terminal);
        stringBuilder.append("select ");
        stringBuilder.append(" /*+ LEADING(" + string2 + ") ");
        stringBuilder.append("USE_NL(" + string3 + ") */ ");
        this.appendTableColumns(stringBuilder, string3, bl, terminal);
        stringBuilder.append(" from ");
        stringBuilder.append(" ( select /*+ INDEX(");
        stringBuilder.append(string);
        stringBuilder.append(") */ ");
        this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string);
        stringBuilder.append(" from ");
        this.appendTable(stringBuilder);
        stringBuilder.append(" ");
        stringBuilder.append(string);
        this.generateOffsetAndFetchNext(stringBuilder);
        stringBuilder.append(" ) ");
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        this.appendTable(stringBuilder);
        stringBuilder.append(" ");
        stringBuilder.append(string3);
        stringBuilder.append(" where ");
        stringBuilder.append(string2);
        stringBuilder.append(".rowid = ");
        stringBuilder.append(string3);
        stringBuilder.append(".rowid ");
        stringBuilder.append(" order by ");
        this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string2);
    }

    private void generateSelect(StringBuilder stringBuilder, Terminal terminal) {
        stringBuilder.setLength(0);
        if (terminal == Terminal.EXPLAIN_PLAN) {
            stringBuilder.append("explain plan for ");
        }
        stringBuilder.append("select ");
        if (this.firstRows >= 0 || this.hints != null) {
            stringBuilder.append("/*+");
            if (this.firstRows >= 0) {
                stringBuilder.append(" FIRST_ROWS(");
                stringBuilder.append(this.firstRows);
                stringBuilder.append(')');
            }
            if (this.hints != null) {
                stringBuilder.append(" " + this.hints);
            }
            stringBuilder.append(" */ ");
        }
        boolean bl = this.projection(terminal);
        if (terminal == Terminal.COUNT) {
            stringBuilder.append(" count(\"");
            stringBuilder.append(this.options.keyColumnName);
            stringBuilder.append("\")");
        } else {
            this.appendTableColumns(stringBuilder, null, bl, terminal);
        }
        stringBuilder.append(" from ");
        this.appendTable(stringBuilder);
    }

    private void appendTableColumns(StringBuilder stringBuilder, String string, boolean bl, Terminal terminal) {
        if (this.selectPatchedDoc) {
            if (this.options.hasBinaryFormat() || this.options.hasJsonType()) {
                if (this.options.contentDataType != 4 && this.options.hasBinaryFormat()) {
                    throw new IllegalStateException();
                }
                stringBuilder.append("json_patch(");
                this.appendAliasedColumn(stringBuilder, this.options.contentColumnName, string);
                if (this.options.hasJsonType()) {
                    stringBuilder.append(",? ");
                } else {
                    stringBuilder.append(",? returning blob format oson");
                }
                if (!this.patchSpecExceptionOnly) {
                    stringBuilder.append(" error on error),");
                } else {
                    stringBuilder.append("),");
                }
            } else {
                switch (this.options.contentDataType) {
                    case 4: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_PATCH_B(");
                        break;
                    }
                    case 5: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_PATCH_C(");
                        break;
                    }
                    case 6: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_PATCH_NC(");
                        break;
                    }
                    case 3: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_PATCH_N(");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_PATCH_R(");
                        break;
                    }
                    default: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_PATCH(");
                    }
                }
                this.appendAliasedColumn(stringBuilder, this.options.contentColumnName, string);
                stringBuilder.append(",?");
                if (this.patchSpecExceptionOnly) {
                    stringBuilder.append(",'INVALID_PATCH_SPEC'),");
                } else {
                    stringBuilder.append("),");
                }
            }
        } else if (this.selectMergedDoc) {
            this.appendMergePatchExpression(stringBuilder, string);
            stringBuilder.append(",");
        } else if (bl) {
            if (this.options.hasBinaryFormat() || this.options.hasJsonType()) {
                if (this.options.contentDataType != 4 && this.options.hasBinaryFormat()) {
                    throw new IllegalStateException();
                }
                stringBuilder.append("json_patch(");
                this.appendAliasedColumn(stringBuilder, this.options.contentColumnName, string);
                if (this.options.hasJsonType()) {
                    stringBuilder.append(",? project ");
                } else {
                    stringBuilder.append(",? project returning blob format oson");
                }
                if (!this.skipProjErrors) {
                    stringBuilder.append(" error on error),");
                } else {
                    stringBuilder.append("),");
                }
            } else {
                switch (this.options.contentDataType) {
                    case 4: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_SELECT_B(");
                        break;
                    }
                    case 5: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_SELECT_C(");
                        break;
                    }
                    case 6: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_SELECT_NC(");
                        break;
                    }
                    case 3: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_SELECT_N(");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_SELECT_R(");
                        break;
                    }
                    default: {
                        stringBuilder.append("DBMS_SODA_DOM.JSON_SELECT(");
                    }
                }
                this.appendAliasedColumn(stringBuilder, this.options.contentColumnName, string);
                stringBuilder.append(",?,");
                if (this.skipProjErrors) {
                    stringBuilder.append("'INVALID_PROJECTION_SPEC'),");
                } else {
                    stringBuilder.append("'ALL'),");
                }
            }
        } else if (!this.headerOnly) {
            this.appendAliasedColumn(stringBuilder, this.options.contentColumnName, string);
            stringBuilder.append(",");
        }
        switch (this.options.keyDataType) {
            case 3: {
                stringBuilder.append("to_char(");
                this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string);
                stringBuilder.append(")");
                break;
            }
            case 4: {
                stringBuilder.append("rawtohex(");
                this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string);
                stringBuilder.append(")");
                break;
            }
            case 1: 
            case 2: {
                this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string);
            }
        }
        if (this.options.doctypeColumnName != null) {
            stringBuilder.append(",");
            this.appendAliasedColumn(stringBuilder, this.options.doctypeColumnName, string);
        }
        if (this.options.timestampColumnName != null && !this.selectPatchedDoc && !this.selectMergedDoc) {
            stringBuilder.append(",");
            this.appendAliasedColumn(stringBuilder, this.options.timestampColumnName, string);
        }
        if (this.options.creationColumnName != null && !this.selectPatchedDoc && !this.selectMergedDoc) {
            stringBuilder.append(",");
            this.appendAliasedColumn(stringBuilder, this.options.creationColumnName, string);
        }
        if (this.options.versionColumnName != null && !this.selectPatchedDoc && !this.selectMergedDoc) {
            stringBuilder.append(",");
            this.appendAliasedColumn(stringBuilder, this.options.versionColumnName, string);
        }
    }

    private void appendMergePatchExpression(StringBuilder stringBuilder, String string) {
        if (this.options.hasBinaryFormat() || this.options.hasJsonType()) {
            if (this.options.contentDataType != 4 && this.options.hasBinaryFormat()) {
                throw new IllegalStateException();
            }
            stringBuilder.append("json_mergepatch(");
            this.appendAliasedColumn(stringBuilder, this.options.contentColumnName, string);
            if (this.options.hasJsonType()) {
                stringBuilder.append(",? ");
            } else {
                stringBuilder.append(",? returning blob format oson");
            }
            if (!this.patchSpecExceptionOnly) {
                stringBuilder.append(" error on error)");
            } else {
                stringBuilder.append(")");
            }
        } else {
            switch (this.options.contentDataType) {
                case 4: {
                    stringBuilder.append("JSON_MERGEPATCH(");
                    break;
                }
                case 5: {
                    stringBuilder.append("DBMS_SODA_DOM.JSON_MERGE_PATCH_C(");
                    break;
                }
                case 6: {
                    stringBuilder.append("DBMS_SODA_DOM.JSON_MERGE_PATCH_NC(");
                    break;
                }
                case 3: {
                    stringBuilder.append("DBMS_SODA_DOM.JSON_MERGE_PATCH_N(");
                    break;
                }
                case 2: {
                    stringBuilder.append("DBMS_SODA_DOM.JSON_MERGE_PATCH_R(");
                    break;
                }
                default: {
                    stringBuilder.append("DBMS_SODA_DOM.JSON_MERGE_PATCH(");
                }
            }
            this.appendAliasedColumn(stringBuilder, this.options.contentColumnName, string);
            stringBuilder.append(",?");
            if (this.patchSpecExceptionOnly) {
                stringBuilder.append(",'INVALID_PATCH_SPEC'),");
            } else {
                stringBuilder.append(")");
            }
        }
    }

    private void generateUpdate(StringBuilder stringBuilder, Terminal terminal) {
        stringBuilder.append("update ");
        if (this.hints != null) {
            stringBuilder.append("/*+ " + this.hints + " */");
        }
        this.appendTable(stringBuilder);
        stringBuilder.append(" set \"");
        stringBuilder.append(this.options.contentColumnName);
        if (terminal == Terminal.MERGE_ONE) {
            stringBuilder.append("\" = ");
            this.appendMergePatchExpression(stringBuilder, null);
        } else {
            stringBuilder.append("\" = ?");
        }
        if (this.options.timestampColumnName != null) {
            stringBuilder.append(", \"");
            stringBuilder.append(this.options.timestampColumnName);
            stringBuilder.append("\" = sys_extract_utc(SYSTIMESTAMP)");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            stringBuilder.append(", \"");
            stringBuilder.append(this.options.versionColumnName);
            stringBuilder.append("\" = ");
            if (this.options.versioningMethod == 2) {
                stringBuilder.append("(\"");
                stringBuilder.append(this.options.versionColumnName);
                stringBuilder.append("\" + 1)");
            } else {
                stringBuilder.append("?");
            }
        }
        if (this.options.doctypeColumnName != null) {
            stringBuilder.append(", \"");
            stringBuilder.append(this.options.doctypeColumnName);
            stringBuilder.append("\" = ?");
        }
    }

    private void generateReturning(StringBuilder stringBuilder) {
        TableCollectionImpl tableCollectionImpl = (TableCollectionImpl)this.collection;
        int n = 0;
        stringBuilder.append(" returning ");
        if (this.options.timestampColumnName != null) {
            stringBuilder.append('\"');
            stringBuilder.append(this.options.timestampColumnName);
            stringBuilder.append('\"');
            ++n;
        }
        if (tableCollectionImpl.returnVersion()) {
            TableCollectionImpl.addComma(stringBuilder, n);
            stringBuilder.append("\"");
            stringBuilder.append(this.options.versionColumnName);
            stringBuilder.append("\"");
            ++n;
        }
        if (this.options.creationColumnName != null) {
            TableCollectionImpl.addComma(stringBuilder, n);
            stringBuilder.append('\"');
            stringBuilder.append(this.options.creationColumnName);
            stringBuilder.append('\"');
            ++n;
        }
        if (this.collection.useCallableReturns) {
            TableCollectionImpl.addComma(stringBuilder, n);
            stringBuilder.append("'1'");
            ++n;
        }
        TableCollectionImpl.addInto(stringBuilder, n);
    }

    private void generateRemove(StringBuilder stringBuilder) {
        stringBuilder.append("delete");
        if (this.hints != null) {
            stringBuilder.append(" /*+ " + this.hints + " */");
        }
        stringBuilder.append(" from ");
        this.appendTable(stringBuilder);
    }

    private static enum Terminal {
        COUNT,
        GET_ONE,
        GET_CURSOR,
        REMOVE,
        REPLACE_ONE_AND_GET,
        REPLACE_ONE,
        MERGE_ONE,
        PATCH_ONE,
        PATCH,
        EXPLAIN_PLAN;

    }
}

