/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import oracle.json.logging.OracleLog;
import oracle.json.util.ByteArray;
import oracle.json.util.JsonByteArray;
import oracle.json.util.LimitedInputStream;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;

public class OracleDocumentImpl
implements OracleDocument {
    static final String APPLICATION_JSON = "application/json";
    private static final int UNKNOWN_LENGTH = -1;
    private static final Logger log = Logger.getLogger(OracleDocumentImpl.class.getName());
    private final String docid;
    private final String tstamp;
    private final String version;
    private byte[] payload;
    private SoftReference<byte[]> payloadRef = null;
    private InputStream payloadStream;
    private String ctype = "application/json";
    private String creationTime;
    private int len = -1;
    private boolean binary = false;
    Object jsonFactory = null;

    OracleDocumentImpl(String string, String string2, String string3, byte[] byArray, String string4) {
        this.docid = string;
        this.version = string2;
        this.tstamp = string3;
        this.payload = byArray;
        if (string4 != null) {
            this.ctype = string4;
        }
        if (byArray != null) {
            this.len = byArray.length;
        }
    }

    OracleDocumentImpl(String string, String string2, String string3, InputStream inputStream, String string4) {
        this.docid = string;
        this.version = string2;
        this.tstamp = string3;
        this.payloadStream = inputStream;
        if (string4 != null) {
            this.ctype = string4;
        }
        if (inputStream != null && (inputStream instanceof LimitedInputStream || inputStream instanceof ByteArrayInputStream)) {
            try {
                this.len = inputStream.available();
            }
            catch (IOException iOException) {
                this.len = -1;
            }
        }
    }

    OracleDocumentImpl(String string, String string2, String string3, byte[] byArray) {
        this(string, string2, string3, byArray, null);
    }

    OracleDocumentImpl(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4 == null ? (byte[])null : string4.getBytes(ByteArray.DEFAULT_CHARSET), string5);
    }

    OracleDocumentImpl(String string, String string2, String string3) {
        this(string, string2, string3, (byte[])null, null);
    }

    OracleDocumentImpl(String string, String string2) {
        this(string, null, null, string2 == null ? (byte[])null : string2.getBytes(ByteArray.DEFAULT_CHARSET), null);
    }

    OracleDocumentImpl(String string) {
        this(null, string);
    }

    OracleDocumentImpl(String string, byte[] byArray) {
        this(string, null, null, byArray, null);
    }

    OracleDocumentImpl(String string, InputStream inputStream) throws IOException {
        this(string, inputStream, null);
    }

    OracleDocumentImpl(String string, InputStream inputStream, String string2) throws IOException {
        this(string, null, null, inputStream, string2);
    }

    OracleDocumentImpl(byte[] byArray) {
        this(null, null, null, byArray, null);
    }

    @Override
    public String getKey() {
        return this.docid;
    }

    @Override
    public String getLastModified() {
        return this.tstamp;
    }

    @Override
    public String getCreatedOn() {
        return this.creationTime;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public byte[] getContentAsByteArray() throws OracleException {
        if (this.payloadStream != null) {
            try {
                this.payload = JsonByteArray.loadStream(this.payloadStream).toArray();
            }
            catch (IOException iOException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(iOException.toString());
                }
                throw new OracleException(iOException);
            }
            this.payloadStream = null;
        } else if (this.binary && this.payload != null) {
            return this.convertBinaryToUTF8();
        }
        return this.payload;
    }

    private byte[] convertBinaryToUTF8() throws OracleException {
        byte[] byArray;
        if (this.payloadRef != null && (byArray = this.payloadRef.get()) != null) {
            return byArray;
        }
        byArray = OracleDatabaseImpl.binaryToText(this.payload, this.jsonFactory);
        this.payloadRef = new SoftReference<byte[]>(byArray);
        return byArray;
    }

    public InputStream getContentAsStream() throws OracleException {
        if (this.payloadStream != null) {
            return this.payloadStream;
        }
        if (this.binary && this.payload != null) {
            return new ByteArrayInputStream(this.convertBinaryToUTF8());
        }
        return this.payload == null ? null : new ByteArrayInputStream(this.payload);
    }

    public boolean hasStreamContent() {
        return this.payloadStream != null;
    }

    @Override
    public String getContentAsString() throws OracleException {
        return this.getContentAsString(false);
    }

    public String getContentAsString(boolean bl) throws OracleException {
        if (!this.isJSON()) {
            throw SODAUtils.makeException(SODAMessage.EX_MEDIA_TYPE_NOT_JSON, new Object[0]);
        }
        byte[] byArray = this.getContentAsByteArray();
        if (byArray == null) {
            return null;
        }
        Charset charset = JsonByteArray.getJsonCharset(byArray);
        if (!bl) {
            return new String(byArray, charset);
        }
        try {
            return ByteArray.bytesToString(byArray, charset);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new OracleException(characterCodingException);
        }
    }

    byte[] getBinaryContentAsByteArray() {
        return this.payload;
    }

    void setContent(byte[] byArray) {
        this.payload = byArray;
    }

    private boolean isJSON(String string) {
        if (string == null) {
            return false;
        }
        return string == APPLICATION_JSON || string.equals(APPLICATION_JSON);
    }

    @Override
    public boolean isJSON() {
        return this.isJSON(this.ctype);
    }

    public boolean isBinary() {
        return this.binary;
    }

    @Override
    public String getMediaType() {
        return this.ctype;
    }

    @Override
    public int getContentLength() {
        return this.len;
    }

    void setContentType(String string) {
        this.ctype = string;
    }

    void setContentTypeJson() {
        this.setContentType(APPLICATION_JSON);
    }

    void setCreatedOn(String string) {
        this.creationTime = string;
    }

    void setBinary() {
        this.binary = true;
    }

    void setJsonFactory(Object object) {
        this.jsonFactory = object;
    }

    public String toString() {
        return this.docid;
    }

    @Override
    public <T> T getContentAs(Class<T> clazz) throws OracleException {
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.getContentAsString());
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return clazz.cast(new StringReader(this.getContentAsString()));
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.getContentAsStream());
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return clazz.cast(this.getContentAsByteArray());
        }
        if (JsonValue.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.getJsonValue());
        }
        if (JsonParser.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.getJsonParser());
        }
        if (OracleDatabaseImpl.JSON_VALUE_CLASS.isAssignableFrom(clazz)) {
            return clazz.cast(this.getOracleJsonValue());
        }
        if (OracleDatabaseImpl.JSON_PARSE_CLASS.isAssignableFrom(clazz)) {
            return clazz.cast(this.getOracleJsonParser());
        }
        throw SODAUtils.makeException(SODAMessage.EX_INVALID_TYPE_MAPPING, clazz);
    }

    private JsonValue getJsonValue() throws OracleException {
        if (this.isBinary()) {
            return OracleDatabaseImpl.binaryToJsonValue(this.getBinaryContentAsByteArray(), this.jsonFactory);
        }
        InputStream inputStream = this.getContentAsStream();
        JsonReader jsonReader = Json.createReader((InputStream)inputStream);
        JsonValue jsonValue = jsonReader.readValue();
        jsonReader.close();
        return jsonValue;
    }

    private Object getOracleJsonValue() throws OracleException {
        return this.isBinary() ? OracleDatabaseImpl.binaryToOracleJsonValue(this.getBinaryContentAsByteArray(), this.jsonFactory) : OracleDatabaseImpl.textToOracleJsonValue(this.getBinaryContentAsByteArray(), this.jsonFactory);
    }

    private Object getOracleJsonParser() throws OracleException {
        return this.isBinary() ? OracleDatabaseImpl.createBinaryParser(this.getBinaryContentAsByteArray(), this.jsonFactory) : OracleDatabaseImpl.createTextParser(this.getBinaryContentAsByteArray(), this.jsonFactory);
    }

    private JsonParser getJsonParser() throws OracleException {
        if (this.isBinary()) {
            return OracleDatabaseImpl.binaryToJsonParser(this.getBinaryContentAsByteArray(), this.jsonFactory);
        }
        InputStream inputStream = this.getContentAsStream();
        return Json.createParser((InputStream)inputStream);
    }

    protected static boolean isBinary(OracleDocument oracleDocument) {
        return oracleDocument instanceof OracleDocumentImpl && ((OracleDocumentImpl)oracleDocument).isBinary();
    }
}

