/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.logging.Logger;
import oracle.json.logging.OracleLog;
import oracle.json.util.JsonByteArray;

public final class HashFuncs {
    public static final Charset DEFAULT_CHARSET = JsonByteArray.DEFAULT_CHARSET;
    private static final String DEFAULT_ALGORITHM = "SHA-256";
    private static final String MD5_ALGORITHM = "MD5";
    private static final Logger log = Logger.getLogger("global");
    private final SecureRandom rand = new SecureRandom();

    public static byte[] SHA256(String string) throws NoSuchAlgorithmException {
        byte[] byArray = string.getBytes(DEFAULT_CHARSET);
        return HashFuncs.SHA256(byArray);
    }

    public static byte[] MD5(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(MD5_ALGORITHM);
        return messageDigest.digest(byArray);
    }

    public static byte[] SHA256(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
        messageDigest.update(byArray, 0, byArray.length);
        return messageDigest.digest();
    }

    public static byte[] getRandom() {
        UUID uUID = UUID.randomUUID();
        long l = uUID.getLeastSignificantBits();
        long l2 = uUID.getMostSignificantBits();
        byte[] byArray = new byte[16];
        byArray[7] = (byte)(l2 & 0xFFL);
        byArray[6] = (byte)(l2 >> 8 & 0xFFL);
        byArray[5] = (byte)(l2 >> 16 & 0xFFL);
        byArray[4] = (byte)(l2 >> 24 & 0xFFL);
        byArray[3] = (byte)(l2 >> 32 & 0xFFL);
        byArray[2] = (byte)(l2 >> 40 & 0xFFL);
        byArray[1] = (byte)(l2 >> 48 & 0xFFL);
        byArray[0] = (byte)(l2 >> 56 & 0xFFL);
        byArray[15] = (byte)(l & 0xFFL);
        byArray[14] = (byte)(l >> 8 & 0xFFL);
        byArray[13] = (byte)(l >> 16 & 0xFFL);
        byArray[12] = (byte)(l >> 24 & 0xFFL);
        byArray[11] = (byte)(l >> 32 & 0xFFL);
        byArray[10] = (byte)(l >> 40 & 0xFFL);
        byArray[9] = (byte)(l >> 48 & 0xFFL);
        byArray[8] = (byte)(l >> 56 & 0xFFL);
        return byArray;
    }

    public static byte[] getTimeRandom() {
        long l = System.nanoTime();
        long l2 = System.currentTimeMillis();
        byte[] byArray = new byte[16];
        byArray[7] = (byte)(l & 0xFFL);
        byArray[6] = (byte)(l >> 8 & 0xFFL);
        byArray[5] = (byte)(l >> 16 & 0xFFL);
        byArray[4] = (byte)(l >> 24 & 0xFFL);
        byArray[3] = (byte)(l >> 32 & 0xFFL);
        byArray[2] = (byte)(l >> 40 & 0xFFL);
        byArray[1] = (byte)(l >> 48 & 0xFFL);
        byArray[0] = (byte)(l >> 56 & 0xFFL);
        byArray[15] = (byte)(l2 & 0xFFL);
        byArray[14] = (byte)(l2 >> 8 & 0xFFL);
        byArray[13] = (byte)(l2 >> 16 & 0xFFL);
        byArray[12] = (byte)(l2 >> 24 & 0xFFL);
        byArray[11] = (byte)(l2 >> 32 & 0xFFL);
        byArray[10] = (byte)(l2 >> 40 & 0xFFL);
        byArray[9] = (byte)(l2 >> 48 & 0xFFL);
        byArray[8] = (byte)(l2 >> 56 & 0xFFL);
        return byArray;
    }

    public HashFuncs() {
        try {
            this.rand.setSeed(System.nanoTime());
        }
        catch (RuntimeException runtimeException) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning(runtimeException.toString());
            }
            throw runtimeException;
        }
    }

    public byte[] getSecureRandom() {
        byte[] byArray = new byte[16];
        this.rand.nextBytes(byArray);
        return byArray;
    }
}

