/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.json.common.Message;

public final class ComponentTime
implements Comparable<ComponentTime> {
    public static final String LOWEST_TIME = "0001-01-01T00:00:00.000000";
    public static final String INFINITY_TIME = "9999-12-31T23:59:59.999999";
    public static final String DEFAULT_OFORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DEFAULT_IFORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String HTTP_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final ComponentTime UNKNOWN_STAMP = new ComponentTime(0L);
    public static final ComponentTime EXPIRED_STAMP = new ComponentTime(Long.MAX_VALUE);
    public static final ComponentTime LOWEST_STAMP = new ComponentTime("0001-01-01T00:00:00.000000");
    public static final ComponentTime HIGHEST_STAMP = new ComponentTime("9999-12-31T23:59:59.999999");
    private static final int YPOS = 46;
    private static final int MPOS = 42;
    private static final int DPOS = 37;
    private static final int HPOS = 32;
    private static final int IPOS = 26;
    private static final int SPOS = 20;
    private static final int UPOS = 0;
    private static final int YMASK = 16383;
    private static final int MMASK = 15;
    private static final int DMASK = 31;
    private static final int HMASK = 31;
    private static final int IMASK = 63;
    private static final int SMASK = 63;
    private static final int UMASK = 1048575;
    private static final int YIDX = 0;
    private static final int MIDX = 1;
    private static final int DIDX = 2;
    private static final int HIDX = 3;
    private static final int IIDX = 4;
    private static final int SIDX = 5;
    private static final int UIDX = 6;
    private static final int NUMIDX = 7;
    private final long timestamp;
    private static final long MAX_MICROS = 1000000L;

    public ComponentTime(String string) {
        this.timestamp = ComponentTime.stringToStamp(string);
    }

    public ComponentTime(long l) {
        this.timestamp = l;
    }

    public static SimpleDateFormat makeOutputFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_OFORMAT);
        simpleDateFormat.setTimeZone(GMT_ZONE);
        return simpleDateFormat;
    }

    public static SimpleDateFormat makeInputFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_IFORMAT);
        simpleDateFormat.setTimeZone(GMT_ZONE);
        return simpleDateFormat;
    }

    public static String dateToString(Date date) {
        SimpleDateFormat simpleDateFormat = ComponentTime.makeOutputFormatter();
        return simpleDateFormat.format(date);
    }

    public static String dateToHeaderString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HTTP_FORMAT, Locale.US);
        simpleDateFormat.setTimeZone(GMT_ZONE);
        return simpleDateFormat.format(date);
    }

    public static Date dateFromHeaderString(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HTTP_FORMAT, Locale.US);
        ParsePosition parsePosition = new ParsePosition(0);
        simpleDateFormat.setTimeZone(GMT_ZONE);
        return simpleDateFormat.parse(string, parsePosition);
    }

    public static Date stringToDate(String string) {
        SimpleDateFormat simpleDateFormat = ComponentTime.makeInputFormatter();
        ParsePosition parsePosition = new ParsePosition(0);
        if (string.length() > 23) {
            string = string.substring(0, 23);
        }
        return simpleDateFormat.parse(string, parsePosition);
    }

    public static String millisToString(long l) {
        return ComponentTime.dateToString(new Date(l));
    }

    public String toString() {
        return ComponentTime.stampToString(this.timestamp);
    }

    public long getValue() {
        return this.timestamp;
    }

    public Date toDate() {
        return ComponentTime.stringToDate(this.toString().substring(0, 23));
    }

    private static long packBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        long l = n7;
        l |= (long)n << 46;
        l |= (long)n2 << 42;
        l |= (long)n3 << 37;
        l |= (long)n4 << 32;
        l |= (long)n5 << 26;
        return l |= (long)n6 << 20;
    }

    private static void unpackBits(long l, int[] nArray) {
        int n = (int)(l >> 46) & 0x3FFF;
        int n2 = (int)(l >> 42) & 0xF;
        int n3 = (int)(l >> 37) & 0x1F;
        int n4 = (int)(l >> 32) & 0x1F;
        int n5 = (int)(l >> 26) & 0x3F;
        int n6 = (int)(l >> 20) & 0x3F;
        int n7 = (int)l & 0xFFFFF;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray[3] = n4;
        nArray[4] = n5;
        nArray[5] = n6;
        nArray[6] = n7;
    }

    private static void throwException(String string) {
        throw new IllegalArgumentException(Message.EX_ILLEGAL_DATE_TIME.get(string));
    }

    public static long stringToStamp(String string) {
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = string == null ? 0 : string.length();
        try {
            if (n8 == 0) {
                throw new IllegalArgumentException(Message.EX_ILLEGAL_DATE_TIME2.get(new Object[0]));
            }
            n = n8 < 4 ? Integer.parseInt(string.substring(0, n8)) : Integer.parseInt(string.substring(0, 4));
            if (n8 >= 9) {
                if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                    ComponentTime.throwException(string);
                }
                n2 = Integer.parseInt(string.substring(5, 7));
                n3 = Integer.parseInt(string.substring(8, 10));
            }
            if (n8 >= 16) {
                if (string.charAt(10) != 'T' && string.charAt(10) != 't' && string.charAt(10) != ' ' || string.charAt(13) != ':') {
                    ComponentTime.throwException(string);
                }
                n4 = Integer.parseInt(string.substring(11, 13));
                n5 = Integer.parseInt(string.substring(14, 16));
            }
            if (n8 >= 19) {
                if (string.charAt(16) != ':') {
                    ComponentTime.throwException(string);
                }
                n6 = Integer.parseInt(string.substring(17, 19));
            }
            if (n8 > 20) {
                int n9;
                int n10 = n9 = n8 > 26 ? 26 : n8;
                if (string.charAt(n9 - 1) == 'Z') {
                    --n9;
                }
                if (string.charAt(19) != '.') {
                    ComponentTime.throwException(string);
                }
                n7 = Integer.parseInt(string.substring(20, n9));
                n9 -= 20;
                while (n9 < 6) {
                    n7 *= 10;
                    ++n9;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            ComponentTime.throwException(string);
        }
        if (n > 9999 || n3 > 31 || n2 > 12 || n4 > 23 || n5 > 59 || n6 > 62 || n <= 0 || n3 <= 0 || n2 <= 0 || n4 < 0 || n5 < 0 || n6 < 0) {
            ComponentTime.throwException(string);
        }
        return ComponentTime.packBits(n, n2, n3, n4, n5, n6, n7);
    }

    private static String stampToString(long l, String string) {
        StringBuilder stringBuilder = new StringBuilder(30);
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        int[] nArray = new int[7];
        ComponentTime.unpackBits(l, nArray);
        formatter.format(string, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6]);
        formatter.close();
        return stringBuilder.toString();
    }

    public static String stampToString(long l) {
        return ComponentTime.stampToString(l, "%04d-%02d-%02dT%02d:%02d:%02d.%06dZ");
    }

    public static long maxFractionalSeconds(long l, boolean bl) {
        int n = (int)l & 0xFFFFF;
        l &= 0xFFFFFFFFFFF00000L;
        n = !bl ? 999999 : n % 1000 + 999;
        return l |= (long)n;
    }

    public static long plus(long l, long l2) {
        long l3 = l & 0xFFFFFL;
        if (l3 + l2 < 1000000L) {
            l += l2;
        } else {
            int[] nArray = new int[7];
            ComponentTime.unpackBits(l, nArray);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            int n4 = nArray[3];
            int n5 = nArray[4];
            int n6 = nArray[5];
            int n7 = (int)((l3 += l2) / 1000000L);
            l3 %= 1000000L;
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
            gregorianCalendar.add(13, n7);
            n6 = gregorianCalendar.get(13);
            n5 = gregorianCalendar.get(12);
            n4 = gregorianCalendar.get(11);
            n3 = gregorianCalendar.get(5);
            n2 = gregorianCalendar.get(2) + 1;
            n = gregorianCalendar.get(1);
            l = l3;
            l |= (long)n << 46;
            l |= (long)n2 << 42;
            l |= (long)n3 << 37;
            l |= (long)n4 << 32;
            l |= (long)n5 << 26;
            l |= (long)n6 << 20;
        }
        return l;
    }

    public static long increment(long l, long l2) {
        long l3 = l & 0xFFFFFL;
        if (l3 + l2 > 1000000L) {
            return -1L;
        }
        return l + l2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ComponentTime)) {
            return false;
        }
        ComponentTime componentTime = (ComponentTime)object;
        return this.timestamp == componentTime.timestamp;
    }

    public int hashCode() {
        return new Long(this.timestamp).hashCode();
    }

    @Override
    public int compareTo(ComponentTime componentTime) {
        if (componentTime == null) {
            return 1;
        }
        if (this.timestamp > componentTime.timestamp) {
            return 1;
        }
        if (this.timestamp < componentTime.timestamp) {
            return -1;
        }
        return 0;
    }
}

