/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.AndORNode;
import oracle.json.parser.ContainsClause;
import oracle.json.parser.Evaluator;
import oracle.json.parser.FilterLoader;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.Predicate;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.parser.SpatialClause;
import oracle.json.parser.SqlJsonClause;
import oracle.json.parser.ValueTypePair;

public class AndORTree {
    private AndORNode root;
    private ArrayList<ValueTypePair> valueArray = new ArrayList();
    private ArrayList<Predicate> orderByArray = new ArrayList();
    private HashSet<String> keysSet = new HashSet();
    private String predChar = "@";
    private StringBuilder jsonExists;
    private boolean need_12_2 = false;
    private static final boolean WRAP_TEMPORAL = false;
    private static final String FIELDS_ARRAY = "$fields";
    private static final String LAX = "$lax";
    private static final String SCALAR_REQ = "$scalarRequired";
    public static final String ERROR_ON_ERROR = "error on error";
    public static final String ERROR_ON_ERROR_NULL_ON_EMPTY = "error on error null on empty";
    public static final String NULL_ON_ERROR = "null on error";
    private int bookmark_start = -1;
    private Evaluator.EvaluatorCode bookmarkedModifier = null;
    private int numBinds;
    private ArrayList<SqlJsonClause> sjClauses = null;
    private ArrayList<SpatialClause> spatialClauses = null;
    private ArrayList<ContainsClause> containsClauses = null;

    private AndORTree() {
    }

    public ArrayList<ValueTypePair> getValueArray() {
        return this.valueArray;
    }

    public ArrayList<Predicate> getOrderByArray() {
        return this.orderByArray;
    }

    public HashSet<String> getKeys() {
        return this.keysSet;
    }

    String getPredChar() {
        return this.predChar;
    }

    private void addToOrderByArray(Predicate predicate) {
        this.orderByArray.add(predicate);
    }

    void addToKeys(String string) {
        this.keysSet.add(string);
    }

    void checkCompatibility(Evaluator.EvaluatorCode evaluatorCode) {
        if (Evaluator.requires_12_2(evaluatorCode)) {
            this.need_12_2 = true;
        }
    }

    String getScalarKey(JsonValue jsonValue) throws QueryException {
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (valueType == JsonValue.ValueType.STRING) {
            return ((JsonString)jsonValue).getString();
        }
        if (valueType == JsonValue.ValueType.NUMBER) {
            return ((JsonNumber)jsonValue).toString();
        }
        QueryException.throwSyntaxException(QueryMessage.EX_NON_SCALAR_KEY, new Object[0]);
        return null;
    }

    static boolean isJSONPrimitive(JsonValue jsonValue) {
        JsonValue.ValueType valueType = jsonValue.getValueType();
        return valueType != JsonValue.ValueType.ARRAY && valueType != JsonValue.ValueType.OBJECT;
    }

    static boolean isJSONArray(JsonValue jsonValue) {
        return jsonValue.getValueType() == JsonValue.ValueType.ARRAY;
    }

    static boolean isJSONObject(JsonValue jsonValue) {
        return jsonValue.getValueType() == JsonValue.ValueType.OBJECT;
    }

    static ValueTypePair createBindValue(JsonValue jsonValue, String string, boolean bl) throws QueryException {
        ValueTypePair valueTypePair = null;
        boolean bl2 = false;
        if (AndORTree.isJSONPrimitive(jsonValue)) {
            if (jsonValue.getValueType() == JsonValue.ValueType.NULL) {
                valueTypePair = new ValueTypePair(4);
                bl2 = true;
            } else if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                valueTypePair = new ValueTypePair(true, 3);
                bl2 = true;
            } else if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                valueTypePair = new ValueTypePair(false, 3);
                bl2 = true;
            } else if (jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                valueTypePair = new ValueTypePair(((JsonNumber)jsonValue).bigDecimalValue(), 1);
            } else if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                valueTypePair = new ValueTypePair(((JsonString)jsonValue).getString(), 2);
            }
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_SCALAR, string);
        }
        if (bl2 && !bl) {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_NOT_BE_LITERAL, string);
        }
        return valueTypePair;
    }

    ValueTypePair addToValueArray(JsonValue jsonValue, String string) throws QueryException {
        ValueTypePair valueTypePair = AndORTree.createBindValue(jsonValue, string, true);
        if (valueTypePair != null) {
            this.valueArray.add(valueTypePair);
        }
        return valueTypePair;
    }

    ValueTypePair addToValueArray(String string) {
        ValueTypePair valueTypePair = new ValueTypePair(string, 2);
        if (valueTypePair != null) {
            this.valueArray.add(valueTypePair);
        }
        return valueTypePair;
    }

    void setValBookmark(Evaluator.EvaluatorCode evaluatorCode) {
    }

    void endValBookmark() {
        if (this.bookmarkedModifier != null) {
            boolean bl;
            boolean bl2 = this.bookmarkedModifier == Evaluator.EvaluatorCode.$date;
            boolean bl3 = bl = this.bookmarkedModifier == Evaluator.EvaluatorCode.$timestamp;
            if (bl2 || bl) {
                for (int i = this.bookmark_start; i < this.getNumVals(); ++i) {
                    ValueTypePair valueTypePair = this.valueArray.get(i);
                    valueTypePair = ValueTypePair.makeTemporal(valueTypePair, bl);
                    this.valueArray.set(i, valueTypePair);
                }
            }
            this.bookmarkedModifier = null;
            this.bookmark_start = -1;
        }
    }

    int getNextBind() throws QueryException {
        int n = this.getNumVals();
        if (this.numBinds >= n) {
            QueryException.throwExecutionException(QueryMessage.RR_BIND_MISMATCH, Integer.toString(n), Integer.toString(this.numBinds + 1));
        }
        return this.numBinds++;
    }

    void removeBind(int n) {
        this.valueArray.remove(n);
        --this.numBinds;
    }

    int getNumVals() {
        if (this.getValueArray() != null) {
            return this.valueArray.size();
        }
        return 0;
    }

    public static AndORTree createTree(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) throws QueryException {
        FilterLoader filterLoader;
        try {
            filterLoader = new FilterLoader(jsonFactoryProvider, inputStream);
        }
        catch (JsonException jsonException) {
            throw new QueryException((Exception)((Object)jsonException));
        }
        return AndORTree.createTree(filterLoader);
    }

    private static void processArrayOrderBy(AndORTree andORTree, JsonArray jsonArray, String string) throws QueryException {
        JsonArray jsonArray2 = jsonArray;
        for (JsonValue jsonValue : jsonArray2) {
            AndORTree.checkIfValueIsJsonObject(jsonValue, "$orderby");
            JsonObject jsonObject = (JsonObject)jsonValue;
            String string2 = null;
            String string3 = null;
            int n = 0;
            boolean bl = true;
            for (Map.Entry entry : jsonObject.entrySet()) {
                String string4 = (String)entry.getKey();
                JsonValue jsonValue2 = (JsonValue)entry.getValue();
                if (string4.equals("path")) {
                    if (!(jsonValue2 instanceof JsonString)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", "path", "string");
                    }
                    string2 = ((JsonString)jsonValue2).getString();
                    continue;
                }
                if (string4.equals("datatype")) {
                    if (!(jsonValue2 instanceof JsonString)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", "datatype", "string");
                    }
                    string3 = ((JsonString)jsonValue2).getString();
                    continue;
                }
                if (string4.equals("order")) {
                    String string5;
                    if (!(jsonValue2 instanceof JsonString)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", "order", "string");
                    }
                    if ((string5 = ((JsonString)jsonValue2).getString()).equals("asc")) {
                        bl = true;
                        continue;
                    }
                    if (string5.equals("desc")) {
                        bl = false;
                        continue;
                    }
                    QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_INVALID_PROP, "order", string5);
                    continue;
                }
                if (string4.equals("maxLength")) {
                    if (!(jsonValue2 instanceof JsonNumber)) {
                        QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", "maxLength", "number");
                    }
                    if ((n = ((JsonNumber)jsonValue2).intValue()) > 0) continue;
                    QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_INVALID_PROP, "maxLength", Integer.toString(n));
                    continue;
                }
                QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_UNKNOWN_PROP, string4);
            }
            if (string2 == null) {
                QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_PATH_REQUIRED, new Object[0]);
            }
            if (string3 != null) {
                if (string3.equalsIgnoreCase("number")) {
                    string3 = "number";
                } else if (string3.equalsIgnoreCase("date")) {
                    string3 = "date";
                } else if (string3.equalsIgnoreCase("datetime")) {
                    string3 = "timestamp";
                } else if (string3.equalsIgnoreCase("string") || string3.equalsIgnoreCase("varchar2") || string3.equalsIgnoreCase("varchar")) {
                    string3 = "varchar2";
                    if (n > 0) {
                        string3 = string3 + "(" + Integer.toString(n) + ")";
                    }
                } else {
                    QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_INVALID_PROP, "datatype", string3);
                }
            }
            Predicate predicate = new Predicate(new JsonQueryPath(string2), bl ? "1" : "-1", string3, string);
            andORTree.addToOrderByArray(predicate);
        }
    }

    private static AndORTree createTree(FilterLoader filterLoader) throws QueryException {
        JsonObject jsonObject;
        try {
            jsonObject = (JsonObject)filterLoader.parse();
        }
        catch (JsonParsingException jsonParsingException) {
            if (jsonParsingException.getMessage().equals("SODA FOR JAVA: ENCOUNTERED MULTIPLE $orderby")) {
                throw QueryException.getSyntaxException(QueryMessage.EX_MULTIPLE_OPS, "$orderby");
            }
            if (jsonParsingException.getMessage().equals("SODA FOR JAVA: ENCOUNTERED MULTIPLE $query")) {
                throw QueryException.getSyntaxException(QueryMessage.EX_MULTIPLE_OPS, "$query");
            }
            throw new QueryException((Exception)((Object)jsonParsingException));
        }
        catch (JsonException jsonException) {
            throw new QueryException((Exception)((Object)jsonException));
        }
        AndORTree andORTree = new AndORTree();
        AndORNode andORNode = new AndORNode(null);
        andORNode.setEval(Evaluator.EvaluatorCode.$and);
        andORNode.setPredicate(new Predicate(new JsonQueryPath(), null));
        andORTree.root = andORNode;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (jsonObject != null) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonValue jsonValue;
                String string = (String)entry.getKey();
                if (string.equalsIgnoreCase("$project") || string.equalsIgnoreCase("$patch") || string.equalsIgnoreCase("$merge")) {
                    if (bl2) {
                        QueryException.throwSyntaxException(QueryMessage.EX_ENVELOPE_WITH_OTHER_OPS, new Object[0]);
                    }
                    bl3 = true;
                    continue;
                }
                if (string.equalsIgnoreCase("$query")) {
                    if (bl2) {
                        QueryException.throwSyntaxException(QueryMessage.EX_QUERY_WITH_OTHER_OPS, new Object[0]);
                    }
                    bl3 = true;
                    bl = true;
                    jsonValue = (JsonValue)entry.getValue();
                    AndORTree.checkIfValueIsJsonObject(jsonValue, "$query");
                    for (Map.Entry entry2 : ((JsonObject)jsonValue).entrySet()) {
                        andORNode.addNode(andORTree, entry2);
                    }
                    continue;
                }
                if (string.equalsIgnoreCase("$orderby")) {
                    if (bl2) {
                        QueryException.throwSyntaxException(QueryMessage.EX_ENVELOPE_WITH_OTHER_OPS, new Object[0]);
                    }
                    bl3 = true;
                    jsonValue = (JsonValue)entry.getValue();
                    if (jsonValue instanceof JsonObject) {
                        Object object;
                        int n;
                        Object object2;
                        String[] stringArray;
                        JsonObject jsonObject2 = (JsonObject)jsonValue;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        JsonArray jsonArray = null;
                        String[] stringArray2 = null;
                        String[] stringArray3 = null;
                        for (Map.Entry entry3 : jsonObject2.entrySet()) {
                            stringArray = (String[])entry3.getKey();
                            if (stringArray.equals(FIELDS_ARRAY)) {
                                object2 = (JsonValue)entry3.getValue();
                                if (!object2.getValueType().equals((Object)JsonValue.ValueType.ARRAY)) continue;
                                jsonArray = (JsonArray)object2;
                                continue;
                            }
                            if (stringArray.equals(SCALAR_REQ)) {
                                object2 = (JsonValue)entry3.getValue();
                                if (object2.getValueType().equals((Object)JsonValue.ValueType.TRUE)) {
                                    bl4 = true;
                                    continue;
                                }
                                if (object2.getValueType().equals((Object)JsonValue.ValueType.FALSE)) continue;
                                stringArray3 = stringArray;
                                continue;
                            }
                            if (stringArray.equals(LAX)) {
                                object2 = (JsonValue)entry3.getValue();
                                if (object2.getValueType().equals((Object)JsonValue.ValueType.TRUE)) {
                                    bl5 = true;
                                    continue;
                                }
                                if (object2.getValueType().equals((Object)JsonValue.ValueType.FALSE)) continue;
                                stringArray3 = stringArray;
                                continue;
                            }
                            stringArray2 = stringArray;
                        }
                        if (jsonArray != null) {
                            if (bl4 && bl5) {
                                QueryException.throwSyntaxException(QueryMessage.EX_SCALAR_AND_LAX, new Object[0]);
                            } else if (stringArray3 != null) {
                                QueryException.throwSyntaxException(QueryMessage.EX_BAD_PROP_TYPE, "$orderby", stringArray3, "boolean");
                            } else if (stringArray2 != null) {
                                QueryException.throwSyntaxException(QueryMessage.EX_ORDERBY_UNKNOWN_PROP, new Object[]{stringArray2});
                            }
                            if (bl4) {
                                AndORTree.processArrayOrderBy(andORTree, jsonArray, ERROR_ON_ERROR);
                                continue;
                            }
                            if (bl5) {
                                AndORTree.processArrayOrderBy(andORTree, jsonArray, NULL_ON_ERROR);
                                continue;
                            }
                            AndORTree.processArrayOrderBy(andORTree, jsonArray, ERROR_ON_ERROR_NULL_ON_EMPTY);
                            continue;
                        }
                        int n2 = filterLoader.getOrderCount();
                        if (n2 <= 0) continue;
                        stringArray = new String[n2];
                        object2 = new int[n2];
                        for (n = 0; n < n2; ++n) {
                            int n3;
                            object = filterLoader.getOrderPath(n);
                            String string2 = filterLoader.getOrderDirection(n);
                            if (object == null) break;
                            int n4 = 0;
                            if (string2 != null) {
                                try {
                                    n4 = Integer.parseInt(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE, object, string2);
                                }
                                if (n4 == 0) {
                                    QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE, object, string2);
                                }
                            } else {
                                QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE2, object);
                            }
                            int n5 = n4 < 0 ? -n4 : n4;
                            for (n3 = 0; n3 < n; ++n3) {
                                int n6 = object2[n3];
                                if (n6 < 0) {
                                    n6 = -n6;
                                }
                                if (n5 < n6) break;
                            }
                            if (n3 < n) {
                                System.arraycopy(stringArray, n3, stringArray, n3 + 1, n - n3);
                                System.arraycopy(object2, n3, object2, n3 + 1, n - n3);
                            }
                            stringArray[n3] = object;
                            object2[n3] = n4;
                        }
                        n2 = n;
                        for (n = 0; n < n2; ++n) {
                            object = new Predicate(new JsonQueryPath(stringArray[n]), object2[n] < 0 ? "-1" : "1", null, ERROR_ON_ERROR_NULL_ON_EMPTY);
                            andORTree.addToOrderByArray((Predicate)object);
                        }
                        continue;
                    }
                    if (jsonValue instanceof JsonArray) {
                        AndORTree.processArrayOrderBy(andORTree, (JsonArray)jsonValue, ERROR_ON_ERROR_NULL_ON_EMPTY);
                        continue;
                    }
                    QueryException.throwSyntaxException(QueryMessage.EX_BAD_OP_VALUE, "$orderby");
                    continue;
                }
                bl2 = true;
                if (bl) {
                    QueryException.throwSyntaxException(QueryMessage.EX_QUERY_WITH_OTHER_OPS, new Object[0]);
                }
                if (bl3) {
                    QueryException.throwSyntaxException(QueryMessage.EX_ENVELOPE_WITH_OTHER_OPS, new Object[0]);
                }
                andORNode.addNode(andORTree, entry);
            }
        }
        return andORTree;
    }

    private static void checkIfValueIsJsonObject(JsonValue jsonValue, String string) throws QueryException {
        if (!(jsonValue instanceof JsonObject)) {
            QueryException.throwSyntaxException(QueryMessage.EX_BAD_OP_VALUE, string);
        }
    }

    public boolean hasOrderBy() {
        return !this.getOrderByArray().isEmpty();
    }

    public boolean hasKeys() {
        return !this.getKeys().isEmpty();
    }

    public boolean hasJsonExists() {
        if (this.jsonExists == null) {
            throw new IllegalStateException();
        }
        return this.jsonExists.length() > 0;
    }

    public void generateJsonExists() throws QueryException {
        this.jsonExists = this.root.generateJsonExists(this);
    }

    public void appendJsonExists(StringBuilder stringBuilder) {
        if (this.jsonExists == null) {
            throw new IllegalStateException();
        }
        stringBuilder.append("'$?");
        stringBuilder.append((CharSequence)this.jsonExists);
        stringBuilder.append("'");
        int n = this.getNumVals();
        if (n > 0) {
            stringBuilder.append("\npassing ");
            for (int i = 0; i < n; ++i) {
                ValueTypePair valueTypePair = this.valueArray.get(i);
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (valueTypePair.isTimestamp()) {
                    stringBuilder.append("TO_TIMESTAMP_TZ(?,'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM')");
                } else if (valueTypePair.isDate()) {
                    stringBuilder.append("TO_DATE(?,'SYYYY-MM-DD\"T\"HH24:MI:SS')");
                } else {
                    stringBuilder.append("?");
                }
                stringBuilder.append(" as \"B");
                stringBuilder.append(Integer.toString(i));
                stringBuilder.append("\"");
            }
        }
    }

    public void appendFormattedBind(StringBuilder stringBuilder, ValueTypePair valueTypePair, SqlJsonClause sqlJsonClause) {
        if (sqlJsonClause == null) {
            stringBuilder.append("?");
            return;
        }
        boolean bl = sqlJsonClause.useDateWrapper();
        boolean bl2 = sqlJsonClause.useTimestampWrapper();
        if (valueTypePair.getType() == 1) {
            if (bl || bl2) {
                stringBuilder.append("TO_DATE(((?/1000)+2440588),'J')");
                return;
            }
        } else if (valueTypePair.getType() == 2) {
            if (bl) {
                stringBuilder.append("TO_DATE(?,'YYYY-MM-DD')");
                return;
            }
            if (bl2) {
                stringBuilder.append("TO_TIMESTAMP_TZ(?,'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM')");
                return;
            }
        }
        stringBuilder.append("?");
    }

    void addSqlJsonOperator(SqlJsonClause sqlJsonClause) {
        if (this.sjClauses == null) {
            this.sjClauses = new ArrayList();
        }
        this.sjClauses.add(sqlJsonClause);
    }

    public boolean hasSqlJsonClause() {
        return this.sjClauses != null;
    }

    public List<SqlJsonClause> getSqlJsonOperators() {
        return this.sjClauses;
    }

    void addSpatialOperator(SpatialClause spatialClause) {
        if (this.spatialClauses == null) {
            this.spatialClauses = new ArrayList();
        }
        this.spatialClauses.add(spatialClause);
    }

    public List<SpatialClause> getSpatialOperators() {
        return this.spatialClauses;
    }

    public boolean hasSpatialClause() {
        return this.spatialClauses != null;
    }

    void addContainsClause(ContainsClause containsClause) {
        if (this.containsClauses == null) {
            this.containsClauses = new ArrayList();
        }
        this.containsClauses.add(containsClause);
    }

    public List<ContainsClause> getContainsOperators() {
        return this.containsClauses;
    }

    public boolean hasContainsClause() {
        return this.containsClauses != null;
    }

    public boolean requires_12_2() {
        return this.need_12_2;
    }
}

