/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.util.LimitedInputStream;

public class LobInputStream
extends LimitedInputStream {
    private static final Logger log = Logger.getLogger(LobInputStream.class.getName());
    private final Blob blocator;
    private final Clob clocator;
    private final NClob nlocator;
    private final boolean noLob;
    protected MetricsCollector metrics = null;

    public LobInputStream() {
        this.blocator = null;
        this.clocator = null;
        this.nlocator = null;
        this.noLob = true;
    }

    public LobInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
        this.blocator = null;
        this.clocator = null;
        this.nlocator = null;
        this.noLob = true;
    }

    public LobInputStream(Blob blob, InputStream inputStream, int n) {
        super(inputStream, n);
        this.blocator = blob;
        this.clocator = null;
        this.nlocator = null;
        this.noLob = false;
    }

    public LobInputStream(Clob clob, InputStream inputStream, int n) {
        super(inputStream, n);
        this.blocator = null;
        this.clocator = clob;
        this.nlocator = null;
        this.noLob = false;
    }

    public LobInputStream(NClob nClob, InputStream inputStream, int n) {
        super(inputStream, n);
        this.blocator = null;
        this.clocator = null;
        this.nlocator = nClob;
        this.noLob = false;
    }

    public void setMetrics(MetricsCollector metricsCollector) {
        this.metrics = metricsCollector;
    }

    @Override
    protected int timedRead(byte[] byArray, int n, int n2) throws IOException {
        if (this.metrics == null) {
            return super.timedRead(byArray, n, n2);
        }
        this.metrics.startTiming();
        int n3 = super.timedRead(byArray, n, n2);
        if (this.noLob) {
            this.metrics.recordStreamRead(n3 > 0 ? n3 : 0);
        } else {
            this.metrics.recordLobReads(0);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                super.close();
            }
            finally {
                block13: {
                    try {
                        if (this.blocator != null) {
                            this.blocator.free();
                        }
                        if (this.clocator != null) {
                            this.clocator.free();
                        }
                        if (this.nlocator != null) {
                            this.nlocator.free();
                        }
                        if (this.metrics != null) {
                            this.metrics.recordLobReads(1);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!OracleLog.isLoggingEnabled()) break block13;
                        log.severe(sQLException.toString());
                    }
                }
            }
        }
    }
}

