/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParserFactory;

public class JsonFactoryProvider {
    private volatile JsonBuilderFactory builderFactory = null;
    private volatile JsonParserFactory parserFactory = null;
    private volatile JsonGeneratorFactory generatorFactory = null;
    private volatile JsonWriterFactory writerFactory = null;
    private volatile JsonReaderFactory readerFactory = null;
    private volatile Object jsonFactory = null;
    public static final String ORACLE_JSON_FACTORY = "oracle.sql.json.OracleJsonFactory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonParserFactory getParserFactory() {
        JsonParserFactory jsonParserFactory = this.parserFactory;
        if (jsonParserFactory == null) {
            JsonFactoryProvider jsonFactoryProvider = this;
            synchronized (jsonFactoryProvider) {
                jsonParserFactory = this.parserFactory;
                if (jsonParserFactory == null) {
                    this.parserFactory = jsonParserFactory = Json.createParserFactory(null);
                }
            }
        }
        return jsonParserFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonGeneratorFactory getGeneratorFactory() {
        JsonGeneratorFactory jsonGeneratorFactory = this.generatorFactory;
        if (jsonGeneratorFactory == null) {
            JsonFactoryProvider jsonFactoryProvider = this;
            synchronized (jsonFactoryProvider) {
                jsonGeneratorFactory = this.generatorFactory;
                if (jsonGeneratorFactory == null) {
                    this.generatorFactory = jsonGeneratorFactory = Json.createGeneratorFactory(null);
                }
            }
        }
        return jsonGeneratorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonWriterFactory getWriterFactory() {
        JsonWriterFactory jsonWriterFactory = this.writerFactory;
        if (jsonWriterFactory == null) {
            JsonFactoryProvider jsonFactoryProvider = this;
            synchronized (jsonFactoryProvider) {
                jsonWriterFactory = this.writerFactory;
                if (jsonWriterFactory == null) {
                    this.writerFactory = jsonWriterFactory = Json.createWriterFactory(null);
                }
            }
        }
        return jsonWriterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonReaderFactory getReaderFactory() {
        JsonReaderFactory jsonReaderFactory = this.readerFactory;
        if (jsonReaderFactory == null) {
            JsonFactoryProvider jsonFactoryProvider = this;
            synchronized (jsonFactoryProvider) {
                jsonReaderFactory = this.readerFactory;
                if (jsonReaderFactory == null) {
                    this.readerFactory = jsonReaderFactory = Json.createReaderFactory(null);
                }
            }
        }
        return jsonReaderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonBuilderFactory getBuilderFactory() {
        JsonBuilderFactory jsonBuilderFactory = this.builderFactory;
        if (jsonBuilderFactory == null) {
            JsonFactoryProvider jsonFactoryProvider = this;
            synchronized (jsonFactoryProvider) {
                jsonBuilderFactory = this.builderFactory;
                if (jsonBuilderFactory == null) {
                    this.builderFactory = jsonBuilderFactory = Json.createBuilderFactory(null);
                }
            }
        }
        return jsonBuilderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getJsonFactory() {
        Object object = this.jsonFactory;
        if (object == null) {
            JsonFactoryProvider jsonFactoryProvider = this;
            synchronized (jsonFactoryProvider) {
                object = this.jsonFactory;
                if (object == null) {
                    try {
                        Class<?> clazz = Class.forName(ORACLE_JSON_FACTORY);
                        this.jsonFactory = object = clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                }
            }
        }
        return object;
    }

    public JsonObjectBuilder createObjectBuilder() {
        return this.getBuilderFactory().createObjectBuilder();
    }

    public JsonArrayBuilder createArrayBuilder() {
        return this.getBuilderFactory().createArrayBuilder();
    }
}

