/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv;

import java.io.IOException;
import java.util.ArrayList;
import liquibase.util.StringUtil;
import liquibase.util.csv.opencsv.enums.CSVReaderNullFieldIndicator;

public class CSVParser {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 1024;
    public static final int READ_BUFFER_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final boolean DEFAULT_STRICT_QUOTES = false;
    public static final boolean DEFAULT_IGNORE_QUOTATIONS = false;
    public static final char NULL_CHARACTER = '\u0000';
    public static final CSVReaderNullFieldIndicator DEFAULT_NULL_FIELD_INDICATOR = CSVReaderNullFieldIndicator.NEITHER;
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private final boolean ignoreLeadingWhiteSpace;
    private final boolean ignoreQuotations;
    private final CSVReaderNullFieldIndicator nullFieldIndicator;
    private String pending;
    private boolean inField;

    public CSVParser() {
        this(',', '\"', '\\');
    }

    public CSVParser(char separator) {
        this(separator, '\"', '\\');
    }

    public CSVParser(char separator, char quotechar) {
        this(separator, quotechar, '\\');
    }

    public CSVParser(char separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this(separator, quotechar, escape, strictQuotes, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, ignoreQuotations, DEFAULT_NULL_FIELD_INDICATOR);
    }

    CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations, CSVReaderNullFieldIndicator nullFieldIndicator) {
        if (this.anyCharactersAreTheSame(separator, quotechar, escape)) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        if (separator == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        this.ignoreQuotations = ignoreQuotations;
        this.nullFieldIndicator = nullFieldIndicator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuotechar() {
        return this.quotechar;
    }

    public char getEscape() {
        return this.escape;
    }

    public boolean isStrictQuotes() {
        return this.strictQuotes;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.ignoreLeadingWhiteSpace;
    }

    public boolean isIgnoreQuotations() {
        return this.ignoreQuotations;
    }

    private boolean anyCharactersAreTheSame(char separator, char quotechar, char escape) {
        return this.isSameCharacter(separator, quotechar) || this.isSameCharacter(separator, escape) || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    protected String[] parseLine(String nextLine, boolean multi) throws IOException {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s = this.pending;
                this.pending = null;
                return new String[]{s};
            }
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(nextLine.length() + 128);
        boolean inQuotes = false;
        boolean fromQuotedField = false;
        if (this.pending != null) {
            sb.append(this.pending);
            this.pending = null;
            inQuotes = !this.ignoreQuotations;
        }
        for (int i = 0; i < nextLine.length(); ++i) {
            char c = nextLine.charAt(i);
            if (c == this.escape) {
                if (!this.isNextCharacterEscapable(nextLine, this.inQuotes(inQuotes), i)) continue;
                i = this.appendNextCharacterAndAdvanceLoop(nextLine, sb, i);
                continue;
            }
            if (c == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(nextLine, this.inQuotes(inQuotes), i)) {
                    i = this.appendNextCharacterAndAdvanceLoop(nextLine, sb, i);
                } else {
                    boolean bl = inQuotes = !inQuotes;
                    if (this.atStartOfField(sb)) {
                        fromQuotedField = true;
                    }
                    if (!this.strictQuotes && i > 2 && nextLine.charAt(i - 1) != this.separator && nextLine.length() > i + 1 && nextLine.charAt(i + 1) != this.separator) {
                        if (this.ignoreLeadingWhiteSpace && sb.length() > 0 && this.isAllWhiteSpace(sb)) {
                            sb.setLength(0);
                        } else {
                            sb.append(c);
                        }
                    }
                }
                this.inField = !this.inField;
                continue;
            }
            if (c == this.separator && (!inQuotes || this.ignoreQuotations)) {
                tokensOnThisLine.add(this.convertEmptyToNullIfNeeded(sb.toString(), fromQuotedField));
                fromQuotedField = false;
                sb.setLength(0);
                this.inField = false;
                continue;
            }
            if (this.strictQuotes && (!inQuotes || this.ignoreQuotations)) continue;
            sb.append(c);
            this.inField = true;
            fromQuotedField = true;
        }
        if (inQuotes && !this.ignoreQuotations) {
            if (!multi) {
                throw new IOException("Un-terminated quoted field at end of CSV line");
            }
            sb.append('\n');
            this.pending = sb.toString();
            sb = null;
            if (this.inField) {
                fromQuotedField = true;
            }
        } else {
            this.inField = false;
        }
        if (sb != null) {
            tokensOnThisLine.add(this.convertEmptyToNullIfNeeded(sb.toString(), fromQuotedField));
            fromQuotedField = false;
        }
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    private boolean atStartOfField(StringBuilder sb) {
        return sb.length() == 0;
    }

    private String convertEmptyToNullIfNeeded(String s, boolean fromQuotedField) {
        if (s.isEmpty() && this.shouldConvertEmptyToNull(fromQuotedField)) {
            return null;
        }
        return s;
    }

    private boolean shouldConvertEmptyToNull(boolean fromQuotedField) {
        switch (this.nullFieldIndicator) {
            case BOTH: {
                return true;
            }
            case EMPTY_SEPARATORS: {
                return !fromQuotedField;
            }
            case EMPTY_QUOTES: {
                return fromQuotedField;
            }
        }
        return false;
    }

    private int appendNextCharacterAndAdvanceLoop(String line, StringBuilder sb, int i) {
        sb.append(line.charAt(i + 1));
        return ++i;
    }

    private boolean inQuotes(boolean inQuotes) {
        return inQuotes && !this.ignoreQuotations || this.inField;
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && this.isCharacterQuoteCharacter(nextLine.charAt(i + 1));
    }

    private boolean isCharacterQuoteCharacter(char c) {
        return c == this.quotechar;
    }

    private boolean isCharacterEscapeCharacter(char c) {
        return c == this.escape;
    }

    private boolean isCharacterEscapable(char c) {
        return this.isCharacterQuoteCharacter(c) || this.isCharacterEscapeCharacter(c);
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && this.isCharacterEscapable(nextLine.charAt(i + 1));
    }

    protected boolean isAllWhiteSpace(CharSequence sb) {
        return StringUtil.isWhitespace(sb);
    }

    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return this.nullFieldIndicator;
    }
}

