/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.GlobalConfiguration;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.changelog.visitor.RollbackListVisitor;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.InternalSyncHubCommandStep;
import liquibase.command.core.RegisterChangelogCommandStep;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.core.DeprecatedConfigurationValueProvider;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.HubRegisterResponse;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationChange;
import liquibase.hub.model.OperationEvent;
import liquibase.integration.IntegrationDetails;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.core.BufferedLogService;
import liquibase.util.StringUtil;

public class HubUpdater {
    private final Date startTime;
    private final DatabaseChangeLog changeLog;
    private final Database database;
    private static final String SEPARATOR_LINE = "\n----------------------------------------------------------------------\n";
    final HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
    private static Boolean skipAutoRegistration = null;

    public HubUpdater(Date startTime, DatabaseChangeLog changeLog, Database database) {
        this.startTime = startTime;
        this.changeLog = changeLog;
        this.database = database;
    }

    public HubUpdater(Date startTime, Database database) {
        this.startTime = startTime;
        this.database = database;
        this.changeLog = null;
    }

    public Operation preUpdateHub(String operationType, String operationCommand, Connection connection) throws LiquibaseException, SQLException {
        if (connection == null || connection.getProject() == null) {
            return null;
        }
        return this.preUpdateHub(operationType, operationCommand, connection, null, null, null, null);
    }

    public Operation preUpdateHub(String operationType, String operationCommand, Connection connection, String changeLogFile, Contexts contexts, LabelExpression labelExpression, ChangeLogIterator changeLogIterator) throws LiquibaseHubException, DatabaseException, LiquibaseException, SQLException {
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        if (executor instanceof LoggingExecutor) {
            return null;
        }
        HubChangeLog hubChangeLog = this.getHubChangeLog();
        this.syncHub(changeLogFile, connection);
        this.loadDatabaseMetadata();
        Operation operation = this.sendStartOperationEvent(operationType, operationCommand, connection, hubChangeLog);
        ListVisitor listVisitor = operationType.equalsIgnoreCase("ROLLBACK") ? new RollbackListVisitor() : new ListVisitor();
        OperationChange operationChange = new OperationChange();
        this.populateOperationChange(contexts, labelExpression, changeLogIterator, listVisitor, operationChange);
        this.populateProject(connection, hubChangeLog, operationChange);
        operationChange.setOperation(operation);
        try {
            this.hubService.sendOperationChanges(operationChange);
        }
        catch (LiquibaseException e) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e.getMessage(), e);
        }
        if (operation != null) {
            Operation.OperationStatus operationStatus = new Operation.OperationStatus();
            operationStatus.setOperationStatusType(operationType);
            operation.setOperationStatus(operationStatus);
        }
        return operation;
    }

    private void populateOperationChange(Contexts contexts, LabelExpression labelExpression, ChangeLogIterator changeLogIterator, ListVisitor listVisitor, OperationChange operationChange) throws LiquibaseException {
        if (changeLogIterator != null) {
            changeLogIterator.run(listVisitor, new RuntimeEnvironment(this.database, contexts, labelExpression));
            List<ChangeSet> operationChangeSets = listVisitor.getSeenChangeSets();
            for (ChangeSet operationChangeSet : operationChangeSets) {
                operationChange.getChangeSets().add(operationChangeSet);
            }
        }
    }

    private void populateProject(Connection connection, HubChangeLog hubChangeLog, OperationChange operationChange) {
        if (hubChangeLog == null) {
            operationChange.setProject(connection.getProject());
        } else {
            operationChange.setProject(hubChangeLog.getProject());
        }
    }

    private Operation sendStartOperationEvent(String operationType, String operationCommand, Connection connection, HubChangeLog hubChangeLog) throws LiquibaseHubException {
        Operation updateOperation = this.hubService.createOperation(operationType, operationCommand, hubChangeLog, connection);
        try {
            this.hubService.sendOperationEvent(updateOperation, new OperationEvent().setEventType("START").setStartDate(this.startTime).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("PASS").setStatusMessage(String.format("%s operation started successfully", operationType))));
        }
        catch (LiquibaseException e) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e.getMessage(), e);
        }
        return updateOperation;
    }

    private HubChangeLog getHubChangeLog() throws LiquibaseHubException {
        HubChangeLog hubChangeLog = null;
        if (this.changeLog != null) {
            if (this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
                return null;
            }
            hubChangeLog = this.hubService.getHubChangeLog(UUID.fromString(this.changeLog.getChangeLogId()), "DELETED");
            if (hubChangeLog.isDeleted()) {
                String message = "\nThe operation did not complete and will not be reported to Hub because the\nregistered changelog has been deleted by someone in your organization.\nLearn more at http://hub.liquibase.com";
                Scope.getCurrentScope().getLog(HubUpdater.class).warning(message);
                throw new LiquibaseHubException(message);
            }
        }
        return hubChangeLog;
    }

    public void postUpdateHub(Operation updateOperation, BufferedLogService bufferLog) {
        try {
            Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            if (executor instanceof LoggingExecutor) {
                return;
            }
            if (updateOperation == null || this.changeLog != null && this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
                return;
            }
            if (this.changeLog != null) {
                HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
                HubChangeLog hubChangeLog = hubService.getHubChangeLog(UUID.fromString(this.changeLog.getChangeLogId()));
                if (hubChangeLog.isInactive()) {
                    String message = "\nThe command completed and reported to Hub, but changelog '" + hubChangeLog.getName() + "' has been deactivated by someone in your organization.\nTo synchronize your changelog, checkout the latest from source control or run \"deactivatechangelog\".\nAfter that, commands run against this changelog will not be reported to Hub until \"registerchangelog\" is run again.\nLearn more at http://hub.liquibase.com";
                    Scope.getCurrentScope().getLog(HubUpdater.class).warning(message);
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
                }
                this.sendCompleteOperationEvent(updateOperation, bufferLog);
                if (hubChangeLog.isActive()) {
                    this.showOperationReportLink(updateOperation, hubService);
                }
            } else {
                this.sendCompleteOperationEvent(updateOperation, bufferLog);
                this.showOperationReportLink(updateOperation, this.hubService);
            }
        }
        catch (LiquibaseException e) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e.getMessage(), e);
        }
    }

    private void sendCompleteOperationEvent(Operation updateOperation, BufferedLogService bufferLog) throws LiquibaseException {
        Level currentLevel = HubConfiguration.LIQUIBASE_HUB_LOGLEVEL.getCurrentValue();
        this.hubService.sendOperationEvent(updateOperation, new OperationEvent().setEventType("COMPLETE").setStartDate(this.startTime).setEndDate(new Date()).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("PASS").setStatusMessage(String.format("%s operation completed successfully", updateOperation.getOperationStatus().getOperationStatusType()))).setOperationEventLog(new OperationEvent.OperationEventLog().setLogMessage(bufferLog.getLogAsString(currentLevel)).setTimestampLog(this.startTime)));
    }

    public void postUpdateHubExceptionHandling(Operation operation, BufferedLogService bufferLog, String originalExceptionMessage) {
        try {
            Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            if (executor instanceof LoggingExecutor) {
                return;
            }
            if (operation == null || this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
                return;
            }
            Level currentLevel = HubConfiguration.LIQUIBASE_HUB_LOGLEVEL.getCurrentValue();
            HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
            HubChangeLog hubChangeLog = hubService.getHubChangeLog(UUID.fromString(this.changeLog.getChangeLogId()));
            if (hubChangeLog.isInactive()) {
                String message = "\nThe command completed and reported to Hub, but changelog '" + hubChangeLog.getName() + "' has been deactivated by someone in your organization.\nTo synchronize your changelog, checkout the latest from source control or run \"deactivatechangelog\".\nAfter that, commands run against this changelog will not be reported to Hub until \"registerchangelog\" is run again.\nLearn more at http://hub.liquibase.com";
                Scope.getCurrentScope().getLog(HubUpdater.class).warning(message);
                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            }
            hubService.sendOperationEvent(operation, new OperationEvent().setEventType("COMPLETE").setStartDate(this.startTime).setEndDate(new Date()).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("FAIL").setStatusMessage(String.format("%s operation completed with errors", operation.getOperationStatus().getOperationStatusType()))).setOperationEventLog(new OperationEvent.OperationEventLog().setLogMessage(bufferLog.getLogAsString(currentLevel))));
            if (hubChangeLog.isActive()) {
                this.showOperationReportLink(operation, hubService);
            }
        }
        catch (LiquibaseException serviceException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(originalExceptionMessage, serviceException);
        }
    }

    public boolean hubIsNotAvailable(String changeLogId) {
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        return !hubService.isOnline() || changeLogId == null;
    }

    public void syncHub(String changeLogFile, Connection hubConnection) throws CommandExecutionException {
        UUID hubConnectionId = hubConnection != null ? hubConnection.getId() : null;
        UUID hubProjectId = hubConnection != null && hubConnection.getProject() != null ? hubConnection.getProject().getId() : null;
        CommandScope syncHub = new CommandScope("internalSyncHub").addArgumentValue(InternalSyncHubCommandStep.CHANGELOG_FILE_ARG, changeLogFile).addArgumentValue(InternalSyncHubCommandStep.URL_ARG, this.database.getConnection().getURL()).addArgumentValue(InternalSyncHubCommandStep.HUB_CONNECTION_ID_ARG, hubConnectionId).addArgumentValue(InternalSyncHubCommandStep.HUB_PROJECT_ID_ARG, hubProjectId).addArgumentValue(InternalSyncHubCommandStep.CONTINUE_IF_CONNECTION_AND_PROJECT_ID_BOTH_SET_ARG, true).addArgumentValue(InternalSyncHubCommandStep.DATABASE_ARG, this.database).addArgumentValue(InternalSyncHubCommandStep.FAIL_IF_OFFLINE_ARG, false);
        try {
            syncHub.execute();
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(this.getClass()).warning("Liquibase Hub sync failed: " + e.getMessage(), e);
        }
    }

    public HubRegisterResponse register(String changeLogFile) throws LiquibaseException {
        HubRegisterResponse registerResponse = null;
        if (!this.hubService.isOnline()) {
            return null;
        }
        if (!Scope.getCurrentScope().getUI().getAllowPrompt()) {
            return null;
        }
        if (!StringUtil.isEmpty(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue()) || this.changeLog != null && this.changeLog.getChangeLogId() != null) {
            return null;
        }
        if (skipAutoRegistration != null && skipAutoRegistration.booleanValue()) {
            return null;
        }
        try {
            LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
            lockService.releaseLock();
        }
        catch (LockException e) {
            Scope.getCurrentScope().getLog(HubUpdater.class).warning(Liquibase.MSG_COULD_NOT_RELEASE_LOCK);
        }
        String promptString = "Do you want to see this operation's report in Liquibase Hub, which improves team collaboration? \nIf so, enter your email. If not, enter [N] to no longer be prompted, or [S] to skip for now, but ask again next time";
        String input = Scope.getCurrentScope().getUI().prompt(promptString, "S", (input1, returnType) -> {
            if (!((input1 = input1.trim().toLowerCase()).equals("s") || input1.equals("n") || input1.contains("@"))) {
                throw new IllegalArgumentException("Invalid input '" + input1 + "'");
            }
            return input1;
        }, String.class);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        String defaultsFilePath = (String)((Object)Scope.getCurrentScope().get("defaultsFile", String.class));
        File defaultsFile = null;
        if (defaultsFilePath != null) {
            defaultsFile = new File(defaultsFilePath);
        }
        if ((input = input.toLowerCase()).equals("n")) {
            try {
                String message = "No operations will be reported. Simply add a liquibase.hub.apiKey setting to generate free deployment reports. Learn more at https://hub.liquibase.com";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).info(message);
                this.writeToPropertiesFile(defaultsFile, "\nliquibase.hub.mode=off\n");
                message = "* Updated properties file " + defaultsFile + " to set liquibase.hub.mode=off";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).info(message);
                DeprecatedConfigurationValueProvider.setData(HubConfiguration.LIQUIBASE_HUB_MODE, HubConfiguration.HubMode.OFF);
            }
            catch (IOException ioe) {
                String message = "Unable to write hubMode to liquibase.properties: " + ioe.getMessage();
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            }
        } else if (input.equals("s")) {
            String message = "Skipping auto-registration";
            Scope.getCurrentScope().getUI().sendMessage(message);
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            skipAutoRegistration = true;
        } else {
            try {
                registerResponse = this.hubService.register(input);
            }
            catch (LiquibaseException lhe) {
                String message = "Account creation failed for email address '" + input + "': " + lhe.getMessage() + ".\nNo operation report will be generated.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(HubUpdater.class).warning(message);
                return registerResponse;
            }
            if (registerResponse == null) {
                String message = "Account creation failed for email address '" + input + "'.\nNo operation report will be generated.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(HubUpdater.class).warning(message);
                return registerResponse;
            }
            try {
                String message;
                this.writeToPropertiesFile(defaultsFile, "\nliquibase.hub.apiKey=" + registerResponse.getApiKey() + "\n");
                ConfiguredValue<HubConfiguration.HubMode> hubModeProperty = HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentConfiguredValue();
                if (hubModeProperty.wasDefaultValueUsed()) {
                    this.writeToPropertiesFile(defaultsFile, "\nliquibase.hub.mode=all\n");
                    message = "* Updated properties file " + defaultsFile + " to set liquibase.hub properties";
                    Scope.getCurrentScope().getUI().sendMessage(message);
                    Scope.getCurrentScope().getLog(this.getClass()).info(message);
                } else {
                    message = "* Updated the liquibase.hub.apiKey property.";
                    String message2 = "The liquibase.hub.mode is already set to " + (Object)((Object)hubModeProperty.getValue()) + ". It will not be updated.";
                    Scope.getCurrentScope().getUI().sendMessage(message);
                    Scope.getCurrentScope().getUI().sendMessage(message2);
                    Scope.getCurrentScope().getLog(this.getClass()).warning(message);
                    Scope.getCurrentScope().getLog(this.getClass()).warning(message2);
                }
                DeprecatedConfigurationValueProvider.setData(HubConfiguration.LIQUIBASE_HUB_API_KEY, registerResponse.getApiKey());
                if (this.changeLog != null) {
                    message = "* Registering changelog file " + changeLogFile + " with Hub";
                    Scope.getCurrentScope().getUI().sendMessage(message);
                    Scope.getCurrentScope().getLog(this.getClass()).info(message);
                    this.registerChangeLog(registerResponse.getProjectId(), this.changeLog, changeLogFile);
                }
                message = "Great! Your free operation and deployment reports will be available to you after your local Liquibase commands complete.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).info(message);
            }
            catch (IOException ioe) {
                String message = "Unable to write information to liquibase.properties: " + ioe.getMessage() + "\nPlease check your permissions.  No operations will be reported.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            }
            catch (CommandExecutionException cee) {
                String message = "Unable to register changelog: " + cee.getMessage() + "\nNo operations will be reported.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
                DeprecatedConfigurationValueProvider.setData(HubConfiguration.LIQUIBASE_HUB_API_KEY, null);
            }
        }
        return registerResponse;
    }

    private void writeToPropertiesFile(File defaultsFile, String stringToWrite) throws IOException {
        if (defaultsFile == null) {
            return;
        }
        String encoding = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(defaultsFile, "rw");){
            randomAccessFile.seek(defaultsFile.length());
            randomAccessFile.write(stringToWrite.getBytes(encoding));
        }
    }

    private void registerChangeLog(UUID hubProjectId, DatabaseChangeLog changeLog, String changeLogFile) throws LiquibaseException {
        CommandScope registerChangeLogCommand;
        block6: {
            String apiKey = StringUtil.trimToNull(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue());
            if (apiKey == null) {
                throw new LiquibaseException("The command 'RegisterChangeLog'  failed because the Liquibase API Key has not been set. Learn more at https://hub.liquibase.com");
            }
            registerChangeLogCommand = new CommandScope("registerChangeLog");
            registerChangeLogCommand.addArgumentValue(RegisterChangelogCommandStep.CHANGELOG_FILE_ARG, changeLogFile);
            try {
                if (hubProjectId == null) break block6;
                try {
                    registerChangeLogCommand.addArgumentValue(RegisterChangelogCommandStep.HUB_PROJECT_ID_ARG, hubProjectId);
                }
                catch (IllegalArgumentException e) {
                    throw new LiquibaseException("The command 'RegisterChangeLog'  failed because parameter 'hubProjectId' has invalid value '" + hubProjectId + "'. Learn more at https://hub.liquibase.com");
                }
            }
            catch (IllegalArgumentException e) {
                throw new LiquibaseException("Unexpected hubProjectId format: " + hubProjectId, e);
            }
        }
        CommandResults results = registerChangeLogCommand.execute();
        String registerChangeLogId = results.getResult(RegisterChangelogCommandStep.REGISTERED_CHANGELOG_ID);
        if (registerChangeLogId != null) {
            changeLog.setChangeLogId(registerChangeLogId);
        }
    }

    private void showOperationReportLink(Operation updateOperation, HubService hubService) throws LiquibaseException {
        Connection connection = updateOperation.getConnection();
        String reportURL = "/organizations/" + hubService.getOrganization().getId().toString() + "/projects/" + connection.getProject().getId() + "/operations/" + updateOperation.getId().toString();
        String hubLink = hubService.shortenLink(reportURL);
        String message = SEPARATOR_LINE;
        message = message + "View a report of this operation at " + hubLink + "\n";
        message = message + "* IMPORTANT: New users of Hub first need to Sign In to your account\n";
        message = message + "with the one-time password sent to your email, which also serves as\n";
        message = message + "your username.";
        message = message + SEPARATOR_LINE;
        Scope.getCurrentScope().getUI().sendMessage(message);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
    }

    private void loadDatabaseMetadata() throws DatabaseException, SQLException {
        if (this.database.getConnection() == null) {
            return;
        }
        IntegrationDetails integrationDetails = (IntegrationDetails)((Object)Scope.getCurrentScope().get("integrationDetails", IntegrationDetails.class));
        if (integrationDetails == null) {
            return;
        }
        String databaseProductName = this.database.getDatabaseProductName();
        String databaseProductVersion = this.database.getDatabaseProductVersion();
        Scope.getCurrentScope().getLog(this.getClass()).fine("Database product name         " + databaseProductName);
        Scope.getCurrentScope().getLog(this.getClass()).fine("Database product version      " + databaseProductVersion);
        DatabaseConnection connection = this.database.getConnection();
        if (connection instanceof JdbcConnection) {
            JdbcConnection jdbcConnection = (JdbcConnection)connection;
            java.sql.Connection conn = jdbcConnection.getUnderlyingConnection();
            int driverMajorVersion = conn.getMetaData().getDriverMajorVersion();
            int driverMinorVersion = conn.getMetaData().getDriverMinorVersion();
            Scope.getCurrentScope().getLog(this.getClass()).fine("Database driver version       " + driverMajorVersion + "." + driverMinorVersion);
            integrationDetails.setParameter("db__driverVersion", driverMajorVersion + "." + driverMinorVersion);
        } else {
            integrationDetails.setParameter("db__driverVersion", "Unable to determine");
        }
        integrationDetails.setParameter("db__databaseProduct", databaseProductName);
        integrationDetails.setParameter("db__databaseVersion", databaseProductVersion);
    }
}

