/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.editor;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.plusplus.FileSystem;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.scriptrunner.commands.editor.Messages;

public class GetCommand
extends CommandListener
implements IHelp {
    private static final String GET = "GET";
    private static final String FILE = "file";
    private static final String LIST = "list";
    private static final String NOLIST = "nolist";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String suffix;
        String sqlpcmd = cmd.getSql().trim();
        String[] cmds = sqlpcmd.split("\\s+");
        boolean list = true;
        String filename = null;
        switch (cmds.length) {
            case 1: {
                ctx.write(Messages.getString("GetCommand.1"));
                ctx.write(this.getHelp());
                return true;
            }
            case 2: {
                filename = ctx.prependCD(cmds[1]);
                break;
            }
            case 3: {
                if (cmds[1].toLowerCase().equals(FILE)) {
                    filename = ctx.prependCD(cmds[2]);
                    break;
                }
                filename = ctx.prependCD(cmds[1]);
                if (cmds[2].toLowerCase().equals(NOLIST)) {
                    list = false;
                    break;
                }
                if (cmds[2].toLowerCase().equals(LIST)) {
                    list = true;
                    break;
                }
                ctx.write(Messages.getString("GetCommand.2"));
                return true;
            }
            case 4: {
                if (!cmds[1].toLowerCase().equals(FILE)) {
                    ctx.write(Messages.getString("GetCommand.3"));
                }
                if (cmds[3].toLowerCase().equals(NOLIST)) {
                    list = false;
                } else if (cmds[3].toLowerCase().equals(LIST)) {
                    list = true;
                } else {
                    ctx.write(Messages.getString("GetCommand.4"));
                    return true;
                }
                filename = ctx.prependCD(cmds[2]);
                break;
            }
            default: {
                ctx.write(Messages.getString("GetCommand.5"));
                return true;
            }
        }
        if (filename.lastIndexOf(".") == -1 && (suffix = (String)ctx.getProperty("script.runner.file.suffix")).length() > 0) {
            filename = filename + "." + suffix;
        }
        Path path = null;
        path = Paths.get(filename, new String[0]).toFile().canRead() ? Paths.get(filename, new String[0]) : FileUtils.getFileOnSQLPATH(ctx, filename, true);
        FileSystem.Results error = FileSystem.Results.FILE_NOT_FOUND;
        if (path != null) {
            error = ctx.getSQLPlusBuffer().getBufferSafe().get(path.toAbsolutePath().toString(), list, (String)ctx.getProperty("script.runner.file.suffix"));
        }
        switch (error) {
            case OK: {
                if (!list) break;
                if (this.isSqlPlus()) {
                    ctx.write(ctx.getSQLPlusBuffer().getBufferSafe().list());
                    break;
                }
                ctx.write(ctx.getSQLPlusBuffer().getBufferSafe().list(false));
                break;
            }
            case FILE_NOT_FOUND: 
            case FILE_NOT_ACCESSIBLE: {
                String realFile = filename.lastIndexOf(".") > -1 ? filename : filename + "." + ctx.getProperty("script.runner.file.suffix");
                ctx.write(MessageFormat.format(Messages.getString("GetCommand.10"), realFile));
                break;
            }
        }
        return true;
    }

    @Override
    public String getCommand() {
        return GET;
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

