/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Properties;
import javax.crypto.Cipher;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.jdbc.wallet.DatabaseToolsProperties;
import oracle.dbtools.jdbc.wallet.OracleWalletArchive;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

@Restricted(level=Restricted.Level.R4)
public class SetCloudConfig
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setcloudconfig")) {
            String[] parts = cmd.getModifiedSQL().split(" ");
            if (parts.length < 3) {
                ctx.write(Messages.getString("CLOUD_USAGE"));
                return true;
            }
            int startPath = 2;
            URI httpsProxy = null;
            if (parts[2].startsWith("-proxy")) {
                String proxyValue = null;
                try {
                    proxyValue = parts[2].substring(parts[2].indexOf("=") + 1);
                    if (!proxyValue.startsWith("http://") && !proxyValue.startsWith("https://")) {
                        proxyValue = "https://" + proxyValue;
                    }
                    httpsProxy = new URI(proxyValue);
                }
                catch (URISyntaxException e) {
                    ctx.write(MessageFormat.format(Messages.getString("CLOUD_INVALID_PROXY"), proxyValue) + "\n");
                }
                startPath = 3;
            }
            if (this.testJCE()) {
                StringBuilder sb = new StringBuilder();
                for (int i = startPath; i < parts.length; ++i) {
                    sb.append(parts[i]).append(" ");
                }
                String fName = sb.toString().trim();
                if (fName.equalsIgnoreCase("off")) {
                    ctx.removeProperty("script.runner.walletarchive.zip");
                    ctx.removeProperty("script.runner.walletarchive.location");
                } else {
                    URLConnection fUrl = FileUtils.getFile(ctx, fName);
                    try (InputStream contents = fUrl.getInputStream();){
                        OracleWalletArchive walletArchive = OracleWalletArchive.read(contents);
                        if (httpsProxy != null) {
                            DatabaseToolsProperties oldProperties = walletArchive.getDatabaseToolsProperties();
                            DatabaseToolsProperties.Builder propBuilder = oldProperties.modify();
                            propBuilder.httpsProxy(httpsProxy);
                            DatabaseToolsProperties newProperties = propBuilder.build();
                            OracleWalletArchive.Builder archiveBuilder = walletArchive.modify();
                            archiveBuilder.databaseToolsProperties(newProperties);
                            walletArchive = archiveBuilder.build();
                        }
                        if (walletArchive.isConfigurable()) {
                            ctx.putProperty("script.runner.walletarchive.zip", walletArchive);
                            ctx.putProperty("script.runner.walletarchive.location", fName);
                        } else {
                            ctx.write(MessageFormat.format(Messages.getString("CLOUD_ARCHIVE_INVALID"), fName) + "\n");
                        }
                    }
                    catch (Exception e) {
                        ctx.write(MessageFormat.format(Messages.getString("CLOUD_INVALID"), fName) + "\n");
                    }
                    if (parts.length < 3) {
                        ctx.write(Messages.getString("CLOUD_USAGE"));
                        return true;
                    }
                }
            } else {
                ctx.write("***** JCE NOT INSTALLED **** \n");
                ctx.write("***** CAN NOT CONNECT TO PDB Service without it **** \n");
                ctx.write("  Current Java: " + System.getProperty("java.home") + "\n");
                ctx.write(" Follow instructions on  http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html\n");
            }
            return true;
        }
        return false;
    }

    private boolean testJCE() {
        int maxKeySize = 0;
        try {
            maxKeySize = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return maxKeySize > 128;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        DatabaseToolsProperties dbtProps;
        URI httpsProxy;
        String message = null;
        String archiveLocation = (String)ctx.getProperty("script.runner.walletarchive.location");
        message = archiveLocation != null ? MessageFormat.format(Messages.getString("CLOUD_LOCATION"), archiveLocation) : Messages.getString("CLOUD_NOLOCATION");
        ctx.write("");
        ctx.write(message);
        OracleWalletArchive archive = (OracleWalletArchive)ctx.getProperty("script.runner.walletarchive.zip");
        if (archive != null && (httpsProxy = (dbtProps = archive.getDatabaseToolsProperties()).httpsProxy()) != null) {
            message = MessageFormat.format(Messages.getString("CLOUD_PROXY"), httpsProxy.toASCIIString());
            ctx.write("");
            ctx.write(message);
        }
        ctx.write("\n");
        return true;
    }

    private String getProp(Properties props, String prop) {
        return props != null ? props.getProperty(prop) : "";
    }

    public void printProp(ScriptRunnerContext ctx, Properties props, String prop) {
        ctx.write(prop + "=" + this.getProp(props, prop) + "\n");
    }

    public void setProp(Properties props, String prop, String value) {
        props.setProperty(prop, value);
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"cloudconfig"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public static boolean isCloudConfigConfigured(ScriptRunnerContext ctx) {
        return ctx.getProperty("script.runner.walletarchive.zip") != null;
    }
}

