/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.plusplus.JDBCHelper;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.restricted.RunnerRestrictedLevel;
import oracle.dbtools.raptor.scriptrunner.cmdline.Messages;
import oracle.dbtools.raptor.scriptrunner.cmdline.NLSLANGParser;
import oracle.dbtools.util.Logger;

public class SQLCliOptions {
    public static String commandlineArg = "";
    public static ArrayList<String> options = new ArrayList();
    public static Properties properties = new Properties();
    public static final String LOGGING = "-verbose";
    public static final String H = "-h";
    public static final String HELP = "-help";
    public static final String L = "-l";
    public static final String LOGON = "-logon";
    public static final String R = "-r";
    public static final String RESTRICT = "-restrict";
    public static final String R1 = "1";
    public static final String R2 = "2";
    public static final String R3 = "3";
    public static final String R4 = "4";
    public static final String S = "-s";
    public static final String SILENT = "-silent";
    public static final String V = "-v";
    public static final String VERSION = "-version";
    public static final String N = "-n";
    public static final String NOHISTORY = "-nohistory";
    public static final String NOUPDATES = "-noupdates";
    public static final String NOLOG = "/nolog";
    public static final String NOLOG1 = "/nlog";
    public static final String NOLOG2 = "-nolog";
    public static final String OCI = "-oci";
    public static final String THIN = "-thin";
    public static final String NOLOGINFILE = "-nologinfile";
    private static final String AT = "@";
    private static final Object AS = "as";
    private static final String[] ASROLES = new String[]{"sysdba", "sysbackup", "sysdg", "syskm", "sysasm", "sysoper"};
    private static final CharSequence SYSBACKUP = "sysbackup";
    public static final String CLOUDCONFIG = "-cloudconfig";
    public static final String PROXY = "-proxy";
    public static final String XHIDEBANNERS = "-x";
    public static final String COMPATIBILITY = "-compatibility";
    public static final String NOLOGINTIME = "-nologintime";
    private static int atcount = 0;
    private static String connectString;
    private static String filename;
    private static String edition;
    private static ArrayList<String> variables;
    private static String asRole;
    private static boolean assysbackup;
    public static final String SSHHOST = "-sshhost";
    public static final String SSHKEY = "-sshkey";
    private static final String NLS_LANG;
    private static final String EDITION = "edition";
    static String[] realOption;
    private static String badOption;
    private static boolean finishedOptions;
    private static String s_compatability;

    public static void setArgs(String[] cmdLineArgs) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < cmdLineArgs.length; ++index) {
            String arg = cmdLineArgs[index] + " ";
            sb.append(arg);
        }
        commandlineArg = sb.toString();
    }

    public static String getArgsString() {
        return commandlineArg;
    }

    public static String[] getArgsArray() {
        StringTokenizer st = new StringTokenizer(commandlineArg);
        String[] args = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreElements()) {
            args[index] = st.nextToken();
        }
        return args;
    }

    public static void setAtCount(int i) {
        atcount = i;
    }

    public static int getAtCount() {
        return atcount;
    }

    private static boolean isDQuotedUsername(String connect) {
        if (connect.length() < 2) {
            return false;
        }
        int nextDQuote = connect.indexOf(34, 1);
        if (nextDQuote == -1) {
            return false;
        }
        if (nextDQuote == connect.length() - 1) {
            return true;
        }
        char after = connect.charAt(nextDQuote + 1);
        if (after == '/') {
            return true;
        }
        if (after == '@') {
            return true;
        }
        return Character.isWhitespace(after);
    }

    private static int slashesBeforeAt(String s) {
        int dquote = 0;
        int slash = 0;
        if (s == null) {
            return 0;
        }
        block4: for (char c : s.toCharArray()) {
            switch (c) {
                case '\"': {
                    ++dquote;
                    continue block4;
                }
                case '/': {
                    if (dquote % 2 != 0) continue block4;
                    ++slash;
                    continue block4;
                }
            }
        }
        return slash;
    }

    public static void setConnectString(String connect) {
        connectString = connect != null && connect.startsWith("\"") && !connect.endsWith("\"") && connect.length() > 1 && !SQLCliOptions.isDQuotedUsername(connect) ? connect.substring(1) : connect;
        String s = connectString.substring(0, connectString.indexOf(64) != -1 ? connectString.indexOf(64) : connectString.length());
        if (SQLCliOptions.slashesBeforeAt(s) > 1) {
            String msg = Messages.getString("SQLCliOptions.4");
            SQLCliOptions.setBadOption(MessageFormat.format(msg, connectString));
        }
    }

    public static String getConnectString() {
        return connectString;
    }

    public static String getFileName() {
        return filename;
    }

    public static void setFileArguments(ArrayList<String> args) {
        variables = args;
    }

    public static ArrayList<String> getFileArguments() {
        return variables;
    }

    public static void setFileName(String arg) {
        String aFileName = "";
        if (arg != null) {
            aFileName = arg.indexOf(AT) == 0 ? arg.substring(1) : arg;
            File f = new File(aFileName);
            int lastAnySlash = aFileName.lastIndexOf("/");
            int lastBSlash = aFileName.lastIndexOf("\\");
            if (lastBSlash > lastAnySlash) {
                lastAnySlash = lastBSlash;
            }
            if (!f.exists() && aFileName.lastIndexOf(".") <= lastAnySlash) {
                aFileName = aFileName + ".sql";
            }
        }
        filename = aFileName;
    }

    private static int processOption(String[] arguments, int index) {
        String currArg;
        String arg = currArg = arguments[index];
        int skip = 0;
        if (currArg.startsWith(AT) || currArg.contains(AT)) {
            finishedOptions = true;
        }
        if (currArg != null) {
            block31 : switch (arg.toLowerCase()) {
                case "-l": {
                    if (!options.contains(LOGON)) {
                        options.add(LOGON);
                    }
                    skip = 1;
                    break;
                }
                case "-logon": {
                    if (!options.contains(LOGON)) {
                        options.add(LOGON);
                    }
                    skip = 1;
                    break;
                }
                case "-h": {
                    if (!options.contains(HELP)) {
                        options.add(HELP);
                    }
                    skip = 1;
                    break;
                }
                case "-help": {
                    if (!options.contains(HELP)) {
                        options.add(HELP);
                    }
                    skip = 1;
                    break;
                }
                case "-nologintime": {
                    if (!options.contains(NOLOGINTIME)) {
                        options.add(NOLOGINTIME);
                    }
                    skip = 1;
                    break;
                }
                case "-noupdates": {
                    if (!options.contains(NOUPDATES)) {
                        options.add(NOUPDATES);
                    }
                    skip = 1;
                    break;
                }
                case "-v": {
                    if (!options.contains(VERSION)) {
                        options.add(VERSION);
                    }
                    skip = 1;
                    break;
                }
                case "-version": {
                    if (!options.contains(VERSION)) {
                        options.add(VERSION);
                    }
                    skip = 1;
                    break;
                }
                case "-n": 
                case "-nohistory": {
                    if (!options.contains(NOHISTORY)) {
                        options.add(NOHISTORY);
                    }
                    skip = 1;
                    break;
                }
                case "-s": {
                    if (!options.contains(SILENT)) {
                        options.add(SILENT);
                    }
                    skip = 1;
                    break;
                }
                case "-silent": {
                    if (!options.contains(SILENT)) {
                        options.add(SILENT);
                    }
                    skip = 1;
                    break;
                }
                case "-x": {
                    if (!options.contains(XHIDEBANNERS)) {
                        options.add(XHIDEBANNERS);
                    }
                    skip = 1;
                    break;
                }
                case "-compatibility": 
                case "-c": {
                    if (!options.contains(COMPATIBILITY)) {
                        options.add(COMPATIBILITY);
                    }
                    skip = 1;
                    if (index >= arguments.length - 1) break;
                    String input = arguments[index + 1];
                    String regex = "^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$";
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(input);
                    boolean fail = false;
                    if (matcher.matches()) {
                        String[] bits = input.split("\\.");
                        if (bits.length == 2 || bits.length == 3) {
                            int majormin = Integer.parseInt(bits[0] + bits[1]);
                            if (majormin < 73) {
                                fail = true;
                            }
                            if (bits.length > 2) {
                                String patch = bits[2];
                                if (majormin == 73 && !patch.equals("*") && Integer.parseInt(patch) < 4) {
                                    fail = true;
                                }
                            }
                            if (!fail) {
                                SQLCliOptions.setCompatability(arguments[index + 1]);
                            } else {
                                String msg = Messages.getString("SQLCliOptions.11");
                                SQLCliOptions.setBadOption(msg);
                            }
                        } else {
                            String msg = "";
                            msg = bits.length == 1 ? Messages.getString("SQLCliOptions.13") : Messages.getString("SQLCliOptions.11");
                            SQLCliOptions.setBadOption(msg);
                        }
                    } else {
                        String msg = Messages.getString("SQLCliOptions.12");
                        SQLCliOptions.setBadOption(MessageFormat.format(msg, arguments[index] + " " + input));
                    }
                    skip = 2;
                    break;
                }
                case "-r": 
                case "-restrict": {
                    if (!options.contains(RESTRICT)) {
                        options.add(RESTRICT);
                    }
                    skip = 1;
                    if (index >= arguments.length - 1) break;
                    try {
                        int rlevel = Integer.parseInt(arguments[index + 1]);
                        skip = 2;
                        switch (rlevel) {
                            case 1: {
                                if (options.contains(R1)) break block31;
                                options.add(R1);
                                break;
                            }
                            case 2: {
                                if (options.contains(R2)) break block31;
                                options.add(R2);
                                break;
                            }
                            case 3: {
                                if (options.contains(R3)) break block31;
                                options.add(R3);
                                break;
                            }
                            case 4: {
                                if (options.contains(R4)) break block31;
                                options.add(R4);
                                break;
                            }
                            default: {
                                String msg = Messages.getString("SQLCliOptions.14");
                                SQLCliOptions.setBadOption(MessageFormat.format(msg, arguments[index] + " " + arguments[index + 1]));
                                skip = -1;
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        String msg = Messages.getString("SQLCliOptions.16");
                        SQLCliOptions.setBadOption(MessageFormat.format(msg, arguments[index] + " " + arguments[index + 1]));
                    }
                    break;
                }
                case "-oci": {
                    if (!options.contains(OCI)) {
                        options.add(OCI);
                    }
                    skip = 1;
                    break;
                }
                case "-thin": {
                    if (!options.contains(THIN)) {
                        options.add(THIN);
                    }
                    skip = 1;
                    break;
                }
                case "-nologinfile": {
                    if (!options.contains(NOLOGINFILE)) {
                        options.add(NOLOGINFILE);
                    }
                    skip = 1;
                    break;
                }
                case "/nolog": {
                    if (!options.contains(NOLOG)) {
                        options.add(NOLOG);
                    }
                    skip = 1;
                    break;
                }
                case "/nlog": {
                    if (!options.contains(NOLOG1)) {
                        options.add(NOLOG);
                    }
                    skip = 1;
                    break;
                }
                case "-nolog": {
                    if (!options.contains(NOLOG2)) {
                        options.add(NOLOG);
                    }
                    skip = 1;
                    break;
                }
                case "-verbose": {
                    if (!options.contains(LOGGING)) {
                        options.add(LOGGING);
                    }
                    skip = 1;
                    break;
                }
                case "-sshhost": {
                    if (options.contains(SSHHOST)) break;
                    if (arguments.length > index) {
                        options.add(SSHHOST);
                        SQLCliOptions.getProperties().put(SSHHOST, arguments[index + 1]);
                    }
                    skip = 2;
                    break;
                }
                case "-sshkey": {
                    if (options.contains(SSHKEY)) break;
                    if (arguments.length > index) {
                        options.add(SSHKEY);
                        SQLCliOptions.getProperties().put(SSHKEY, arguments[index + 1]);
                    }
                    skip = 2;
                    break;
                }
                case "-cloudconfig": {
                    if (options.contains(CLOUDCONFIG)) break;
                    if (arguments.length > index + 1 && arguments[index + 1].indexOf(10) == -1) {
                        options.add(CLOUDCONFIG);
                        SQLCliOptions.getProperties().put(CLOUDCONFIG, arguments[index + 1]);
                    }
                    skip = 2;
                    break;
                }
                case "-proxy": {
                    if (options.contains(PROXY)) break;
                    if (arguments.length > index + 1 && arguments[index + 1].indexOf(10) == -1) {
                        options.add(PROXY);
                        SQLCliOptions.getProperties().put(PROXY, arguments[index + 1]);
                    }
                    skip = 2;
                    break;
                }
                default: {
                    skip = finishedOptions ? -2 : -1;
                }
            }
        }
        return skip;
    }

    private static void setCompatability(String string) {
        s_compatability = string;
    }

    public static String getCompatability() {
        return s_compatability;
    }

    public static boolean processOptions(String[] arguments) {
        String msg = Messages.getString("SQLCliOptions.18");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arguments));
        int index = 0;
        for (index = 0; index < arguments.length; ++index) {
            int skip = SQLCliOptions.processOption(arguments, index);
            if (!(skip != -1 || !arguments[index].startsWith("-") && (!arguments[index].startsWith("/") || arguments[index].trim().equals("/") || arguments[index].trim().startsWith("/") && arguments[index].trim().contains(AT)))) {
                SQLCliOptions.setBadOption(MessageFormat.format(msg, arguments[index]));
            }
            for (int i = 0; i < skip && list.size() > 0; ++i) {
                list.remove(0);
            }
            if (skip <= 1) continue;
            index = index + skip - 1;
        }
        if (!list.isEmpty() && !list.get(0).startsWith(AT)) {
            SQLCliOptions.setConnectString(list.get(0));
            boolean usedtwo = false;
            if (list.size() >= 2) {
                String[] two;
                String both = list.get(1).toLowerCase(Locale.US).trim().replaceAll("\\s+", " ");
                if (list.size() >= 3 && both.equals(AS) && list.get(2) != null) {
                    for (String role : ASROLES) {
                        if (!list.get(2).trim().equalsIgnoreCase(role)) continue;
                        both = both + " " + list.get(2).trim();
                        usedtwo = true;
                    }
                }
                String theRole = null;
                if (both.toLowerCase(Locale.US).startsWith("as ") && (two = both.split(" ")).length == 2) {
                    theRole = two[1];
                }
                if (theRole != null) {
                    for (String role : ASROLES) {
                        if (!theRole.equalsIgnoreCase(role)) continue;
                        SQLCliOptions.setAsRole(theRole);
                    }
                    if (theRole.toLowerCase(Locale.US).contains(SYSBACKUP)) {
                        SQLCliOptions.setAsSysBackup(true);
                    }
                }
            }
            list.remove(0);
            if (SQLCliOptions.getAsRole() != null && !SQLCliOptions.getAsRole().equals("")) {
                list.remove(0);
                if (usedtwo) {
                    list.remove(0);
                }
            }
        }
        if (!list.isEmpty() && list.get(0).toLowerCase().startsWith(EDITION)) {
            SQLCliOptions.setEdition(list);
        }
        if (!list.isEmpty()) {
            if (list.get(0).startsWith(AT) && list.get(0).length() > 1) {
                SQLCliOptions.setFileName(list.get(0));
                list.remove(0);
            } else if (list.get(0).startsWith(AT) && list.get(0).length() == 1) {
                list.remove(0);
                if (!list.isEmpty()) {
                    SQLCliOptions.setFileName(list.get(0));
                    list.remove(0);
                }
            } else {
                msg = Messages.getString("SQLCliOptions.24");
                SQLCliOptions.setBadOption(MessageFormat.format(msg, list.get(0)));
                list.remove(0);
            }
        }
        if (!list.isEmpty()) {
            SQLCliOptions.setFileArguments(list);
        }
        if (s_compatability != null && options.contains(NOLOGINTIME)) {
            options.remove(NOLOGINTIME);
        }
        return true;
    }

    private static void setEdition(ArrayList<String> list) {
        if (list.get(0).indexOf("=") != -1) {
            edition = list.get(0).split("=")[1];
            list.remove(0);
        } else if (list.size() > 1 && list.get(1).indexOf("=") != 1) {
            edition = list.get(1).substring(1);
            list.remove(0);
            list.remove(0);
        } else {
            if (list.size() > 2 && list.get(1).equals("=")) {
                edition = list.get(2);
            }
            list.remove(0);
            list.remove(0);
            list.remove(0);
        }
    }

    public static void main(String[] args) {
        String argsString = "-V -SILENT -oci -nologinfile \"repo/repo@orcl as sysdba\"";
        String[] arg = SQLCliOptions.argsProcess(argsString);
        if (!SQLCliOptions.processOptions(arg)) {
            // empty if block
        }
        SQLCliOptions.printStuff();
        options.removeAll(options);
        SQLCliOptions.setFileName(null);
        SQLCliOptions.getFileArguments().removeAll(SQLCliOptions.getFileArguments());
        SQLCliOptions.setAsRole("");
        argsString = "-oci -nologinfile repo@orcl @file one two three";
        arg = SQLCliOptions.argsProcess(argsString);
        SQLCliOptions.processOptions(arg);
        SQLCliOptions.printStuff();
        options.removeAll(options);
        SQLCliOptions.setFileName(null);
        SQLCliOptions.getFileArguments().removeAll(SQLCliOptions.getFileArguments());
        SQLCliOptions.setAsRole("");
        argsString = "repo/repo@localhost:1521/orcl @t.sql";
        arg = SQLCliOptions.argsProcess(argsString);
        SQLCliOptions.processOptions(arg);
        SQLCliOptions.printStuff();
        options.removeAll(options);
        SQLCliOptions.setFileName(null);
        SQLCliOptions.getFileArguments().removeAll(SQLCliOptions.getFileArguments());
        SQLCliOptions.setAsRole("");
        argsString = "repo/repo@localhost:1521/orcl fakeit.sql";
        arg = SQLCliOptions.argsProcess(argsString);
        SQLCliOptions.processOptions(arg);
        SQLCliOptions.printStuff();
    }

    public static void printStuff() {
        Iterator<String> it = options.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.println("ConnectString:" + SQLCliOptions.getConnectString());
        System.out.println("sysdba:" + (SQLCliOptions.getAsRole() != null && SQLCliOptions.getAsRole().equalsIgnoreCase("sysdba") ? "true" : "false"));
        System.out.println("Filename:" + SQLCliOptions.getFileName());
        System.out.println("Filename args:");
        it = SQLCliOptions.getFileArguments().iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    private static String[] argsProcess(String stringArray) {
        StringTokenizer st = new StringTokenizer(stringArray);
        String[] array = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreElements()) {
            array[index] = st.nextToken();
            ++index;
        }
        return array;
    }

    public static String getAsRole() {
        return asRole;
    }

    public static boolean isAsSysBackup() {
        return assysbackup;
    }

    public static void setAsRole(String role) {
        asRole = role;
    }

    public static void setAsSysBackup(boolean amISysBackup) {
        assysbackup = amISysBackup;
    }

    public static ScriptRunnerContext populateContextWithOptions(ScriptRunnerContext context) {
        if (options.contains(NOLOGINTIME)) {
            context.putProperty("sqlcl.last.login.time", false);
        }
        if (options.contains(OCI)) {
            context.putProperty("DBConfig.USE_THICK_DRIVER", true);
        }
        if (options.contains(THIN)) {
            context.putProperty("DBConfig.USE_THICK_DRIVER", false);
        }
        if (options.contains(NOLOGINFILE)) {
            context.putProperty("DBConfig.GLOGIN", false);
        }
        if (options.contains(LOGGING)) {
            context.putProperty("SqlCli.optlflag", true);
        }
        if (options.contains(NOLOG)) {
            context.putProperty("script.runner.sqlplus.nolog", true);
        }
        if (options.contains(R1)) {
            context.setRestrictedLevel(RunnerRestrictedLevel.Level.R1);
        }
        if (options.contains(R2)) {
            context.setRestrictedLevel(RunnerRestrictedLevel.Level.R2);
        }
        if (options.contains(R3)) {
            context.setRestrictedLevel(RunnerRestrictedLevel.Level.R3);
        }
        if (options.contains(R4)) {
            context.setRestrictedLevel(RunnerRestrictedLevel.Level.R4);
        }
        if (options.contains(SILENT) || options.contains(S)) {
            context.putProperty("script.runner.sqlplus.silent", true);
        }
        if (options.contains(NOHISTORY)) {
            context.putProperty("sqlcl.batch.nohistory", Boolean.TRUE);
        }
        if (options.contains(XHIDEBANNERS)) {
            context.putProperty("script.runner.sqlcl.optionx", true);
        }
        if (options.contains(COMPATIBILITY)) {
            context.putProperty("script.runner.sqlcl.optionc", true);
            context.putProperty("script.runner.set_sqlpluscompat", s_compatability);
        }
        if (options.contains(LOGON)) {
            context.putProperty("script.runner.sqlplus.logon", true);
        }
        if (JDBCHelper.doesOHJDBCExist()) {
            context.putProperty("DBConfig.USE_THICK_DRIVER", true);
        }
        SQLCliOptions.processProxy(context);
        SQLCliOptions.processNLSLANG(context);
        SQLCliOptions.processSQLcliDefaults(context);
        return context;
    }

    private static void processSQLcliDefaults(ScriptRunnerContext context) {
        String[] parts = "set sqlformat ansiconsole".split(" ");
        context.putProperty("sql.format", "ansiconsole");
        context.putProperty("sql.format.full", parts);
    }

    private static void processNLSLANG(ScriptRunnerContext context) {
        if (NLSLANGParser.isNLSLangSet()) {
            if (NLSLANGParser.isNLSLangValid()) {
                context.putProperty(NLS_LANG, Boolean.TRUE);
            } else {
                context.putProperty(NLS_LANG, Boolean.FALSE);
                Logger.info(SQLCliOptions.class, "NLS_LANG is set, but not valid. Ignoring.\n");
            }
        }
    }

    private static ScriptRunnerContext processProxy(ScriptRunnerContext context) {
        String value;
        Map<String, String> a = System.getenv();
        if (System.getenv("HTTP_PROXY") != null || System.getenv("http_proxy") != null) {
            value = System.getenv("HTTP_PROXY");
            if (value != null) {
                SQLCliOptions.processValue(value, context);
            } else {
                value = System.getenv("http_proxy");
                if (value != null) {
                    SQLCliOptions.processValue(value, context);
                }
            }
        }
        if (System.getenv("HTTPS_PROXY") != null || System.getenv("https_proxy") != null) {
            value = System.getenv("HTTPS_PROXY");
            if (value != null) {
                SQLCliOptions.processValue(value, context);
            } else {
                value = System.getenv("https_proxy");
                if (value != null) {
                    SQLCliOptions.processValue(value, context);
                }
            }
        }
        return context;
    }

    private static void processValue(String value, ScriptRunnerContext context) {
        if ((value = value.replaceFirst("http://|https://", "")).split(":").length == 2) {
            context.putProperty("script.runner.hhtp.proxy", true);
            context.putProperty("script.runner.hhtp.proxy.host", value.split(":")[0]);
            context.putProperty("script.runner.hhtp.proxy.port", value.split(":")[1].split("/")[0]);
        }
    }

    public static boolean isOptionUsed(String option) {
        return options.contains(option);
    }

    public static Properties getProperties() {
        return properties;
    }

    public static boolean isBadOption() {
        return badOption != null;
    }

    public static String getBadOption() {
        return badOption;
    }

    public static void setBadOption(String badOption) {
        SQLCliOptions.badOption = badOption;
    }

    private static boolean containsFile(String inFile) {
        String stub;
        boolean retVal = false;
        if (inFile.indexOf(":") > 1 && (stub = inFile.substring(0, inFile.indexOf(":"))).endsWith("file") && stub.indexOf("/") == -1 && stub.indexOf("\\") == -1) {
            retVal = true;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean haveIBytesRaw(String base) {
        if (!SQLCliOptions.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (SQLCliOptions.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            if (base.indexOf("\\") != -1) {
                base.replace("/", "\\");
                c = new URL(base).openConnection();
                is = c.getInputStream();
                if (is.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean haveIBytes(String base) {
        if (!SQLCliOptions.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (SQLCliOptions.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            if ((is = (c = new URL(base.replaceAll("\\\\", "/")).openConnection()).getInputStream()).read() != -1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean startsWithHttpOrFtp(String base) {
        if (base == null) {
            return false;
        }
        String lower = base.toLowerCase();
        return lower.startsWith("http://") || lower.startsWith("http:\\\\") || lower.startsWith("https://") || lower.startsWith("https:\\\\") || SQLCliOptions.containsFile(lower) || lower.startsWith("ftp:\\\\") || lower.startsWith("ftp://");
    }

    public static String getEdition() {
        return edition;
    }

    public static void setEdition(String edition) {
        SQLCliOptions.edition = edition;
    }

    static {
        variables = new ArrayList();
        asRole = "";
        assysbackup = false;
        NLS_LANG = null;
        realOption = new String[]{SSHHOST, SSHKEY, OCI, THIN, NOLOGINFILE, NOLOG, NOLOG1, NOLOG2, VERSION, V, SILENT, S, RESTRICT, R, LOGGING, LOGON, L, HELP, H, COMPATIBILITY, XHIDEBANNERS};
        finishedOptions = false;
    }
}

