/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.newscriptrunner.FallbackParserProvider;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;

public class ParseUtil {
    public static List<LexerToken> tokenize(String buffer) {
        List<LexerToken> tokens;
        if (buffer.trim().startsWith("script")) {
            tokens = Lexer.parse(buffer, true, 0);
        } else {
            int singleQs = 0;
            int doubleQs = 0;
            int len = buffer.length();
            block4: for (int c = 0; c < len; ++c) {
                char chr = buffer.charAt(c);
                switch (chr) {
                    case '\'': {
                        ++singleQs;
                        continue block4;
                    }
                    case '\"': {
                        ++doubleQs;
                    }
                }
            }
            if (singleQs % 2 != 0) {
                buffer = buffer + "'";
            } else if (doubleQs % 2 != 0) {
                buffer = buffer + "\"";
            }
            tokens = Lexer.parse(buffer, true);
            if (singleQs % 2 != 0 || doubleQs % 2 != 0) {
                LexerToken lastToken = tokens.get(tokens.size() - 1);
                --lastToken.end;
                lastToken.content = lastToken.content.substring(0, lastToken.content.length() - 1);
                lastToken.type = Token.INCOMPLETE;
            }
        }
        return tokens;
    }

    public static List<ISQLCommand> parse(String buffer) {
        ArrayList<ISQLCommand> commands = new ArrayList<ISQLCommand>();
        FallbackParserProvider parserProvider = new FallbackParserProvider(null, new StringReader(buffer));
        while (parserProvider.hasNext()) {
            commands.add((ISQLCommand)parserProvider.next());
        }
        return commands;
    }

    public static ISQLCommand parseLast(String buffer) {
        ISQLCommand command = null;
        FallbackParserProvider parserProvider = new FallbackParserProvider(null, new StringReader(buffer));
        while (parserProvider.hasNext()) {
            command = (ISQLCommand)parserProvider.next();
        }
        return command;
    }
}

