/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security;

import java.util.Collection;
import oracle.dbtools.security.PasswordValidatorException;
import oracle.dbtools.security.Resources;

public class PasswordValidator {
    public static final PasswordValidator ADWC_VALIDATOR = new Builder().minLowerCase(1).minUpperCase(1).minDigits(1).minLength(12).maxLength(60).build();
    public static final PasswordValidator DEFAULT_VALIDATOR = new Builder().maxLength(30).build();
    private final int minLowerCase;
    private final int minUpperCase;
    private final int minLetters;
    private final int minSymbols;
    private final int minDigits;
    private final String allowedSymbols;
    private final int minLength;
    private final int maxLength;

    static void validateAgainstChecklist(char[] password, Collection<String> checkList) throws PasswordValidatorException {
        int len = password.length;
        for (String seq : checkList) {
            char[] seqChars = seq.toLowerCase().toCharArray();
            block1: for (int i = 0; i < len && len - i >= seqChars.length; ++i) {
                for (int j = 0; j < seqChars.length; ++j) {
                    char candidate = Character.toLowerCase(password[i + j]);
                    if (seqChars[j] != candidate) continue block1;
                }
                throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_SEQUENCE", seq));
            }
        }
    }

    private PasswordValidator(int minLowerCase, int minUpperCase, int minLetters, int minSymbols, String allowedSymbols, int minDigits, int minLength, int maxLength) {
        this.minLowerCase = minLowerCase;
        this.minUpperCase = minUpperCase;
        this.minLetters = minLetters;
        this.minSymbols = minSymbols;
        this.allowedSymbols = allowedSymbols;
        this.minDigits = minDigits;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public int getMinimumLowerCaseCount() {
        return this.minLowerCase;
    }

    public int getMinimumUpperCaseCount() {
        return this.minUpperCase;
    }

    public int getMinimumLetterCount() {
        return this.minLetters;
    }

    public int getMinimumSpecialCount() {
        return this.minSymbols;
    }

    public int getMinimumDigitCount() {
        return this.minDigits;
    }

    public String getAllowedSpecialCharacters() {
        return this.allowedSymbols;
    }

    public int getMinimumLength() {
        return this.minLength;
    }

    public int getMaximumLength() {
        return this.maxLength;
    }

    public void validate(char[] password, Collection<String> checkList) throws PasswordValidatorException {
        int len = password.length;
        if (len < this.minLength) {
            throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_SHORT", this.minLength));
        }
        if (this.maxLength > 0 && len > this.maxLength) {
            throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_LONG", this.maxLength));
        }
        int lower = 0;
        int upper = 0;
        int chars = 0;
        int symbols = 0;
        int numbers = 0;
        for (char curr : password) {
            if (curr >= 'A' && curr <= 'Z') {
                ++upper;
                ++chars;
                continue;
            }
            if (curr >= 'a' && curr <= 'z') {
                ++lower;
                ++chars;
                continue;
            }
            if (curr >= '0' && curr <= '9') {
                ++numbers;
                continue;
            }
            if (this.allowedSymbols == null) {
                if (Character.isISOControl(curr)) {
                    throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_INVALID_CHARACTER", String.format("0x%04X", curr)));
                }
                if (curr == '\"') {
                    throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_INVALID_CHARACTER", Character.valueOf(curr)));
                }
                ++symbols;
                continue;
            }
            boolean valid = false;
            if (this.allowedSymbols.indexOf(curr) >= 0) {
                ++symbols;
                valid = true;
            }
            if (valid) continue;
            throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_INVALID_CHARACTER", Character.valueOf(curr)));
        }
        if (lower < this.minLowerCase) {
            throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_LOWERCASE", this.minLowerCase));
        }
        if (upper < this.minUpperCase) {
            throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_UPPERCASE", this.minUpperCase));
        }
        if (chars < this.minLetters) {
            throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_LETTER", this.minLetters));
        }
        if (numbers < this.minDigits) {
            throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_DIGIT", this.minDigits));
        }
        if (symbols < this.minSymbols) {
            throw new PasswordValidatorException(Resources.format("MSG_ERROR_PASSWORD_SYMBOL", this.minSymbols));
        }
        PasswordValidator.validateAgainstChecklist(password, checkList);
    }

    public static class Builder {
        private int minLowerCase;
        private int minUpperCase;
        private int minLetters;
        private int minSymbols;
        private int minDigits;
        private String allowedSymbols;
        private int minLength = 8;
        private int maxLength = 30;

        public Builder minLowerCase(int min) {
            this.minLowerCase = min;
            return this;
        }

        public Builder minUpperCase(int min) {
            this.minUpperCase = min;
            return this;
        }

        public Builder minLetters(int min) {
            this.minLetters = min;
            return this;
        }

        public Builder minSpecials(int min) {
            this.minSymbols = min;
            return this;
        }

        public Builder minDigits(int min) {
            this.minDigits = min;
            return this;
        }

        public Builder allowedSpecials(String symbols) {
            this.allowedSymbols = symbols == null ? null : symbols;
            return this;
        }

        public Builder minLength(int min) {
            this.minLength = min;
            return this;
        }

        public Builder maxLength(int max) {
            this.maxLength = max;
            return this;
        }

        public PasswordValidator build() {
            return new PasswordValidator(this.minLowerCase, this.minUpperCase, this.minLetters, this.minSymbols, this.allowedSymbols, this.minDigits, this.minLength, this.maxLength);
        }
    }
}

