/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.swagger;

import java.util.List;
import oracle.dbtools.rest.generators.RestCodeGenResults;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;

public class RestSwaggerGen {
    private final StringBuilder call = new StringBuilder();

    public String getContents() {
        return this.call.toString();
    }

    public void visitModuleAndPrivileges(RestModule module) {
        this.call.append("BEGIN");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.visit(module);
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("  DECLARE");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    l_modules  owa.vc_arr;");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    l_roles    owa.vc_arr;");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    l_patterns owa.vc_arr;");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    l_priv_id  number;");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    l_role_id  number;");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("  BEGIN");
        int roleCounter = 1;
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    ORDS.CREATE_ROLE(p_role_name => '" + module.getName() + "_role');");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    l_roles(" + roleCounter++ + ")   := '" + module.getName() + "_role';");
        this.call.append(RestCodeGenResults.NEWLINE);
        int moduleCounter = 1;
        this.call.append("    l_modules(" + moduleCounter++ + ") := '" + module.getName() + "';");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    ORDS.DEFINE_PRIVILEGE(");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("      p_privilege_name => '" + module.getName() + "_priv',");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("      p_label          => '" + module.getName() + "',");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("      p_description    => '" + module.getName() + "',");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("      p_roles          => l_roles,");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("      p_modules        => l_modules,");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("      p_patterns       => l_patterns,");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("      p_comments       => '" + module.getName() + "');");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    END;");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("  COMMIT;");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("END;");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("/");
    }

    public void visit(RestModule module) {
        this.call.append("  ORDS.DEFINE_MODULE(");
        if (module.getName() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_module_name    => '" + module.getName() + "' ,");
        }
        if (module.getURIPrefix() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_base_path      => '" + module.getURIPrefix() + "' ,");
        }
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    p_items_per_page => 25 ,");
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    p_status         => 'PUBLISHED' ,");
        if (module.getComments() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_comments       => '" + module.getComments() + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        this.call.append(RestCodeGenResults.NEWLINE);
        for (RestTemplate template : module.getTemplates()) {
            this.visit(template, module);
        }
    }

    public void visit(RestTemplate template, RestModule module) {
        this.call.append("  ORDS.DEFINE_TEMPLATE(");
        if (module.getName() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_module_name => '" + module.getName() + "' ,");
        }
        if (template.getURIPattern() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_pattern     => '" + template.getURIPattern() + "' ,");
        }
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    p_priority    => " + template.getPriority() + " ,");
        if (template.getEntityTag() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_etag_type   => 'HASH' ,");
        }
        if (template.getEntityTagQuery() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_etag_query  => '" + template.getEntityTagQuery() + "' ,");
        } else {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_etag_query  => NULL,");
        }
        if (template.getComments() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_comments    => '" + template.getComments() + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        this.call.append(RestCodeGenResults.NEWLINE);
        for (RestResourceHandler.HTTP_METHOD_TYPE method : template.getResourceHandlers().keySet()) {
            this.visit(template.getResourceHandlers().get((Object)method), module, template);
        }
    }

    public void visit(RestResourceHandler handler, RestModule module, RestTemplate template) {
        this.call.append("  ORDS.DEFINE_HANDLER(");
        if (module.getName() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_module_name    => '" + module.getName() + "' ,");
        }
        if (template.getURIPattern() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_pattern        => '" + template.getURIPattern() + "' ,");
        }
        if (handler.getSourceType() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_source_type    => '" + (Object)((Object)handler.getSourceType()) + "' ,");
        } else if ("GET".equalsIgnoreCase(handler.getMethodType().getType())) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_source_type    => 'json/collection',");
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    /*p_source_type  => 'json/item',*/");
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    /*p_source_type  => 'plsql/block',*/");
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    /*p_source_type  => 'resource/lob',*/");
        } else {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_source_type    => 'plsql/block',");
        }
        if (handler.getMethodType() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_method         => '" + (Object)((Object)handler.getMethodType()) + "' ,");
        }
        if (handler.getMimeTypes() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_mimes_allowed  => '" + this.listToCSV(handler.getMimeTypes()) + "' ,");
        }
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    p_items_per_page => 25 ,");
        if (handler.getComments() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_comments       => '" + handler.getComments() + "',");
        }
        this.call.append(RestCodeGenResults.NEWLINE);
        this.call.append("    p_source         => ");
        this.call.append("'" + handler.getSQL() + "'");
        this.call.append(",");
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        this.call.append(RestCodeGenResults.NEWLINE);
        for (RestHandlerParameter param : handler.getParameters()) {
            this.visit(param, module, template, handler);
        }
    }

    public void visit(RestHandlerParameter parameter, RestModule module, RestTemplate template, RestResourceHandler handler) {
        if (parameter.getSourceType() == null) {
            this.call.append("  /* The parameter ");
            this.call.append(parameter.getBindVariable());
            this.call.append(" can be refereneced in the handler's source as a bind");
            this.call.append(" without a definition in ORDS*/");
            return;
        }
        this.call.append("  ORDS.DEFINE_PARAMETER(");
        if (module.getName() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_module_name        => '" + module.getName() + "' ,");
        }
        if (template.getURIPattern() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_pattern            => '" + template.getURIPattern() + "' ,");
        }
        if (handler.getMethodType() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_method             => '" + (Object)((Object)handler.getMethodType()) + "' ,");
        }
        if (parameter.getName() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_name               => '" + parameter.getName() + "' ,");
        }
        if (parameter.getBindVariable() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_bind_variable_name => '" + parameter.getBindVariable() + "' ,");
        }
        if (parameter.getSourceType() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_source_type        => '" + parameter.getSourceType().getType().toUpperCase() + "',");
        }
        if (parameter.getAccessMethod() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_access_method      => '" + (Object)((Object)parameter.getAccessMethod()) + "',");
        }
        if (parameter.getSourceType() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_param_type         => '" + parameter.getDataType().getType().toUpperCase() + "',");
        }
        if (parameter.getComments() != null) {
            this.call.append(RestCodeGenResults.NEWLINE);
            this.call.append("    p_comments           => '" + parameter.getComments() + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        this.call.append(RestCodeGenResults.NEWLINE);
    }

    private String listToCSV(List<String> items) {
        StringBuilder builder = new StringBuilder();
        for (String item : items) {
            builder.append(item);
            if (items.size() - 1 <= items.indexOf(item)) continue;
            builder.append(",");
        }
        return builder.toString();
    }
}

