/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.swagger;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.dbtools.rest.RestMessages;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.swagger.RestParser;

public abstract class ParserBase
implements RestParser {
    @Override
    public RestModule read(JsonObject root) {
        RestModule module = null;
        if (this.isValidVersion(root)) {
            module = new RestModule();
            module.setName(this.getModuleName(root));
            module.setURIPrefix(this.getModuleBasePath(root));
            module.setTemplates(this.getTemplates(root));
            module.setPublished(true);
            module.setPaginationSize(25L);
            module.setComments(this.getModuleComments(root));
        }
        return module;
    }

    protected abstract String getModuleBasePath(JsonObject var1);

    protected String getModuleComments(JsonObject root) {
        StringBuilder comments = new StringBuilder();
        JsonObject info = this.getOptionalProperty("info", root);
        if (info != null && info.containsKey((Object)"title")) {
            String title = info.getString("title");
            comments.append(title);
        }
        return comments.toString();
    }

    protected String getModuleName(JsonObject node) {
        String basePath = this.getModuleBasePath(node);
        if (basePath.startsWith("/") && basePath.length() > 1) {
            basePath = basePath.substring(1);
        }
        if (basePath.endsWith("/") && basePath.length() > 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath.replace("/", "_");
    }

    protected List<String> getConsumes(JsonObject nodeObject) {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        JsonArray mimeArray = nodeObject.getJsonArray("consumes");
        if (mimeArray != null) {
            for (JsonValue item : mimeArray.getValuesAs(JsonString.class)) {
                String mimeType = item.toString();
                mimeTypes.add(mimeType);
            }
        }
        return mimeTypes;
    }

    protected List<RestTemplate> getTemplates(JsonObject rootNode) {
        ArrayList<RestTemplate> templates = new ArrayList<RestTemplate>();
        JsonObject pathsObject = rootNode.getJsonObject("paths");
        for (String property : pathsObject.keySet()) {
            JsonObject templateObject = pathsObject.getJsonObject(property);
            RestTemplate template = new RestTemplate();
            template.setURIPattern(this.transformURIParameters(property));
            template.setPriority(1);
            template.setResourceHandlers(this.getHandlers(templateObject));
            template.setEntityTag("HASH");
            template.setComments("");
            templates.add(template);
        }
        return templates;
    }

    protected String transformURIParameters(String input) {
        StringBuilder newURI = new StringBuilder();
        boolean inParameter = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!inParameter && c == '{') {
                newURI.append(':');
                continue;
            }
            if (c == '}') {
                inParameter = false;
                continue;
            }
            if (inParameter && c == '{') {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format("SWAGGER_ILLEGAL_CHARACTER_PARAM_URI", input));
                continue;
            }
            newURI.append(c);
        }
        return newURI.toString();
    }

    protected TreeMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> getHandlers(JsonObject templateObject) {
        TreeMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> handlers = new TreeMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler>();
        JsonObject get = this.getObjectAbsoluteCase(templateObject, "get");
        JsonObject post = this.getObjectAbsoluteCase(templateObject, "post");
        JsonObject put = this.getObjectAbsoluteCase(templateObject, "put");
        JsonObject delete = this.getObjectAbsoluteCase(templateObject, "delete");
        if (get != null) {
            handlers.put(RestResourceHandler.HTTP_METHOD_TYPE.GET, this.createHandlerObject(get, "GET"));
        }
        if (post != null) {
            handlers.put(RestResourceHandler.HTTP_METHOD_TYPE.POST, this.createHandlerObject(post, "POST"));
        }
        if (put != null) {
            handlers.put(RestResourceHandler.HTTP_METHOD_TYPE.PUT, this.createHandlerObject(put, "PUT"));
        }
        if (delete != null) {
            handlers.put(RestResourceHandler.HTTP_METHOD_TYPE.DELETE, this.createHandlerObject(delete, "DELETE"));
        }
        return handlers;
    }

    protected RestResourceHandler createHandlerObject(JsonObject jsonObject, String method) {
        boolean shouldAddConsumes;
        RestResourceHandler h = new RestResourceHandler();
        h.setMethodType(RestResourceHandler.HTTP_METHOD_TYPE.valueOf(method));
        h.setComments("");
        h.setSQL(this.getGenericSource(method));
        h.setPaginationSize(25L);
        h.setComments(this.getHandlerComments(jsonObject));
        List<String> mimesConsumed = this.getConsumes(jsonObject);
        boolean bl = shouldAddConsumes = "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method);
        if (mimesConsumed.size() > 0 && shouldAddConsumes) {
            h.setMimeTypes(mimesConsumed);
        }
        h.setParameters(this.getParameters(jsonObject, method));
        return h;
    }

    protected String getHandlerComments(JsonObject root) {
        StringBuilder comments = new StringBuilder("");
        if (root.containsKey((Object)"description")) {
            String title = root.getString("description");
            comments.append(title);
        }
        return comments.toString();
    }

    protected List<RestHandlerParameter> getParameters(JsonObject object, String method) {
        ArrayList<RestHandlerParameter> parameters = new ArrayList<RestHandlerParameter>();
        JsonArray array = object.getJsonArray("parameters");
        if (array != null) {
            for (JsonObject jsonParameter : array.getValuesAs(JsonObject.class)) {
                String name = this.getOptionalStringProperty("name", jsonParameter);
                String in = this.getOptionalStringProperty("in", jsonParameter);
                String type = this.getOptionalStringProperty("type", jsonParameter);
                String format = this.getOptionalStringProperty("format", jsonParameter);
                JsonObject schema = this.getOptionalProperty("schema", jsonParameter);
                if (name == null || "".equals(name)) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format("SWAGGER_PROPERTY_EMPTY", "name", name));
                }
                if (in == null || "".equals(in)) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format("SWAGGER_PROPERTY_EMPTY", "in", name));
                }
                RestHandlerParameter param = new RestHandlerParameter();
                param.setName(name);
                param.setBindVariable(name);
                param.setDataType(this.transformSwaggerType(type, format));
                param.setComments("");
                String sourceType = this.transformSwaggerIN(in);
                if ("implicit".equals(sourceType)) {
                    param.setComments("implicit");
                } else {
                    param.setSourceType(sourceType);
                    param.setAccessMethod("IN");
                }
                if (schema != null) continue;
                parameters.add(param);
            }
        }
        this.addDefaultOUTParameters(parameters, method);
        return parameters;
    }

    protected void addDefaultOUTParameters(List<RestHandlerParameter> parameterList, String method) {
        if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
            RestHandlerParameter forwardLocation = new RestHandlerParameter();
            forwardLocation.setAccessMethod(method);
            forwardLocation.setName("X-ORDS-FORWARD");
            forwardLocation.setBindVariable("forward_location");
            forwardLocation.setSourceType("HEADER");
            forwardLocation.setDataType("STRING");
            forwardLocation.setAccessMethod("OUT");
            forwardLocation.setComments("");
            parameterList.add(forwardLocation);
            RestHandlerParameter statusCode = new RestHandlerParameter();
            statusCode.setAccessMethod(method);
            statusCode.setName("X-ORDS-STATUS-CODE");
            statusCode.setBindVariable("status");
            statusCode.setSourceType(RestHandlerParameter.SOURCE_TYPE.HTTP_HEADER);
            statusCode.setDataType(RestHandlerParameter.DATA_TYPE.INT);
            statusCode.setAccessMethod("OUT");
            statusCode.setComments("");
            parameterList.add(statusCode);
        }
    }

    protected JsonObject getOptionalProperty(String propertyName, JsonObject object) {
        JsonObject result = null;
        if (object.containsKey((Object)propertyName)) {
            result = object.getJsonObject(propertyName);
        }
        return result;
    }

    protected String getOptionalStringProperty(String propertyName, JsonObject object) {
        String result = null;
        if (object.containsKey((Object)propertyName)) {
            result = object.getString(propertyName);
        }
        return result;
    }

    protected String transformSwaggerIN(String swaggerIn) {
        if ("path".equalsIgnoreCase(swaggerIn)) {
            return "uri";
        }
        if ("header".equalsIgnoreCase(swaggerIn)) {
            return "header";
        }
        return "implicit";
    }

    protected String transformSwaggerType(String swaggerType, String format) {
        if ("number".equalsIgnoreCase(swaggerType) || "double".equalsIgnoreCase(swaggerType)) {
            return "Double";
        }
        if ("integer".equalsIgnoreCase(swaggerType) || "long".equalsIgnoreCase(swaggerType)) {
            return "INTEGER";
        }
        if ("boolean".equalsIgnoreCase(swaggerType)) {
            return "BOOLEAN";
        }
        if ("string".equalsIgnoreCase(swaggerType)) {
            if (format == null || "".equals(format)) {
                return "STRING";
            }
            if ("date".equalsIgnoreCase(format) || "date-time".equalsIgnoreCase(format)) {
                return "TIMESTAMP";
            }
            return "STRING";
        }
        return "STRING";
    }

    protected String getGenericSource(String method) {
        String result = "select ''example'' from dual";
        if ("DELETE".equalsIgnoreCase(method)) {
            result = "begin /*source goes here*/ HTP.P(''example''); end;";
        } else if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
            result = "\ndeclare\n next_id integer;\nbegin\n select (max(id)+1) into next_id from my_table;\n insert into my_table (id, val) values (next_id, ''val'');\n commit;\n  :forward_location := ''./'' || next_id;\n  :status := 201;\nend;";
        }
        return result;
    }

    protected JsonObject getObjectAbsoluteCase(JsonObject object, String propertyName) {
        JsonObject result = null;
        result = object.getJsonObject(propertyName.toLowerCase());
        if (result == null) {
            result = object.getJsonObject(propertyName.toUpperCase());
        }
        return result;
    }

    protected abstract boolean isValidVersion(JsonObject var1);
}

