/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.CharBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.objects.LargeDatum;
import oracle.dbtools.raptor.datatypes.objects.PLSQLRecord;
import oracle.dbtools.raptor.datatypes.util.ConcurrentWeakIdentityHashMap;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.ReaderInputStream;
import oracle.dbtools.raptor.utils.StringValuable;
import oracle.dbtools.raptor.utils.StringValuableObject;
import oracle.dbtools.raptor.utils.StringValueRenderer;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;

public class DataTypesUtil {
    public static final Object EMPTY = new String(new char[0]);
    public static final int DISPLAY_NONE = 0;
    public static final int DISPLAY_STRUCT_VALUE = 1;
    public static final int DISPLAY_XMLTYPE_VALUE = 2;
    public static final int DISPLAY_ALL = 3;
    public static final int BUFFER_SIZE = 2400;
    private static final List<StringValueRenderer> DYNAMIC_STRING_RENDERERS = DataTypesUtil.loadStringValueRenderers();
    private static final Map<String, TimeZone> timeZoneMap = new HashMap<String, TimeZone>(){
        {
            for (String id : TimeZone.getAvailableIDs()) {
                TimeZone tz = TimeZone.getTimeZone(id);
                this.put(id.toUpperCase(), tz);
            }
        }
    };
    private static Map<Clob, String> cachedClobs = new ConcurrentWeakIdentityHashMap<Clob, String>();
    private static Map<Object, String> cachedXMLCharacters = new ConcurrentWeakIdentityHashMap<Object, String>();
    private static Map<Object, byte[]> cachedXMLBytes = new ConcurrentWeakIdentityHashMap<Object, byte[]>();
    static Map<Integer, String> dataTypesMap = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            Field[] fields = OracleTypes.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    String name = fields[i].getName();
                    Integer value = (Integer)fields[i].get(null);
                    this.put(value, name);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    };
    static Map<String, Integer> dataTypesMap2 = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            Field[] fields = OracleTypes.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    String name = fields[i].getName();
                    Integer value = (Integer)fields[i].get(null);
                    this.put(name, value);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    };
    protected static final String _NULL_ = "NULL";

    private static List<StringValueRenderer> loadStringValueRenderers() {
        ArrayList<StringValueRenderer> renderers = new ArrayList<StringValueRenderer>();
        try {
            ClassLoader classLoader = DataTypesUtil.class.getClassLoader();
            Class<?> externalClass = classLoader.loadClass("oracle.sql.json.OracleJsonFactory");
            Class<?> internalClass = classLoader.loadClass("oracle.dbtools.raptor.datatypes.oracle.sql.JSON$StringValueRenderer");
            StringValueRenderer renderer = (StringValueRenderer)internalClass.newInstance();
            renderers.add(renderer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return renderers;
    }

    public static boolean areEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    public static boolean isEqual(Object obj1, Object obj2, Connection conn, int columType) {
        String s;
        if (DataTypesUtil.isExtendedType(obj1, columType)) {
            return ModelUtil.areEqual(obj1, obj2);
        }
        if (obj1 != null && obj2 != null && (s = DataTypesUtil.stringValue(obj1, conn, Integer.MAX_VALUE)) != null) {
            return s.equals(obj2);
        }
        return false;
    }

    public static String stringValueChecked(Object obj, Connection conn) throws SQLException, IOException {
        return DataTypesUtil.stringValueChecked(obj, conn, 4000);
    }

    public static String stringValueChecked(Object obj, Connection conn, int maxLen) throws SQLException, IOException {
        return DataTypesUtil.stringValue(obj, conn, maxLen, false);
    }

    public static String stringValue(Object obj, Connection conn) {
        return DataTypesUtil.stringValue(obj, conn, 4000);
    }

    public static String stringValue(Object obj, Connection conn, int maxLen) {
        try {
            return DataTypesUtil.stringValue(obj, conn, maxLen, true);
        }
        catch (SQLException e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (IOException e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return null;
    }

    public static String stringValue(Object obj, Connection conn, FormatType formatType) {
        try {
            return DataTypesUtil.stringValue(obj, conn, 4000, true, 3, formatType);
        }
        catch (SQLException e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (IOException e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return null;
    }

    public static String stringValue(Object obj, Connection conn, int maxLen, boolean logOnly) throws SQLException, IOException {
        return DataTypesUtil.stringValue(obj, conn, maxLen, logOnly, 3);
    }

    @Deprecated
    public static String stringValue(Object obj, Connection conn, int maxLen, boolean logOnly, boolean displayValue) throws SQLException, IOException {
        return DataTypesUtil.stringValue(obj, conn, maxLen, logOnly, displayValue, null);
    }

    @Deprecated
    public static String stringValue(Object obj, Connection conn, int maxLen, boolean logOnly, boolean displayValue, FormatType formatType) throws SQLException, IOException {
        return DataTypesUtil.stringValue(obj, conn, maxLen, logOnly, displayValue ? 3 : 0, formatType);
    }

    public static String stringValue(Object obj, Connection conn, int maxLen, boolean logOnly, int displayValue) throws SQLException, IOException {
        return DataTypesUtil.stringValue(obj, conn, maxLen, logOnly, displayValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stringValue(Object obj, Connection conn, int maxLen, boolean logOnly, int displayValue, FormatType formatType) throws SQLException, IOException {
        String nullDisplay = NLSUtils.yieldNullDisplay(conn, obj);
        if (obj == null) return nullDisplay;
        if (nullDisplay != null) {
            return nullDisplay;
        }
        String str = null;
        if (obj instanceof StringValuableObject) {
            return ((StringValuableObject)obj).stringValue(conn, maxLen, logOnly, displayValue, formatType);
        }
        if (obj instanceof StringValuable) {
            return ((StringValuable)obj).stringValue(conn, maxLen, logOnly, (displayValue & 1) != 0, formatType);
        }
        if (obj instanceof Clob) {
            String candidate = cachedClobs.get(obj);
            boolean isTemporary = false;
            if (candidate != null) {
                return candidate;
            }
            try {
                try {
                    Method m = obj.getClass().getMethod("isTemporary", new Class[0]);
                    isTemporary = (Boolean)m.invoke(obj, new Object[0]);
                }
                finally {
                    int width = 0;
                }
            }
            catch (SQLException e) {
                if (!logOnly) throw e;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                return str;
            }
            finally {
                try {
                    if (isTemporary) {
                        ((Clob)obj).free();
                    }
                }
                catch (Throwable e) {}
                if (str != null && maxLen > -1 && maxLen < str.length()) {
                    str = str.substring(0, maxLen);
                }
            }
        }
        if (obj instanceof Blob) {
            return "(BLOB)";
        }
        if (obj instanceof RAW) {
            return (String)NLSUtils.getValue(conn, obj);
        }
        if (obj instanceof BFILE) {
            String dir = ((OracleBfile)obj).getDirAlias();
            String file = ((OracleBfile)obj).getName();
            return MessageFormat.format("bfilename(''{0}'',''{1}'')", dir, file);
        }
        if (obj instanceof TIMESTAMPTZ) return (String)NLSUtils.getValue(conn, obj, formatType);
        if (obj instanceof TIMESTAMPLTZ) return (String)NLSUtils.getValue(conn, obj, formatType);
        if (obj instanceof TIMESTAMP) return (String)NLSUtils.getValue(conn, obj, formatType);
        if (obj instanceof INTERVALYM) return (String)NLSUtils.getValue(conn, obj, formatType);
        if (obj instanceof INTERVALDS) {
            return (String)NLSUtils.getValue(conn, obj, formatType);
        }
        if (obj instanceof Timestamp) {
            return (String)NLSUtils.getValue(conn, obj);
        }
        if (obj instanceof DATE) {
            try {
                return (String)NLSUtils.getValue(conn, obj, formatType);
            }
            catch (NullPointerException e) {
                DATE val = (DATE)obj;
                return DATE.toString((byte[])val.toBytes());
            }
        }
        if (obj instanceof Date) {
            return NLSUtils.format(conn, obj);
        }
        if (obj instanceof NUMBER || obj instanceof BINARY_FLOAT || obj instanceof BINARY_DOUBLE) {
            try {
                return (String)NLSUtils.getValue(conn, obj);
            }
            catch (NullPointerException e) {
                NUMBER val = (NUMBER)obj;
                try {
                    return NUMBER.toBigDecimal((byte[])val.toBytes()).toString();
                }
                catch (SQLException ee) {
                    if (!logOnly) throw ee;
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    return "??";
                }
            }
        }
        if (obj instanceof BigDecimal) {
            return (String)NLSUtils.getValue(conn, obj);
        }
        if (obj instanceof SQLXML) {
            str = "(XMLTYPE)";
            if ((displayValue & 2) == 0) return str;
            try {
                str = DataTypesUtil.stringValue((Object)DataTypesUtil.getXMLAsCharacters((SQLXML)obj), conn, maxLen, logOnly, displayValue);
                if (str == null) return str;
                if (maxLen <= -1) return str;
                if (maxLen >= str.length()) return str;
                return str.substring(0, maxLen);
            }
            catch (Exception e) {
                if (obj instanceof XMLType) return str;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            return str;
        }
        if (obj instanceof OPAQUE) {
            if ((displayValue & 2) == 0) {
                return "(OPAQUE)";
            }
            try {
                OPAQUE opaque = (OPAQUE)obj;
                str = opaque.getSQLTypeName().trim();
                if (!str.equalsIgnoreCase("SYS.XMLTYPE")) return "(OPAQUE)";
                try {
                    str = DataTypesUtil.stringValue((Object)DataTypesUtil.getXMLAsCharacters(opaque), conn, maxLen, logOnly, displayValue);
                    if (str == null) return str;
                    if (maxLen <= -1) return str;
                    if (maxLen >= str.length()) return str;
                    return str.substring(0, maxLen);
                }
                catch (Exception e) {
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    return "(XMLTYPE)";
                }
            }
            catch (SQLException e) {
                if (!logOnly) throw e;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.INFO, e.getStackTrace()[0].toString(), e);
                return str;
            }
        }
        if (obj instanceof STRUCT) {
            if ((displayValue & 1) == 0) return "[" + ((STRUCT)obj).getSQLTypeName().trim() + "]";
            return DataTypesUtil.getStruct(obj, maxLen);
        }
        if (obj instanceof ARRAY) {
            try {
                String sqlt = ((ARRAY)obj).getSQLTypeName();
                str = sqlt + "(";
                Datum[] dat = ((ARRAY)obj).getOracleArray();
                boolean first = true;
                String quote = "";
                Datum[] datumArray = dat;
                int n = datumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Datum el = datumArray[n2];
                    quote = el instanceof CHAR ? "'" : "";
                    str = str + (first ? "" : ", ") + quote + DataTypesUtil.stringValue((Object)el, conn, maxLen, logOnly, displayValue) + quote;
                    first = false;
                    ++n2;
                }
                return str + ")";
            }
            catch (SQLException e) {
                if (!logOnly) throw e;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                return str;
            }
        }
        if (obj instanceof ResultSet) {
            ResultSetFormatter formatter = new ResultSetFormatter();
            if (conn instanceof OracleConnection) {
                formatter = new SQLPLUSCmdFormatter();
            }
            StringBuffer buf = new StringBuffer();
            try {
                int rowcount = formatter.rset2sqlplus((ResultSet)obj, conn, buf);
                if (rowcount <= 8) return buf.toString();
                buf.append(MessageFormat.format("\n{0} rows selected.\n", rowcount));
                return buf.toString();
            }
            catch (IOException e) {
                if (!logOnly) throw e;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                return buf.toString();
            }
            catch (SQLException e) {
                if (!logOnly) throw e;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            return buf.toString();
        }
        if (obj instanceof PLSQLRecord) {
            str = "<";
            int i = 0;
            Iterator buf = ((List)obj).iterator();
            while (buf.hasNext()) {
                Object fld = buf.next();
                str = str + (i++ > 0 ? "," : "") + DataTypesUtil.stringValue(fld, conn, maxLen, logOnly, displayValue);
            }
            return str + ">";
        }
        if (obj instanceof DataValue) {
            try {
                return ((DataValue)obj).getStringValue(maxLen).toString();
            }
            catch (DataTypeException e) {
                if (!logOnly) throw e;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                return str;
            }
        }
        if (obj instanceof LargeDatum) {
            try {
                return ((LargeDatum)obj).getStringValue(StringType.DEFAULT, maxLen).toString();
            }
            catch (DataTypeException e) {
                if (!logOnly) throw e;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                return str;
            }
        }
        if (obj instanceof List) {
            str = "{";
            List l = (List)obj;
            int i = 0;
            List zeroThRow = (List)l.get(0);
            Iterator quote = l.iterator();
            while (quote.hasNext()) {
                Object row = quote.next();
                if (i > 0) {
                    str = str + "<";
                    int j = 0;
                    for (Object fld : (List)row) {
                        str = str + zeroThRow.get(j) + "=" + DataTypesUtil.stringValue(fld, conn, maxLen, logOnly, displayValue) + ",";
                        ++j;
                    }
                    str = str.substring(0, str.length() - 1);
                    str = str + ">,";
                }
                ++i;
            }
            return str + "}";
        }
        if (obj instanceof REF) {
            try {
                return DataTypesUtil.stringValue(((REF)obj).getValue(), conn, maxLen, logOnly, displayValue);
            }
            catch (SQLException e) {
                if (!logOnly) throw e;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                return str;
            }
        }
        if (obj instanceof byte[]) {
            return "(BINARY DATA)";
        }
        if (obj instanceof Reader) {
            StringWriter writer = new StringWriter();
            DataTypesUtil.copyData((Reader)obj, writer, maxLen);
            return writer.toString();
        }
        boolean rendered = false;
        for (StringValueRenderer renderer : DYNAMIC_STRING_RENDERERS) {
            try {
                str = renderer.stringValue(obj, conn, maxLen, false, displayValue, formatType);
            }
            catch (SQLException e) {
                if (!logOnly) throw e;
                rendered = true;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IOException e) {
                if (!logOnly) throw e;
                rendered = true;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            if (!rendered && str == null) continue;
            rendered = true;
            break;
        }
        if (rendered) return str;
        if (!(obj instanceof Datum)) return obj.toString();
        try {
            str = ((Datum)obj).stringValue();
            return str.equals("CLOB()") || str.equals("BLOB()") || str.equals("NCLOB()") ? str.replace("()", "") : str;
        }
        catch (SQLException e) {
            if (!logOnly) throw e;
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return str;
        }
    }

    private static String getStruct(Object obj, int maxLen) {
        String str = "";
        try {
            Object[] cols = ((STRUCT)obj).getAttributes();
            String type = ((STRUCT)obj).getSQLTypeName();
            StringBuilder column = new StringBuilder(type + "(");
            int lastChar = -1;
            for (int i = 0; i < cols.length && column.length() <= maxLen; ++i) {
                Object obj2 = cols[i];
                if (obj2 instanceof STRUCT) {
                    column.append(DataTypesUtil.getStruct(obj2, maxLen) + ", ");
                    continue;
                }
                if (obj2 instanceof ARRAY) {
                    String aType = ((ARRAY)obj2).getSQLTypeName();
                    Object[] values = (Object[])((ARRAY)obj2).getArray();
                    int aLength = ((ARRAY)obj2).length();
                    column.append(aType + "(");
                    for (int x = 0; x < aLength; ++x) {
                        if (values[x] instanceof STRUCT) {
                            column.append(DataTypesUtil.getStruct(values[x], maxLen) + ", ");
                            continue;
                        }
                        if (values[x] instanceof ARRAY) {
                            column.append(DataTypesUtil.getArray(values[x], maxLen) + ", ");
                            continue;
                        }
                        try {
                            BigDecimal bd = (BigDecimal)values[x];
                            column.append(bd + ", ");
                            continue;
                        }
                        catch (ClassCastException cce) {
                            column.append(values[x] + ", ");
                        }
                    }
                    lastChar = column.lastIndexOf(",");
                    if (lastChar > -1) {
                        column.deleteCharAt(lastChar);
                    }
                    if ((lastChar = column.lastIndexOf(" ")) > -1) {
                        column.deleteCharAt(lastChar);
                    }
                    column = column.append("), ");
                    continue;
                }
                if (obj2 instanceof BigDecimal) {
                    column.append(cols[i] + ", ");
                    continue;
                }
                if (cols[i] == null) {
                    column.append("NULL, ");
                    continue;
                }
                column.append("'" + cols[i] + "', ");
            }
            lastChar = column.lastIndexOf(",");
            if (lastChar > -1) {
                column.deleteCharAt(lastChar);
            }
            if ((lastChar = column.lastIndexOf(" ")) > -1) {
                column.deleteCharAt(lastChar);
            }
            column.append(")");
            str = column.toString();
        }
        catch (SQLException e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return str;
    }

    private static String getArray(Object obj, int maxLen) throws SQLException {
        String str = "";
        String sqlt = ((ARRAY)obj).getSQLTypeName();
        str = sqlt + "(";
        Datum[] dat = ((ARRAY)obj).getOracleArray();
        boolean first = true;
        String quote = "";
        for (Datum el : dat) {
            String val = "";
            if (el instanceof STRUCT) {
                str = str + (first ? "" : ", ") + quote + DataTypesUtil.getStruct(el, maxLen);
            }
            first = false;
        }
        str = str + ")";
        return str;
    }

    public static boolean isExtendedType(Object obj, int colType) {
        return obj instanceof ExtendedType || obj instanceof BFILE || obj instanceof Blob || colType == -13 || colType == 2004 || colType == 2007 || colType == 2009 || colType == 2003 || colType == -10;
    }

    public static boolean isTemporalType(Object obj, int colType) {
        return colType == 91 || colType == 93 || colType == -102 || colType == -101;
    }

    public static boolean isXMLType(Object obj) {
        try {
            return obj instanceof XMLType || obj instanceof OPAQUE && DataTypesUtil.getXMLSQLTypeName().equals(((OPAQUE)obj).getSQLTypeName());
        }
        catch (SQLException e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return false;
        }
    }

    public static boolean isJson(Object obj) {
        if (obj != null) {
            String className = obj.getClass().getName();
            return "oracle.sql.json.OracleJsonValue".equals(className) || "oracle.sql.json.OracleJsonDatum".equals(className);
        }
        return false;
    }

    public static String getXMLSQLTypeName() {
        return "SYS.XMLTYPE";
    }

    public static String getEmptyExtendedType(Object obj, int colType) {
        if (obj instanceof Blob || colType == 2004) {
            return "empty_blob()";
        }
        if (obj instanceof BFILE || colType == -13) {
            return "bfilename(' ',' ')";
        }
        return _NULL_;
    }

    public static String getJdbcTypeName(int jdbcType) {
        return dataTypesMap.get(new Integer(jdbcType));
    }

    public static Integer getJdbcTypeCode(String name) {
        return dataTypesMap2.get(name);
    }

    public static void main(String[] args) {
    }

    public static boolean canDuplicate(Object obj, int colType) {
        return !(obj instanceof STRUCT) && colType != 2002 && !(obj instanceof RAW) && colType != -4 && colType != -2 && colType != -3 && !(obj instanceof Blob) && colType != 2004 && colType != -8 && !(obj instanceof ARRAY) && colType != 2003 && colType != -13;
    }

    public static CLOB getCLOB(String data, Connection conn) throws SQLException {
        CLOB tempClob = null;
        try {
            tempClob = DataTypesUtil.getTemporaryCLOB(conn);
            tempClob.open(1);
            Writer tempClobWriter = tempClob.setCharacterStream(0L);
            tempClobWriter.write(data);
            tempClobWriter.flush();
            tempClobWriter.close();
            tempClob.close();
        }
        catch (SQLException e) {
            tempClob.freeTemporary();
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (Exception e) {
            tempClob.freeTemporary();
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return tempClob;
    }

    public static CLOB getTemporaryCLOB(Connection conn) throws SQLException {
        return CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
    }

    public static BLOB getTemporaryBLOB(Connection conn) throws SQLException {
        return BLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB getCLOB(Reader reader, Connection conn) throws SQLException, IOException {
        boolean throwing = true;
        CLOB tempClob = DataTypesUtil.getTemporaryCLOB(conn);
        try {
            tempClob.open(1);
            try {
                Writer tempClobWriter = tempClob.setCharacterStream(0L);
                try {
                    char[] buf = new char[2048];
                    int len = reader.read(buf);
                    while (len != -1) {
                        tempClobWriter.write(buf, 0, len);
                        len = reader.read(buf);
                    }
                    tempClobWriter.flush();
                    throwing = false;
                }
                finally {
                    try {
                        tempClobWriter.close();
                    }
                    catch (IOException e) {
                        if (!throwing) {
                            throwing = true;
                            throw e;
                        }
                        Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                }
            }
            finally {
                try {
                    tempClob.close();
                }
                catch (SQLException e) {
                    if (!throwing) {
                        throwing = true;
                        throw e;
                    }
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        finally {
            if (throwing) {
                try {
                    tempClob.freeTemporary();
                }
                catch (SQLException e) {
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        return tempClob;
    }

    private static byte[] hexToBytes(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte)value;
        }
        return raw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BLOB getBLOB(char[] hex, Connection conn) throws SQLException, IOException {
        boolean throwing = true;
        BLOB tempBlob = DataTypesUtil.getTemporaryBLOB(conn);
        try {
            tempBlob.open(1);
            OutputStream tempBlobWriter = tempBlob.setBinaryStream(0L);
            byte[] rawBlob = DataTypesUtil.hexToBytes(hex);
            tempBlobWriter.write(rawBlob, 0, rawBlob.length);
            tempBlobWriter.flush();
            throwing = false;
        }
        finally {
            if (throwing) {
                try {
                    tempBlob.freeTemporary();
                }
                catch (SQLException e) {
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        return tempBlob;
    }

    public static void copyData(Reader reader, Writer writer) throws IOException {
        char[] buf = new char[2048];
        int len = reader.read(buf);
        while (len != -1) {
            writer.write(buf, 0, len);
            len = reader.read(buf);
        }
    }

    public static void copyData(Reader reader, Writer writer, int maxLen) throws IOException {
        if (maxLen < 0) {
            DataTypesUtil.copyData(reader, writer);
        } else {
            int c;
            for (int written = 0; (maxLen == -1 || written < maxLen) && (c = reader.read()) != -1; ++written) {
                writer.write((char)c);
            }
        }
    }

    public static void copyData(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[2048];
        int len = in.read(buf);
        while (len != -1) {
            out.write(buf, 0, len);
            len = in.read(buf);
        }
    }

    public static Object getDuplicate(Object o, Connection conn, int colType) throws SQLException {
        if (DataTypesUtil.canDuplicate(o, colType)) {
            if (o instanceof Clob || colType == 2005) {
                if (o == null || o.equals("")) {
                    return "";
                }
                if (o instanceof Clob) {
                    return ((Clob)o).getSubString(1L, (int)((Clob)o).length());
                }
                return o;
            }
            if (o instanceof Datum) {
                try {
                    Datum datum = (Datum)o;
                    byte[] bytes = datum.getBytes();
                    Class<?> clazz = datum.getClass();
                    Constructor<?> constructor = clazz.getConstructor(bytes.getClass());
                    return constructor.newInstance(new Object[]{bytes});
                }
                catch (Exception datum) {
                    // empty catch block
                }
            }
            if (o instanceof Cloneable) {
                try {
                    Class<?> clazz = o.getClass();
                    Method cloneMethod = clazz.getMethod("clone", new Class[0]);
                    return cloneMethod.invoke(o, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return DataTypesUtil.stringValue(o, conn);
        }
        return null;
    }

    public static String stripDataTypeStringConstraints(String value) {
        String ret = value;
        if (ret != null) {
            Pattern p = Pattern.compile("[(][^()]*[)]");
            Matcher m = p.matcher(ret);
            ret = m.replaceAll(" ");
            ret = DataTypesUtil.reformatDataTypeString(ret);
        }
        return ret;
    }

    public static String reformatDataTypeString(String value) {
        String ret = value;
        if (ret != null) {
            Pattern ob = Pattern.compile("[\\s]*[(][\\s]*");
            Matcher obm = ob.matcher(ret);
            ret = obm.replaceAll("(");
            Pattern co = Pattern.compile("[\\s]*[,][\\s]*");
            Matcher com = co.matcher(ret);
            ret = com.replaceAll(",");
            Pattern cb = Pattern.compile("[\\s]*[)]");
            Matcher cbm = cb.matcher(ret);
            ret = cbm.replaceAll(") ");
            Pattern mws = Pattern.compile("[\\s]+");
            Matcher mwsm = mws.matcher(ret);
            ret = mwsm.replaceAll(" ");
            ret = ret.trim();
        }
        return ret;
    }

    public static boolean canAutoFilter(int columnSqlType) {
        switch (columnSqlType) {
            case -16: 
            case -13: 
            case -10: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2011: {
                return false;
            }
        }
        return true;
    }

    public static boolean isNull(Object value) {
        return value == null || (value instanceof CharSequence || value instanceof CHAR) && "".equals(value.toString());
    }

    public static boolean isEmpty(Object value) {
        return value == EMPTY;
    }

    public static boolean isDateOrTime(int columnSqlType) {
        switch (columnSqlType) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static DataTypeKind getDataTypeKind(int sqlType) {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return DataTypeKind.CHARACTER;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return DataTypeKind.NUMERIC;
            }
            case -102: 
            case -101: 
            case 91: 
            case 92: 
            case 93: {
                return DataTypeKind.TEMPORAL;
            }
            case -104: 
            case -103: {
                return DataTypeKind.INTERVAL;
            }
        }
        return DataTypeKind.UNKNOWN;
    }

    public static Calendar getCalendar(Connection conn, TIMESTAMPTZ tsTZ) throws SQLException {
        Calendar cal = null;
        if (tsTZ != null) {
            OraTIMESTAMPTZFormat tzFormat;
            cal = Calendar.getInstance();
            try {
                tzFormat = ((OracleNLSProvider)NLSProvider.getProvider(conn)).getOraTIMESTAMPTZFormat();
            }
            catch (ParseException pe) {
                tzFormat = null;
            }
            try {
                tzFormat.applyPattern("TZR");
                String tzID = tzFormat.format(tsTZ);
                TimeZone tz = timeZoneMap.get(tzID.toUpperCase());
                if (tz != null) {
                    cal.setTimeZone(tz);
                }
            }
            catch (ParseException tzID) {
                // empty catch block
            }
            Date date = tsTZ.dateValue(conn);
            if (date != null) {
                cal.setTime(date);
            }
        }
        return cal;
    }

    public static void freeSQLXML(SQLXML xml) throws SQLException {
        DataTypesUtil.removeCachedXMLCharacters(xml);
        xml.free();
    }

    public static void freeSQLXML(OPAQUE opq) throws SQLException {
        if (opq instanceof SQLXML) {
            DataTypesUtil.freeSQLXML((SQLXML)opq);
        } else {
            DataTypesUtil.removeCachedXMLCharacters(opq);
        }
    }

    private static String cacheXMLCharacters(Object xml, String str) {
        if (xml != null && str != null) {
            return cachedXMLCharacters.put(xml, str);
        }
        return null;
    }

    private static String getCachedXMLCharacters(Object xml) {
        if (xml != null) {
            return cachedXMLCharacters.get(xml);
        }
        return null;
    }

    private static String removeCachedXMLCharacters(Object xml) {
        if (xml != null) {
            return cachedXMLCharacters.remove(xml);
        }
        return null;
    }

    private static byte[] cacheXMLBytes(Object xml, InputStream in) throws IOException {
        if (xml != null && in != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataTypesUtil.copyData(in, out);
            out.flush();
            byte[] bytes = out.toByteArray();
            if (bytes != null) {
                return DataTypesUtil.cacheXMLBytes(xml, out.toByteArray());
            }
        }
        return null;
    }

    private static byte[] cacheXMLBytes(Object xml, byte[] bytes) throws IOException {
        if (xml != null && bytes != null) {
            return cachedXMLBytes.put(xml, bytes);
        }
        return null;
    }

    private static InputStream getCachedXMLBytes(Object xml) {
        byte[] bytes;
        if (xml != null && (bytes = cachedXMLBytes.get(xml)) != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    private static byte[] removeCachedXMLBytes(Object xml) {
        if (xml != null) {
            return cachedXMLBytes.remove(xml);
        }
        return null;
    }

    public static SQLXML castToSQLXML(Object obj) throws SQLException {
        if (obj instanceof SQLXML) {
            return (SQLXML)obj;
        }
        if (obj instanceof OPAQUE) {
            return XMLType.createXML((OPAQUE)((OPAQUE)obj));
        }
        return (SQLXML)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLXML loadSQLXML(Connection conn, URL url) throws IOException, SQLException {
        XMLType xmlType = null;
        if (url != null) {
            InputStream is = url.openStream();
            CLOB clob = DataTypesUtil.getTemporaryCLOB(conn);
            try {
                Writer clobWriter = clob.setCharacterStream(1L);
                try {
                    DataTypesUtil.getXMLAsCharacters(is, clobWriter);
                    clobWriter.flush();
                    xmlType = XMLType.createXML((Connection)conn, (CLOB)clob);
                }
                catch (XMLStreamException xe) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    is = url.openStream();
                    xmlType = XMLType.createXML((Connection)conn, (InputStream)is);
                }
                finally {
                    try {
                        clobWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    clob.close();
                }
                catch (SQLException sQLException) {}
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return xmlType;
    }

    public static String getXMLAsCharacters(SQLXML xml) throws SQLException {
        String str = DataTypesUtil.getCachedXMLCharacters(xml);
        if (str == null) {
            str = xml.getString();
            DataTypesUtil.cacheXMLCharacters(xml, str);
        }
        return str;
    }

    public static String getXMLAsCharacters(OPAQUE opq) throws SQLException {
        String str;
        if (opq instanceof SQLXML) {
            str = DataTypesUtil.getXMLAsCharacters((SQLXML)opq);
        } else {
            SQLXML sqlxml;
            str = DataTypesUtil.getCachedXMLCharacters(opq);
            if (str == null && (str = DataTypesUtil.getXMLAsCharacters(sqlxml = DataTypesUtil.castToSQLXML(opq))) != null && sqlxml != opq) {
                DataTypesUtil.removeCachedXMLCharacters(sqlxml);
                DataTypesUtil.cacheXMLCharacters(opq, str);
            }
        }
        return str;
    }

    public static String getXMLAsBytes(SQLXML xml) throws SQLException {
        String str = DataTypesUtil.getCachedXMLCharacters(xml);
        if (str == null) {
            str = xml.getString();
            DataTypesUtil.cacheXMLCharacters(xml, str);
        }
        return str;
    }

    public static String getXMLAsBytes(OPAQUE opq) throws SQLException {
        String str;
        if (opq instanceof SQLXML) {
            str = DataTypesUtil.getXMLAsCharacters((SQLXML)opq);
        } else {
            SQLXML sqlxml;
            str = DataTypesUtil.getCachedXMLCharacters(opq);
            if (str == null && (str = DataTypesUtil.getXMLAsCharacters(sqlxml = DataTypesUtil.castToSQLXML(opq))) != null && sqlxml != opq) {
                DataTypesUtil.removeCachedXMLCharacters(sqlxml);
                DataTypesUtil.cacheXMLCharacters(opq, str);
            }
        }
        return str;
    }

    public static Reader getCharacterStream(SQLXML xml) throws SQLException {
        String str = DataTypesUtil.getXMLAsCharacters(xml);
        if (str != null) {
            return new StringReader(str);
        }
        return null;
    }

    public static Reader getCharacterStream(OPAQUE opq) throws SQLException {
        String str = DataTypesUtil.getXMLAsCharacters(opq);
        if (str != null) {
            return new StringReader(str);
        }
        return null;
    }

    public static InputStream getBinaryStream(SQLXML xml) throws IOException, SQLException {
        InputStream is = DataTypesUtil.getCachedXMLBytes(xml);
        if (is == null) {
            is = xml.getBinaryStream();
            DataTypesUtil.cacheXMLBytes((Object)xml, is);
        }
        is = DataTypesUtil.getCachedXMLBytes(xml);
        return is;
    }

    public static InputStream getBinaryStream(OPAQUE opq) throws IOException, SQLException {
        InputStream is;
        if (opq instanceof SQLXML) {
            is = DataTypesUtil.getBinaryStream((SQLXML)opq);
        } else {
            SQLXML sqlxml;
            is = DataTypesUtil.getCachedXMLBytes(opq);
            if (is == null && (is = DataTypesUtil.getBinaryStream(sqlxml = DataTypesUtil.castToSQLXML(opq))) != null && sqlxml != opq) {
                DataTypesUtil.removeCachedXMLBytes(sqlxml);
                DataTypesUtil.cacheXMLBytes((Object)opq, is);
            }
        }
        return is;
    }

    public static InputStream getXMLAsBytes(Reader reader) throws XMLStreamException, IOException, UnsupportedEncodingException {
        return DataTypesUtil.getXMLAsBytes(reader, "UTF-8");
    }

    public static InputStream getXMLAsBytes(Reader reader, String defaultEncoding) throws XMLStreamException, IOException, UnsupportedEncodingException {
        BufferedReader in = new BufferedReader(reader);
        in.mark(200);
        String encoding = DataTypesUtil.getEncodingNameFromPI(in);
        if (encoding == null) {
            encoding = defaultEncoding;
        }
        in.reset();
        if (encoding != null) {
            return new ReaderInputStream(in, encoding);
        }
        return new ReaderInputStream(in);
    }

    public static boolean getXMLAsCharacters(InputStream is, Writer writer) throws XMLStreamException, IOException, UnsupportedEncodingException {
        return DataTypesUtil.getXMLAsCharacters(is, writer, -1);
    }

    public static boolean getXMLAsCharacters(InputStream is, Writer writer, int maxLen) throws XMLStreamException, IOException, UnsupportedEncodingException {
        return DataTypesUtil.getXMLAsCharacters(is, writer, maxLen, null);
    }

    public static boolean getXMLAsCharacters(InputStream is, Writer writer, String defaultEncoding) throws XMLStreamException, IOException, UnsupportedEncodingException {
        return DataTypesUtil.getXMLAsCharacters(is, writer, -1, defaultEncoding);
    }

    public static boolean getXMLAsCharacters(InputStream is, Writer writer, int maxLen, String defaultEncoding) throws XMLStreamException, IOException, UnsupportedEncodingException {
        Reader isr = DataTypesUtil.getXMLAsReader(is, defaultEncoding);
        if (isr != null) {
            DataTypesUtil.copyData(isr, writer, maxLen);
            return true;
        }
        return false;
    }

    public static Reader getXMLAsReader(URL url, String defaultEncoding) throws XMLStreamException, IOException, UnsupportedEncodingException {
        if (defaultEncoding == null) {
            defaultEncoding = "UTF-8";
        }
        return DataTypesUtil.getXMLAsReader(url.openStream(), defaultEncoding);
    }

    public static Reader getXMLAsReader(InputStream is, String defaultEncoding) throws XMLStreamException, IOException, UnsupportedEncodingException {
        byte[] bytes = new byte[200];
        int[] bomSize = new int[]{0};
        BufferedInputStream inBis = new BufferedInputStream(is);
        inBis.mark(200);
        int count = inBis.read(bytes, 0, 195);
        ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(bytes, 0, count);
        BufferedInputStream bis = new BufferedInputStream(byteArrayIS);
        bis.mark(count);
        String encoding = DataTypesUtil.detectedEncodingName(bis, bomSize);
        bis.reset();
        String PIEncoding = DataTypesUtil.getEncodingNameFromPI(bis);
        if (PIEncoding != null) {
            encoding = PIEncoding;
        }
        if (encoding == null && defaultEncoding != null) {
            encoding = defaultEncoding;
        }
        if (encoding != null) {
            inBis.reset();
            inBis.skip(bomSize[0]);
            return new InputStreamReader((InputStream)inBis, encoding);
        }
        return null;
    }

    public static String getEncodingNameFromPI(Reader reader) throws XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(new ReaderInputStream(reader, "UTF-8"));
        return streamReader.getEncoding();
    }

    public static String getEncodingNameFromPI(InputStream is) throws XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(is);
        return streamReader.getEncoding();
    }

    public static String detectedEncodingName(InputStream is, int[] bomSize) throws IOException {
        byte[] b4 = new byte[4];
        String encoding = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        bis.mark(4);
        int count = bis.read(b4, 0, 4);
        encoding = DataTypesUtil.detectEncodingNameFromBOM(b4, count, bomSize);
        if (encoding == null) {
            encoding = DataTypesUtil.detectEncodingNameFromPIMarker(b4, count);
        }
        return encoding;
    }

    public static String detectEncodingNameFromBOM(byte[] b4, int count, int[] bomSize) {
        if (count >= 3) {
            int b0 = b4[0] & 0xFF;
            int b1 = b4[1] & 0xFF;
            int b2 = b4[2] & 0xFF;
            if (b0 == 239 && b1 == 187 && b2 == 191) {
                bomSize[0] = 3;
                return "UTF-8";
            }
            if (count >= 4) {
                int b3 = b4[3] & 0xFF;
                if (b0 == 0 && b1 == 0 && (b2 == 254 && b3 == 255 || b2 == 255 && b3 == 254)) {
                    bomSize[0] = 4;
                    return "ISO-10646-UCS-4";
                }
                if (b0 == 254 && b1 == 255) {
                    bomSize[0] = 4;
                    if (b2 == 0 && b3 == 0) {
                        return "ISO-10646-UCS-4";
                    }
                    return "UTF-16BE";
                }
                if (b0 == 255 && b1 == 254) {
                    bomSize[0] = 4;
                    if (b2 == 0 && b3 == 0) {
                        return "ISO-10646-UCS-4";
                    }
                    return "UTF-16LE";
                }
            }
        }
        return null;
    }

    public static String detectEncodingNameFromPIMarker(byte[] b4, int count) {
        if (count >= 4) {
            int b0 = b4[0] & 0xFF;
            int b1 = b4[1] & 0xFF;
            int b2 = b4[2] & 0xFF;
            int b3 = b4[3] & 0xFF;
            if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60 || b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0 || b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0 || b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
                return "ISO-10646-UCS-4";
            }
            if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
                return "UTF-16BE";
            }
            if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
                return "UTF-16LE";
            }
            if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
                return "CP037";
            }
            if (b0 == 60 && b1 == 63 && b2 == 120 && b3 == 109) {
                return "US-ASCII";
            }
        }
        return null;
    }

    public static String toSQLSyntax(Connection conn, FormatType formatType, Object obj) {
        return DataTypesUtil.toSQLSyntax(conn, formatType, obj, obj);
    }

    public static String toSQLSyntax(Connection conn, FormatType formatType, Object obj, Object preFormattedObj) {
        int sqlType = DataTypesUtil.getSQLType(obj);
        String str = DataTypesUtil.toSQLStringValue(conn, sqlType, formatType, obj, preFormattedObj);
        String literal = DataTypesUtil.toSQLLiteral(str, sqlType);
        String wrapper = DataTypesUtil.getSQLLiteralWrapper(conn, sqlType, formatType);
        return String.format(wrapper, literal);
    }

    public static String toSQLStringValue(Connection conn, FormatType formatType, Object obj, Object preFormattedObj) {
        return DataTypesUtil.toSQLStringValue(conn, DataTypesUtil.getSQLType(obj), formatType, obj, preFormattedObj);
    }

    public static String toSQLStringValue(Connection conn, int sqlType, FormatType formatType, Object obj, Object preFormattedObj) {
        if (obj != null) {
            Format formatter = DataTypesUtil.getSQLFormatter(conn, sqlType, formatType);
            if (formatter != null) {
                return formatter.format(obj);
            }
            if (preFormattedObj == null) {
                return obj.toString();
            }
        }
        if (preFormattedObj != null) {
            return preFormattedObj.toString();
        }
        return null;
    }

    public static String getSQLLiteralWrapper(Connection conn, int sqlType, FormatType formatType) {
        StringBuffer wrapper = new StringBuffer();
        boolean closeBracket = true;
        switch (sqlType) {
            case 91: {
                wrapper.append("TO_DATE(");
                break;
            }
            case -102: 
            case 93: {
                wrapper.append("TO_TIMESTAMP(");
                break;
            }
            case -101: {
                wrapper.append("TO_TIMESTAMP_TZ(");
                break;
            }
            default: {
                closeBracket = false;
            }
        }
        wrapper.append("%s");
        if (closeBracket) {
            String pattern = DataTypesUtil.getSQLFormatPattern(conn, sqlType, formatType);
            if (pattern != null) {
                wrapper.append(", ").append(DataTypesUtil.toSQLLiteral(pattern, 1));
            }
            wrapper.append(")");
        }
        return wrapper.toString();
    }

    public static Format getSQLFormatter(Connection conn, int sqlType, FormatType formatType) {
        return NLSUtils.getFormat(conn, sqlType, formatType);
    }

    public static String getSQLFormatPattern(Connection conn, int sqlType, FormatType formatType) {
        switch (sqlType) {
            case 91: {
                return NLSUtils.getDateFormat(conn, formatType);
            }
            case -102: 
            case 93: {
                return NLSUtils.getTimeStampFormat(conn, formatType);
            }
            case -101: {
                return NLSUtils.getTimeStampWithTimeZoneFormat(conn, formatType);
            }
        }
        return null;
    }

    public static int getSQLType(Object obj) {
        return obj != null ? DataTypesUtil.getSQLType(obj.getClass()) : -1;
    }

    public static int getSQLType(Class<?> clazz) {
        if (DATE.class.isAssignableFrom(clazz)) {
            return 91;
        }
        if (TIMESTAMP.class.isAssignableFrom(clazz)) {
            return 93;
        }
        if (TIMESTAMPLTZ.class.isAssignableFrom(clazz)) {
            return -102;
        }
        if (TIMESTAMPTZ.class.isAssignableFrom(clazz)) {
            return -101;
        }
        if (INTERVALDS.class.isAssignableFrom(clazz)) {
            return -104;
        }
        if (INTERVALYM.class.isAssignableFrom(clazz)) {
            return -103;
        }
        if (NUMBER.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (BINARY_DOUBLE.class.isAssignableFrom(clazz)) {
            return 101;
        }
        if (BINARY_FLOAT.class.isAssignableFrom(clazz)) {
            return 100;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return 2;
        }
        return -1;
    }

    public static String toSQLLiteral(String str, int sqlType) {
        return DataTypesUtil.toSQLLiteral(str, sqlType, true);
    }

    public static String toSQLLiteral(String str, int sqlType, boolean treatEmptyAsNull) {
        if (str == null) {
            return _NULL_;
        }
        if (str.length() == 0) {
            if (treatEmptyAsNull) {
                return _NULL_;
            }
            return "'''";
        }
        if (DataTypesUtil.getDataTypeKind(sqlType) == DataTypeKind.NUMERIC) {
            return str;
        }
        return "'" + str.replaceAll("'", "''") + "'";
    }

    public static void copyCharacters(Readable reader, Appendable writer) throws IOException {
        DataTypesUtil.copyCharacters(reader, writer, 2400);
    }

    public static void copyCharacters(Readable reader, Appendable writer, int bufferSize) throws IOException {
        char[] b = new char[bufferSize];
        CharBuffer buf = CharBuffer.wrap(b);
        int len = reader.read(buf);
        while (len != -1) {
            buf.rewind();
            writer.append(buf, 0, len);
            len = reader.read(buf);
        }
    }

    public static void copyCharacters(Readable reader, StringBuffer buffer) throws IOException {
        DataTypesUtil.copyCharacters(reader, buffer, 2400);
    }

    public static void copyCharacters(Readable reader, StringBuffer buffer, int bufferSize) throws IOException {
        char[] b = new char[bufferSize];
        CharBuffer buf = CharBuffer.wrap(b);
        int len = reader.read(buf);
        while (len != -1) {
            buffer.append(buf, 0, len);
            len = reader.read(buf);
        }
    }

    public static void copyCharacters(Reader reader, StringBuilder buffer) throws IOException {
        DataTypesUtil.copyCharacters((Readable)reader, buffer, 2400);
    }

    public static void copyCharacters(Readable reader, StringBuilder buffer, int bufferSize) throws IOException {
        char[] b = new char[bufferSize];
        CharBuffer buf = CharBuffer.wrap(b);
        int len = reader.read(buf);
        while (len != -1) {
            buffer.append(buf, 0, len);
            len = reader.read(buf);
        }
    }

    public static boolean compareData(Readable r1, Readable r2) throws IOException {
        char[] b1 = new char[2400];
        char[] b2 = new char[2400];
        Arrays.fill(b1, ' ');
        Arrays.fill(b2, ' ');
        CharBuffer buf1 = CharBuffer.wrap(b1);
        CharBuffer buf2 = CharBuffer.wrap(b2);
        int l1 = r1.read(buf1);
        int l2 = r2.read(buf2);
        while (l1 != -1 && l2 != -1 && l1 == l2) {
            if (!Arrays.equals(b1, b2)) {
                return false;
            }
            l1 = r1.read(buf1);
            l2 = r2.read(buf2);
        }
        return l1 == l2;
    }

    protected static class TemporaryClobReader
    extends BufferedReader {
        private CLOB clob;

        public TemporaryClobReader(CLOB clob) throws SQLException {
            super(clob.getCharacterStream());
            this.clob = clob;
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }

    public static enum DataTypeKind {
        UNKNOWN,
        CHARACTER,
        NUMERIC,
        TEMPORAL,
        INTERVAL;

    }
}

