/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.query.db.QueryDB;
import oracle.dbtools.raptor.query.db.QueryItem;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;

public final class Query
implements Serializable {
    private static final String DBA_PREFIX = "Dba_";
    private static final long serialVersionUID = 1L;
    private static final String NO_ID = "THIS_QUERY_HAS_NO_ID";
    private transient Version m_minversion;
    private transient Version m_maxversion;
    private long _itemID = -1L;
    private String _checksum;
    private String _id;
    private long _dbaID = -1L;

    public static Query getQuery(Node node) {
        return Query.getQuery(node, null, null);
    }

    public static Query getQuery(Node node, XLIFFHelper xliffHelper, ClassLoader cl) {
        return QueryUtils.getQuery(node, xliffHelper, cl);
    }

    public static Query getQuery(Node node, XLIFFHelper xliffHelper) {
        return Query.getQuery(node, xliffHelper, null);
    }

    public static List<Query> getQueries(Node node) {
        return Query.getQueries(node, null);
    }

    public static List<Query> getQueries(Node item, ClassLoader cl) {
        return QueryUtils.getQueries(item, cl);
    }

    protected Query(Node node) {
        this.init();
        this.buildQuery(node, null, null);
    }

    protected Query(Node node, XLIFFHelper xliffHelper) {
        this(node, xliffHelper, null);
    }

    protected Query(Node node, XLIFFHelper xliffHelper, ClassLoader cl) {
        this.init();
        this.buildQuery(node, xliffHelper, cl);
    }

    public Query() {
        this.init();
    }

    public Query(long id) {
        this._itemID = id;
    }

    public Query(String md) {
        this._checksum = md;
    }

    private QueryItem getItem() {
        QueryItem qi = QueryDB.getDatabase().get(this._itemID);
        if (qi == null) {
            qi = new QueryItem();
            if (this._itemID != -1L) {
                qi.setPk(this._itemID);
            }
        }
        return qi;
    }

    private void init() {
        this._itemID = QueryDB.getDatabase().getNextSeq();
    }

    public long getItemPK() {
        return this._itemID;
    }

    public Set<String> getRequiredObjects() {
        return this.getItem().getReqs();
    }

    public String[] getRequiredFeatures() {
        return this.getItem().getRequiredFeatures();
    }

    public void setRequiredFeatures(String[] features) {
        this.getItem().setRequiredFeatures(features);
    }

    public void setMinversion(Version minversion) {
        QueryItem qi = this.getItem();
        qi.setMin(minversion.toCanonicalString());
        QueryDB.getDatabase().put(qi);
        this.m_minversion = minversion;
    }

    public Version getMinversion() {
        if (this.m_minversion == null) {
            String min = this.getItem().getMin();
            this.m_minversion = min == null ? null : new Version(min);
        }
        return this.m_minversion;
    }

    public void setMaxversion(Version maxversion) {
        QueryItem qi = this.getItem();
        qi.setMax(maxversion.toCanonicalString());
        QueryDB.getDatabase().put(qi);
        this.m_maxversion = maxversion;
    }

    public Version getMaxversion() {
        if (this.m_maxversion == null) {
            String max = this.getItem().getMax();
            this.m_maxversion = max == null ? null : new Version(max);
        }
        return this.m_maxversion;
    }

    public void setSql(String sql) {
        QueryItem qi = this.getItem();
        qi.setSql(sql);
        QueryDB.getDatabase().put(qi);
    }

    public String getSql() {
        return this.getItem().getSql();
    }

    private List<Bind> getRawBinds() {
        List<Bind> binds = this.getItem().getBinds();
        if (binds == null) {
            binds = new ArrayList<Bind>();
        }
        return binds;
    }

    public void setBinds(List<Bind> binds) {
        QueryItem qi = this.getItem();
        qi.setBinds(binds);
        QueryDB.getDatabase().put(qi);
    }

    public Map<String, Object> getBindMap() {
        HashMap<String, Object> binds = new HashMap<String, Object>();
        for (Bind b : this.getRawBinds()) {
            if (b.getDataValue() != null) {
                binds.put(b.getName(), b.getDataValue());
                continue;
            }
            binds.put(b.getName(), b.getValue());
        }
        return binds;
    }

    public List<Bind> getBinds() {
        if (this.getItem().getSql() == null) {
            return this.getRawBinds();
        }
        ArrayList<Bind> binds = Parser.getInstance().getBinds(this.getItem().getSql());
        if (this.getRawBinds().size() >= binds.size()) {
            ArrayList<Bind> retBinds = new ArrayList<Bind>();
            block0: for (Bind rb : this.getRawBinds()) {
                for (Bind qb : binds) {
                    if (!qb.getName().equals(rb.getName())) continue;
                    retBinds.add(rb);
                    continue block0;
                }
            }
            return retBinds;
        }
        return binds;
    }

    public List<Bind> getReportBindsFromSQL() {
        return Parser.getInstance().getBinds(this.getItem().getSql());
    }

    public List<Bind> getReportBinds() {
        List<Bind> binds = this.getReportBindsFromSQL();
        if (this.getRawBinds().size() >= binds.size()) {
            return this.getRawBinds();
        }
        return binds;
    }

    public void addBind(Bind bind) {
        QueryItem qi = this.getItem();
        if (qi.getBinds() == null) {
            qi.setBinds(new ArrayList<Bind>());
        }
        String name = bind.getName();
        boolean found = false;
        if (name != null) {
            // empty if block
        }
        for (Bind b : qi.getBinds()) {
            if (!name.equals(b.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            qi.getBinds().add(bind);
        }
        QueryDB.getDatabase().put(qi);
    }

    public void setOptionalBinds(List<Bind> binds) {
        QueryItem qi = this.getItem();
        qi.setOptBinds(binds);
        QueryDB.getDatabase().put(qi);
    }

    public List<Bind> getOptionalBinds() {
        return this.getItem().getOptBinds();
    }

    protected void addOptionalBind(Bind bind) {
        QueryItem qi = this.getItem();
        if (qi.getOptBinds() == null) {
            qi.setOptBinds(new ArrayList<Bind>());
        }
        String name = bind.getName();
        boolean found = false;
        if (name != null) {
            for (Bind b : qi.getOptBinds()) {
                if (!name.equals(b.getName())) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            qi.getOptBinds().add(bind);
        }
        QueryDB.getDatabase().put(qi);
    }

    public HashMap<String, Object> getBindValues() {
        HashMap<String, Object> bindVals = new HashMap<String, Object>();
        ArrayList<Bind> sqlBinds = Parser.getInstance().getBinds(this.getItem().getSql());
        if (this.getRawBinds().isEmpty()) {
            this.getItem().setBinds(sqlBinds);
        }
        if (this.getItem().getBinds().isEmpty()) {
            return bindVals;
        }
        for (int i = 0; i < this.getRawBinds().size(); ++i) {
            Object target = null;
            String name = this.getRawBinds().get(i).getName();
            String value = this.getRawBinds().get(i).getValue();
            String type = this.getRawBinds().get(i).getType();
            DataValue dataValue = this.getRawBinds().get(i).getDataValue();
            if (dataValue != null) {
                bindVals.put(name, dataValue);
                continue;
            }
            if (value != null && value.equals("NULL_VALUE")) {
                target = DBUtil.NULL_VALUE;
                bindVals.put(name, target);
            } else if (name.startsWith("SQLDEVPREF")) {
                target = "target";
                bindVals.put(name, target);
            } else {
                target = value;
                bindVals.put(name, target);
            }
            if (type == null || !type.equalsIgnoreCase("substitution")) continue;
            this.handleSubstitution(name, target);
        }
        return bindVals;
    }

    private void handleSubstitution(String bindName, Object bindValue) {
        if (this.getItem().getSql().indexOf("&" + bindName) != -1 && bindValue instanceof String) {
            String sql = this.getItem().getSql();
            sql = sql.replaceAll("&" + bindName, (String)bindValue);
            this.getItem().setSql(sql);
        }
    }

    public void setCols(List<Column> cols) {
        QueryItem qi = this.getItem();
        qi.setCols(cols);
        QueryDB.getDatabase().put(qi);
    }

    public List<Column> getCols() {
        List<Column> cols = this.getItem().getCols();
        if (cols == null) {
            cols = new ArrayList<Column>();
        }
        return cols;
    }

    protected void addColumn(Column col) {
        QueryItem qi = this.getItem();
        if (qi.getCols() == null) {
            qi.setCols(new ArrayList<Column>());
        }
        String id = col.getID();
        boolean found = false;
        if (id != null) {
            for (Column c : qi.getCols()) {
                if (!id.equals(c.getID())) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            qi.getCols().add(col);
        }
        QueryDB.getDatabase().put(qi);
    }

    public HashMap<String, Object> getColValues() {
        HashMap<String, Object> colVals = new HashMap<String, Object>();
        if (this.getCols().isEmpty()) {
            return colVals;
        }
        for (int i = 0; i < this.getCols().size(); ++i) {
            String name = this.getCols().get(i).getName();
            colVals.put(name, this.getCols().get(i));
        }
        return colVals;
    }

    public void buildQuery(Node node, XLIFFHelper xliffHelper) {
        this.buildQuery(node, xliffHelper, null);
    }

    public void buildQuery(Node node, XLIFFHelper xliffHelper, ClassLoader cl) {
        String reqFeatures;
        Object cols;
        String skipCols;
        QueryItem qi = this.getItem();
        if (qi == null) {
            qi = new QueryItem();
            if (this._itemID != -1L) {
                qi.setPk(this._itemID);
            }
        }
        if ((skipCols = XMLHelper.getNodeValue(node, "nodisplay")) != null) {
            cols = skipCols.split(",");
            ArrayList<String> colArr = new ArrayList<String>();
            for (int i = 0; i < ((String[])cols).length; ++i) {
                colArr.add(cols[i]);
            }
            qi.setSkipCols(colArr);
        }
        cols = QueryUtils.getNodeCols(node, cl);
        qi.setCols((List<Column>)cols);
        List<Bind> optBinds = QueryUtils.getNodeBinds(node, "optionalBinds", xliffHelper);
        qi.setOptBinds(optBinds);
        List<Bind> binds = QueryUtils.getNodeBinds(node, xliffHelper);
        qi.setBinds(binds);
        qi.setId(XMLHelper.getAttributeNode(node, "id"));
        this._id = qi.getId();
        if (this._id == null) {
            this._id = NO_ID;
        }
        String min = XMLHelper.getAttributeNode(node, "minversion");
        qi.setMin(min);
        String reqs = XMLHelper.getAttributeNode(node, "requiredAccessObjects");
        if (reqs != null) {
            HashSet<String> r = new HashSet<String>();
            Collections.addAll(r, reqs.split(","));
            qi.setReqs(r);
        }
        qi.setRequiredFeatures((reqFeatures = XMLHelper.getAttributeNode(node, "requiredFeatures")) != null ? reqFeatures.split(",") : null);
        String max = XMLHelper.getAttributeNode(node, "maxversion");
        qi.setMax(max);
        String sql = XMLHelper.getNodeValue(node, "sql");
        if (sql != null) {
            qi.setSql(sql);
        }
        qi.setConstrained(Boolean.parseBoolean(XMLHelper.getAttributeNode(XMLHelper.getChildNode(node, "sql"), "constrained")));
        String canBeConstrained = XMLHelper.getAttributeNode(XMLHelper.getChildNode(node, "sql"), "canbeconstrained");
        qi.setCanBeConstrained(ModelUtil.hasLength(canBeConstrained) ? Boolean.parseBoolean(canBeConstrained) : true);
        qi.setChecksum(QueryUtils.digest(node));
        QueryDB.getDatabase().put(qi);
    }

    public void setSkipCols(String skipCols) {
        String[] cols = skipCols.split(",");
        ArrayList<String> colArr = new ArrayList<String>();
        for (int i = 0; i < cols.length; ++i) {
            colArr.add(cols[i]);
        }
        this.setSkipCols(colArr);
    }

    public void setSkipCols(List<String> skipCols) {
        QueryItem qi = this.getItem();
        qi.setSkipCols(skipCols);
        QueryDB.getDatabase().put(qi);
    }

    public List<String> getSkipCols() {
        return this.getItem().getSkipCols();
    }

    public void setCheckSum(String md) {
        QueryItem qi = this.getItem();
        qi.setChecksum(md);
        QueryDB.getDatabase().put(qi);
    }

    public String getCheckSum() {
        return this.getItem().getChecksum();
    }

    public boolean isConstrained() {
        return this.getItem().isConstrained();
    }

    public boolean canBeConstrained() {
        return this.getItem().canBeConstrained();
    }

    public void setConstrained(boolean b) {
        QueryItem qi = this.getItem();
        qi.setConstrained(b);
        QueryDB.getDatabase().put(qi);
    }

    @Deprecated
    public Set<String> getReqs() {
        return this.getItem().getReqs();
    }

    public void setReqs(Set<String> reqs) {
        QueryItem qi = this.getItem();
        qi.setReqs(reqs);
        QueryDB.getDatabase().put(qi);
    }

    public String getIndent(int idx) {
        String indent = "";
        for (int i = 0; i < idx; ++i) {
            indent = indent + "\t";
        }
        return indent;
    }

    public String toXML(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIndent(indent) + "<query");
        if (this.m_minversion != null) {
            sb.append(" minversion=\"" + this.m_minversion + "\"");
        }
        if (this.m_maxversion != null) {
            sb.append(" maxversion=\"" + this.m_maxversion + "\"");
        }
        if (this.getItem().getReqs() != null) {
            StringBuilder objs = new StringBuilder();
            for (String s : this.getItem().getReqs()) {
                objs.append(s);
                objs.append(",");
            }
            objs.deleteCharAt(objs.length() - 1);
            sb.append(" requiredAccessObjects=\"" + objs + "\"");
        }
        sb.append(">\n");
        String sql = this.getItem().getSql();
        sb.append(this.getIndent(indent + 1) + "<sql><![CDATA[" + (sql != null ? sql : "") + "]]></sql>\n");
        if (this.getRawBinds() != null && this.getRawBinds().size() > 0) {
            sb.append(this.getIndent(indent + 1) + "<binds>\n");
            for (Bind bind : this.getRawBinds()) {
                sb.append(bind.toXML(indent + 2));
            }
            sb.append(this.getIndent(indent + 1) + "</binds>\n");
        }
        if (this.getCols() != null && this.getCols().size() > 0) {
            sb.append(this.getIndent(indent + 1) + "<columns>\n");
            for (Column col : this.getCols()) {
                sb.append(col.toXML(indent + 2));
            }
            sb.append(this.getIndent(indent + 1) + "</columns>\n");
        }
        sb.append(this.getIndent(indent) + "</query>\n");
        return sb.toString();
    }

    public String getID() {
        if (this._id == null && this._id != NO_ID) {
            this._id = this.getItem().getId();
        }
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
        QueryItem qi = this.getItem();
        qi.setId(id);
        QueryDB.getDatabase().put(qi);
    }

    public Query dbaVersion() {
        Query ret = null;
        if (this._dbaID == -1L) {
            QueryItem baseQI = this.getQueryItem();
            QueryItem qi = new QueryItem();
            qi.setReqs(new HashSet<String>());
            if (baseQI.getReqs() != null) {
                qi.getReqs().addAll(baseQI.getReqs());
            }
            qi.setSql(baseQI.getSql());
            if (qi.getSql() == null) {
                return null;
            }
            List<LexerToken> src = Query.lex(qi.getSql());
            ParseNode root = Query.parse(src);
            Map<Integer, String> tabAtPos = Query.getAllTablePos(root, src);
            if (tabAtPos.size() == 0) {
                return null;
            }
            for (Integer p : tabAtPos.keySet()) {
                qi.setSql(qi.getSql().substring(0, p) + DBA_PREFIX + qi.getSql().substring(p + DBA_PREFIX.length()));
                qi.getReqs().add(DBA_PREFIX + tabAtPos.get(p).substring(DBA_PREFIX.length()));
            }
            qi.setBinds(baseQI.getBinds());
            qi.setCols(baseQI.getCols());
            qi.setConstrained(baseQI.isConstrained());
            qi.setCanBeConstrained(baseQI.canBeConstrained());
            qi.setId(baseQI.getId());
            qi.setMax(baseQI.getMax());
            qi.setMin(baseQI.getMin());
            qi.setOptBinds(baseQI.getOptBinds());
            qi.setSkipCols(baseQI.getSkipCols());
            if (!qi.getSql().equals(this.getSql())) {
                ret = new Query();
                qi.setPk(ret.getItemPK());
                this._dbaID = qi.getPk();
                QueryDB.getDatabase().put(qi);
            }
        } else {
            ret = new Query(this._dbaID);
        }
        return ret;
    }

    public QueryItem getQueryItem() {
        return this.getItem();
    }

    static List<LexerToken> lex(String input) {
        return Lexer.parse(input);
    }

    static ParseNode parse(List<LexerToken> src) {
        SqlEarley earley = SqlEarley.getInstance();
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        return earley.forest(src, matrix);
    }

    static Map<Integer, String> getAllTablePos(ParseNode root, List<LexerToken> src) {
        int table_reference = SqlEarley.getInstance().getSymbol("table_reference");
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        block0: for (ParseNode child : root.children()) {
            if (child.contains(table_reference) && child.to - child.from < 5) {
                int pos = -1;
                for (LexerToken t : src) {
                    if (child.from > ++pos || pos >= child.to) continue;
                    String tok = t.content.toLowerCase();
                    if (tok.startsWith("all_")) {
                        ret.put(t.begin, tok);
                        continue block0;
                    }
                    if (!t.content.startsWith("\"ALL_")) continue;
                    ret.put(t.begin + 1, tok.substring(1, tok.length() - 1));
                    continue block0;
                }
                continue;
            }
            ret.putAll(Query.getAllTablePos(child, src));
        }
        return ret;
    }

    public String toString() {
        return this.getSql();
    }

    public static void main(String[] args) throws Exception {
        Query q = new Query();
        String input = "select emp from empno;";
        q.setSql("select emp from empno;");
        Query dbaVersion = q.dbaVersion();
        QueryItem item = dbaVersion.getItem();
        System.out.println(item.getSql());
    }
}

