/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowSpace
implements IShowCommand {
    private static final String[] SHOWSPACE = new String[]{"space"};

    @Override
    public String[] getShowAliases() {
        return SHOWSPACE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSpace(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowSpace(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String colsp = (String)ctx.getProperty("script.runner.setcolsep");
        String str = MessageFormat.format(Messages.getString("SPACE"), colsp) + Show.m_lineSeparator;
        ctx.write(str);
        return true;
    }
}

