/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetNet
extends AForAllStmtsCommand
implements IShowCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NET;

    public SetNet() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String in = cmd.getSql();
            if ((in = in.trim().replaceAll("^[sS][eE][tT]\\s+[nN][eE][tT]\\s+", "").trim()).startsWith("\"") && in.endsWith("\"") && in.length() > 1) {
                in = in.substring(1, in.length() - 1);
            } else if (in.startsWith("'") && in.endsWith("'") && in.length() > 1) {
                in = in.substring(1, in.length() - 1);
            }
            if (in.equalsIgnoreCase("ON")) {
                in = "ON";
            } else if (in.equalsIgnoreCase("OFF")) {
                in = "OFF";
            } else if (in.equalsIgnoreCase("READONLY")) {
                in = "READONLY";
            } else {
                ctx.write("ERROR:set net on|off|readonly\n");
                return true;
            }
            ctx.putProperty("script.runner.setnet", in);
        }
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"net"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String val = (String)ctx.getProperty("script.runner.setnet");
        if (val == null) {
            val = "ON";
        }
        ctx.write("net: " + val + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

